/*
 * Decompiled with CFR 0.152.
 */
package net.cellcomputing.himawari.library;

import net.cellcomputing.himawari.accessory.STLVector;
import net.cellcomputing.himawari.accessory.primitive.p_String;
import net.cellcomputing.himawari.accessory.primitive.p_float;
import net.cellcomputing.himawari.accessory.primitive.p_int;
import net.cellcomputing.himawari.library.CqBasicSurface;
import net.cellcomputing.himawari.library.CqBound;
import net.cellcomputing.himawari.library.CqParameter;
import net.cellcomputing.himawari.library.CqParameterTyped;
import net.cellcomputing.himawari.library.CqParameterTypedVarying;
import net.cellcomputing.himawari.library.CqPolygonBase;
import net.cellcomputing.himawari.library.CqStats;
import net.cellcomputing.himawari.library.CqSurface;
import net.cellcomputing.himawari.library.CqSurfacePatchBilinear;
import net.cellcomputing.himawari.library.EqVariableType;
import net.cellcomputing.himawari.library.IqAttributes;
import net.cellcomputing.himawari.library.IqTransform;
import net.cellcomputing.himawari.library.RiGlobal;
import net.cellcomputing.himawari.library.types.CqColor;
import net.cellcomputing.himawari.library.types.CqMatrix;
import net.cellcomputing.himawari.library.types.CqVector3D;
import net.cellcomputing.himawari.library.types.CqVector4D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class CqSurfacePolygon
extends CqSurface
implements CqPolygonBase {
    protected int m_cVertices;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public CqSurfacePolygon(int cVertices) {
        CqStats.STATS_INC(8);
        this.m_cVertices = cVertices;
    }

    public CqSurfacePolygon(CqSurfacePolygon From) {
        this.assignment(From);
        CqStats.STATS_INC(8);
    }

    @Override
    public void destruct() {
        super.destruct();
    }

    public CqSurfacePolygon assignment(CqSurfacePolygon From) {
        super.assignment(From);
        this.m_cVertices = From.m_cVertices;
        return this;
    }

    public boolean CheckDegenerate() {
        boolean fDegen = true;
        int n = this.NumVertices();
        int i = 1;
        while (i < n) {
            if (this.PolyP(i).sub(this.PolyP(i - 1)).Magnitude() > 1.1920929E-7f) {
                fDegen = false;
                break;
            }
            ++i;
        }
        return fDegen;
    }

    @Override
    public CqBound Bound() {
        return this.AdjustBoundForTransformationMotion(this.PBBound());
    }

    @Override
    public int Split(STLVector<CqBasicSurface> aSplits) {
        return this.PBSplit(aSplits);
    }

    @Override
    public boolean IsMotionBlurMatch(CqBasicSurface pSurf) {
        return false;
    }

    @Override
    public int cUniform() {
        return 1;
    }

    @Override
    public int cVarying() {
        return this.m_cVertices;
    }

    @Override
    public int cVertex() {
        return this.m_cVertices;
    }

    @Override
    public int cFaceVarying() {
        return 1;
    }

    @Override
    public CqSurface Surface() {
        return this;
    }

    @Override
    public CqVector4D PolyP(int i) {
        return this.P().pValue_get(i, 0);
    }

    @Override
    public CqVector3D PolyN(int i) {
        return this.N().pValue_get(i, 0);
    }

    @Override
    public CqColor PolyCs(int i) {
        return this.Cs().pValue_get(i, 0);
    }

    @Override
    public CqColor PolyOs(int i) {
        return this.Os().pValue_get(i, 0);
    }

    @Override
    public p_float Polys(int i) {
        return this.s().pValue_get(i, 0);
    }

    @Override
    public p_float Polyt(int i) {
        return this.t().pValue_get(i, 0);
    }

    @Override
    public p_float Polyu(int i) {
        return this.u().pValue_get(i, 0);
    }

    @Override
    public p_float Polyv(int i) {
        return this.v().pValue_get(i, 0);
    }

    @Override
    public int PolyIndex(int i) {
        return i;
    }

    @Override
    public int FaceVaryingIndex(int i) {
        return i;
    }

    @Override
    public boolean bHasVar(int index) {
        return super.bHasVar(index);
    }

    @Override
    public int NumVertices() {
        return this.cVertex();
    }

    @Override
    public IqAttributes pAttributes() {
        return super.pAttributes();
    }

    @Override
    public IqTransform pTransform() {
        return super.pTransform();
    }

    @Override
    public CqBound PBBound() {
        CqVector3D vecA = new CqVector3D(Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE);
        CqVector3D vecB = new CqVector3D(-3.4028235E38f, -3.4028235E38f, -3.4028235E38f);
        int n = this.NumVertices();
        int i = 0;
        while (i < n) {
            CqVector3D vecV = new CqVector3D();
            vecV.assignment(this.PolyP(i));
            if (vecV.x < vecA.x) {
                vecA.x(vecV.x);
            }
            if (vecV.y < vecA.y) {
                vecA.y(vecV.y);
            }
            if (vecV.x > vecB.x) {
                vecB.x(vecV.x);
            }
            if (vecV.y > vecB.y) {
                vecB.y(vecV.y);
            }
            if (vecV.z < vecA.z) {
                vecA.z(vecV.z);
            }
            if (vecV.z > vecB.z) {
                vecB.z(vecV.z);
            }
            ++i;
        }
        CqBound B = new CqBound();
        B.vecMin().assignment(vecA);
        B.vecMax().assignment(vecB);
        return B;
    }

    @Override
    public int PBSplit(STLVector<CqBasicSurface> aSplits) {
        int i;
        CqVector3D vecN = new CqVector3D();
        boolean CSO = this.pTransform().GetHandedness(this.pTransform().Time(0));
        boolean O = this.pAttributes().GetIntegerAttribute("System", "Orientation")[0] != 0;
        int indexA = 0;
        int indexB = 1;
        int iUses = this.PolyUses();
        int n = this.NumVertices();
        if (!this.bHasVar(11)) {
            CqVector3D vecA = new CqVector3D();
            vecA.assignment(this.PolyP(indexA));
            i = 1;
            CqVector3D vecN0 = new CqVector3D();
            CqVector3D vecN1 = new CqVector3D();
            CqVector3D tmp = new CqVector3D();
            while (i < n) {
                tmp.assignment(this.PolyP(i));
                vecN0.assignment(tmp.sub(vecA));
                if (vecN0.Magnitude() > 1.1920929E-7f) break;
                ++i;
            }
            ++i;
            while (i < n) {
                tmp.assignment(this.PolyP(i));
                vecN1.assignment(tmp.sub(vecA));
                if (vecN1.Magnitude() > 1.1920929E-7f && vecN1 != vecN0) break;
                ++i;
            }
            vecN.assignment(vecN0.mod(vecN1));
            vecN.assignment(O == CSO ? vecN : vecN.mul(-1.0f));
            vecN.Unit();
        }
        int cNew = 0;
        i = 2;
        while (i < n) {
            int indexD;
            int indexC = indexD = i;
            if (n > i + 1) {
                indexD = i + 1;
            }
            CqSurfacePatchBilinear pNew = new CqSurfacePatchBilinear();
            pNew.SetSurfaceParameters(this.Surface());
            int iUPA = this.PolyIndex(indexA);
            int iUPB = this.PolyIndex(indexB);
            int iUPC = this.PolyIndex(indexC);
            int iUPD = this.PolyIndex(indexD);
            int iUPAf = this.FaceVaryingIndex(indexA);
            int iUPBf = this.FaceVaryingIndex(indexB);
            int iUPCf = this.FaceVaryingIndex(indexC);
            int iUPDf = this.FaceVaryingIndex(indexD);
            for (CqParameter iUP : this.Surface().aUserParams()) {
                CqParameter pNewUP = iUP.CloneType(iUP.strName(), iUP.Count());
                if (pNewUP.Class().getValue() == 3 || pNewUP.Class().getValue() == 4) {
                    pNewUP.SetSize(pNew.cVarying());
                    pNewUP.SetValue(iUP, 0, iUPA);
                    pNewUP.SetValue(iUP, 1, iUPB);
                    pNewUP.SetValue(iUP, 2, iUPD);
                    pNewUP.SetValue(iUP, 3, iUPC);
                    if (indexC == indexD) {
                        this.CreatePhantomData(pNewUP);
                    }
                } else if (pNewUP.Class().getValue() == 2) {
                    pNewUP.SetSize(pNew.cUniform());
                    pNewUP.SetValue(iUP, 0, this.MeshIndex());
                } else if (pNewUP.Class().getValue() == 1) {
                    pNewUP.SetSize(1);
                    pNewUP.SetValue(iUP, 0, 0);
                } else if (pNewUP.Class().getValue() == 5) {
                    pNewUP.SetSize(pNew.cVarying());
                    pNewUP.SetValue(iUP, 0, iUPAf);
                    pNewUP.SetValue(iUP, 1, iUPBf);
                    pNewUP.SetValue(iUP, 2, iUPDf);
                    pNewUP.SetValue(iUP, 3, iUPCf);
                    if (indexC == indexD) {
                        this.CreatePhantomData(pNewUP);
                    }
                }
                pNew.AddPrimitiveVariable(pNewUP);
            }
            if (indexC == indexD) {
                pNew.SetfHasPhantomFourthVertex(true);
            }
            if (!this.bHasVar(11) && RiGlobal.USES(iUses, 11)) {
                CqParameterTypedVarying<CqVector3D, CqVector3D> pNewUP = new CqParameterTypedVarying<CqVector3D, CqVector3D>("N", 1, new EqVariableType(8), CqVector3D.class, CqVector3D.class);
                pNewUP.SetSize(pNew.cVarying());
                pNewUP.pValue_get(0, 0).assignment(vecN);
                pNewUP.pValue_get(0, 1).assignment(vecN);
                pNewUP.pValue_get(0, 2).assignment(vecN);
                pNewUP.pValue_get(0, 3).assignment(vecN);
                pNew.AddPrimitiveVariable(pNewUP);
            }
            if (RiGlobal.USES(iUses, 14) || RiGlobal.USES(iUses, 15) || RiGlobal.USES(iUses, 12) || RiGlobal.USES(iUses, 13)) {
                CqParameterTypedVarying<p_float, p_float> pNewUP;
                CqVector3D PA = new CqVector3D();
                CqVector3D PB = new CqVector3D();
                CqVector3D PC = new CqVector3D();
                CqVector3D PD = new CqVector3D();
                CqMatrix matID = new CqMatrix();
                CqMatrix matCurrentToWorld = RiGlobal.QGetRenderContext().matSpaceToSpace("current", "object", matID, this.Surface().pTransform().matObjectToWorld(this.Surface().pTransform().Time(0)), this.Surface().pTransform().Time(0));
                PA.assignment(matCurrentToWorld.multiply(pNew.P().pValue_get(0, 0)));
                PB.assignment(matCurrentToWorld.multiply(pNew.P().pValue_get(0, 1)));
                PC.assignment(matCurrentToWorld.multiply(pNew.P().pValue_get(0, 3)));
                PD.assignment(matCurrentToWorld.multiply(pNew.P().pValue_get(0, 2)));
                if (RiGlobal.USES(iUses, 14) && !this.bHasVar(14)) {
                    pNewUP = new CqParameterTypedVarying<p_float, p_float>("s", new EqVariableType(1), p_float.class, p_float.class);
                    pNewUP.SetSize(pNew.cVarying());
                    pNewUP.pValue_get((int)0, (int)0).value = PA.x;
                    pNewUP.pValue_get((int)0, (int)1).value = PB.x;
                    pNewUP.pValue_get((int)0, (int)2).value = PD.x;
                    pNewUP.pValue_get((int)0, (int)3).value = PC.x;
                    pNew.AddPrimitiveVariable(pNewUP);
                }
                if (RiGlobal.USES(iUses, 15) && !this.bHasVar(15)) {
                    pNewUP = new CqParameterTypedVarying<p_float, p_float>("t", new EqVariableType(1), p_float.class, p_float.class);
                    pNewUP.SetSize(pNew.cVarying());
                    pNewUP.pValue_get((int)0, (int)0).value = PA.y;
                    pNewUP.pValue_get((int)0, (int)1).value = PB.y;
                    pNewUP.pValue_get((int)0, (int)2).value = PD.y;
                    pNewUP.pValue_get((int)0, (int)3).value = PC.y;
                    pNew.AddPrimitiveVariable(pNewUP);
                }
                if (RiGlobal.USES(iUses, 12) && !this.bHasVar(12)) {
                    pNewUP = new CqParameterTypedVarying<p_float, p_float>("u", new EqVariableType(1), p_float.class, p_float.class);
                    pNewUP.SetSize(pNew.cVarying());
                    pNewUP.pValue_get((int)0, (int)0).value = PA.x;
                    pNewUP.pValue_get((int)0, (int)1).value = PB.x;
                    pNewUP.pValue_get((int)0, (int)2).value = PD.x;
                    pNewUP.pValue_get((int)0, (int)3).value = PC.x;
                    pNew.AddPrimitiveVariable(pNewUP);
                }
                if (RiGlobal.USES(iUses, 13) && !this.bHasVar(13)) {
                    pNewUP = new CqParameterTypedVarying<p_float, p_float>("v", new EqVariableType(1), p_float.class, p_float.class);
                    pNewUP.SetSize(pNew.cVarying());
                    pNewUP.pValue_get((int)0, (int)0).value = PA.y;
                    pNewUP.pValue_get((int)0, (int)1).value = PB.y;
                    pNewUP.pValue_get((int)0, (int)2).value = PD.y;
                    pNewUP.pValue_get((int)0, (int)3).value = PC.y;
                    pNew.AddPrimitiveVariable(pNewUP);
                }
            }
            aSplits.add(pNew);
            ++cNew;
            indexB = indexD;
            i += 2;
        }
        return cNew;
    }

    @Override
    public void CreatePhantomData(CqParameter pParam) {
        assert (pParam.Class().getValue() == 3 || pParam.Class().getValue() == 4 || pParam.Class().getValue() == 5);
        int iArrayCount = 1;
        if (pParam.Count() > 0) {
            iArrayCount = pParam.Count();
        }
        switch (pParam.Type().getValue()) {
            case 3: 
            case 8: 
            case 9: {
                CqParameterTyped pTParam = (CqParameterTyped)pParam;
                int iArray = 0;
                while (iArray < iArrayCount) {
                    ((CqVector3D)pTParam.pValue_get(3, iArray)).assignment(((CqVector3D)pTParam.pValue_get(1, iArray)).sub((CqVector3D)pTParam.pValue_get(0, iArray)).add((CqVector3D)pTParam.pValue_get(2, iArray)));
                    ++iArray;
                }
                break;
            }
            case 7: {
                CqParameterTyped pTParam = (CqParameterTyped)pParam;
                int iArray = 0;
                while (iArray < iArrayCount) {
                    ((CqVector4D)pTParam.pValue_get(3, iArray)).assignment(((CqVector4D)pTParam.pValue_get(1, iArray)).sub((CqVector4D)pTParam.pValue_get(0, iArray)).add((CqVector4D)pTParam.pValue_get(2, iArray)));
                    ++iArray;
                }
                break;
            }
            case 1: {
                CqParameterTyped pTParam = (CqParameterTyped)pParam;
                int iArray = 0;
                while (iArray < iArrayCount) {
                    ((p_float)pTParam.pValue_get((int)3, (int)iArray)).value = ((p_float)pTParam.pValue_get((int)1, (int)iArray)).value - ((p_float)pTParam.pValue_get((int)0, (int)iArray)).value + ((p_float)pTParam.pValue_get((int)2, (int)iArray)).value;
                    ++iArray;
                }
                break;
            }
            case 2: {
                CqParameterTyped pTParam = (CqParameterTyped)pParam;
                int iArray = 0;
                while (iArray < iArrayCount) {
                    ((p_int)pTParam.pValue_get((int)3, (int)iArray)).value = ((p_int)pTParam.pValue_get((int)1, (int)iArray)).value - ((p_int)pTParam.pValue_get((int)0, (int)iArray)).value + ((p_int)pTParam.pValue_get((int)2, (int)iArray)).value;
                    ++iArray;
                }
                break;
            }
            case 5: {
                CqParameterTyped pTParam = (CqParameterTyped)pParam;
                int iArray = 0;
                while (iArray < iArrayCount) {
                    ((CqColor)pTParam.pValue_get(3, iArray)).assignment(((CqColor)pTParam.pValue_get(1, iArray)).sub((CqColor)pTParam.pValue_get(0, iArray)).add((CqColor)pTParam.pValue_get(2, iArray)));
                    ++iArray;
                }
                break;
            }
            case 11: {
                CqParameterTyped pTParam = (CqParameterTyped)pParam;
                int iArray = 0;
                while (iArray < iArrayCount) {
                    ((CqMatrix)pTParam.pValue_get(3, iArray)).assignment(((CqMatrix)pTParam.pValue_get(1, iArray)).sub((CqMatrix)pTParam.pValue_get(0, iArray)).add((CqMatrix)pTParam.pValue_get(2, iArray)));
                    ++iArray;
                }
                break;
            }
            case 4: {
                CqParameterTyped pTParam = (CqParameterTyped)pParam;
                int iArray = 0;
                while (iArray < iArrayCount) {
                    ((p_String)pTParam.pValue_get((int)3, (int)iArray)).value = String.valueOf(((p_String)pTParam.pValue_get((int)1, (int)iArray)).value) + ((p_String)pTParam.pValue_get((int)2, (int)iArray)).value;
                    ++iArray;
                }
                break;
            }
        }
    }

    @Override
    public int MeshIndex() {
        return 0;
    }

    @Override
    public int PolyUses() {
        return this.Surface().Uses();
    }
}

