/*
 * Decompiled with CFR 0.152.
 */
package net.cellcomputing.himawari.library;

import net.cellcomputing.himawari.accessory.STLArray;
import net.cellcomputing.himawari.accessory.primitive.p_float;
import net.cellcomputing.himawari.library.CqBound;
import net.cellcomputing.himawari.library.CqHitTestCache;
import net.cellcomputing.himawari.library.CqMicroPolyGridBase;
import net.cellcomputing.himawari.library.CqStats;
import net.cellcomputing.himawari.library.RiGlobal;
import net.cellcomputing.himawari.library.SqSampleData;
import net.cellcomputing.himawari.library.types.CqColor;
import net.cellcomputing.himawari.library.types.CqRefCount;
import net.cellcomputing.himawari.library.types.CqVector2D;
import net.cellcomputing.himawari.library.types.CqVector3D;

public strictfp class CqMicroPolygon
extends CqRefCount {
    protected int m_IndexCode;
    protected int m_BoundCode;
    protected CqBound m_Bound = new CqBound();
    protected CqMicroPolyGridBase m_pGrid = null;
    protected int m_Index;
    protected short m_Flags = 0;
    protected CqHitTestCache m_pHitTestCache = null;
    static /* synthetic */ Class class$0;

    public CqMicroPolygon() {
        CqStats.STATS_INC(46);
        CqStats.STATS_INC(48);
        int cMPG = CqStats.STATS_GETI(48);
        int cPeak = CqStats.STATS_GETI(49);
        CqStats.STATS_SETI(49, cMPG > cPeak ? cMPG : cPeak);
    }

    public void destruct() {
        CqStats.STATS_INC(47);
        CqStats.STATS_DEC(48);
        if (!this.IsHit()) {
            CqStats.STATS_INC(51);
        }
    }

    public void SetGrid(CqMicroPolyGridBase pGrid) {
        if (this.m_pGrid != null) {
            this.m_pGrid.Release();
        }
        this.m_pGrid = pGrid;
        this.m_pGrid.AddRef();
    }

    public CqMicroPolyGridBase pGrid() {
        return this.m_pGrid;
    }

    public int GetIndex() {
        return this.m_Index;
    }

    public void SetIndex(int Index) {
        assert (this.m_pGrid != null && this.m_pGrid.GridSize() > Index);
        this.m_Index = Index;
    }

    public void Detach() {
        if (this.m_pGrid != null) {
            this.m_pGrid = null;
        }
    }

    public CqColor colColor() {
        CqColor colRes = new CqColor();
        this.m_pGrid.pVar(17).GetColor(colRes, this.m_Index);
        return colRes;
    }

    public CqColor colOpacity() {
        CqColor colRes = new CqColor();
        this.m_pGrid.pVar(18).GetColor(colRes, this.m_Index);
        return colRes;
    }

    public void CalculateTotalBound() {
        STLArray<CqVector3D> pP = this.m_pGrid.pVar(8).GetPointPtr_2();
        CqVector3D B = pP.get(this.m_Index + 1);
        int cu = this.m_pGrid.uGridRes();
        CqVector3D C = pP.get(this.m_Index + cu + 2);
        CqVector3D D = pP.get(this.m_Index + cu + 1);
        int BCMinX = 0;
        int BCMaxX = 0;
        int BCMinY = 0;
        int BCMaxY = 0;
        int BCMinZ = 0;
        int BCMaxZ = 0;
        this.m_BoundCode = 228;
        int[] TempIndexTable = new int[]{this.GetCodedIndex(this.m_BoundCode, 0), this.GetCodedIndex(this.m_BoundCode, 1), this.GetCodedIndex(this.m_BoundCode, 2), this.GetCodedIndex(this.m_BoundCode, 3)};
        if (B.x < pP.get((int)TempIndexTable[BCMinX]).x) {
            BCMinX = 1;
        }
        if (B.x > pP.get((int)TempIndexTable[BCMaxX]).x) {
            BCMaxX = 1;
        }
        if (B.y < pP.get((int)TempIndexTable[BCMinY]).y) {
            BCMinY = 1;
        }
        if (B.y > pP.get((int)TempIndexTable[BCMaxY]).y) {
            BCMaxY = 1;
        }
        if (B.z < pP.get((int)TempIndexTable[BCMinZ]).z) {
            BCMinZ = 1;
        }
        if (B.z > pP.get((int)TempIndexTable[BCMaxZ]).z) {
            BCMaxZ = 1;
        }
        if (C.x < pP.get((int)TempIndexTable[BCMinX]).x) {
            BCMinX = 2;
        }
        if (C.x > pP.get((int)TempIndexTable[BCMaxX]).x) {
            BCMaxX = 2;
        }
        if (C.y < pP.get((int)TempIndexTable[BCMinY]).y) {
            BCMinY = 2;
        }
        if (C.y > pP.get((int)TempIndexTable[BCMaxY]).y) {
            BCMaxY = 2;
        }
        if (C.z < pP.get((int)TempIndexTable[BCMinZ]).z) {
            BCMinZ = 2;
        }
        if (C.z > pP.get((int)TempIndexTable[BCMaxZ]).z) {
            BCMaxZ = 2;
        }
        if (!this.IsDegenerate()) {
            if (D.x < pP.get((int)TempIndexTable[BCMinX]).x) {
                BCMinX = 3;
            }
            if (D.x > pP.get((int)TempIndexTable[BCMaxX]).x) {
                BCMaxX = 3;
            }
            if (D.y < pP.get((int)TempIndexTable[BCMinY]).y) {
                BCMinY = 3;
            }
            if (D.y > pP.get((int)TempIndexTable[BCMaxY]).y) {
                BCMaxY = 3;
            }
            if (D.z < pP.get((int)TempIndexTable[BCMinZ]).z) {
                BCMinZ = 3;
            }
            if (D.z > pP.get((int)TempIndexTable[BCMaxZ]).z) {
                BCMaxZ = 3;
            }
        }
        this.m_BoundCode = BCMinX & 3 | (BCMinY & 3) << 2 | (BCMinZ & 3) << 4 | (BCMaxX & 3) << 6 | (BCMaxY & 3) << 8 | (BCMaxZ & 3) << 10;
        this.m_Bound = new CqBound(pP.get((int)this.GetCodedIndex((int)this.m_BoundCode, (int)0)).x, pP.get((int)this.GetCodedIndex((int)this.m_BoundCode, (int)1)).y, pP.get((int)this.GetCodedIndex((int)this.m_BoundCode, (int)2)).z, pP.get((int)this.GetCodedIndex((int)this.m_BoundCode, (int)3)).x, pP.get((int)this.GetCodedIndex((int)this.m_BoundCode, (int)4)).y, pP.get((int)this.GetCodedIndex((int)this.m_BoundCode, (int)5)).z);
        if (RiGlobal.QGetRenderContext().UsingDepthOfField()) {
            CqVector2D minZCoc = RiGlobal.QGetRenderContext().GetCircleOfConfusion(this.m_Bound.vecMin().z);
            CqVector2D maxZCoc = RiGlobal.QGetRenderContext().GetCircleOfConfusion(this.m_Bound.vecMax().z);
            float cocX = Math.max(minZCoc.x, maxZCoc.x);
            float cocY = Math.max(minZCoc.y, maxZCoc.y);
            this.m_Bound.vecMin().x -= cocX;
            this.m_Bound.vecMin().y -= cocY;
            this.m_Bound.vecMax().x += cocX;
            this.m_Bound.vecMax().y += cocY;
        }
    }

    public CqBound GetTotalBound() {
        return new CqBound(this.m_Bound);
    }

    public int cSubBounds() {
        return 1;
    }

    public CqBound SubBound(int iIndex, p_float time) {
        time.value = 0.0f;
        return this.GetTotalBound();
    }

    public boolean Sample(SqSampleData sample, p_float D, float time, boolean UsingDof) {
        CqVector2D vecSample = sample.m_Position;
        if (UsingDof) {
            CqVector3D[] points = new CqVector3D[]{new CqVector3D(this.PointB()), new CqVector3D(this.PointC()), new CqVector3D(this.PointD()), new CqVector3D(this.PointA())};
            CqVector2D coc = new CqVector2D();
            RiGlobal.QGetRenderContext().GetCircleOfConfusion(points[0].z, coc);
            points[0].x(points[0].x - coc.x * sample.m_DofOffset.x);
            points[0].y(points[0].y - coc.y * sample.m_DofOffset.y);
            RiGlobal.QGetRenderContext().GetCircleOfConfusion(points[1].z, coc);
            points[1].x(points[1].x - coc.x * sample.m_DofOffset.x);
            points[1].y(points[1].y - coc.y * sample.m_DofOffset.y);
            RiGlobal.QGetRenderContext().GetCircleOfConfusion(points[2].z, coc);
            points[2].x(points[2].x - coc.x * sample.m_DofOffset.x);
            points[2].y(points[2].y - coc.y * sample.m_DofOffset.y);
            RiGlobal.QGetRenderContext().GetCircleOfConfusion(points[3].z, coc);
            points[3].x(points[3].x - coc.x * sample.m_DofOffset.x);
            points[3].y(points[3].y - coc.y * sample.m_DofOffset.y);
            CqHitTestCache hitTestCache = new CqHitTestCache();
            this.CacheHitTestValues(hitTestCache, points);
        }
        if (this.fContains(vecSample, D, time)) {
            if (this.IsTrimmed()) {
                String[] pattrTrimSense = this.pGrid().pAttributes().GetStringAttribute("trimcurve", "sense");
                String strTrimSense = "inside";
                if (pattrTrimSense != null) {
                    strTrimSense = pattrTrimSense[0];
                }
                boolean bOutside = strTrimSense.equals("outside");
                CqVector2D vecUV = this.ReverseBilinear(vecSample);
                p_float u = new p_float();
                p_float v = new p_float();
                this.pGrid().pVar(12).GetFloat(u, this.m_Index);
                this.pGrid().pVar(13).GetFloat(v, this.m_Index);
                CqVector2D uvA = new CqVector2D(u.value, v.value);
                this.pGrid().pVar(12).GetFloat(u, this.m_Index + 1);
                this.pGrid().pVar(13).GetFloat(v, this.m_Index + 1);
                CqVector2D uvB = new CqVector2D(u.value, v.value);
                this.pGrid().pVar(12).GetFloat(u, this.m_Index + this.pGrid().uGridRes() + 1);
                this.pGrid().pVar(13).GetFloat(v, this.m_Index + this.pGrid().uGridRes() + 1);
                CqVector2D uvC = new CqVector2D(u.value, v.value);
                this.pGrid().pVar(12).GetFloat(u, this.m_Index + this.pGrid().uGridRes() + 2);
                this.pGrid().pVar(13).GetFloat(v, this.m_Index + this.pGrid().uGridRes() + 2);
                CqVector2D uvD = new CqVector2D(u.value, v.value);
                CqVector2D vR = RiGlobal.BilinearEvaluate(uvA, uvB, uvC, uvD, vecUV.x, vecUV.y, CqVector2D.class);
                if (this.pGrid().pSurface().bCanBeTrimmed() && this.pGrid().pSurface().bIsPointTrimmed(vR) && !bOutside) {
                    CqStats.STATS_INC(52);
                    return false;
                }
            }
            if (this.pGrid().fTriangular()) {
                CqVector3D vA = new CqVector3D();
                CqVector3D vB = new CqVector3D();
                this.pGrid().TriangleSplitPoints(vA, vB, time);
                float Ax = vA.x;
                float Ay = vA.y;
                float Bx = vB.x;
                float By = vB.y;
                float v = (Ay - By) * vecSample.x + (Bx - Ax) * vecSample.y + (Ax * By - Bx * Ay);
                if (v <= 0.0f) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public boolean IsHit() {
        return (this.m_Flags & 2) != 0;
    }

    public void MarkHit() {
        this.m_Flags = (short)(this.m_Flags | 2);
    }

    public boolean IsPushedForward() {
        return (this.m_Flags & 4) != 0;
    }

    public void MarkPushedForward() {
        this.m_Flags = (short)(this.m_Flags | 4);
    }

    public void MarkTrimmed() {
        this.m_Flags = (short)(this.m_Flags | 1);
    }

    public boolean IsTrimmed() {
        return (this.m_Flags & 1) != 0;
    }

    public boolean IsMoving() {
        return false;
    }

    public boolean fContains(CqVector2D vecP, p_float Depth, float time) {
        float x = vecP.x;
        float y = vecP.y;
        int e = this.m_pHitTestCache.m_LastFailedEdge;
        int prev = e - 1;
        if (prev < 0) {
            prev = 3;
        }
        int i = 0;
        while (i < 4) {
            if ((e & 2) != 0) {
                if ((y - this.m_pHitTestCache.m_Y[e]) * this.m_pHitTestCache.m_YMultiplier[e] - (x - this.m_pHitTestCache.m_X[e]) * this.m_pHitTestCache.m_XMultiplier[e] < 0.0f) {
                    this.m_pHitTestCache.m_LastFailedEdge = e;
                    return false;
                }
            } else if ((y - this.m_pHitTestCache.m_Y[e]) * this.m_pHitTestCache.m_YMultiplier[e] - (x - this.m_pHitTestCache.m_X[e]) * this.m_pHitTestCache.m_XMultiplier[e] <= 0.0f) {
                this.m_pHitTestCache.m_LastFailedEdge = e;
                return false;
            }
            prev = e;
            e = e + 1 & 3;
            ++i;
        }
        Depth.value = (this.m_pHitTestCache.m_D - this.m_pHitTestCache.m_VecN.x * vecP.x - this.m_pHitTestCache.m_VecN.y * vecP.y) * this.m_pHitTestCache.m_OneOverVecNZ;
        return true;
    }

    public void CacheHitTestValues(CqHitTestCache cache, CqVector3D[] points) {
        this.m_pHitTestCache = cache;
        int j = 3;
        int i = 0;
        while (i < 4) {
            cache.m_YMultiplier[i] = points[i].x - points[j].x;
            cache.m_XMultiplier[i] = points[i].y - points[j].y;
            cache.m_X[i] = points[j].x;
            cache.m_Y[i] = points[j].y;
            j = i++;
        }
        if (this.IsDegenerate()) {
            i = 2;
            while (i < 4) {
                cache.m_YMultiplier[i] = points[3].x - points[1].x;
                cache.m_XMultiplier[i] = points[3].y - points[1].y;
                cache.m_X[i] = points[1].x;
                cache.m_Y[i] = points[1].y;
                ++i;
            }
        }
        cache.m_VecN.exterior(points[3].sub(points[0]), points[1].sub(points[0]));
        cache.m_VecN.Unit();
        cache.m_D = cache.m_VecN.mul(points[3]);
        cache.m_OneOverVecNZ = 1.0f / cache.m_VecN.z;
        cache.m_LastFailedEdge = 0;
    }

    public void CacheHitTestValues(CqHitTestCache cache) {
        CqVector3D[] points = new CqVector3D[]{this.PointB(), this.PointC(), this.PointD(), this.PointA()};
        this.CacheHitTestValues(cache, points);
    }

    public void CacheHitTestValuesDof(CqHitTestCache cache, CqVector2D DofOffset, CqVector2D[] coc) {
        CqVector3D[] points = new CqVector3D[]{new CqVector3D(this.PointB().x - coc[1].x * DofOffset.x, this.PointB().y - coc[1].y * DofOffset.y, this.PointB().z), new CqVector3D(this.PointC().x - coc[2].x * DofOffset.x, this.PointC().y - coc[2].y * DofOffset.y, this.PointC().z), new CqVector3D(this.PointD().x - coc[3].x * DofOffset.x, this.PointD().y - coc[3].y * DofOffset.y, this.PointD().z), new CqVector3D(this.PointA().x - coc[0].x * DofOffset.x, this.PointA().y - coc[0].y * DofOffset.y, this.PointA().z)};
        this.CacheHitTestValues(cache, points);
    }

    public void Initialise() {
        int cu = this.m_pGrid.uGridRes();
        int IndexA = this.m_Index;
        int IndexB = this.m_Index + 1;
        int IndexC = this.m_Index + cu + 2;
        int IndexD = this.m_Index + cu + 1;
        int CodeA = 0;
        int CodeB = 1;
        int CodeC = 2;
        int CodeD = 3;
        STLArray<CqVector3D> pP = this.m_pGrid.pVar(8).GetPointPtr_2();
        if ((double)pP.get(IndexA).sub(pP.get(IndexB)).Magnitude2() < 1.0E-8) {
            IndexB = IndexC;
            CodeB = CodeC;
            IndexC = IndexD;
            CodeC = CodeD;
            IndexD = -1;
            CodeD = -1;
        } else if ((double)pP.get(IndexB).sub(pP.get(IndexC)).Magnitude2() < 1.0E-8) {
            IndexB = IndexC;
            CodeB = CodeC;
            IndexC = IndexD;
            CodeC = CodeD;
            IndexD = -1;
            CodeD = -1;
        } else if ((double)pP.get(IndexC).sub(pP.get(IndexD)).Magnitude2() < 1.0E-8) {
            IndexC = IndexD;
            CodeC = CodeD;
            IndexD = -1;
            CodeD = -1;
        } else if ((double)pP.get(IndexD).sub(pP.get(IndexA)).Magnitude2() < 1.0E-8) {
            IndexD = IndexC;
            CodeD = CodeC;
            IndexD = -1;
            CodeD = -1;
        }
        CqVector3D vA2 = pP.get(IndexA);
        CqVector3D vB2 = pP.get(IndexB);
        CqVector3D vC2 = pP.get(IndexC);
        boolean fFlip = (vA2.x - vB2.x) * (vB2.y - vC2.y) >= (vA2.y - vB2.y) * (vB2.x - vC2.x);
        this.m_IndexCode = 0;
        this.m_IndexCode = !fFlip ? (CodeD == -1 ? CodeA & 3 | (CodeC & 3) << 2 | (CodeB & 3) << 4 | 0x8000000 : CodeA & 3 | (CodeD & 3) << 2 | (CodeC & 3) << 4 | (CodeB & 3) << 6) : (CodeD == -1 ? CodeA & 3 | (CodeB & 3) << 2 | (CodeC & 3) << 4 | 0x8000000 : CodeA & 3 | (CodeB & 3) << 2 | (CodeC & 3) << 4 | (CodeD & 3) << 6);
    }

    public CqVector2D ReverseBilinear(CqVector2D v) {
        CqVector2D kResult = new CqVector2D();
        boolean flip = false;
        CqVector2D kA = new CqVector2D(this.PointA());
        CqVector2D kB = new CqVector2D(this.PointB());
        CqVector2D kC = new CqVector2D(this.PointD());
        CqVector2D kD = new CqVector2D(this.PointC());
        if (Math.abs(kB.x - kA.x) < Math.abs(kC.x - kA.x)) {
            CqVector2D temp = new CqVector2D();
            temp.assignment(kC);
            kC.assignment(kB);
            kB.assignment(temp);
        }
        kD.assignAdd(kA.sub(kB).sub(kC));
        kB.assignSub(kA);
        kC.assignSub(kA);
        float fBCdet = kB.x * kC.y - kB.y * kC.x;
        float fCDdet = kC.y * kD.x - kC.x * kD.y;
        CqVector2D kDiff = kA.sub(v);
        float fABdet = kDiff.y * kB.x - kDiff.x * kB.y;
        float fADdet = kDiff.y * kD.x - kDiff.x * kD.y;
        float fA = fCDdet;
        float fB = fADdet + fBCdet;
        float fC = fABdet;
        if ((double)Math.abs(fA) >= 1.0E-6) {
            float fDiscr = (float)Math.sqrt(Math.abs(fB * fB - 4.0f * fA * fC));
            kResult.y((-fB + fDiscr) / (2.0f * fA));
            if (kResult.y < 0.0f || kResult.y > 1.0f) {
                kResult.y((-fB - fDiscr) / (2.0f * fA));
                if (kResult.y < 0.0f || kResult.y > 1.0f) {
                    return new CqVector2D(-1.0f, -1.0f);
                }
            }
        } else {
            kResult.y(-fC / fB);
        }
        kResult.x = -(kDiff.x + kResult.y * kC.x) / (kB.x + kResult.y * kD.x);
        if (flip) {
            float temp = kResult.x;
            kResult.x = kResult.y;
            kResult.y = temp;
        }
        return kResult;
    }

    public CqVector3D PointA() {
        STLArray<CqVector3D> pP = this.m_pGrid.pVar(8).GetPointPtr_2();
        return pP.get(this.GetCodedIndex(this.m_IndexCode, 0));
    }

    public CqVector3D PointB() {
        STLArray<CqVector3D> pP = this.m_pGrid.pVar(8).GetPointPtr_2();
        return pP.get(this.GetCodedIndex(this.m_IndexCode, 1));
    }

    public CqVector3D PointC() {
        STLArray<CqVector3D> pP = this.m_pGrid.pVar(8).GetPointPtr_2();
        return pP.get(this.GetCodedIndex(this.m_IndexCode, 2));
    }

    public CqVector3D PointD() {
        STLArray<CqVector3D> pP = this.m_pGrid.pVar(8).GetPointPtr_2();
        return pP.get(this.GetCodedIndex(this.m_IndexCode, 3));
    }

    public boolean IsDegenerate() {
        return (this.m_IndexCode & 0x8000000) != 0;
    }

    protected int GetCodedIndex(int code, int shift) {
        switch (code >> (shift << 1) & 3) {
            case 1: {
                return this.m_Index + 1;
            }
            case 2: {
                return this.m_Index + this.m_pGrid.uGridRes() + 2;
            }
            case 3: {
                return this.m_Index + this.m_pGrid.uGridRes() + 1;
            }
        }
        return this.m_Index;
    }

    public CqMicroPolygon assignment(CqMicroPolygon From) {
        if (this.m_pGrid != null) {
            this.m_pGrid.Release();
        }
        this.m_pGrid = From.m_pGrid;
        this.m_pGrid.AddRef();
        this.m_Index = From.m_Index;
        this.m_IndexCode = From.m_IndexCode;
        this.m_BoundCode = From.m_BoundCode;
        this.m_Flags = From.m_Flags;
        return this;
    }

    public static void Flush() {
    }
}

