/*
 * Decompiled with CFR 0.152.
 */
package net.cellcomputing.himawari.library;

import net.cellcomputing.himawari.accessory.primitive.p_float;
import net.cellcomputing.himawari.library.CqBasicSurface;
import net.cellcomputing.himawari.library.CqBound;
import net.cellcomputing.himawari.library.CqParameter;
import net.cellcomputing.himawari.library.CqParameterTypedConstant;
import net.cellcomputing.himawari.library.CqParameterTypedVarying;
import net.cellcomputing.himawari.library.CqStats;
import net.cellcomputing.himawari.library.CqSurface;
import net.cellcomputing.himawari.library.EqVariableType;
import net.cellcomputing.himawari.library.RiGlobal;
import net.cellcomputing.himawari.library.types.CqVector3D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp abstract class CqCurve
extends CqSurface {
    protected int m_widthParamIndex;
    protected int m_constantwidthParamIndex;
    protected int m_splitDecision;
    protected static int hwidth = "width".hashCode();
    protected static int hcwidth = "constantwidth".hashCode();
    protected static int hp = "P".hashCode();
    protected static int hu = "u".hashCode();
    protected static int hn = "N".hashCode();
    protected static int hv = "v".hashCode();
    static /* synthetic */ Class class$0;

    public CqCurve() {
        this.m_widthParamIndex = -1;
        this.m_constantwidthParamIndex = -1;
        this.m_splitDecision = 0;
        CqStats.STATS_INC(10);
    }

    public CqCurve(CqCurve from) {
        this.assignment(from);
        CqStats.STATS_INC(10);
    }

    @Override
    public void AddPrimitiveVariable(CqParameter pParam) {
        super.AddPrimitiveVariable(pParam);
        if (pParam.hash() == (long)hwidth) {
            assert (this.m_widthParamIndex == -1);
            this.m_widthParamIndex = this.m_aUserParams.size() - 1;
        } else if (pParam.hash() == (long)hcwidth) {
            assert (this.m_constantwidthParamIndex == -1);
            this.m_constantwidthParamIndex = this.m_aUserParams.size() - 1;
        }
    }

    @Override
    public CqBound Bound() {
        CqVector3D vecA = new CqVector3D(Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE);
        CqVector3D vecB = new CqVector3D(-3.4028235E38f, -3.4028235E38f, -3.4028235E38f);
        float maxCameraSpaceWidth = 0.0f;
        int nWidthParams = this.cVarying();
        int i = 0;
        while (i < this.P().Size()) {
            float camSpaceWidth;
            CqVector3D vecV = new CqVector3D(this.P().pValue_get(i, 0));
            if (vecV.x < vecA.x) {
                vecA.x(vecV.x);
            }
            if (vecV.y < vecA.y) {
                vecA.y(vecV.y);
            }
            if (vecV.x > vecB.x) {
                vecB.x(vecV.x);
            }
            if (vecV.y > vecB.y) {
                vecB.y(vecV.y);
            }
            if (vecV.z < vecA.z) {
                vecA.z(vecV.z);
            }
            if (vecV.z > vecB.z) {
                vecB.z(vecV.z);
            }
            if (i < nWidthParams && (camSpaceWidth = this.width().pValue_get((int)i, (int)0).value) > maxCameraSpaceWidth) {
                maxCameraSpaceWidth = camSpaceWidth;
            }
            ++i;
        }
        vecA.assignSub(maxCameraSpaceWidth / 2.0f);
        vecB.assignAdd(maxCameraSpaceWidth / 2.0f);
        CqBound B = new CqBound();
        B.vecMin().assignment(vecA);
        B.vecMax().assignment(vecB);
        return this.AdjustBoundForTransformationMotion(B);
    }

    public CqCurve assignment(CqCurve from) {
        super.assignment(from);
        return this;
    }

    @Override
    public void SetDefaultPrimitiveVariables(boolean bUseDef_st) {
    }

    protected float GetGridLength() {
        float micropolysPerGrid = 256.0f;
        int[] poptGridSize = RiGlobal.QGetRenderContext().optCurrent().GetIntegerOption("limits", "gridsize");
        if (poptGridSize != null) {
            micropolysPerGrid = poptGridSize[0] * poptGridSize[1];
        }
        float ShadingRate = this.pAttributes().GetFloatAttribute("System", "ShadingRate")[0];
        float mpgsAlongSide = (float)Math.sqrt(micropolysPerGrid);
        return mpgsAlongSide / ShadingRate;
    }

    protected void PopulateWidth() {
        if (this.width() != null) {
            return;
        }
        float widthvalue = 1.0f;
        if (this.constantwidth() != null) {
            widthvalue = this.constantwidth().pValue_get((int)0, (int)0).value;
        }
        CqParameterTypedVarying<p_float, p_float> widthP = new CqParameterTypedVarying<p_float, p_float>("width", new EqVariableType(1), p_float.class, p_float.class);
        widthP.SetSize(this.cVarying());
        int i = 0;
        while (i < this.cVarying()) {
            widthP.pValue_get((int)i, (int)0).value = widthvalue;
            ++i;
        }
        this.AddPrimitiveVariable(widthP);
    }

    public CqParameterTypedConstant<p_float, p_float> constantwidth() {
        if (this.m_constantwidthParamIndex >= 0) {
            return (CqParameterTypedConstant)this.m_aUserParams.get(this.m_constantwidthParamIndex);
        }
        return null;
    }

    @Override
    public boolean Diceable() {
        if (this.m_splitDecision == 0) {
            this.m_splitDecision = 2;
        }
        return false;
    }

    @Override
    public boolean IsMotionBlurMatch(CqBasicSurface pSurf) {
        return false;
    }

    @Override
    public void CopySplitInfo(CqBasicSurface From) {
        super.CopySplitInfo(From);
        try {
            CqCurve pCurve = (CqCurve)From;
            this.m_splitDecision = pCurve.m_splitDecision;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public boolean GetNormal(int index, CqVector3D normal) {
        if (this.N() != null) {
            normal.assignment(this.N().pValue_get(index, 0));
            return true;
        }
        normal.assignment(new CqVector3D(0.0f, 0.0f, -1.0f));
        return true;
    }

    public CqParameterTypedVarying<p_float, p_float> width() {
        if (this.m_widthParamIndex >= 0) {
            return (CqParameterTypedVarying)this.m_aUserParams.get(this.m_widthParamIndex);
        }
        return null;
    }

    protected strictfp class EssSplitDecision {
        public static final int Split_Undecided = 0;
        public static final int Split_Curve = 1;
        public static final int Split_Patch = 2;

        protected EssSplitDecision() {
        }
    }
}

