/*
 * Decompiled with CFR 0.152.
 */
package net.cellcomputing.himawari.display;

import java.awt.image.BufferedImage;
import net.cellcomputing.himawari.display.ImageData;
import net.cellcomputing.himawari.library.IqBucket;
import net.cellcomputing.himawari.library.RiGlobal;
import net.cellcomputing.himawari.library.types.CqColor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class RGBImageData
extends ImageData<BufferedImage> {
    private static final int DATA_SIZE = 3;

    protected RGBImageData(int offset) {
        super(offset);
        this.dataSize = 3;
        this.pixelData = new float[3];
    }

    @Override
    public void init() {
        super.init();
        this.imageData = new BufferedImage(this.width, this.height, 1);
        this.raster = ((BufferedImage)this.imageData).getRaster();
    }

    @Override
    public void setBucket(IqBucket pBucket) {
        if (pBucket.Width() == 0 || pBucket.Height() == 0) {
            return;
        }
        int xmin = pBucket.XOrigin();
        int ymin = pBucket.YOrigin();
        int xmaxplus1 = xmin + pBucket.Width();
        int ymaxplus1 = ymin + pBucket.Height();
        if (xmaxplus1 <= RiGlobal.QGetRenderContext().pImage().CropWindowXMin() || ymaxplus1 <= RiGlobal.QGetRenderContext().pImage().CropWindowYMin() || xmin > RiGlobal.QGetRenderContext().pImage().CropWindowXMax() || ymin > RiGlobal.QGetRenderContext().pImage().CropWindowYMax()) {
            return;
        }
        int y = ymin;
        while (y < ymaxplus1) {
            int x = xmin;
            while (x < xmaxplus1) {
                if (x >= RiGlobal.QGetRenderContext().pImage().CropWindowXMin() && y >= RiGlobal.QGetRenderContext().pImage().CropWindowYMin() && x < RiGlobal.QGetRenderContext().pImage().CropWindowXMax() && y < RiGlobal.QGetRenderContext().pImage().CropWindowYMax()) {
                    CqColor col = pBucket.Color(x, y);
                    this.pixelData[0] = col.fRed();
                    this.pixelData[1] = col.fGreen();
                    this.pixelData[2] = col.fBlue();
                    this.raster.setPixel(x - RiGlobal.QGetRenderContext().pImage().CropWindowXMin(), y - RiGlobal.QGetRenderContext().pImage().CropWindowYMin(), this.pixelData);
                }
                ++x;
            }
            ++y;
        }
    }

    @Override
    public BufferedImage getImage() {
        return (BufferedImage)this.imageData;
    }
}

