/*
 * Decompiled with CFR 0.152.
 */
package net.cellcomputing.himawari.display;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import net.cellcomputing.himawari.display.DisplayRequest;
import net.cellcomputing.himawari.display.ImageData;
import net.cellcomputing.himawari.util.HimawariLogger;

public strictfp class BMPRequest
extends DisplayRequest {
    private static final String IMAGE_EXT = "bmp";

    public BMPRequest(String name, String type, String mode, int modeID, int dataOffset, int dataSize, ImageData imageData) {
        super(name, type, mode, modeID, dataOffset, dataSize, imageData);
    }

    public void openRequest() {
    }

    public void display() {
    }

    public void saveImage(BufferedImage image) {
        Iterator<ImageWriter> writers = ImageIO.getImageWritersByFormatName(IMAGE_EXT);
        if (writers.hasNext()) {
            ImageWriter writer = writers.next();
            try {
                ImageOutputStream stream = ImageIO.createImageOutputStream(new File(this.name));
                writer.setOutput(stream);
                writer.write(image);
                writer.dispose();
                return;
            }
            catch (FileNotFoundException e) {
                HimawariLogger.outputException(e);
                HimawariLogger.getLogger().error("Cannot open output image file: " + this.name + "\n");
            }
            catch (IOException e) {
                HimawariLogger.outputException(e);
                HimawariLogger.getLogger().error("Cannot open output image file: " + this.name + "\n");
            }
        }
    }

    public void closeRequest() {
        BufferedImage image = (BufferedImage)this.imageData.getImage();
        this.saveImage(image);
        this.imageData = null;
    }
}

