/*
 * Decompiled with CFR 0.152.
 */
package net.cellcomputing.himawari.library;

import net.cellcomputing.himawari.library.CqBound;
import net.cellcomputing.himawari.library.RiGlobal;
import net.cellcomputing.himawari.library.types.CqVector2D;
import net.cellcomputing.himawari.library.types.CqVector3D;

public strictfp class CqMovingMicroPolygonKey {
    public CqVector3D m_Point0 = new CqVector3D();
    public CqVector3D m_Point1 = new CqVector3D();
    public CqVector3D m_Point2 = new CqVector3D();
    public CqVector3D m_Point3 = new CqVector3D();
    public CqVector3D m_N = new CqVector3D();
    public float m_D;
    public CqBound m_Bound = new CqBound();
    public boolean m_BoundReady;

    public CqMovingMicroPolygonKey() {
    }

    public CqMovingMicroPolygonKey(CqVector3D vA, CqVector3D vB, CqVector3D vC, CqVector3D vD) {
        this.Initialise(vA, vB, vC, vD);
    }

    public CqBound GetTotalBound() {
        if (this.m_BoundReady) {
            return this.m_Bound;
        }
        this.m_Bound.vecMin().x(Math.min(this.m_Point0.x, Math.min(this.m_Point1.x, Math.min(this.m_Point2.x, this.m_Point3.x))));
        this.m_Bound.vecMin().y(Math.min(this.m_Point0.y, Math.min(this.m_Point1.y, Math.min(this.m_Point2.y, this.m_Point3.y))));
        this.m_Bound.vecMin().z(Math.min(this.m_Point0.z, Math.min(this.m_Point1.z, Math.min(this.m_Point2.z, this.m_Point3.z))));
        this.m_Bound.vecMax().x(Math.max(this.m_Point0.x, Math.max(this.m_Point1.x, Math.max(this.m_Point2.x, this.m_Point3.x))));
        this.m_Bound.vecMax().y(Math.max(this.m_Point0.y, Math.max(this.m_Point1.y, Math.max(this.m_Point2.y, this.m_Point3.y))));
        this.m_Bound.vecMax().z(Math.max(this.m_Point0.z, Math.max(this.m_Point1.z, Math.max(this.m_Point2.z, this.m_Point3.z))));
        if (RiGlobal.QGetRenderContext().UsingDepthOfField()) {
            CqVector2D minZCoc = RiGlobal.QGetRenderContext().GetCircleOfConfusion(this.m_Bound.vecMin().z);
            CqVector2D maxZCoc = RiGlobal.QGetRenderContext().GetCircleOfConfusion(this.m_Bound.vecMax().z);
            float cocX = Math.max(minZCoc.x, maxZCoc.x);
            float cocY = Math.max(minZCoc.y, maxZCoc.y);
            this.m_Bound.vecMin().x(this.m_Bound.vecMin().x - cocX);
            this.m_Bound.vecMin().y(this.m_Bound.vecMin().y - cocY);
            this.m_Bound.vecMax().x(this.m_Bound.vecMax().x + cocX);
            this.m_Bound.vecMax().y(this.m_Bound.vecMax().y + cocY);
        }
        this.m_BoundReady = true;
        return this.m_Bound;
    }

    public void Initialise(CqVector3D vA, CqVector3D vB, CqVector3D vC, CqVector3D vD) {
        boolean fFlip;
        CqVector3D vvB = (double)vA.sub(vB).Magnitude() < 0.01 ? vC : vB;
        CqVector3D vvC = (double)vvB.sub(vC).Magnitude() < 0.01 ? vD : vC;
        CqVector3D vvD = (double)vvC.sub(vD).Magnitude() < 0.01 ? vvC : vD;
        boolean bl = fFlip = (vA.x - vvB.x) * (vvB.y - vvC.y) >= (vA.y - vvB.y) * (vvB.x - vvC.x);
        if (!fFlip) {
            this.m_Point0.assignment(vA);
            this.m_Point1.assignment(vvD);
            this.m_Point2.assignment(vvC);
            this.m_Point3.assignment(vvB);
        } else {
            this.m_Point0.assignment(vA);
            this.m_Point1.assignment(vvB);
            this.m_Point2.assignment(vvC);
            this.m_Point3.assignment(vvD);
        }
        this.m_N = vA.sub(vvB).mod(vvC.sub(vvB));
        this.m_N.Unit();
        this.m_D = this.m_N.mul(vA);
        this.m_BoundReady = false;
    }

    final boolean IsDegenerate() {
        return this.m_Point2.equals(this.m_Point3);
    }

    public CqVector2D ReverseBilinear(CqVector2D v) {
        CqVector2D kA = new CqVector2D();
        CqVector2D kB = new CqVector2D();
        CqVector2D kC = new CqVector2D();
        CqVector2D kD = new CqVector2D();
        kA = new CqVector2D(this.m_Point0);
        kB = new CqVector2D(this.m_Point1).sub(kA);
        kC = new CqVector2D(this.m_Point3).sub(kA);
        kD = new CqVector2D(this.m_Point2).add(kA).sub(new CqVector2D(this.m_Point1)).sub(new CqVector2D(this.m_Point3));
        float fBCdet = kB.x * kC.y - kB.y * kC.x;
        float fCDdet = kC.y * kD.x - kC.x * kD.y;
        CqVector2D kDiff = kA.sub(v);
        float fABdet = kDiff.y * kB.x - kDiff.x * kB.y;
        float fADdet = kDiff.y * kD.x - kDiff.x * kD.y;
        float fA = fCDdet;
        float fB = fADdet + fBCdet;
        float fC = fABdet;
        CqVector2D kResult = new CqVector2D();
        if ((double)Math.abs(fA) >= 1.0E-6) {
            float fDiscr = (float)Math.sqrt(Math.abs(fB * fB - 4.0f * fA * fC));
            kResult.y((-fB + fDiscr) / (2.0f * fA));
            if (kResult.y < 0.0f || kResult.y > 1.0f) {
                kResult.y((-fB - fDiscr) / (2.0f * fA));
                if (kResult.y < 0.0f || kResult.y > 1.0f) {
                    return new CqVector2D(-1.0f, -1.0f);
                }
            }
        } else {
            kResult.y(-fC / fB);
        }
        kResult.x(-(kDiff.x + kResult.y * kC.x) / (kB.x + kResult.y * kD.x));
        return kResult;
    }
}

