/*
 * Decompiled with CFR 0.152.
 */
package net.cellcomputing.himawari.library;

import java.lang.reflect.Modifier;
import net.cellcomputing.himawari.accessory.primitive.p_String;
import net.cellcomputing.himawari.accessory.primitive.p_float;
import net.cellcomputing.himawari.accessory.primitive.p_int;
import net.cellcomputing.himawari.library.types.CqColor;
import net.cellcomputing.himawari.library.types.CqMatrix;
import net.cellcomputing.himawari.library.types.CqVector3D;
import net.cellcomputing.himawari.library.types.CqVector4D;
import net.cellcomputing.himawari.util.HimawariLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class CqForwardDiffBezier<T> {
    private float M00;
    private float M01;
    private float M02;
    private float M03;
    private float M10;
    private float M11;
    private float M12;
    private float M13;
    private float M20;
    private float M21;
    private float M22;
    private float M23;
    Class<? extends T> cls;
    T f;
    T df;
    T ddf;
    T dddf;

    public CqForwardDiffBezier(float dt, Class<? extends T> cls) {
        this.f = this.newInstance(cls);
        this.df = this.newInstance(cls);
        this.ddf = this.newInstance(cls);
        this.dddf = this.newInstance(cls);
        this.InitPreCalcMatrix(dt);
    }

    public void InitPreCalcMatrix(float dt) {
        float dt2 = dt * dt;
        float dt3 = dt2 * dt;
        float dt3_3 = 3.0f * dt3;
        float dt3_6 = 6.0f * dt3;
        float dt3_18 = 18.0f * dt3;
        float dt2_3 = 3.0f * dt2;
        float dt2_6 = 6.0f * dt2;
        float dt_3 = 3.0f * dt;
        this.M00 = -dt3_6;
        this.M01 = dt3_18;
        this.M02 = -dt3_18;
        this.M03 = dt3_6;
        this.M10 = dt2_6 - dt3_6;
        this.M11 = dt3_18 - 2.0f * dt2_6;
        this.M12 = dt2_6 - dt3_18;
        this.M13 = dt3_6;
        this.M20 = dt2_3 - dt_3 - dt3;
        this.M21 = dt3_3 - dt2_6 + dt_3;
        this.M22 = dt2_3 - dt3_3;
        this.M23 = dt3;
    }

    public void CalcForwardDiff(T A, T B, T C, T D) {
        if (A instanceof CqVector3D) {
            ((CqVector3D)this.f).assignment((CqVector3D)A);
            ((CqVector3D)this.df).assignment(((CqVector3D)A).mul(this.M20).add(((CqVector3D)B).mul(this.M21).add(((CqVector3D)C).mul(this.M22).add(((CqVector3D)D).mul(this.M23)))));
            ((CqVector3D)this.ddf).assignment(((CqVector3D)A).mul(this.M10).add(((CqVector3D)B).mul(this.M11).add(((CqVector3D)C).mul(this.M12).add(((CqVector3D)D).mul(this.M13)))));
            ((CqVector3D)this.dddf).assignment(((CqVector3D)A).mul(this.M00).add(((CqVector3D)B).mul(this.M01).add(((CqVector3D)C).mul(this.M02).add(((CqVector3D)D).mul(this.M03)))));
        } else if (A instanceof CqVector4D) {
            ((CqVector4D)this.f).assignment((CqVector4D)A);
            ((CqVector4D)this.df).assignment(((CqVector4D)A).mul(this.M20).add(((CqVector4D)B).mul(this.M21).add(((CqVector4D)C).mul(this.M22).add(((CqVector4D)D).mul(this.M23)))));
            ((CqVector4D)this.ddf).assignment(((CqVector4D)A).mul(this.M10).add(((CqVector4D)B).mul(this.M11).add(((CqVector4D)C).mul(this.M12).add(((CqVector4D)D).mul(this.M13)))));
            ((CqVector4D)this.dddf).assignment(((CqVector4D)A).mul(this.M00).add(((CqVector4D)B).mul(this.M01).add(((CqVector4D)C).mul(this.M02).add(((CqVector4D)D).mul(this.M03)))));
        } else if (A instanceof CqColor) {
            ((CqColor)this.f).assignment((CqColor)A);
            ((CqColor)this.df).assignment(((CqColor)A).mul(this.M20).add(((CqColor)B).mul(this.M21).add(((CqColor)C).mul(this.M22).add(((CqColor)D).mul(this.M23)))));
            ((CqColor)this.ddf).assignment(((CqColor)A).mul(this.M10).add(((CqColor)B).mul(this.M11).add(((CqColor)C).mul(this.M12).add(((CqColor)D).mul(this.M13)))));
            ((CqColor)this.dddf).assignment(((CqColor)A).mul(this.M00).add(((CqColor)B).mul(this.M01).add(((CqColor)C).mul(this.M02).add(((CqColor)D).mul(this.M03)))));
        } else if (A instanceof CqMatrix) {
            ((CqMatrix)this.f).assignment((CqMatrix)A);
            ((CqMatrix)this.df).assignment(((CqMatrix)A).multiply(this.M20).add(((CqMatrix)B).multiply(this.M21)).add(((CqMatrix)C).multiply(this.M22)).add(((CqMatrix)D).multiply(this.M23)));
            ((CqMatrix)this.ddf).assignment(((CqMatrix)A).multiply(this.M10).add(((CqMatrix)B).multiply(this.M11)).add(((CqMatrix)C).multiply(this.M12)).add(((CqMatrix)D).multiply(this.M13)));
            ((CqMatrix)this.dddf).assignment(((CqMatrix)A).multiply(this.M00).add(((CqMatrix)B).multiply(this.M01)).add(((CqMatrix)C).multiply(this.M02)).add(((CqMatrix)D).multiply(this.M03)));
        } else if (A instanceof p_float) {
            ((p_float)this.f).value = ((p_float)A).value;
            ((p_float)this.df).value = ((p_float)A).value * this.M20 + ((p_float)B).value * this.M21 + ((p_float)C).value * this.M22 + ((p_float)D).value * this.M23;
            ((p_float)this.ddf).value = ((p_float)A).value * this.M10 + ((p_float)B).value * this.M11 + ((p_float)C).value * this.M12 + ((p_float)D).value * this.M13;
            ((p_float)this.dddf).value = ((p_float)A).value * this.M00 + ((p_float)B).value * this.M01 + ((p_float)C).value * this.M02 + ((p_float)D).value * this.M03;
        } else if (A instanceof p_int) {
            ((p_int)this.f).value = ((p_int)A).value;
            ((p_int)this.df).value = (int)((float)((p_int)A).value * this.M20 + (float)((p_int)B).value * this.M21 + (float)((p_int)C).value * this.M22 + (float)((p_int)D).value * this.M23);
            ((p_int)this.ddf).value = (int)((float)((p_int)A).value * this.M10 + (float)((p_int)B).value * this.M11 + (float)((p_int)C).value * this.M12 + (float)((p_int)D).value * this.M13);
            ((p_int)this.dddf).value = (int)((float)((p_int)A).value * this.M00 + (float)((p_int)B).value * this.M01 + (float)((p_int)C).value * this.M02 + (float)((p_int)D).value * this.M03);
        } else if (A instanceof p_String) {
            ((p_String)this.f).value = ((p_String)A).value;
            ((p_String)this.df).value = String.valueOf(((p_String)A).value) + ((p_String)B).value + ((p_String)C).value + ((p_String)D).value;
            ((p_String)this.ddf).value = String.valueOf(((p_String)A).value) + ((p_String)B).value + ((p_String)C).value + ((p_String)D).value;
            ((p_String)this.dddf).value = String.valueOf(((p_String)A).value) + ((p_String)B).value + ((p_String)C).value + ((p_String)D).value;
        }
    }

    public T GetValue() {
        Object res;
        if (this.f instanceof CqVector3D) {
            res = new CqVector3D((CqVector3D)this.f);
            ((CqVector3D)this.f).assignment(((CqVector3D)this.f).add((CqVector3D)this.df));
            ((CqVector3D)this.df).assignment(((CqVector3D)this.df).add((CqVector3D)this.ddf));
            ((CqVector3D)this.ddf).assignment(((CqVector3D)this.ddf).add((CqVector3D)this.dddf));
        } else if (this.f instanceof CqVector4D) {
            res = new CqVector4D((CqVector4D)this.f);
            ((CqVector4D)this.f).assignment(((CqVector4D)this.f).add((CqVector4D)this.df));
            ((CqVector4D)this.df).assignment(((CqVector4D)this.df).add((CqVector4D)this.ddf));
            ((CqVector4D)this.ddf).assignment(((CqVector4D)this.ddf).add((CqVector4D)this.dddf));
        } else if (this.f instanceof CqColor) {
            res = new CqColor((CqColor)this.f);
            ((CqColor)this.f).assignment(((CqColor)this.f).add((CqColor)this.df));
            ((CqColor)this.df).assignment(((CqColor)this.df).add((CqColor)this.ddf));
            ((CqColor)this.ddf).assignment(((CqColor)this.ddf).add((CqColor)this.dddf));
        } else if (this.f instanceof CqMatrix) {
            res = new CqMatrix((CqMatrix)this.f);
            ((CqMatrix)this.f).assignment(((CqMatrix)this.f).add((CqMatrix)this.df));
            ((CqMatrix)this.df).assignment(((CqMatrix)this.df).add((CqMatrix)this.ddf));
            ((CqMatrix)this.ddf).assignment(((CqMatrix)this.ddf).add((CqMatrix)this.dddf));
        } else if (this.f instanceof p_float) {
            res = new p_float(((p_float)this.f).value);
            ((p_float)this.f).value += ((p_float)this.df).value;
            ((p_float)this.df).value += ((p_float)this.ddf).value;
            ((p_float)this.ddf).value += ((p_float)this.dddf).value;
        } else if (this.f instanceof p_int) {
            res = new p_int(((p_int)this.f).value);
            ((p_int)this.f).value += ((p_int)this.df).value;
            ((p_int)this.df).value += ((p_int)this.ddf).value;
            ((p_int)this.ddf).value += ((p_int)this.dddf).value;
        } else if (this.f instanceof p_String) {
            res = new p_String(((p_String)this.f).value);
            ((p_String)this.f).value = String.valueOf(((p_String)this.f).value) + ((p_String)this.df).value;
            ((p_String)this.df).value = String.valueOf(((p_String)this.df).value) + ((p_String)this.ddf).value;
            ((p_String)this.ddf).value = String.valueOf(((p_String)this.ddf).value) + ((p_String)this.dddf).value;
        } else {
            res = null;
        }
        return (T)res;
    }

    private T newInstance(Class<? extends T> cls) {
        try {
            return cls.newInstance();
        }
        catch (Exception e) {
            int mod = cls.getModifiers();
            if (!Modifier.isInterface(mod) && !Modifier.isAbstract(mod)) {
                HimawariLogger.outputException(e);
            }
            return null;
        }
    }
}

