/*
 * Decompiled with CFR 0.152.
 */
package net.cellcomputing.himawari.library;

import net.cellcomputing.himawari.accessory.STLVector;
import net.cellcomputing.himawari.accessory.primitive.p_float;
import net.cellcomputing.himawari.library.CqBasicSurface;
import net.cellcomputing.himawari.library.CqCubicCurveSegment;
import net.cellcomputing.himawari.library.CqCurvesGroup;
import net.cellcomputing.himawari.library.CqParameter;
import net.cellcomputing.himawari.library.CqParameterTypedVarying;
import net.cellcomputing.himawari.library.EqVariableType;
import net.cellcomputing.himawari.library.RiGlobal;
import net.cellcomputing.himawari.library.types.CqMatrix;
import net.cellcomputing.himawari.library.types.CqVector3D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class CqCubicCurvesGroup
extends CqCurvesGroup {
    static /* synthetic */ Class class$0;

    public CqCubicCurvesGroup(int ncurves, int[] nvertices, boolean periodic) {
        this.m_ncurves = ncurves;
        this.m_periodic = periodic;
        this.m_nTotalVerts = 0;
        int i = 0;
        while (i < ncurves) {
            this.m_nTotalVerts += nvertices[i];
            ++i;
        }
        this.m_nvertices.clear();
        i = 0;
        while (i < this.m_ncurves) {
            this.m_nvertices.add(nvertices[i]);
            ++i;
        }
    }

    public CqCubicCurvesGroup(CqCubicCurvesGroup from) {
        this.assignment(from);
    }

    public CqCubicCurvesGroup assignment(CqCubicCurvesGroup from) {
        super.assignment(from);
        return this;
    }

    @Override
    public int Split(STLVector<CqBasicSurface> aSplits) {
        int vStep = this.pAttributes().GetIntegerAttribute("System", "BasisStep")[1];
        int bUses = this.Uses();
        int vertexI = 0;
        int varyingI = 0;
        int uniformI = 0;
        int nsplits = 0;
        int curveN = 0;
        while (curveN < this.m_ncurves) {
            int npcSegs = this.m_periodic ? (Integer)this.m_nvertices.get(curveN) / vStep : ((Integer)this.m_nvertices.get(curveN) - 4) / vStep + 1;
            int nVarying = this.m_periodic ? npcSegs : npcSegs + 1;
            int nextCurveVertexIndex = vertexI + (Integer)this.m_nvertices.get(curveN);
            int nextCurveVaryingIndex = varyingI + nVarying;
            int pcN = 0;
            while (pcN < npcSegs) {
                int cvi = 0;
                int cva = 0;
                int[] vi = new int[4];
                vi[0] = vertexI + cvi;
                if (++cvi >= (Integer)this.m_nvertices.get(curveN)) {
                    cvi = 0;
                }
                vi[1] = vertexI + cvi;
                if (++cvi >= (Integer)this.m_nvertices.get(curveN)) {
                    cvi = 0;
                }
                vi[2] = vertexI + cvi;
                if (++cvi >= (Integer)this.m_nvertices.get(curveN)) {
                    cvi = 0;
                }
                vi[3] = vertexI + cvi;
                ++cvi;
                int i = 0;
                while (i < vi.length) {
                    if (vi[i] >= nextCurveVertexIndex) {
                        int n = i;
                        vi[n] = vi[n] - (Integer)this.m_nvertices.get(curveN);
                    }
                    ++i;
                }
                int[] vai = new int[2];
                vai[0] = varyingI + cva;
                if (++cva >= nVarying) {
                    cva = 0;
                }
                vai[1] = varyingI + cva;
                ++cva;
                int i2 = 0;
                while (i2 < 2) {
                    if (vai[i2] >= nextCurveVaryingIndex) {
                        int n = i2;
                        vai[n] = vai[n] - nVarying;
                    }
                    ++i2;
                }
                float vstart = (float)pcN / (float)npcSegs;
                float vend = (float)(pcN + 1) / (float)npcSegs;
                CqCubicCurveSegment pSeg = new CqCubicCurveSegment();
                pSeg.SetSurfaceParameters(this);
                if (RiGlobal.USES(bUses, 13)) {
                    CqParameterTypedVarying<p_float, p_float> pVP = new CqParameterTypedVarying<p_float, p_float>("v", 1, new EqVariableType(1), p_float.class, p_float.class);
                    pVP.SetSize(pSeg.cVarying());
                    pVP.pValue_get((int)0, (int)0).value = vstart;
                    pVP.pValue_get((int)1, (int)0).value = vend;
                    pSeg.AddPrimitiveVariable(pVP);
                }
                for (CqParameter iUP : this.aUserParams()) {
                    CqParameter pNewUP;
                    if (iUP.Class().getValue() == 4) {
                        pNewUP = iUP.CloneType(iUP.strName(), iUP.Count());
                        pNewUP.SetSize(pSeg.cVertex());
                        int i3 = 0;
                        while (i3 < 4) {
                            pNewUP.SetValue(iUP, i3, vi[i3]);
                            ++i3;
                        }
                        pSeg.AddPrimitiveVariable(pNewUP);
                        continue;
                    }
                    if (iUP.Class().getValue() == 3) {
                        pNewUP = iUP.CloneType(iUP.strName(), iUP.Count());
                        pNewUP.SetSize(pSeg.cVarying());
                        pNewUP.SetValue(iUP, 0, vai[0]);
                        pNewUP.SetValue(iUP, 1, vai[1]);
                        pSeg.AddPrimitiveVariable(pNewUP);
                        continue;
                    }
                    if (iUP.Class().getValue() == 2) {
                        pNewUP = iUP.CloneType(iUP.strName(), iUP.Count());
                        pNewUP.SetSize(pSeg.cUniform());
                        pNewUP.SetValue(iUP, 0, uniformI);
                        pSeg.AddPrimitiveVariable(pNewUP);
                        continue;
                    }
                    if (iUP.Class().getValue() != 1) continue;
                    pNewUP = iUP.CloneType(iUP.strName(), iUP.Count());
                    pNewUP.SetSize(1);
                    pNewUP.SetValue(iUP, 0, 0);
                    pSeg.AddPrimitiveVariable(pNewUP);
                }
                vertexI += vStep;
                ++varyingI;
                ++nsplits;
                CqMatrix matBasis = this.pAttributes().GetMatrixAttribute("System", "Basis")[1];
                pSeg.ConvertToBezierBasis(matBasis);
                aSplits.add(pSeg);
                ++pcN;
            }
            vertexI = nextCurveVertexIndex;
            varyingI = nextCurveVaryingIndex;
            ++uniformI;
            ++curveN;
        }
        return nsplits;
    }

    @Override
    public void Transform(CqMatrix matTx, CqMatrix matITTx, CqMatrix matRTx, int iTime) {
        this.PopulateWidth();
        int vStep = this.pAttributes().GetIntegerAttribute("System", "BasisStep")[1];
        int widthI = 0;
        int vertexI = 0;
        int curveN = 0;
        while (curveN < this.m_ncurves) {
            int nsegments = this.m_periodic ? (Integer)this.m_nvertices.get(curveN) / vStep : ((Integer)this.m_nvertices.get(curveN) - 4) / vStep + 1;
            int nvarying = this.m_periodic ? nsegments : nsegments + 1;
            int nextCurveVertexIndex = vertexI + (Integer)this.m_nvertices.get(curveN);
            int ccwidth = 0;
            while (ccwidth < nvarying) {
                CqVector3D horiz = new CqVector3D(1.0f, 0.0f, 0.0f);
                horiz = matITTx.multiply(horiz);
                horiz.assignMul(this.width().pValue_get((int)widthI, (int)0).value / horiz.Magnitude());
                CqVector3D pt = new CqVector3D(this.P().pValue_get(vertexI, 0));
                CqVector3D pt_delta = pt.add(horiz);
                pt = matTx.multiply(pt);
                pt_delta = matTx.multiply(pt_delta);
                CqVector3D widthVector = pt_delta.sub(pt);
                this.width().pValue_get((int)widthI, (int)0).value = widthVector.Magnitude();
                ++widthI;
                if ((vertexI += vStep) >= (Integer)this.m_nvertices.get(curveN)) {
                    vertexI -= ((Integer)this.m_nvertices.get(curveN)).intValue();
                }
                ++ccwidth;
            }
            vertexI = nextCurveVertexIndex;
            ++curveN;
        }
        super.Transform(matTx, matITTx, matRTx, iTime);
    }

    @Override
    public int cVarying() {
        int vStep = this.pAttributes().GetIntegerAttribute("System", "BasisStep")[1];
        int varying_count = 0;
        int i = 0;
        while (i < this.m_ncurves) {
            int segment_count = this.m_periodic ? (Integer)this.m_nvertices.get(i) / vStep : ((Integer)this.m_nvertices.get(i) - 4) / vStep + 1;
            varying_count += this.m_periodic ? segment_count : segment_count + 1;
            ++i;
        }
        return varying_count;
    }

    @Override
    public int cFaceVarying() {
        return 0;
    }

    @Override
    public int cUniform() {
        return this.m_ncurves;
    }

    @Override
    public int cVertex() {
        return this.m_nTotalVerts;
    }
}

