/*
 * Decompiled with CFR 0.152.
 */
package net.cellcomputing.himawari.display;

import net.cellcomputing.himawari.accessory.Valarray;
import net.cellcomputing.himawari.display.ImageData;
import net.cellcomputing.himawari.library.CqBucket;
import net.cellcomputing.himawari.library.IqBucket;
import net.cellcomputing.himawari.library.RiGlobal;
import net.cellcomputing.himawari.library.types.CqColor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class HDRImage
extends ImageData<CqColor[][]> {
    protected HDRImage(int offset) {
        super(offset);
    }

    @Override
    public void setBucket(IqBucket pBucket) {
        if (pBucket.Width() == 0 || pBucket.Height() == 0) {
            return;
        }
        int xmin = pBucket.XOrigin();
        int ymin = pBucket.YOrigin();
        int xmaxplus1 = xmin + pBucket.Width();
        int ymaxplus1 = ymin + pBucket.Height();
        if (xmaxplus1 <= RiGlobal.QGetRenderContext().pImage().CropWindowXMin() || ymaxplus1 <= RiGlobal.QGetRenderContext().pImage().CropWindowYMin() || xmin > RiGlobal.QGetRenderContext().pImage().CropWindowXMax() || ymin > RiGlobal.QGetRenderContext().pImage().CropWindowYMax()) {
            return;
        }
        int y = ymin;
        while (y < ymaxplus1) {
            int x = xmin;
            while (x < xmaxplus1) {
                if (x >= RiGlobal.QGetRenderContext().pImage().CropWindowXMin() && y >= RiGlobal.QGetRenderContext().pImage().CropWindowYMin() && x < RiGlobal.QGetRenderContext().pImage().CropWindowXMax() && y < RiGlobal.QGetRenderContext().pImage().CropWindowYMax()) {
                    CqColor col;
                    if (this.offset == 0) {
                        col = ((CqBucket)pBucket).getFColor(x, y);
                    } else {
                        Valarray val = ((CqBucket)pBucket).Data(x, y);
                        float val0 = val.valueAt(this.offset + 0);
                        float val1 = val.valueAt(this.offset + 1);
                        float val2 = val.valueAt(this.offset + 2);
                        if (this.m_QuantizeZeroVal != 0.0f || this.m_QuantizeOneVal != 0.0f || this.m_QuantizeMinVal != 0.0f || this.m_QuantizeMaxVal != 0.0f) {
                            val0 = this.quantize(val0);
                            val1 = this.quantize(val1);
                            val2 = this.quantize(val2);
                        }
                        col = new CqColor(val0, val1, val2);
                    }
                    ((CqColor[][])this.imageData)[y - RiGlobal.QGetRenderContext().pImage().CropWindowYMin()][x - RiGlobal.QGetRenderContext().pImage().CropWindowXMin()] = new CqColor(col);
                }
                ++x;
            }
            ++y;
        }
    }

    @Override
    public CqColor[][] getImage() {
        return (CqColor[][])this.imageData;
    }

    @Override
    public void init() {
        super.init();
        this.imageData = new CqColor[this.height][this.width];
    }
}

