/*
 * Decompiled with CFR 0.152.
 */
package net.cellcomputing.himawari.accessory;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;
import java.util.SortedSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class STLPriorityQueue<E>
extends AbstractQueue<E> {
    private static final int DEFAULT_INITIAL_CAPACITY = 11;
    private transient Object[] queue;
    private int size = 0;
    private final Comparator<? super E> comparator;
    private transient int modCount = 0;

    public STLPriorityQueue() {
        this(11, null);
    }

    public STLPriorityQueue(int initialCapacity) {
        this(initialCapacity, null);
    }

    public STLPriorityQueue(int initialCapacity, Comparator<? super E> comparator) {
        if (initialCapacity < 1) {
            throw new IllegalArgumentException();
        }
        this.queue = new Object[initialCapacity + 1];
        this.comparator = comparator;
    }

    private void initializeArray(Collection<? extends E> c) {
        int sz = c.size();
        int initialCapacity = (int)Math.min((long)sz * 110L / 100L, 0x7FFFFFFEL);
        if (initialCapacity < 1) {
            initialCapacity = 1;
        }
        this.queue = new Object[initialCapacity + 1];
    }

    private void fillFromSorted(Collection<? extends E> c) {
        Iterator<E> i = c.iterator();
        while (i.hasNext()) {
            this.queue[++this.size] = i.next();
        }
    }

    private void fillFromUnsorted(Collection<? extends E> c) {
        Iterator<E> i = c.iterator();
        while (i.hasNext()) {
            this.queue[++this.size] = i.next();
        }
        this.heapify();
    }

    public STLPriorityQueue(Collection<? extends E> c) {
        this.initializeArray(c);
        if (c instanceof SortedSet) {
            SortedSet s = (SortedSet)c;
            this.comparator = s.comparator();
            this.fillFromSorted(s);
        } else if (c instanceof STLPriorityQueue) {
            STLPriorityQueue s = (STLPriorityQueue)c;
            this.comparator = s.comparator();
            this.fillFromSorted(s);
        } else {
            this.comparator = null;
            this.fillFromUnsorted(c);
        }
    }

    public STLPriorityQueue(PriorityQueue<? extends E> c) {
        this.initializeArray(c);
        this.comparator = c.comparator();
        this.fillFromSorted(c);
    }

    public STLPriorityQueue(SortedSet<? extends E> c) {
        this.initializeArray(c);
        this.comparator = c.comparator();
        this.fillFromSorted(c);
    }

    /*
     * Unable to fully structure code
     */
    private void grow(int index) {
        newlen = this.queue.length;
        if (index < newlen) {
            return;
        }
        if (index != 0x7FFFFFFF) ** GOTO lbl10
        throw new OutOfMemoryError();
lbl-1000:
        // 1 sources

        {
            if (newlen >= 0x3FFFFFFF) {
                newlen = 0x7FFFFFFF;
                continue;
            }
            newlen <<= 2;
lbl10:
            // 3 sources

            ** while (newlen <= index)
        }
lbl11:
        // 1 sources

        newQueue = new Object[newlen];
        System.arraycopy(this.queue, 0, newQueue, 0, this.queue.length);
        this.queue = newQueue;
    }

    @Override
    public boolean offer(E o) {
        if (o == null) {
            throw new NullPointerException();
        }
        ++this.modCount;
        ++this.size;
        if (this.size >= this.queue.length) {
            this.grow(this.size);
        }
        this.queue[this.size] = o;
        this.fixUp(this.size);
        return true;
    }

    @Override
    public E peek() {
        if (this.size == 0) {
            return null;
        }
        return (E)this.queue[1];
    }

    @Override
    public boolean add(E o) {
        return this.offer(o);
    }

    @Override
    public boolean remove(Object o) {
        if (o == null) {
            return false;
        }
        if (this.comparator == null) {
            int i = 1;
            while (i <= this.size) {
                if (((Comparable)this.queue[i]).compareTo(o) == 0) {
                    this.removeAt(i);
                    return true;
                }
                ++i;
            }
        } else {
            int i = 1;
            while (i <= this.size) {
                if (this.comparator.compare(this.queue[i], o) == 0) {
                    this.removeAt(i);
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        ++this.modCount;
        int i = 1;
        while (i <= this.size) {
            this.queue[i] = null;
            ++i;
        }
        this.size = 0;
    }

    @Override
    public E poll() {
        if (this.size == 0) {
            return null;
        }
        ++this.modCount;
        Object result = this.queue[1];
        this.queue[1] = this.queue[this.size];
        this.queue[this.size--] = null;
        if (this.size > 1) {
            this.fixDown(1);
        }
        return (E)result;
    }

    private E removeAt(int i) {
        Object moved;
        assert (i > 0 && i <= this.size);
        ++this.modCount;
        this.queue[i] = moved = this.queue[this.size];
        this.queue[this.size--] = null;
        if (i <= this.size) {
            this.fixDown(i);
            if (this.queue[i] == moved) {
                this.fixUp(i);
                if (this.queue[i] != moved) {
                    return (E)moved;
                }
            }
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private void fixUp(int k) {
        block3: {
            if (this.comparator != null) ** GOTO lbl17
            while (k > 1) {
                j = k >> 1;
                if (((Comparable)this.queue[j]).compareTo(this.queue[k]) > 0) {
                    tmp = this.queue[j];
                    this.queue[j] = this.queue[k];
                    this.queue[k] = tmp;
                    k = j;
                    continue;
                }
                break block3;
            }
            break block3;
            while (this.comparator.compare(this.queue[j = k >>> 1], this.queue[k]) > 0) {
                tmp = this.queue[j];
                this.queue[j] = this.queue[k];
                this.queue[k] = tmp;
                k = j;
lbl17:
                // 2 sources

                if (k > 1) continue;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void fixDown(int k) {
        block5: {
            if (this.comparator != null) ** GOTO lbl20
            while ((j = k << 1) <= this.size && j > 0) {
                if (j < this.size && ((Comparable)this.queue[j]).compareTo(this.queue[j + 1]) >= 0) {
                    ++j;
                }
                if (((Comparable)this.queue[k]).compareTo(this.queue[j]) >= 0) {
                    tmp = this.queue[j];
                    this.queue[j] = this.queue[k];
                    this.queue[k] = tmp;
                    k = j;
                    continue;
                }
                break block5;
            }
            break block5;
lbl-1000:
            // 1 sources

            {
                if (j < this.size && this.comparator.compare(this.queue[j], this.queue[j + 1]) >= 0) {
                    ++j;
                }
                if (this.comparator.compare(this.queue[k], this.queue[j]) < 0) break;
                tmp = this.queue[j];
                this.queue[j] = this.queue[k];
                this.queue[k] = tmp;
                k = j;
lbl20:
                // 2 sources

                ** while ((j = k << 1) <= this.size && j > 0)
            }
        }
    }

    private void heapify() {
        int i = this.size / 2;
        while (i >= 1) {
            this.fixDown(i);
            --i;
        }
    }

    public Comparator<? super E> comparator() {
        return this.comparator;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.queue.length);
        int i = 1;
        while (i <= this.size) {
            s.writeObject(this.queue[i]);
            ++i;
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int arrayLength = s.readInt();
        this.queue = new Object[arrayLength];
        int i = 1;
        while (i <= this.size) {
            this.queue[i] = s.readObject();
            ++i;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private strictfp class Itr
    implements Iterator<E> {
        private int cursor = 1;
        private int lastRet = 0;
        private int expectedModCount;
        private ArrayList<E> forgetMeNot;
        private Object lastRetElt;

        Itr() {
            this.expectedModCount = STLPriorityQueue.this.modCount;
            this.forgetMeNot = null;
            this.lastRetElt = null;
        }

        @Override
        public boolean hasNext() {
            return this.cursor <= STLPriorityQueue.this.size || this.forgetMeNot != null;
        }

        @Override
        public E next() {
            Object result;
            this.checkForComodification();
            if (this.cursor <= STLPriorityQueue.this.size) {
                result = STLPriorityQueue.this.queue[this.cursor];
                this.lastRet = this.cursor++;
            } else {
                if (this.forgetMeNot == null) {
                    throw new NoSuchElementException();
                }
                int remaining = this.forgetMeNot.size();
                result = this.forgetMeNot.remove(remaining - 1);
                if (remaining == 1) {
                    this.forgetMeNot = null;
                }
                this.lastRet = 0;
                this.lastRetElt = result;
            }
            return result;
        }

        @Override
        public void remove() {
            this.checkForComodification();
            if (this.lastRet != 0) {
                Object moved = STLPriorityQueue.this.removeAt(this.lastRet);
                this.lastRet = 0;
                if (moved == null) {
                    --this.cursor;
                } else {
                    if (this.forgetMeNot == null) {
                        this.forgetMeNot = new ArrayList();
                    }
                    this.forgetMeNot.add(moved);
                }
            } else if (this.lastRetElt != null) {
                STLPriorityQueue.this.remove(this.lastRetElt);
                this.lastRetElt = null;
            } else {
                throw new IllegalStateException();
            }
            this.expectedModCount = STLPriorityQueue.this.modCount;
        }

        final void checkForComodification() {
            if (STLPriorityQueue.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

