/*
 * Decompiled with CFR 0.152.
 */
package net.cellcomputing.himawari.accessory;

import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.util.AbstractList;
import java.util.Collection;
import net.cellcomputing.himawari.accessory.primitive.p_String;
import net.cellcomputing.himawari.accessory.primitive.p_float;
import net.cellcomputing.himawari.accessory.primitive.p_int;
import net.cellcomputing.himawari.library.types.CqColor;
import net.cellcomputing.himawari.library.types.CqMatrix;
import net.cellcomputing.himawari.library.types.CqVector3D;
import net.cellcomputing.himawari.library.types.CqVector4D;
import net.cellcomputing.himawari.util.HimawariLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class STLArray<T>
extends AbstractList<T> {
    private Class<? extends T> myClass;
    protected T[] elementData;
    protected int elementCount;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;

    public STLArray(Class<? extends T> cls) {
        this.myClass = cls;
        this.elementData = new Object[10];
    }

    public STLArray(Class<? extends T> cls, int initialCapacity) {
        this.myClass = cls;
        this.elementData = new Object[initialCapacity];
        try {
            int i = 0;
            while (i < initialCapacity) {
                this.elementData[i] = cls.newInstance();
                ++i;
            }
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        this.elementCount = initialCapacity;
    }

    public void resize(int newSize) {
        block4: {
            Class<T> cls = this.myClass;
            int oldSize = this.elementCount;
            this.elementCount = newSize;
            try {
                if (newSize > oldSize) {
                    T[] oldData = this.elementData;
                    this.elementData = new Object[newSize];
                    System.arraycopy(oldData, 0, this.elementData, 0, oldSize);
                    int i = oldSize;
                    while (i < newSize) {
                        this.elementData[i] = this.myClass.newInstance();
                        ++i;
                    }
                }
            }
            catch (Exception e) {
                int mod = cls.getModifiers();
                if (Modifier.isInterface(mod) || Modifier.isAbstract(mod)) break block4;
                HimawariLogger.outputException(e);
            }
        }
    }

    public T elementAt(int index) {
        if (index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(index) + " >= " + this.elementCount);
        }
        return this.elementData[index];
    }

    @Override
    public T get(int index) {
        if (index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(index) + " >= " + this.elementCount);
        }
        return this.elementData[index];
    }

    public void setElementAt(T obj, int index) {
        if (index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(index) + " >= " + this.elementCount);
        }
        this.elementData[index] = obj;
    }

    @Override
    public T set(int index, T obj) {
        if (index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(index) + " >= " + this.elementCount);
        }
        this.elementData[index] = obj;
        return obj;
    }

    @Override
    public int size() {
        return this.elementCount;
    }

    public void assign(int num, T val) {
        this.resize(num);
        if (this.myClass.equals(CqVector3D.class)) {
            int i = 0;
            while (i < this.elementCount) {
                ((CqVector3D)this.elementData[i]).assignment((CqVector3D)val);
                ++i;
            }
        } else if (this.myClass.equals(CqVector4D.class)) {
            int i = 0;
            while (i < this.elementCount) {
                ((CqVector4D)this.elementData[i]).assignment((CqVector4D)val);
                ++i;
            }
        } else if (this.myClass.equals(p_float.class)) {
            int i = 0;
            while (i < this.elementCount) {
                ((p_float)this.elementData[i]).value = ((p_float)val).value;
                ++i;
            }
        } else if (this.myClass.equals(CqColor.class)) {
            int i = 0;
            while (i < this.elementCount) {
                ((CqColor)this.elementData[i]).assignment((CqColor)val);
                ++i;
            }
        } else if (this.myClass.equals(CqMatrix.class)) {
            int i = 0;
            while (i < this.elementCount) {
                ((CqMatrix)this.elementData[i]).assignment((CqMatrix)val);
                ++i;
            }
        } else if (this.myClass.equals(p_int.class)) {
            int i = 0;
            while (i < this.elementCount) {
                ((p_int)this.elementData[i]).value = ((p_int)val).value;
                ++i;
            }
        } else if (this.myClass.equals(p_String.class)) {
            int i = 0;
            while (i < this.elementCount) {
                ((p_String)this.elementData[i]).value = ((p_String)val).value;
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.elementCount) {
                this.setElementAt(val, i);
                ++i;
            }
        }
    }

    public void setSize(int size) {
        this.resize(size);
    }

    @Override
    public void clear() {
        int i = 0;
        while (i < this.elementCount) {
            this.elementData[i] = null;
            ++i;
        }
        this.elementCount = 0;
    }

    public T[] toArray(int StartPoint) {
        Object[] array = (Object[])Array.newInstance(this.getClass(), this.elementCount - StartPoint);
        System.arraycopy(this.elementData, StartPoint, array, 0, this.elementCount - StartPoint);
        return array;
    }

    @Override
    public T[] toArray() {
        return this.elementData;
    }

    public void ensureCapacity(int minCapacity) {
        int oldCapacity = this.elementData.length;
        if (minCapacity > oldCapacity) {
            T[] oldData = this.elementData;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.elementData = new Object[newCapacity];
            System.arraycopy(oldData, 0, this.elementData, 0, this.elementCount);
        }
    }

    @Override
    public boolean add(T o) {
        this.ensureCapacity(this.elementCount + 1);
        this.elementData[this.elementCount++] = o;
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        Object[] oldData = c.toArray();
        int numNew = c.size();
        this.ensureCapacity(this.elementCount + numNew);
        System.arraycopy(oldData, 0, this.elementData, this.elementCount, numNew);
        this.elementCount += numNew;
        return numNew != 0;
    }
}

