/*
 * segatex SELinux tool.
 *
 * Copyright (C) 2007-2014 Shintaro Fujiwara 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * */

#include <QButtonGroup>
#include <QHBoxLayout>
#include <QLabel>
#include <QLineEdit>
#include <QLayout>
#include <QMessageBox>
#include <QPushButton>
#include <QProcess>
#include <QRadioButton>
#include <QTextEdit>
#include <QTextStream>
#include <QVBoxLayout>

#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <fstream>

#include "sepolicygenerate.h"

#include <iostream>
using namespace std;

// constructor
SepolicyGenerate::SepolicyGenerate(QWidget *parent, const char *name): QDialog(parent, name)
{
        setCaption(tr("Sepolicy Generate Process"));
	textEdit1 = new QTextEdit(this);
	textEdit1->setPaletteBackgroundColor(QColor(0,254,100));
	semanageEditLabel = new QLabel(tr("command:"), this );
	semanageEditLabel2 = new QLabel(tr("WRITE_PATH:"), this );
	semanageEditLineEdit = new QLineEdit( this );
	semanageEditLineEdit->setText("");
	semanageEditLineEdit->setPaletteBackgroundColor(QColor(255,100,200));
	semanageEditLineEdit2 = new QLineEdit( this );
	semanageEditLineEdit2->setText("");
	semanageEditLineEdit2->setPaletteBackgroundColor(QColor(255,100,200));
	policygenerationButton = new QPushButton(tr("Generate policy files"), this);
	policygenerationButton->setPaletteBackgroundColor(QColor(200,157,100));
	connect(policygenerationButton, SIGNAL(clicked()), this, SLOT(policygeneration_button_clicked()));

	closeButton = new QPushButton(tr("close"), this);
	//closing process button
	connect(closeButton, SIGNAL(clicked()), this, SLOT(close()));
	closeButton->setDefault(true);

	policygeneration_base_process();

	mainLayout = new QVBoxLayout(this);
	mainLayout->setMargin(11);

	upperLayout = new QVBoxLayout;
	upperLayout->addWidget(textEdit1);

	middleLayout = new QVBoxLayout;
	leftLayout = new QVBoxLayout;
	
	leftLayout->addWidget(semanageEditLabel);
	leftLayout->addWidget(semanageEditLineEdit);
	leftLayout->addWidget(semanageEditLabel2);
	leftLayout->addWidget(semanageEditLineEdit2);

	rightLayout = new QHBoxLayout;
	rightLayout->addStretch();
	rightLayout->addWidget(policygenerationButton);

	middleLayout->addLayout(leftLayout);

	footLayout = new QHBoxLayout;
	footLayout->addStretch();
	footLayout->addWidget(closeButton);

	mainLayout->addLayout(upperLayout);
	mainLayout->addLayout(middleLayout);
	mainLayout->addLayout(rightLayout);
	mainLayout->addLayout(footLayout);
	resize(900,600);
}

void SepolicyGenerate::policygeneration_button_clicked()
{
	semanageEditLineEdit_str = semanageEditLineEdit->text();
	semanageEditLineEdit2_str = semanageEditLineEdit2->text();
	policygeneration_button_clicked_ok();
}
void SepolicyGenerate::policygeneration_button_clicked_ok()
{
	policygeneration_button_clicked_process(semanageEditLineEdit_str,semanageEditLineEdit2_str);
}
void SepolicyGenerate::policygeneration_button_clicked_process(QString semanageEditLineEdit_str, QString semanageEditLineEdit2_str)
{
        this->setEnabled(false);
        process = new QProcess(this);
        semanageEditLineEdit3_str = "/usr/bin/sepolicy generate --init " + semanageEditLineEdit_str + " -w " + semanageEditLineEdit2_str;
        //connect(process, SIGNAL(stateChanged(NotRunning)),this,SLOT(processExited()));
        //connect(process, SIGNAL(started()),this,SLOT(processExited()));
        //connect(process, SIGNAL(stateChanged(Running)),this,SLOT(processExited()));
        process->start(semanageEditLineEdit3_str);

        QMessageBox::information(0, tr("Wrote files in your home !"),
                tr("Wrote .te .fc .if .sh _selinux.spec in your home directory."));
        processExited();
}
void SepolicyGenerate::processExited()
{
        delete process;
        process = 0;
        this->setEnabled(true);
}

void SepolicyGenerate::policygeneration_base_process()
{
        #define PWD_BUF 8600
        const char* semanage_login_list_file="/usr/share/segatex/sepolicy/1_sepolicy";
        ofstream os;
        os.open(semanage_login_list_file);
        if(os){
                FILE *read_fp;
                #define SIZE_TMP 8600
                char buffer[SIZE_TMP];
                int chars_read;
                memset(buffer, '\0', sizeof(buffer));

                read_fp = popen("/usr/sbin/semodule -l", "r");
                if(read_fp != NULL){
                        chars_read = fread(buffer, sizeof(char), SIZE_TMP, read_fp);
                        while(chars_read>0){
                                buffer[chars_read -1] = '\0';
                                //os << "Reading:-" << endl;
                                os << buffer;
                                chars_read= fread(buffer, sizeof(char), SIZE_TMP, read_fp);
			}
			pclose(read_fp);
                }
       }
	os.close();
	readFromOutputFile();
}

//this slot should be called from above slot
void SepolicyGenerate::readFromOutputFile()
{
	/////////////////////////////////////////////////////////////
	path = "/usr/share/segatex/sepolicy";
	/////////////////////////////////////////////////////////////
	forward_slash = "/";
	dir.setPath(path);
	dir_name = dir.absPath();
	/////////////////////////////////////////////////////////////
	dir.setFilter( QDir::Files );
        dir.setSorting( QDir::Name );
	files = dir.entryList("*sepolicy");
	/////////////////////////////////////////////////////////////
	it_d = files.begin();
	int order_x;
	order_x = 1;
	//first clear it all, unless double the file.
	textEdit1->clear();
		while(it_d != files.end()){
			name = *it_d;
			file_interface_name = dir_name + forward_slash + name;
			QFile file( file_interface_name );
			QRegExp rx_nologin("nologin");
			QRegExp rx_shutdown("shutdown");
			QRegExp rx_halt("halt");
			QRegExp rx_news("news");
			QRegExp rx_false("false");
			QRegExp rx_sync("sync");
			if ( file.open( QIODevice::ReadOnly ) ) {
				QTextStream stream( &file );
				////////////////////////////////////////////
				int i,j,k,l,m,n;	
				if(order_x == 1)
					textEdit1->append("#########module list#########");
					textEdit1->append("");
				if(order_x == 2)
					textEdit1->append("#########user list#########");
					textEdit1->append("");
				if(order_x == 3)
					textEdit1->append("#########etc passwd list#########");
					textEdit1->append("");
				while ( !stream.atEnd() ) {
					line_analized = stream.readLine(); // line of text excluding '\n'
					//buttons.push_back(line_analized);
					i = line_analized.find( rx_nologin, 0);
					j = line_analized.find( rx_shutdown, 0);
					k = line_analized.find( rx_halt, 0);
					l = line_analized.find( rx_news, 0);
					m = line_analized.find( rx_false, 0);
					n = line_analized.find( rx_sync, 0);
                                        if((i != -1)||(j != -1)||(k != -1)||(l != -1)||(m != -1)||(n != -1)){
						//do nothing
					}else{
						textEdit1->append(line_analized);
					}
				}
				file.close();
				order_x++;
				++it_d;
			}else{
				//do nothing
			}
		}
}
