/*
 * segatex SELinux tool.
 *
 * Copyright (C) 2007-2014 Shintaro Fujiwara 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * */

#ifndef SEGATEXCOREPROCESS_H
#define SEGATEXCOREPROCESS_H

#include <qstringlist.h>
#include <qfile.h>
#include <q3textstream.h>
#include <qregexp.h>
#include <QDir>
#include <q3textedit.h>
#include <qsplitter.h>
#include <QVBoxLayout>
#include <QHBoxLayout>


#include "segatex_core.h" 

class SegatexCoreProcess: public QDialog 
{
	Q_OBJECT
public:
	SegatexCoreProcess(QWidget *parent = 0, const char *name = 0);
    
public slots:
signals:
	void segatex_core_prosess_close_button_clicked();
protected:

private slots:
	void close_button_clicked();
	void segatex_core_pre();
private:
	QPushButton *closeButton;
	Q3TextEdit *textEdit1;
	SegatexCore *segatex_core_on;
	SegatexCoreProcess *segatex_core_process;
	
        QDir dir;
        QDir dir_curr;
        QString dir_name;
        QString dir_name_curr;

        QString path;
        QString path_to_be_written;
        QString path_to_be_written_ready;
        QString forward_slash;
        QString name;
        QString file_interface_name;
        QString file_interface_name_analized;
        QFile file_w;
        QFile file_w_ready;
        QStringList::Iterator it_d;
        QStringList::Iterator it_d_analized;
        QStringList::Iterator it_d_read;
        QStringList::Iterator it;
        QStringList files;
        QStringList files_to_be_analized;
        QStringList files_to_be_read;

        QStringList lines;
        QStringList lines_break;//used in break functions

        QString line;
        QString line_started;
        QString line_ended;
        QString line_analized;//every lines put in this var
        QString line_analized_if_clause;
        QString line_analized_dollar_one;
        QString line_analized_dollar_two;
        QString line_analized_dollar_three;
        QString line_analized_dollar_four;
        QString line_analized_dollar_five;
        QString line_analized_dollar_six;
        QString line_analized_interface_name;
        QString line_interface;
        QString line_added;
        QString double_quote;
        QString brace_first;
        QString brace_end;
        QString cumma;
        QString semicolon;
        QString colon;
        QString space;
        QString line_first;
        QString line_middle;
        QString line_end;
        QString var1;
        QString var2;
        QString var3;
        QString var4;
        QString var5;
        QString var6;
        QString first_var;
        QString second_var;
        QString third_var;
        QString fourth_var;
        QString fifth_var;
        QString sixth_var;
        QString tab;
        QVBoxLayout *headLayout;
        QHBoxLayout *footLayout;
        QVBoxLayout *mainLayout;
};

#endif
