/*
 * segatex SELinux tool.
 *
 * Copyright (C) 2007-2014 Shintaro Fujiwara 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * */

#include <QtGui> 
#include <QtSql> 
#include <QMessageBox> 

#include "sqlrefpolicy.h"

#include <iostream>
using namespace std;
//

//constructor
Sqlrefpolicy::Sqlrefpolicy(QWidget *parent, const char *name): QDialog(parent, name)
{
	targetdomainEditLineEdit = new QLineEdit(this );
	targetdomainEditLineEdit->setPaletteBackgroundColor(QColor(174,187,255));
	targetdomainEditLineEdit->setText(tr(""));
	targetdomainLabel = new QLabel(tr("Target Domain:"), this );
	objectclassEditLineEdit = new QLineEdit(this );
	objectclassEditLineEdit->setPaletteBackgroundColor(QColor(255,187,174));
	objectclassEditLineEdit->setText(tr(""));
	objectclassLabel = new QLabel(tr("Object Class:"), this );
	permissionsEditLineEdit = new QLineEdit(this );
	permissionsEditLineEdit->setPaletteBackgroundColor(QColor(187,255,174));
	permissionsEditLineEdit->setText(tr(""));
	permissionsLabel = new QLabel(tr("Permissions:"), this );
	targetdomainobjectclassButton = new QPushButton(tr("search(blank for all results)"), this);
	targetdomainobjectclassButton->setPaletteBackgroundColor(QColor(155, 155, 255));

	connect(targetdomainobjectclassButton, SIGNAL(clicked()), this, SLOT(targetdomain_clicked()));

	model = new QSqlTableModel(this);
	model->setTable("layer_if_file_interface_name_target_domain_object_class_permissions");
	model->setEditStrategy(QSqlTableModel::OnManualSubmit);
	model->select();

	//hide from view
	model->removeColumn(0);
	model->setHeaderData(0, Qt::Horizontal, tr("Layer"));
	model->setHeaderData(1, Qt::Horizontal, tr("If file"));
	model->setHeaderData(2, Qt::Horizontal, tr("Interface Name"));
	model->setHeaderData(3, Qt::Horizontal, tr("Target Domain"));
	model->setHeaderData(4, Qt::Horizontal, tr("Object Class"));
	model->setHeaderData(5, Qt::Horizontal, tr("Permissions"));

	QTableView *view = new QTableView;
	view->setModel(model);
	view->setSelectionBehavior(QAbstractItemView::SelectRows);
	view->resizeColumnsToContents();

	topLayout = new QHBoxLayout;
	topleftLayout = new QHBoxLayout;
	toprightLayout = new QHBoxLayout;
	topleftLayout->addWidget(targetdomainLabel);
	topleftLayout->addWidget(targetdomainEditLineEdit);
	topleftLayout->addWidget(objectclassLabel);
	topleftLayout->addWidget(objectclassEditLineEdit);
	toprightLayout->addWidget(permissionsLabel);
	toprightLayout->addWidget(permissionsEditLineEdit);
	toprightLayout->addWidget(targetdomainobjectclassButton);

	mainLayout = new QVBoxLayout;
	topLayout->addLayout(topleftLayout);
	topLayout->addLayout(toprightLayout);
	mainLayout->addLayout(topLayout);
	mainLayout->addWidget(view);
	setLayout(mainLayout);
	setWindowTitle(tr("refpolicy analyzer"));
	resize(1000,600);
}
void Sqlrefpolicy::targetdomain_clicked()
{
	targetdomain_pre_main_str = targetdomainEditLineEdit->text();
	targetdomain_pre_first_str = "target_domain like '%";
	targetdomain_pre_last_str = "%'";
	objectclass_pre_main_str = objectclassEditLineEdit->text();
	objectclass_pre_first_str = "object_class like '%";
	objectclass_pre_last_str = "%'";
	permissions_pre_main_str = permissionsEditLineEdit->text();
	permissions_pre_first_str = "permissions like '%";
	permissions_pre_last_str = "%'";
	targetdomain_objectclass_str = targetdomain_pre_first_str + targetdomain_pre_main_str + targetdomain_pre_last_str + " and " + objectclass_pre_first_str + objectclass_pre_main_str + objectclass_pre_last_str + " and " + permissions_pre_first_str + permissions_pre_main_str + permissions_pre_last_str ;
	model->setTable("layer_if_file_interface_name_target_domain_object_class_permissions");
	model->setEditStrategy(QSqlTableModel::OnManualSubmit);
	model->removeColumn(0);
	model->setHeaderData(0, Qt::Horizontal, tr("Layer"));
	model->setHeaderData(1, Qt::Horizontal, tr("If file"));
	model->setHeaderData(2, Qt::Horizontal, tr("Interface Name"));
	model->setHeaderData(3, Qt::Horizontal, tr("Target Domain"));
	model->setHeaderData(4, Qt::Horizontal, tr("Object Class"));
	model->setHeaderData(5, Qt::Horizontal, tr("Permissions"));
	model->setFilter(targetdomain_objectclass_str);
	model->select();
}
void Sqlrefpolicy::segatex_core2_next_denied_message_button_clicked()
{
	permissions_pre_main_str = av.value(i_pub++);
	permissionsEditLineEdit->setText(permissions_pre_main_str);
}
void Sqlrefpolicy::segatex_core2_prev_denied_message_button_clicked()
{
	permissions_pre_main_str = av.value(i_pub--);
	permissionsEditLineEdit->setText(permissions_pre_main_str);
}
void Sqlrefpolicy::segatex_core2_process_sql(const QList<QString> &l, const QList<QString> &l2, const QList<QString> &l3, const QList<QString> &l4)
{
	av = l4;
	i_pub = 0;
	permissions_pre_main_str = av.first();
	permissionsEditLineEdit->setText(permissions_pre_main_str);
}
