/*
 * segatex SELinux tool.
 *
 * Copyright (C) 2007-2014 Shintaro Fujiwara 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * */

#include <QLayout>
#include <QPushButton>
#include <QHBoxLayout>
#include <QVBoxLayout>
#include <QProcess>

#include "semodule_dontaudit_process.h"

//#include <iostream>
//using namespace std;

//default constructor
SemoduleDontauditProcess::SemoduleDontauditProcess(QWidget *parent, const char *name , int semodule_dontaudit_common_int): QDialog(parent, name)
{
	setCaption(tr("Semodule Dontaudit Process"));
	textEdit1 = new QTextEdit(this);
	textEdit1->setPaletteBackgroundColor(QColor(174,255,185));
	closeButton = new QPushButton(tr("close"), this);
	closeButton->setDefault(true);
	//closing yum_process button
	connect(closeButton, SIGNAL(clicked()), this, SLOT(close()));
	connect(closeButton, SIGNAL(clicked()), this, SLOT(close_button_clicked()));

	QVBoxLayout *headLayout = new QVBoxLayout;
	headLayout->addWidget(textEdit1);

	QHBoxLayout *footLayout = new QHBoxLayout;
	footLayout->addStretch(1);
	footLayout->addWidget(closeButton);

	QVBoxLayout *mainLayout = new QVBoxLayout(this);
	mainLayout->setMargin(11);
	mainLayout->setSpacing(6);
	mainLayout->addLayout(headLayout);
	mainLayout->addLayout(footLayout);
	resize(300,200);

	semodule_dontaudit_process_base_process(semodule_dontaudit_common_int);
}
void SemoduleDontauditProcess::close_button_clicked()
{
	emit semodule_dontaudit_process_close_button_clicked();
}
void SemoduleDontauditProcess::readFromStdout()
{
	QByteArray data = process->readAllStandardOutput();
	QString text = textEdit1->text() + QString(data);
	textEdit1->setText(text);
}
void SemoduleDontauditProcess::updateOutputTextEdit()
{
	QByteArray data = process->readAllStandardError();
	QString text = textEdit1->text() + QString(data);
	textEdit1->setText(text);
}
void SemoduleDontauditProcess::processExited()
{
	if(process->exitStatus()==0){
		textEdit1->append(tr("semodule dontaudit process ended !"));
		textEdit1->append(tr("\n"));
	} else {
		textEdit1->append(tr("semodule dontaudit process had an error !"));
		textEdit1->append(tr("\n"));
	}
	delete process;
	process = 0;
	this->setEnabled(true);
	process2 = new QProcess(this);
	process2->start("/usr/share/segatex/DONTAUDIT_STATE");

}
void SemoduleDontauditProcess::semodule_dontaudit_process_base_process(int semodule_dontaudit_common_int)
{
	this->setEnabled(false);
	process = new QProcess(this);
	if(semodule_dontaudit_common_int == 0){
		//std::cout << "now the command is semodule -DB" << endl;
		semodule_option = "-DB";
	}
	if(semodule_dontaudit_common_int == 1){
		semodule_option = "-B";
		//std::cout << "now the command is semodule -B" << endl;
	}
	connect(process, SIGNAL(readyReadStdout()),this,SLOT(readFromStdout()));
	connect(process, SIGNAL(readyReadStderr()),this,SLOT(updateOutputTextEdit()));
	connect(process, SIGNAL(processExited()),this,SLOT(processExited()));
        semodule_str = "semodule " + semodule_option;
	process->start(semodule_str);
}
