/*
 * segatex SELinux tool.
 *
 * Copyright (C) 2007-2014 Shintaro Fujiwara 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * */

#ifndef SEMANAGECOREBOOLEANPROCESS_H
#define SEMANAGECOREBOOLEANPROCESS_H

#include <QDialog>
#include <QLayout>
#include <QLabel> 
#include <QRadioButton>
#include <QDir> 
#include <QRegExp> 
#include <QTextEdit>
#include <QButtonGroup>
#include <QPushButton>
#include <QGroupBox>
#include <QHBoxLayout>
#include <QVBoxLayout>


class QLayout;
class QTextEdit;
class QLineEdit;
class QPushButton;

class SemanageCoreBooleanProcess: public QDialog 
{
	Q_OBJECT
public:
	SemanageCoreBooleanProcess(QWidget *parent = 0, const char *name = 0);
public slots:
signals:
protected:
private slots:
	void semanage_core_base_boolean_process();
	void add_button_clicked();
	void add_button_clicked_process(QString textEdit1_str, QString textEdit2_str);
	void readFromOutputFile();
public:
private:
	QPushButton *addButton;
	QPushButton *closeButton;
        QRadioButton *temporaryRadioButton;
        QRadioButton *permanentRadioButton;
	QTextEdit *textEdit1;

	QGroupBox *optionButtonGroupBox;
	QGroupBox *createFirstExclusiveGroup();

	QVBoxLayout *vbox;

	QVBoxLayout *mainLayout;
	QVBoxLayout *upperLayout;
	QVBoxLayout *underLayout;
	QHBoxLayout *leftLayout;
	QHBoxLayout *rightLayout;
	QHBoxLayout *thirdLayout;
	QVBoxLayout *middleLayout;
	QHBoxLayout *footLayout;

        QDir dir;
        QString path;
        QString name;
        QString dir_name;
        QString forward_slash;
        QString file_interface_name;
        QString line_analized;
        QString outputfile_str;

        QStringList::Iterator it_d;
        QStringList files;

        QString radiobutton_obj_str;
        QLabel *semanageEditLabel;
        QLabel *semanageEditLabel2;
        QLineEdit *semanageEditLineEdit;
        QLineEdit *semanageEditLineEdit2;
        QString semanageEditLineEdit_str;
        QString semanageEditLineEdit2_str;
        QString semanageEditLineEdit_str_pp;
};

#endif
