/*
 * segatex SELinux tool.
 *
 * Copyright (C) 2007-2014 Shintaro Fujiwara 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * */

#include <qlayout.h>
#include <qpushbutton.h>
#include <qlineedit.h>
#include <q3textedit.h>
#include <qmessagebox.h>
//Added by qt3to4:
#include <Q3TextStream>
#include <QLabel>

#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <fstream>

#include "restorecon.h"
#include "restorecon_process.h"

#include <iostream>
using namespace std;

Restorecon::Restorecon(QWidget *parent, const char *name): QDialog(parent, name)
{
	setCaption(tr("Restorecon"));
	textEdit1 = new Q3TextEdit(this);
	textEdit1->setPaletteBackgroundColor(QColor(250,180,200));

	semanageEditLabel = new QLabel(tr("restorecon -R -v "), this );
	semanageEditLineEdit = new QLineEdit( this );
	semanageEditLineEdit->setText("");
	addButton = new QPushButton(tr("Restorecon"), this);
	addButton->setPaletteBackgroundColor(QColor(100,200,200));
	semanageEditLineEdit->setPaletteBackgroundColor(QColor(200,100,80));

	connect(addButton, SIGNAL(clicked()), this, SLOT(add_button_clicked()));

	closeButton = new QPushButton(tr("close"), this);
	//closing process button
	connect(closeButton, SIGNAL(clicked()), this, SLOT(close()));
	closeButton->setDefault(true);

	//set textEdit smanage such and such -l
	restorecon_base_fcontext();

	mainLayout = new QVBoxLayout(this);
	mainLayout->setMargin(11);

	upperLayout = new QVBoxLayout;
	upperLayout->addWidget(textEdit1);

	middleLayout = new QVBoxLayout;
	leftLayout = new QHBoxLayout;
	rightLayout = new QHBoxLayout;
	thirdLayout = new QHBoxLayout;
	fourthLayout = new QHBoxLayout;
	
	leftLayout->addWidget(semanageEditLabel);
	leftLayout->addWidget(semanageEditLineEdit);
	leftLayout->addWidget(addButton);

	middleLayout->addLayout(leftLayout);
	middleLayout->addLayout(rightLayout);
	middleLayout->addLayout(thirdLayout);
	middleLayout->addLayout(fourthLayout);

	footLayout = new QHBoxLayout;
	footLayout->addStretch();
	footLayout->addWidget(closeButton);

	mainLayout->addLayout(upperLayout);
	mainLayout->addLayout(middleLayout);
	mainLayout->addLayout(footLayout);
	resize(1000,600);
	restorecon_process = 0;
}

/*signal and slot should have same argument pattern so I had to pass to another slot*/
void Restorecon::add_button_clicked()
{
	semanageEditLineEdit_str = semanageEditLineEdit->text();
	if(semanageEditLineEdit_str == ""){
		QMessageBox::information( this, tr("segatex alert"),
		    tr("No path given.\n"
		    "Try again !" ));
	}else
		add_button_clicked_process(semanageEditLineEdit_str);
}
/* this slot restorecons path */
void Restorecon::add_button_clicked_process(QString semanageEditLineEdit_str)
{
	restorecon_str = semanageEditLineEdit_str;
	
	//Now, let's restorecon path
	semanageEditLineEdit_str_add_restorecon = "restorecon -R -v " + restorecon_str;
	//for debug
        #define PWD_BUF 8600
        const char* restorecon_file="/usr/share/segatex/semanage/restoreconed";
        ofstream os_add_restorecon;
        os_add_restorecon.open(restorecon_file);
        if(os_add_restorecon){
                FILE *read_fp;
                #define SIZE_TMP 8600
                char buffer[SIZE_TMP];
                int chars_read;
                memset(buffer, '\0', sizeof(buffer));
                read_fp = popen(semanageEditLineEdit_str_add_restorecon, "r");
                if(read_fp != NULL){
                        chars_read = fread(buffer, sizeof(char), SIZE_TMP, read_fp);
                        while(chars_read>0){
                                buffer[chars_read -1] = '\0';
                                //os << "Reading:-" << endl;
                                os_add_restorecon << buffer << endl;
                                chars_read= fread(buffer, sizeof(char), SIZE_TMP, read_fp);
                        }
                        pclose(read_fp);
                }
        }
	os_add_restorecon.close();

	restorecon_process = new RestoreconProcess(this);
	connect(restorecon_process, SIGNAL(restorecon_close_button_clicked()), this, SLOT(close()));
	connect(closeButton, SIGNAL(clicked()), restorecon_process, SLOT(close()));
	restorecon_process->setCaption(tr(semanageEditLineEdit_str_add_restorecon));
	restorecon_process->show();
	restorecon_process->raise();
	restorecon_process->setActiveWindow();


	//set textEdit semanage -l
	restorecon_base_fcontext();
}

// {boolean|login|user|port|interface|fcontext|translation}

void Restorecon::restorecon_base_fcontext()
{
        #define PWD_BUF 8600
        const char* semanage_fcontext_list_file="/usr/share/segatex/semanage/1_fcontext";
        ofstream os;
        os.open(semanage_fcontext_list_file);
        if(os){
                FILE *read_fp;
                #define SIZE_TMP 8600
                char buffer[SIZE_TMP];
                int chars_read;
                memset(buffer, '\0', sizeof(buffer));

                read_fp = popen("/usr/sbin/semanage fcontext -l", "r");
                if(read_fp != NULL){
                        chars_read = fread(buffer, sizeof(char), SIZE_TMP, read_fp);
                        while(chars_read>0){
                                buffer[chars_read -1] = '\0';
                                //os << "Reading:-" << endl;
                                os << buffer;
                                chars_read= fread(buffer, sizeof(char), SIZE_TMP, read_fp);
			}
			pclose(read_fp);
                }
        }
	os.close();
	//outputfile_str_common = "fcontext_list";
	readFromOutputFile();
}

//this slot should be called from above slot
void Restorecon::readFromOutputFile()
{
	/////////////////////////////////////////////////////////////
	//path = "./";
	path = "/usr/share/segatex/semanage";
	/////////////////////////////////////////////////////////////
	forward_slash = "/";
	dir.setPath(path);
	dir_name = dir.absPath();
	/////////////////////////////////////////////////////////////
	dir.setFilter( QDir::Files );
        dir.setSorting( QDir::Name );
	//files = dir.entryList(outputfile_str_common);
	files = dir.entryList("*fcontext");
	/////////////////////////////////////////////////////////////
	it_d = files.begin();
	int order_x;
	order_x = 1;
	//first clear it all, unless double the file.
	textEdit1->clear();
		while(it_d != files.end()){
			name = *it_d;
			file_interface_name = dir_name + forward_slash + name;
			QFile file( file_interface_name );
			if ( file.open( QIODevice::ReadOnly ) ) {
				Q3TextStream stream( &file );
				////////////////////////////////////////////
				//int i,j,k,l,m,n;	
				if(order_x == 1)
					textEdit1->append("#########fcontext list#########");
					textEdit1->append("");
				while ( !stream.atEnd() ) {
					line_analized = stream.readLine(); // line of text excluding '\n'
					textEdit1->append(line_analized);
				}
				textEdit1->setCursorPosition(0,0);
				file.close();
				order_x++;
				++it_d;
			}else{
				//do nothing
			}
		}
}
