/*
 * segatex SELinux tool.
 *
 * Copyright (C) 2007-2014 Shintaro Fujiwara 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * */

#ifndef DOWNLOADER_H
#define DOWNLOADER_H

#include <QDialog>
#include <q3ftp.h>
//#include <QFtp>
#include <QStringList>
#include <QProgressDialog>
#include <QWidget>
#include <QLayout>
#include <QDir> 
#include <QLabel> 
#include <QLineEdit> 
#include <QTextEdit>
#include <QPushButton>
#include <q3buttongroup.h>
#include <QRadioButton>
#include <QUrl>
#include <QString>
#include <QHBoxLayout>
#include <QVBoxLayout>
#include <QProcess>
#include <QDir>

#include <vector>

class DownloaderProcess;

class Downloader: public QDialog 
{
	Q_OBJECT
public:
	Downloader(QWidget *parent = 0, const char *name = 0);
public slots:
signals:
protected:
        QUrl url_for_fedora;
        QString version; 
private slots:
	void download_button_clicked();
	//void downloader_process(const QUrl &url_for_fedora, QString version);
	//void downloader_process(const QUrl, QString);
	void updateOutputTextEdit();
	void readFromStdout();
	void processExited(int, QProcess::ExitStatus);
public:
private:
	int mirror;
	//QString version;
	QProcess *process;

	Q3ButtonGroup *optionButtonGroup;
	Q3ButtonGroup *fedoraVersionButtonGroup;

        QRadioButton *usRadioButton;
        QRadioButton *jpRadioButton;
        QRadioButton *deRadioButton;
        QRadioButton *frRadioButton;
        QRadioButton *auRadioButton;
        QRadioButton *new4RadioButton;
        QRadioButton *new3RadioButton;
        QRadioButton *new2RadioButton;
        QRadioButton *newRadioButton;

        QString semanageEditLineEdit_str_add_restorecon;
	QPushButton *downloadButton;
	QPushButton *closeButton;

	QVBoxLayout *mainLayout;
	QVBoxLayout *middleLayout;
	QHBoxLayout *firstLayout;
	QVBoxLayout *secondLayout;
	QVBoxLayout *thirdLayout;
	QHBoxLayout *rightLayout;
	QHBoxLayout *footLayout;

        QDir dir;
        QString path;
        QString name;
        QString dir_name;
        QString forward_slash;
        QString file_interface_name;
        QString line_analized;
        QString outputfile_str;

        QStringList::Iterator it_d;
        QStringList files;

        QString radiobutton_obj_str;
        QLabel *semanageEditLabel;
        QLabel *semanageEditLabel2;
        QLineEdit *semanageEditLineEdit;
        QString semanageEditLineEdit_str;
        QString semanageEditLineEdit_str_pp;
        QString restorecon_str;
        QString url_str;

	Q3Ftp ftp;
	std::vector<QFile *> openedFiles;
        DownloaderProcess *downloader_process_o;
};

#endif
