/*
 * segatex SELinux tool.
 *
 * Copyright (C) 2007-2014 Shintaro Fujiwara 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * */

#include <QLayout>
#include <QPushButton>
#include <QRadioButton>
#include <QButtonGroup>
#include <QLineEdit>
#include <QTextEdit>
#include <QTextStream>
#include <QHBoxLayout>
#include <QVBoxLayout>
#include <QLabel>

#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <fstream>

#include "semodule_core_process.h"
//#include "editor.h"

#include <iostream>
using namespace std;

//constructor
SemoduleCoreProcess::SemoduleCoreProcess(QWidget *parent, const char *name): QDialog(parent, name)
{
	setCaption(tr("Semodule Process"));
	textEdit1 = new QTextEdit(this);
	textEdit1->setPaletteBackgroundColor(QColor(255,100,200));
	textEdit2 = new QTextEdit(this);
	textEdit2->setPaletteBackgroundColor(QColor(200,100,255));
	moduleEditLabel = new QLabel(tr("Copy and paste module name:"), this );
	moduleEditLineEdit = new QLineEdit( this );
	moduleEditLineEdit->setText("");
	moduleEditLineEdit->setPaletteBackgroundColor(QColor(255,100,200));

	makeButton = new QPushButton(tr("Make this module"), this);
	makeButton->setPaletteBackgroundColor(QColor(20,157,20));
	connect(makeButton, SIGNAL(clicked()), this, SLOT(make_button_clicked()));
	installButton = new QPushButton(tr("Install this module"), this);
	installButton->setPaletteBackgroundColor(QColor(220,120,120));
	connect(installButton, SIGNAL(clicked()), this, SLOT(install_button_clicked()));
	updateButton = new QPushButton(tr("Update this module"), this);
	updateButton->setPaletteBackgroundColor(QColor(120,220,120));
	connect(updateButton, SIGNAL(clicked()), this, SLOT(update_button_clicked()));
	removeButton = new QPushButton(tr("Remove this module"), this);
	removeButton->setPaletteBackgroundColor(QColor(155,155,155));
	connect(removeButton, SIGNAL(clicked()), this, SLOT(remove_button_clicked()));
	closeButton = new QPushButton(tr("close"), this);
	//closing process button
	connect(closeButton, SIGNAL(clicked()), this, SLOT(close()));
	closeButton->setDefault(true);

	//set textEdit semodule -l
	semodule_core_base_process();

	mainLayout = new QHBoxLayout(this);
	mainLayout->setMargin(11);
	leftLayout = new QVBoxLayout;
	leftLayout->addWidget(textEdit1);

	middleLayout = new QVBoxLayout;
	middleLayout->addWidget(textEdit2);
	middleLayout->addStretch(2);
	middleLayout->addWidget(moduleEditLabel);
	middleLayout->addWidget(moduleEditLineEdit);
	middleLayout->addStretch(5);

	rightLayout = new QVBoxLayout;
	middleLayout->addStretch(5);
	rightLayout->addWidget(makeButton);
	rightLayout->addWidget(installButton);
	rightLayout->addWidget(updateButton);
	rightLayout->addWidget(removeButton);
	middleLayout->addStretch(5);

	footLayout = new QVBoxLayout;
	footLayout->addStretch(1);
	footLayout->addWidget(closeButton);

	mainLayout->addLayout(leftLayout);
	mainLayout->addLayout(middleLayout);
	mainLayout->addLayout(rightLayout);
	mainLayout->addLayout(footLayout);
	resize(800,600);
}
/*signal and slot should have same argument pattern so I had to pass to another slot*/
void SemoduleCoreProcess::make_button_clicked()
{
	moduleEditLineEdit_str = moduleEditLineEdit->text();
	make_button_clicked_process(moduleEditLineEdit_str);
}
/*signal and slot should have same argument pattern so I had to pass to another slot*/
void SemoduleCoreProcess::install_button_clicked()
{
	moduleEditLineEdit_str = moduleEditLineEdit->text();
	install_button_clicked_process(moduleEditLineEdit_str);
}
/*signal and slot should have same argument pattern so I had to pass to another slot*/
void SemoduleCoreProcess::update_button_clicked()
{
	moduleEditLineEdit_str = moduleEditLineEdit->text();
	update_button_clicked_process(moduleEditLineEdit_str);
}
/*signal and slot should have same argument pattern so I had to pass to another slot*/
void SemoduleCoreProcess::remove_button_clicked()
{
	moduleEditLineEdit_str = moduleEditLineEdit->text();
	remove_button_clicked_process(moduleEditLineEdit_str);
}
/* this slot just do make .pp file */
void SemoduleCoreProcess::make_button_clicked_process(QString moduleEditLineEdit_str)
{
	this->setEnabled(false);
	process = new QProcess(this);
	connect(process, SIGNAL(readyReadStandardOutput()),this,SLOT(readFromStdout()));
	connect(process, SIGNAL(readyReadStandardError()),this,SLOT(updateOutputTextEdit()));
	connect(process, SIGNAL(finished(int, QProcess::ExitStatus)),this,SLOT(processExited(int, QProcess::ExitStatus)));
        moduleEditLineEdit_str_pp = "cd /usr/share/segatex&&rm -rf /usr/share/segatex/tmp&&make -f /usr/share/selinux/devel/Makefile " + moduleEditLineEdit_str + ".pp";
    	process->start("/bin/bash", QStringList() << "-c" << moduleEditLineEdit_str_pp);
}
/* this slot just do semanage -i .pp file */
void SemoduleCoreProcess::install_button_clicked_process(QString moduleEditLineEdit_str)
{
	this->setEnabled(false);
	process = new QProcess(this);
	connect(process, SIGNAL(readyReadStandardOutput()),this,SLOT(readFromStdout()));
	connect(process, SIGNAL(readyReadStandardError()),this,SLOT(updateOutputTextEdit()));
	connect(process, SIGNAL(finished(int, QProcess::ExitStatus)),this,SLOT(processExited(int, QProcess::ExitStatus)));
	moduleEditLineEdit_str_pp = "cd /usr/share/segatex&&rm -rf /usr/share/segatex/tmp&&semodule -i " + moduleEditLineEdit_str + ".pp";
    	process->start("/bin/bash", QStringList() << "-c" << moduleEditLineEdit_str_pp);
}
/* this slot just do semanage -u .pp file */
void SemoduleCoreProcess::update_button_clicked_process(QString moduleEditLineEdit_str)
{
	this->setEnabled(false);
	process = new QProcess(this);
	connect(process, SIGNAL(readyReadStandardOutput()),this,SLOT(readFromStdout()));
	connect(process, SIGNAL(readyReadStandardError()),this,SLOT(updateOutputTextEdit()));
	connect(process, SIGNAL(finished(int, QProcess::ExitStatus)),this,SLOT(processExited(int, QProcess::ExitStatus)));
	moduleEditLineEdit_str_pp = "cd /usr/share/segatex&&rm /usr/share/segatex/update_module_file&&semodule -u " + moduleEditLineEdit_str + ".pp";
    	process->start("/bin/bash", QStringList() << "-c" << moduleEditLineEdit_str_pp);
}
/* this slot does just semodule -r module file */
void SemoduleCoreProcess::remove_button_clicked_process(QString moduleEditLineEdit_str)
{
	this->setEnabled(false);
	process = new QProcess(this);
	connect(process, SIGNAL(readyReadStandardOutput()),this,SLOT(readFromStdout()));
	connect(process, SIGNAL(readyReadStandardError()),this,SLOT(updateOutputTextEdit()));
	connect(process, SIGNAL(finished(int, QProcess::ExitStatus)),this,SLOT(processExited(int, QProcess::ExitStatus)));
	moduleEditLineEdit_str_pp = "semodule -r " + moduleEditLineEdit_str;
    	process->start("/bin/bash", QStringList() << "-c" << moduleEditLineEdit_str_pp);
}
void SemoduleCoreProcess::semodule_core_base_process()
{
	this->setEnabled(false);
	process = new QProcess(this);
	connect(process, SIGNAL(readyReadStandardOutput()),this,SLOT(readFromStdoutB()));
	connect(process, SIGNAL(readyReadStandardError()),this,SLOT(updateOutputTextEditB()));
	connect(process, SIGNAL(finished(int, QProcess::ExitStatus)),this,SLOT(processExitedB(int, QProcess::ExitStatus)));
                //read_fp = popen("/usr/sbin/semodule -l", "r");
                //read_fp = popen("/usr/sbin/semodule -l|grep permissive", "r");
	//moduleEditLineEdit_str_pp = "/usr/sbin/semodule -l|grep permissive;&&/usr/sbin/semodule -l"; 
	moduleEditLineEdit_str_pp = "/usr/sbin/semodule -l"; 
    	process->start("/bin/bash", QStringList() << "-c" << moduleEditLineEdit_str_pp);
}
void SemoduleCoreProcess::readFromStdoutB()
{
	QByteArray data = process->readAllStandardOutput();
	QString text = textEdit1->text() + QString(data);
	textEdit1->setText(text);
}
void SemoduleCoreProcess::updateOutputTextEditB()
{
	QByteArray data = process->readAllStandardError();
	QString text = textEdit1->text() + QString(data);
	textEdit1->setText(text);
}
void SemoduleCoreProcess::processExitedB(int exitCode, QProcess::ExitStatus exitStatus)
{
	if ( exitStatus == QProcess::CrashExit )
	{
		//QMessageBox::warning( this, tr("Error"), tr("Crashed") );
		textEdit1->append(tr("Error, Crashed !"));
		textEdit1->append(tr("\n"));
	}
	else if ( exitCode != 0 )
	{
		//QMessageBox::warning( this, tr("Error"), tr("Failed") );
		textEdit1->append(tr("Error, Failed !"));
		textEdit1->append(tr("\n"));
	}
	else
	{
		//textEdit1->append(tr("succeess!"));
		textEdit1->append(tr("\n"));
        }
	delete process;
	process = 0;
	this->setEnabled(true);
}
void SemoduleCoreProcess::readFromStdout()
{
	QByteArray data = process->readAllStandardOutput();
	QString text = textEdit2->text() + QString(data);
	textEdit2->setText(text);
}
void SemoduleCoreProcess::updateOutputTextEdit()
{
	QByteArray data = process->readAllStandardError();
	QString text = textEdit2->text() + QString(data);
	textEdit2->setText(text);
}
void SemoduleCoreProcess::processExited(int exitCode, QProcess::ExitStatus exitStatus)
{
	if ( exitStatus == QProcess::CrashExit )
	{
		//QMessageBox::warning( this, tr("Error"), tr("Crashed") );
		textEdit2->append(tr("Error, Crashed !"));
		textEdit2->append(tr("\n"));
	}
	else if ( exitCode != 0 )
	{
		//QMessageBox::warning( this, tr("Error"), tr("Failed") );
		textEdit2->append(tr("Error, Failed !"));
		textEdit2->append(tr("\n"));
	}
	else
	{
		textEdit2->append(tr("succeess!"));
		textEdit2->append(tr("\n"));
        }
	delete process;
	process = 0;
	this->setEnabled(true);
}
/*
void SemoduleCoreProcess::semodule_core_base_process()
{
        #define PWD_BUF 8600
        const char* module_list_file="/usr/share/segatex/module_list_2";
        ofstream os;
        os.open(module_list_file);
        if(os){
                FILE *read_fp;
                #define SIZE_TMP 8600
                char buffer[SIZE_TMP];
                int chars_read;
                memset(buffer, '\0', sizeof(buffer));
                read_fp = popen("/usr/sbin/semodule -l", "r");
                if(read_fp != NULL){
                        chars_read = fread(buffer, sizeof(char), SIZE_TMP, read_fp);
                        while(chars_read>0){
                                buffer[chars_read -1] = '\0';
                                os << "Reading:-" << endl;
                                os << buffer;
                                chars_read= fread(buffer, sizeof(char), SIZE_TMP, read_fp);
                        }
                        pclose(read_fp);
                }
        }
	os.close();

        const char* module_list_file2="/usr/share/segatex/module_list_1";
        ofstream os2;
        os2.open(module_list_file2);
        if(os2){
                FILE *read_fp;
                #define SIZE_TMP 8600
                char buffer[SIZE_TMP];
                int chars_read;
                memset(buffer, '\0', sizeof(buffer));
                read_fp = popen("/usr/sbin/semodule -l|grep permissive", "r");
                if(read_fp != NULL){
                        chars_read = fread(buffer, sizeof(char), SIZE_TMP, read_fp);
                        while(chars_read>0){
                                buffer[chars_read -1] = '\0';
                                os2 << buffer;
                                chars_read= fread(buffer, sizeof(char), SIZE_TMP, read_fp);
                        }
                        pclose(read_fp);
                }
        }
	os2.close();
	//outputfile_str_common = module_list_file;
	outputfile_str_common = "module_list*";
	readFromOutputFile();

}
*/

//this slot should be called from above slot
/*
void SemoduleCoreProcess::readFromOutputFile()
{
	/////////////////////////////////////////////////////////////
	path = "/usr/share/segatex";
	/////////////////////////////////////////////////////////////
	forward_slash = "/";
	dir.setPath(path);
	dir_name = dir.absPath();
	/////////////////////////////////////////////////////////////
	dir.setFilter( QDir::Files );
        dir.setSorting( QDir::Name );
	files = dir.entryList(outputfile_str_common);
	/////////////////////////////////////////////////////////////
	it_d = files.begin();
	int order_x;
	order_x = 1;
	textEdit1->clear();
	while(it_d != files.end()){
		name = *it_d;
		file_interface_name = dir_name + forward_slash + name;
		QFile file( file_interface_name );
		if ( file.open( QIODevice::ReadOnly ) ) {
			QTextStream stream( &file );
			////////////////////////////////////////////
			//button_numbers = 1;
			if(order_x == 1)
				textEdit1->append("##permissive domain list##");
				textEdit1->append("");
			if(order_x == 2)
				textEdit1->append("##semodule list##");
				textEdit1->append("");
			//textEdit1->clear();
			while ( !stream.atEnd() ) {
				line_analized = stream.readLine(); // line of text excluding '\n'
				textEdit1->append(line_analized);
			}
			//textEdit1->setCursorPosition(0,0);
			file.close();
			order_x++;
			++it_d;
		}else{
			//do nothing
		}
	}
}
*/
//this slot should be called from above slot
/*
void SemoduleCoreProcess::readFromOutputFile2()
{
	/////////////////////////////////////////////////////////////
	//path = "./";
	path = "/usr/share/segatex";
	/////////////////////////////////////////////////////////////
	forward_slash = "/";
	dir.setPath(path);
	dir_name = dir.absPath();
	/////////////////////////////////////////////////////////////
	dir.setFilter( QDir::Files );
        dir.setSorting( QDir::Name );
	files = dir.entryList(outputfile_str_common2);
	/////////////////////////////////////////////////////////////
	it_d = files.begin();
		while(it_d != files.end()){
			name = *it_d;
			file_interface_name = dir_name + forward_slash + name;
			QFile file( file_interface_name );
			if ( file.open( QIODevice::ReadOnly ) ) {
				QTextStream stream( &file );
				////////////////////////////////////////////
				textEdit2->clear();
				while ( !stream.atEnd() ) {
					line_analized = stream.readLine(); // line of text excluding '\n'
					textEdit2->append(line_analized);
				}
				file.close();
				++it_d;
			}else{
				//do nothing
			}
		}
}
*/
