/*
 * segatex SELinux tool.
 *
 * Copyright (C) 2007-2014 Shintaro Fujiwara 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * */

#include <QLayout>
#include <QPushButton>
#include <QHBoxLayout>
#include <QVBoxLayout>

#include "segatex_yum_process.h"

//#include <iostream>
//using namespace std;

SegatexYumProcess::SegatexYumProcess(QWidget *parent, const char *name): QDialog(parent, name)
{
	setCaption(tr("Yum SELinux Process"));
	textEdit1 = new QTextEdit(this);
	textEdit1->setPaletteBackgroundColor(QColor(174,255,185));
	closeButton = new QPushButton(tr("close"), this);
	closeButton->setDefault(true);
	//closing yum_process button
	connect(closeButton, SIGNAL(clicked()), this, SLOT(close()));
	connect(closeButton, SIGNAL(clicked()), this, SLOT(close_button_clicked()));

	headLayout = new QVBoxLayout;
	headLayout->addWidget(textEdit1);

	footLayout = new QHBoxLayout;
	footLayout->addStretch(1);
	footLayout->addWidget(closeButton);

	mainLayout = new QVBoxLayout(this);
	mainLayout->setMargin(11);
	mainLayout->setSpacing(6);
	mainLayout->addLayout(headLayout);
	mainLayout->addLayout(footLayout);
	resize(600,500);

	yum_install_base_process();
	yum_update_base_process();

}
void SegatexYumProcess::yum_install_base_process()
{
	this->setEnabled(false);
	process = new QProcess(this);
	connect(process, SIGNAL(readyReadStandardOutput()),this,SLOT(readFromStdout()));
	connect(process, SIGNAL(readyReadStandardError()),this,SLOT(updateOutputTextEdit()));
	connect(process, SIGNAL(finished(int, QProcess::ExitStatus)),this,SLOT(processExited(int, QProcess::ExitStatus)));
	process->start("yum -y install audit checkpolicy libsepol libselinux libselinux-devel libselinux-python libselinux-utils libsemanage mcstrans mod_selinux policycoreutils policycoreutils-gui policycoreutils-python selinux-doc selinux-policy selinux-policy-devel selinux-policy-minimum selinux-policy-mls selinux-policy-sandbox selinux-policy-targeted sepolgen setools-console setroubleshoot-server xguest");
}
void SegatexYumProcess::yum_update_base_process()
{
	this->setEnabled(false);
	process1 = new QProcess(this);
	connect(process1, SIGNAL(readyReadStandardOutput()),this,SLOT(readFromStdout1()));
	connect(process1, SIGNAL(readyReadStandardError()),this,SLOT(updateOutputTextEdit1()));
	connect(process1, SIGNAL(finished(int, QProcess::ExitStatus)),this,SLOT(processExited1(int, QProcess::ExitStatus)));
	process1->start("yum -y update audit checkpolicy libsepol libselinux libselinux-devel libselinux-python libselinux-utils libsemanage mcstrans mod_selinux policycoreutils policycoreutils-gui policycoreutils-python selinux-doc selinux-policy selinux-policy-devel selinux-policy-minimum selinux-policy-mls selinux-policy-sandbox selinux-policy-targeted sepolgen setools-console setroubleshoot-server xguest");
}



void SegatexYumProcess::close_button_clicked()
{
	emit yum_prosess_close_button_clicked();

}
void SegatexYumProcess::readFromStdout()
{
	QByteArray data = process->readAllStandardOutput();
	QString text = textEdit1->text() + QString(data);
	textEdit1->setText(text);
}
void SegatexYumProcess::readFromStdout1()
{
	QByteArray data = process1->readAllStandardOutput();
	QString text = textEdit1->text() + QString(data);
	textEdit1->setText(text);
}
void SegatexYumProcess::updateOutputTextEdit()
{
	QByteArray data = process->readAllStandardError();
	QString text = textEdit1->text() + QString(data);
	textEdit1->setText(text);
}
void SegatexYumProcess::updateOutputTextEdit1()
{
	QByteArray data = process1->readAllStandardError();
	QString text = textEdit1->text() + QString(data);
	textEdit1->setText(text);
}
void SegatexYumProcess::processExited(int exitCode, QProcess::ExitStatus exitStatus)
{
	if ( exitStatus == QProcess::CrashExit )
	{
		//QMessageBox::warning( this, tr("Error"), tr("Crashed") );
		textEdit1->append(tr("Error, Crashed !"));
		textEdit1->append(tr("\n"));
	}
	else if ( exitCode != 0 )
	{
		//QMessageBox::warning( this, tr("Error"), tr("Failed") );
		textEdit1->append(tr("Error, Failed !"));
		textEdit1->append(tr("\n"));
	}
	else
	{
		textEdit1->append(tr("yum install process ended !"));
		textEdit1->append(tr("\n"));
        }
	delete process;
	process = 0;
	this->setEnabled(true);
}
void SegatexYumProcess::processExited1(int exitCode, QProcess::ExitStatus exitStatus)
{
	if ( exitStatus == QProcess::CrashExit )
	{
		//QMessageBox::warning( this, tr("Error"), tr("Crashed") );
		textEdit1->append(tr("Error, update process Crashed !"));
		textEdit1->append(tr("\n"));
	}
	else if ( exitCode != 0 )
	{
		//QMessageBox::warning( this, tr("Error"), tr("Failed") );
		textEdit1->append(tr("Error, update process Failed !"));
		textEdit1->append(tr("\n"));
	}
	else
	{
		textEdit1->append(tr("yum update process ended !"));
		textEdit1->append(tr("\n"));
        }
	delete process1;
	process1 = 0;
	this->setEnabled(true);
}

