/*
 * segatex SELinux tool.
 *
 * Copyright (C) 2007-2014 Shintaro Fujiwara 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * */

#ifndef SEGATEXCORE2PROCESS_H
#define SEGATEXCORE2PROCESS_H

#include <QStringList>
#include <QFile>
#include <QTextStream>
#include <QRegExp>
#include <QDir>
#include <QTextEdit>
#include <QSplitter>
#include <QSqlTableModel>
#include <QTableView>
#include <QVBoxLayout>
#include <QHBoxLayout>

#include "segatex_core.h" 

class Sqlrefpolicy;

class SegatexCore2Process: public QDialog 
{
	Q_OBJECT
public:
	SegatexCore2Process(QWidget *parent = 0, const char *name = 0);
        QStringList access_vector_sql_list;
    
public slots:
signals:
	void segatex_core2_prosess_close_button_clicked();
	void segatex_core2_prosess_next_denied_message_button_clicked();
	void segatex_core2_prosess_prev_denied_message_button_clicked();
protected:

private slots:
	void close_button_clicked();
	void next_denied_message_button_clicked();
	void prev_denied_message_button_clicked();
	void segatex_core2_pre();
	void sqlrefpolicy_select(const QList<QString> &, const QList<QString> &, const QList<QString> &, const QList<QString> &);
private:
	QPushButton *closeButton;
	QTextEdit *textEdit1;
	SegatexCore *segatex_core2_on;
	SegatexCore2Process *segatex_core2_process;
	
        QDir dir;
        QDir dir_curr;
        QString dir_name;
        QString dir_name_curr;
	QPushButton *nextDeniedMessageButton;
	QPushButton *prevDeniedMessageButton;


        QString path;
        QString path_to_be_written;
        QString path_to_be_written_ready;
        QString path_selpaw_interface;
        QString forward_slash;
        QString name;
        QString file_interface_name;
        QString file_interface_name_analized;
        QFile file_w;
        QFile file_w_action;
        QFile file2;
        QFile file_w_ready;
        QStringList::Iterator it_d;
        QStringList::Iterator it_d_analized;
        QStringList::Iterator it_d_read;
        QStringList::Iterator it;
        QStringList files;
        QStringList files_to_be_analized;
        QStringList files_to_be_read;

        QStringList lines;
        QStringList lines_break;//used in break functions

        QString line;
        QString line_started;
        QString line_ended;
        QString line_analized;//every lines put in this var
        QString line_analized2;
        QString line_analized_if_clause;
        QString line_analized_dollar_one;
        QString line_analized_dollar_two;
        QString line_analized_dollar_three;
        QString line_analized_dollar_four;
        QString line_analized_dollar_five;
        QString line_analized_dollar_six;
        QString line_analized_interface_name;
        QString line_interface;
        QString line_added;
        QString double_quote;
        QString brace_first;
        QString brace_end;
        QString cumma;
        QString semicolon;
        QString colon;
        QString space;
        QString line_first;
        QString line_middle;
        QString line_end;
        QString first_var;
        QString second_var;
        QString third_var;
        QString fourth_var;
        QString fifth_var;
        QString sixth_var;
        QString tab;
        QString log_str;
        QString log_str_scontext_pre;
        QString log_str_scontext;
        QString log_str_tcontext_pre;
        QString log_str_tcontext;
        QString log_str_tclass_pre;
        QString log_str_tclass;
        QString log_str_access_vector_pre;
        QString log_str_access_vector;
        QString it_comp;
        QString domain;
        QString target_type;
        QString object_class;
        QString access_vector;
        QStringList domain_sql_list;
        QStringList target_type_sql_list;
        QStringList object_class_sql_list;
        QString interface_name;
        QString policy;
        QSqlTableModel *model;
        QTableView *view;
        QString targetdomain_pre_first_str;
        QString targetdomain_pre_main_str;
        QString targetdomain_pre_last_str;
        QString targetdomain_objectclass_str;
        QString objectclass_pre_first_str;
        QString objectclass_pre_main_str;
        QString objectclass_pre_last_str;
        QString permissions_pre_first_str;
        QString permissions_pre_main_str;
        QString permissions_pre_last_str;
        QString str_sql;
	Sqlrefpolicy *sqlrefpolicy_select_o;
	QList<QString> lines_log_str_scontext;
	QList<QString> lines_log_str_tcontext;
	QList<QString> lines_log_str_tclass;
	QList<QString> lines_log_str_access_vector;
        QVBoxLayout *headLayout;
        QHBoxLayout *footLayout;
        QVBoxLayout *mainLayout;
};

#endif
