/*
 * segatex SELinux tool.
 *
 * Copyright (C) 2007-2014 Shintaro Fujiwara 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * */

#include <QTextStream>
#include <QMessageBox>
//########by me#######
#include <sepol/sepol.h>
#include <unistd.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <fstream>
//#########end by me #######
#include <iostream>
using namespace std;


#include "segatex_booleannames.h"


SegatexBooleannames::SegatexBooleannames(QWidget *parent, const char *name): QDialog(parent, name)
{
	setCaption(tr("Booleannames"));
	textEdit1 = new QTextEdit(this);
	textEdit1->setPaletteBackgroundColor(QColor(250,180,200));
	closeButton = new QPushButton(tr("close"), this);
	//closing process button
	connect(closeButton, SIGNAL(clicked()), this, SLOT(close()));
	closeButton->setDefault(true);
	mainLayout = new QVBoxLayout(this);
	mainLayout->setMargin(11);
	mainLayout->addWidget(textEdit1);
	footLayout = new QHBoxLayout(this);
	footLayout->addStretch();
	footLayout->addWidget(closeButton);
	mainLayout->addLayout(footLayout);
	segatex_booleannames_base_process();
	resize(600,300);

	// do nothing
}

/* returns class and access vector*/
int SegatexBooleannames::segatex_booleannames_base_process()
{
		#define PWD_BUF 8600
		const char* segatex_booleannames_file="/usr/share/segatex/segatex_booleannames";
		ofstream os;
		os.open(segatex_booleannames_file);
		if(os){
			FILE *read_fp;
			#define SIZE_TMP 8600
			char buffer[SIZE_TMP];
			int chars_read;
			memset(buffer, '\0', sizeof(buffer));
			const char *command_str_pre;
			command_str_pre = "/usr/share/segatex/utils/booleannames ";
			read_fp = popen(command_str_pre, "r");
			if(read_fp != NULL){
				chars_read = fread(buffer, sizeof(char), SIZE_TMP, read_fp);
				while(chars_read>0){
					buffer[chars_read -1] = '\0';
					//os << "Reading:-" << endl;
					os << buffer;
					chars_read= fread(buffer, sizeof(char), SIZE_TMP, read_fp);
				}
				pclose(read_fp);
			}
		}
		os.close();
		readFromOutputFile();
	//}
}
//this slot should be called from above slot
void SegatexBooleannames::readFromOutputFile()
{
	/////////////////////////////////////////////////////////////
	path = "/usr/share/segatex";
	/////////////////////////////////////////////////////////////
	forward_slash = "/";
	dir.setPath(path);
	dir_name = dir.absPath();
	/////////////////////////////////////////////////////////////
	dir.setFilter( QDir::Files );
        dir.setSorting( QDir::Name );
	outputfile_str = "segatex_booleannames";
	files = dir.entryList(outputfile_str);
	/////////////////////////////////////////////////////////////
	it_d = files.begin();
	int order_x;
	order_x = 1;
	//first clear it all, unless double the file.
	textEdit1->clear();
		while(it_d != files.end()){
			name = *it_d;
			file_interface_name = dir_name + forward_slash + name;
			//cout << "file_interface_name:" << file_interface_name << endl;
			QFile file( file_interface_name );
			if ( file.open( QIODevice::ReadOnly ) ) {
				QTextStream stream( &file );
				////////////////////////////////////////////
				while ( !stream.atEnd() ) {
					line_analized = stream.readLine(); // line of text excluding '\n'
					textEdit1->append(line_analized);
				}
				file.close();
				order_x++;
				++it_d;
			}else{
				//do nothing
			}
		}
	//textEdit1->setCursorPosition(0,0);
}
