/*
 * segatex SELinux tool.
 *
 * Copyright (C) 2007-2014 Shintaro Fujiwara 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * */

#ifndef AUSEARCH_H
#define AUSEARCH_H

#include <QDialog>
#include <QLayout>
#include <QCheckBox>
#include <QLabel> 
#include <QButtonGroup>
#include <QPushButton>
#include <QGroupBox>
#include <QRadioButton>
#include <QHBoxLayout>
#include <QVBoxLayout>


class QLayout;
class QTextEdit;
class QLineEdit;
class QPushButton;
class AusearchProcess;

class Ausearch: public QDialog 
{
	Q_OBJECT
public:
	Ausearch(QWidget *parent = 0, const char *name = 0);
	AusearchProcess *ausearch_process;
public slots:
signals:
protected:
private slots:
	void ausearch_button_clicked();
public:
private:
	QLabel *ausearchLabel;
	QLabel *startdayLabel;
	QLabel *starttimeLabel;
	QLabel *enddayLabel;
	QLabel *endtimeLabel;
	QGroupBox *optionButtonGroupBox;
	QGroupBox *createFirstExclusiveGroup();
	QPushButton *ausearchButton;
        QRadioButton *eventRadioButton;
        QRadioButton *commnameRadioButton;
        QRadioButton *filenameRadioButton;
        QRadioButton *allgroupidRadioButton;
        QRadioButton *effectivegroupidRadioButton;
        QRadioButton *groupidRadioButton;
        QRadioButton *helpRadioButton;
        QRadioButton *hostnameRadioButton;
        QRadioButton *keystringRadioButton;
        QRadioButton *nodenameRadioButton;
        QRadioButton *objectRadioButton;
        QRadioButton *inputRadioButton;
        QRadioButton *processidRadioButton;
        QRadioButton *syscallRadioButton;

	QCheckBox *interpretCheckBox;

	QLineEdit *ausearchEditLineEdit;
	QLineEdit *startdayEditLineEdit;
	QLineEdit *starttimeEditLineEdit;
	QLineEdit *enddayEditLineEdit;
	QLineEdit *endtimeEditLineEdit;
	QString ausearchEditLineEdit_str;
	QPushButton *closeButton;
	QTextEdit *textEdit1;

	QHBoxLayout *mainLayout;
	QVBoxLayout *rightLayout;
	QVBoxLayout *leftLayout;
	QVBoxLayout *vbox;

        QString ausearch_str_pp;
        QString ausearch_str_pp_str;
	QString startdayEditLineEdit_str;
	QString starttimeEditLineEdit_str;
	QString enddayEditLineEdit_str;
	QString endtimeEditLineEdit_str;
};

#endif
