#
# segatex SELinux tool.
#
# Copyright (C) 2007-2013 Shintaro Fujiwara 
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#

#!/bin/sh 

ERROR=0
FILELISTPREPARE="find_optional_policy_filelist_prepare.txt"
FILELISTPREPARE_COMMENTED="find_optional_policy_filelist_prepare_commented.txt"
FILELIST="find_optional_policy_filelist.txt"
FILELIST_COMMENTED="find_optional_policy_filelist_commented.txt"

FIND_TARGET_FILES(){
	find . \( -type f -name "*" \) -print | sort > $FILELISTPREPARE && awk -F/ '{print $2}' $FILELISTPREPARE > $FILELIST
        unlink $FILELISTPREPARE
}

FIND_OPTIONAL_POLICY(){
	echo $1
        IFS=
	FOUND_STR="NO"
	FOUND_STR_SECOND_TIME="NO" 

	while read line
	do
	if [ "$line" = "		optional_policy(\`" ] || [ "$line" = "	optional_policy(\`" ] || [ "$line" = "optional_policy(\`" ]; then
       		if [ "$FOUND_STR" = "YES" ]; then
			FOUND_STR_SECOND_TIME="YES"
		fi
       		FOUND_STR="YES"
        	echo "#""$line"
    	else
		if [ "$FOUND_STR_SECOND_TIME" = "YES" ]; then
                	if [ "$line" = "		')" ] || [ "$line" = "	')" ] || [ "$line" = "')" ]; then
                               	FOUND_STR_SECOND_TIME="NO"
                               	echo "#""$line""++"
			else
				echo "$line"
                	fi
		else
       			if [ "$FOUND_STR" = "YES" ]; then
                		if [ "$line" = "		')" ] || [ "$line" = "	')" ] || [ "$line" = "')" ]; then
                       	        	FOUND_STR="NO"
                       	        	echo "#""$line""+"
				else
                       	       		echo "$line"
				fi
			else
                       	        echo "$line"
			fi
		fi
    	fi
	done < $file_list > "$file_list""_option_commented" 
	echo "$file_list"" has been converted to ""$file_list""_option_commented !"
	
}

cd ./refpolicy/policy/modules

### Get directory name under current directory and put into var.
DICNAME=`find ./ -type d -name "*" | awk -F/ '{ print $2 }'`
### Get target file name under current directory and put into var.
#FILENAME=`find ./ -type f -name "*.te" | awk -F/ '{ print $2 }'`
FILENAME=`find ./ -type f -name "*" | awk -F/ '{ print $2 }'`
### Do something in every directory.

for CHECKDIC in $DICNAME
do
	(\
	cd $CHECKDIC; \
	echo ""
	echo Finding optional policies in $CHECKDIC directory !; \
	echo ""
	FIND_TARGET_FILES; \
	while read file_list 
	do
		FIND_OPTIONAL_POLICY; \
	done < $FILELIST
	unlink $FILELIST
	`rm -f *.te`
	`rm -f *.if`
	`rm -f *.fc`
	`rm -f *.xml`
	for file in *
		do
			mv -f $file `echo $file | sed 's/_option_commented//'`
	done
	)
done

echo "Finding optional policy Successfully finished."

exit $ERROR
