/*
 * segatex SELinux tool.
 *
 * Copyright (C) 2007-2014 Shintaro Fujiwara 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * */

#include <qlayout.h>
#include <qpushbutton.h>
#include <q3process.h>
//Added by qt3to4:
#include <QHBoxLayout>
#include <QVBoxLayout>

#include "segatex_yum_process.h"

//#include <iostream>
//using namespace std;

SegatexYumProcess::SegatexYumProcess(QWidget *parent, const char *name): QDialog(parent, name)
{
	setCaption(tr("Yum SELinux Process"));
	textEdit1 = new Q3TextEdit(this);
	textEdit1->setPaletteBackgroundColor(QColor(174,255,185));
	closeButton = new QPushButton(tr("close"), this);
	closeButton->setDefault(true);
	//closing yum_process button
	connect(closeButton, SIGNAL(clicked()), this, SLOT(close()));
	connect(closeButton, SIGNAL(clicked()), this, SLOT(close_button_clicked()));

	QVBoxLayout *headLayout = new QVBoxLayout;
	headLayout->addWidget(textEdit1);

	QHBoxLayout *footLayout = new QHBoxLayout;
	footLayout->addStretch(1);
	footLayout->addWidget(closeButton);

	QVBoxLayout *mainLayout = new QVBoxLayout(this);
	mainLayout->setMargin(11);
	mainLayout->setSpacing(6);
	mainLayout->addLayout(headLayout);
	mainLayout->addLayout(footLayout);
	resize(600,500);

	yum_install_base_process();
	yum_update_base_process();

}
void SegatexYumProcess::close_button_clicked()
{
	emit yum_prosess_close_button_clicked();

}
void SegatexYumProcess::readFromStdout()
{
	QByteArray data = process->readStdout();
	QString text = textEdit1->text() + QString(data);
	textEdit1->setText(text);
}
void SegatexYumProcess::readFromStdout1()
{
	QByteArray data = process1->readStdout();
	QString text = textEdit1->text() + QString(data);
	textEdit1->setText(text);
}
void SegatexYumProcess::updateOutputTextEdit()
{
	QByteArray data = process->readStderr();
	QString text = textEdit1->text() + QString(data);
	textEdit1->setText(text);
}
void SegatexYumProcess::updateOutputTextEdit1()
{
	QByteArray data = process1->readStderr();
	QString text = textEdit1->text() + QString(data);
	textEdit1->setText(text);
}
void SegatexYumProcess::processExited()
{
	if(process->normalExit()){
		textEdit1->append(tr("yum install process ended !"));
		textEdit1->append(tr("\n"));
	} else {
		textEdit1->append(tr("yum install process had an error !"));
		textEdit1->append(tr("\n"));
	}
	delete process;
	process = 0;
	this->setEnabled(true);
}
void SegatexYumProcess::processExited1()
{
	if(process1->normalExit()){
		textEdit1->append(tr("yum update process ended !"));
		textEdit1->append(tr("\n"));
	} else {
		textEdit1->append(tr("yum update process had an error !"));
		textEdit1->append(tr("\n"));
	}
	delete process1;
	process1 = 0;
	this->setEnabled(true);
}
void SegatexYumProcess::yum_install_base_process()
{
	this->setEnabled(false);
	process = new Q3Process(this);
	process->addArgument("yum");
	process->addArgument("-y");
	process->addArgument("install");
	process->addArgument("audit");
	process->addArgument("checkpolicy");
	process->addArgument("libsepol");
	process->addArgument("libselinux");
	process->addArgument("libselinux-devel");
	process->addArgument("libselinux-python");
	process->addArgument("libsemanage");
	process->addArgument("mod_selinux");
	process->addArgument("policycoreutils");
	process->addArgument("selinux-doc");
	process->addArgument("selinux-policy");
	process->addArgument("selinux-policy-devel");
	process->addArgument("selinux-policy-minimum");
	process->addArgument("selinux-policy-mls");
	process->addArgument("selinux-policy-sandbox");
	process->addArgument("selinux-policy-targeted");
	process->addArgument("sepolgen");
	process->addArgument("setools-console");
	process->addArgument("xguest");
	connect(process, SIGNAL(readyReadStdout()),this,SLOT(readFromStdout()));
	connect(process, SIGNAL(readyReadStderr()),this,SLOT(updateOutputTextEdit()));
	connect(process, SIGNAL(processExited()),this,SLOT(processExited()));
	process->start();
}
void SegatexYumProcess::yum_update_base_process()
{
	this->setEnabled(false);
	process1 = new Q3Process(this);
	process1->addArgument("yum");
	process1->addArgument("-y");
	process1->addArgument("update");
	process1->addArgument("audit");
	process1->addArgument("checkpolicy");
	process1->addArgument("libsepol");
	process1->addArgument("libselinux");
	process1->addArgument("libselinux-devel");
	process1->addArgument("libselinux-python");
	process1->addArgument("libsemanage");
	process1->addArgument("mod_selinux");
	process1->addArgument("policycoreutils");
	process1->addArgument("selinux-doc");
	process1->addArgument("selinux-policy");
	process1->addArgument("selinux-policy-devel");
	process1->addArgument("selinux-policy-minimum");
	process1->addArgument("selinux-policy-mls");
	process1->addArgument("selinux-policy-sandbox");
	process1->addArgument("selinux-policy-targeted");
	process1->addArgument("sepolgen");
	process1->addArgument("setools-console");
	process1->addArgument("xguest");
	connect(process1, SIGNAL(readyReadStdout()),this,SLOT(readFromStdout1()));
	connect(process1, SIGNAL(readyReadStderr()),this,SLOT(updateOutputTextEdit1()));
	connect(process1, SIGNAL(processExited()),this,SLOT(processExited1()));
	process1->start();
}
