/*
 * segatex SELinux tool.
 *
 * Copyright (C) 2007-2014 Shintaro Fujiwara 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * */

#include <qlayout.h>
#include <qpushbutton.h>
#include <q3process.h>
//Added by qt3to4:
#include <Q3TextStream>
#include <Q3HBoxLayout>
#include <Q3VBoxLayout>

#include "segatex_audit2why_process.h"

#include <fstream>

#include <iostream>
using namespace std;

//default constructor
SegatexAudit2whyProcess::SegatexAudit2whyProcess(QWidget *parent, const char *name): QDialog(parent, name)
{
	textEdit1 = new Q3TextEdit(this);
	textEdit1->setPaletteBackgroundColor(QColor(255,187,174));
	closeButton = new QPushButton(tr("close"), this);
	closeButton->setDefault(true);
	//closing process button
	connect(closeButton, SIGNAL(clicked()), this, SLOT(close()));
	connect(closeButton, SIGNAL(clicked()), this, SLOT(close_button_clicked()));
	//connect to checkboxes

	Q3VBoxLayout *headLayout = new Q3VBoxLayout;
	headLayout->addWidget(textEdit1);

	Q3HBoxLayout *footLayout = new Q3HBoxLayout;
	footLayout->addStretch(1);
	footLayout->addWidget(closeButton);

	Q3VBoxLayout *mainLayout = new Q3VBoxLayout(this);
	mainLayout->setMargin(11);
	mainLayout->setSpacing(6);
	mainLayout->addLayout(headLayout);
	mainLayout->addLayout(footLayout);

	audit2why_base_process();

	resize(600,800);
}
void SegatexAudit2whyProcess::close_button_clicked()
{
	emit audit2why_prosess_close_button_clicked();
}

void SegatexAudit2whyProcess::audit2why_base_process()
{
	path = "/usr/share/segatex";
	forward_slash = "/";
	outputfile_str = path + forward_slash + "audit2why";

        #define PWD_BUF 8600
        ofstream os;
        os.open(outputfile_str);
        if(os){
                FILE *read_fp;
                #define SIZE_TMP 8600
                char buffer[SIZE_TMP];
                int chars_read;
                memset(buffer, '\0', sizeof(buffer));
                read_fp = popen("audit2why -i /var/log/audit/audit.log", "r");
                if(read_fp != NULL){
                        chars_read = fread(buffer, sizeof(char), SIZE_TMP, read_fp);
                        while(chars_read>0){
                                buffer[chars_read -1] = '\0';
                                //os << "Reading:-" << endl;
                                os << buffer << endl;
                                chars_read= fread(buffer, sizeof(char), SIZE_TMP, read_fp);
                        }
                        pclose(read_fp);
                }
        }
	os.close();

	//read from .te file
	readFromOutputFile();
}
//this slot should be called from above slot
void SegatexAudit2whyProcess::readFromOutputFile()
{
	/////////////////////////////////////////////////////////////
	//path = "./";
	path = "/usr/share/segatex";
	/////////////////////////////////////////////////////////////
	forward_slash = "/";
	dir.setPath(path);
	dir_name = dir.absPath();
	/////////////////////////////////////////////////////////////
	dir.setFilter( QDir::Files );
        dir.setSorting( QDir::Name );
	files = dir.entryList("audit2why");
	/////////////////////////////////////////////////////////////
	it_d = files.begin();
		while(it_d != files.end()){
			name = *it_d;
			file_interface_name = dir_name + forward_slash + name;
			//cout << "file_interface_name" << file_interface_name << endl;
			QFile file( file_interface_name );
			if ( file.open( QIODevice::ReadOnly ) ) {
				Q3TextStream stream( &file );
				////////////////////////////////////////////
				while ( !stream.atEnd() ) {
					line_analized = stream.readLine(); // line of text excluding '\n'
					textEdit1->append(line_analized);
				}
				file.close();
				++it_d;
			}else{
				//do nothing
			}
		}
	textEdit1->setCursorPosition(0,0);
}

