/*
 * segatex SELinux tool.
 *
 * Copyright (C) 2007-2014 Shintaro Fujiwara 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * */

#ifndef SEEPROCESS_H
#define SEEPROCESS_H

#include <qregexp.h>
#include <qdialog.h>
#include <qradiobutton.h>
#include <q3textedit.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qcheckbox.h>
#include <q3process.h>
//Added by qt3to4:
#include <Q3VBoxLayout>
#include <Q3HBoxLayout>


class Q3TextEdit;
class QLineEdit;
class QPushButton;
class Q3Process;

class Seeprocess: public QDialog
{
	Q_OBJECT
public:
	Seeprocess(QWidget *parent = 0, const char *name = 0);
public slots:
signals:
protected:

private slots:
	void grep_clicked();
	void seeprocess_clicked();
	void seeprocess_end_clicked();
	void seeprocess_base_process();
	void seeprocess_end_process();
	void seeprocess_end();
	void seeprocess_grep_process(QString grep_str);
	void processExited();
	void readFromStdout();
	void readFromOutputFile();
	void readFromOutputFile_grep(QString grep_str);
private:
	Q3Process *process;
	Q3Process *process_end;
	Q3TextEdit *textEdit1;
	QLabel *grepLabel;
	Q3VBoxLayout *firstLayout;
	Q3HBoxLayout *leftLayout;
	Q3VBoxLayout *rightLayout;
	Q3HBoxLayout *mainLayout;
	QLineEdit *grepEditLineEdit;
	QPushButton *grepButton;
	QPushButton *seeprocessButton;
	QPushButton *seeprocessEndButton;
	QPushButton *closeButton;
	QString grep_str;
	QString grep_str_echo;

        QDir dir;
        QString path;
        QString name;
        QString dir_name;
        QString forward_slash;
        QString file_interface_name;
        QString line_analized;
        QString outputfile_str;

        QStringList::Iterator it_d;
        QStringList files;
};

#endif
