#
# segatex SELinux tool.
#
# Copyright (C) 2007-2013 Shintaro Fujiwara 
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#

#!/bin/sh 

ERROR=0
LINE=
SOURCEFILE=
INCLUDEIFFILE="../allif.txt"
INCLUDESPTFILE="../allspt.txt"
INCLUDEFILE="include_if"
BROKENUPPREPAREFILE="broken_up_prepare"
BROKENUPPREPAREFILE2="broken_up_prepare2"
BROKENUPPREPAREFILE3="broken_up_prepare3"
BROKENUPFILE="broken_up"
BROKENUPFILE2="broken_up2"
NEWFILE="prepare"
SPLITFILE="splitfile.txt"
CSPLITFILE="xx00"
CSPLITFILE2="xx01"
BLANK=""
TAB="	"
OUTFILE=../tunable_policy.txt
OUTFILE_WITH_DIR_FILE_NAME=../tunable_policy_with_dir_file_name.txt
OUTFILE_DEL=./tunable_policy.txt
OUTFILE_WITH_DIR_FILE_NAME_DEL=./tunable_policy_with_dir_file_name.txt

FILELISTPREPARE="filelist_prepare.txt"
FILELIST="filelist.txt"


BREAK_TE(){
	find . \( -type f -name "*.te" \) -print | sort > $FILELISTPREPARE && awk -F/ '{print $2}' $FILELISTPREPARE > $FILELIST

	IFS=
	while read LINE
	do
			SOURCEFILE="$LINE"
		if [ ! -r "$SOURCEFILE" ]; then
			echo "Cannot find file $SOURCEFILE" 1>&2
			ERROR=1
		else

        ########### write include(`all.if') first line of the source file#######################################
#######################################edited on 7.870####################################################
			cp ../all.if all.if_now_pre
                        ####interface to define
                        sed 's/interface/define/g' all.if_now_pre > all.if_now
                        cat all.if_now $SOURCEFILE > $INCLUDEFILE
                        m4 $INCLUDEFILE > $BROKENUPPREPAREFILE
                        ####make preparaton
                        m4 $BROKENUPPREPAREFILE > $BROKENUPPREPAREFILE2
        ########### write include(`all.spt') first line of the brokenupprepare file number#######################################
                        cat $INCLUDESPTFILE $BROKENUPPREPAREFILE2 > $BROKENUPPREPAREFILE3
                        ####put this to first line
                        m4 $BROKENUPPREPAREFILE3 > $BROKENUPFILE
        ########### make broken .te_raw#######################################
                        sed 's/# Declarations/Declarations/g' $BROKENUPFILE > $BROKENUPFILE2
                        COMP_STR="Declarations"
                        csplit $BROKENUPFILE2 /^$COMP_STR/ {*}
                        sed 's/Declarations/# Declarations/g' xx01 > $NEWFILE
        ########### eliminate blank lines#######################################
                        NEWFILE_NEW=$SOURCEFILE"_raw"
                        NEWFILE_NEW2=$SOURCEFILE"_raw2"
                        NEWFILE_NEW3=$SOURCEFILE"_raw3"
                        NEWFILE_NEW4=$SOURCEFILE"_raw4"
                        NEWFILE_NEW5=$SOURCEFILE"_raw5"
                        NEWFILE_NEW6=$SOURCEFILE"_raw6"
                        NEWFILE_NEW7=$SOURCEFILE"_raw7"
                        grep [a-zA-Z#{}] "$NEWFILE" > "$NEWFILE_NEW"

                        cat all.if_now $NEWFILE_NEW > $NEWFILE_NEW2
                        m4 $NEWFILE_NEW2 > $NEWFILE_NEW3
                        grep -v -e '^##' -e '^$' "$NEWFILE_NEW3" > "$NEWFILE_NEW4"
                        cat $INCLUDESPTFILE $NEWFILE_NEW4 > $NEWFILE_NEW5
			m4 $NEWFILE_NEW5 > $NEWFILE_NEW6
                        grep -v -e '^##' -e '^$' "$NEWFILE_NEW6" > "$NEWFILE_NEW7"

		fi

		unlink $BROKENUPPREPAREFILE
		unlink $BROKENUPPREPAREFILE2
		unlink $BROKENUPPREPAREFILE3
		unlink $BROKENUPFILE
		unlink $BROKENUPFILE2
		unlink $NEWFILE
		unlink $CSPLITFILE
		unlink $CSPLITFILE2
		unlink all.if_now
		unlink all.if_now_pre
		unlink $INCLUDEFILE
		unlink $NEWFILE_NEW2
		unlink $NEWFILE_NEW3
		unlink $NEWFILE_NEW4
		unlink $NEWFILE_NEW5
		unlink $NEWFILE_NEW6

	done < "$FILELIST"

	unlink $FILELISTPREPARE
	unlink $FILELIST
}

TUNABLE_POLICY(){
	find . \( -type f -name "*.te" \) -print | sort > $FILELISTPREPARE && awk -F/ '{print $2}' $FILELISTPREPARE > $FILELIST
	IFS=
	while read LINE
	do
		SOURCEFILE="$LINE"
		if [[ "$SOURCEFILE_PRE" != "$SOURCEFILE" ]]; then
			SOURCEFILE_ECHO="$SOURCEFILE"
		else
			SOURCEFILE_ECHO=""
		fi
		if [ ! -r "$SOURCEFILE" ]; then
			echo "Cannot find file $SOURCEFILE" 1>&2
			ERROR=1
		else
		echo checking in $SOURCEFILE
		I_TMP=0
		while read LINE2
		do
			if [[ $LINE2 == *tunable_policy* ]]; then
				I_TMP=1
				if [[ "$SOURCEFILE_PRE" != "$SOURCEFILE" ]]; then
					echo "SOURCE:""$CHECKDIC""/""$SOURCEFILE_ECHO"
				fi
			else
				if [[ $LINE2 == \'\) ]]; then
					if [ $I_TMP -eq 1 ]; then
						I_TMP=0
						echo $LINE2
					fi
				fi
			fi
			if [ $I_TMP -eq 1 ]; then
				echo $LINE2
			fi
		done < $SOURCEFILE >> $OUTFILE
		fi
                ####interface to define
		SOURCEFILE_PRE="$SOURCEFILE"
	done < "$FILELIST"
	unlink $FILELIST
	cp $OUTFILE $OUTFILE_WITH_DIR_FILE_NAME
}

cd /usr/share/segatex/raw_te_files

### Get directory name under current directory and put into var.
DICNAME=`find ./ -type d -name "*" | awk -F/ '{ print $2 }'`
### Do something in every directory.
unlink $OUTFILE_DEL
unlink $OUTFILE_DEL"2"
unlink $OUTFILE_DEL"3"
unlink $OUTFILE_DEL"4"
unlink $OUTFILE_DEL"5"
unlink $OUTFILE_DEL"6"
unlink $OUTFILE_DEL"7"
unlink $OUTFILE_DEL"8"
unlink $OUTFILE_DEL"9"
unlink $OUTFILE_DEL"10"
unlink $OUTFILE_DEL"11"
unlink $OUTFILE_DEL"12"
unlink $OUTFILE_DEL"13"
unlink $OUTFILE_DEL"_raw"
for CHECKDIC in $DICNAME
do
	(\
	cd $CHECKDIC; \
	echo ""
	echo Breaking .te files in $CHECKDIC directory !; \
	echo ""
	BREAK_TE; \
	TUNABLE_POLICY;
	)
done

COMP_STR="####START####"
grep -v ^SOURCE $OUTFILE_WITH_DIR_FILE_NAME_DEL > $OUTFILE_DEL
sed -e 's/interface/define/g' "./all.if" > "./all.if_define"
cat "./all.if_define" $SPLITFILE $OUTFILE_DEL > $OUTFILE_DEL"2"
m4 $OUTFILE_DEL"2" > $OUTFILE_DEL"3"
csplit $OUTFILE_DEL"3" /^$COMP_STR/ {*}
cat "./all.if_define" $SPLITFILE "xx01" > $OUTFILE_DEL"4"
unlink "xx00"
unlink "xx01"
m4 $OUTFILE_DEL"4" > $OUTFILE_DEL"5"
csplit $OUTFILE_DEL"5" /^$COMP_STR/ {*}
grep -v ^# "xx02" > $OUTFILE_DEL"6"
sed '/^$/d' $OUTFILE_DEL"6" > $OUTFILE_DEL"7"
sed -e 's/^[\t]*//g' $OUTFILE_DEL"7" > $OUTFILE_DEL"8"
cat "./all.spt" $SPLITFILE $OUTFILE_DEL"8" > $OUTFILE_DEL"9"
unlink "xx00"
unlink "xx01"
unlink "xx02"
m4 $OUTFILE_DEL"9" > $OUTFILE_DEL"10"
csplit $OUTFILE_DEL"9" /^$COMP_STR/ {*}
cat "./all.spt" $SPLITFILE "xx01" > $OUTFILE_DEL"10"
unlink "xx00"
unlink "xx01"
m4 $OUTFILE_DEL"10" > $OUTFILE_DEL"11"
csplit $OUTFILE_DEL"11" /^$COMP_STR/ {*}
sed '/^$/d' "xx02" > $OUTFILE_DEL"12"
unlink "xx00"
unlink "xx01"
unlink "xx02"
sed -e 's/^[\t]*//g' $OUTFILE_DEL"12" > $OUTFILE_DEL"13"
sed '/^$/d' $OUTFILE_DEL"13" > $OUTFILE_DEL"_raw"

unlink $OUTFILE_DEL"2"
unlink $OUTFILE_DEL"3"
unlink $OUTFILE_DEL"4"
unlink $OUTFILE_DEL"5"
unlink $OUTFILE_DEL"6"
unlink $OUTFILE_DEL"7"
unlink $OUTFILE_DEL"8"
unlink $OUTFILE_DEL"9"
unlink $OUTFILE_DEL"10"
unlink $OUTFILE_DEL"11"
unlink $OUTFILE_DEL"12"
unlink $OUTFILE_DEL"13"

echo "Breaking .te scripts Successfully finished."
echo ""
echo "You can see raw .te files at /usr/share/segatex/raw_te_files/"layers" as te_raw files."
echo "You can understand fully the meaning of type enforcement process of SELinx."
echo "tunable_policy is now  at /usr/share/segatex/raw_te_files/tunable_policy.txt and tunable_policy.txt_raw."

exit $ERROR
