/*
 * segatex SELinux tool.
 *
 * Copyright (C) 2007-2013 Shintaro Fujiwara 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * */

#include <qlayout.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qradiobutton.h>
#include <q3textedit.h>
#include <q3process.h>
#include <qmessagebox.h>
//Added by qt3to4:
#include <Q3TextStream>
#include <Q3HBoxLayout>
#include <Q3VBoxLayout>
#include <QLabel>

#include "useradd.h"

//#include <iostream>
//using namespace std;

Useradd::Useradd(QWidget *parent, const char *name): QDialog(parent, name)
{
		setCaption(tr("manage user"));
		textEdit1 = new Q3TextEdit(this);
		textEdit1->setPaletteBackgroundColor(QColor(174,187,255));
		usernameLabel = new QLabel(tr("User name:"), this );
		passwordLabel = new QLabel(tr("Password:"), this );
		password2Label = new QLabel(tr("Password again:"), this );
		usernameEditLineEdit = new QLineEdit(this );
		passwordEditLineEdit = new QLineEdit(this );
		password2EditLineEdit = new QLineEdit(this );
		passwordEditLineEdit->setEchoMode(QLineEdit::Password);
		password2EditLineEdit->setEchoMode(QLineEdit::Password);
		usernameEditLineEdit->setText(tr(""));
		passwordEditLineEdit->setText(tr(""));
		password2EditLineEdit->setText(tr(""));
		useraddButton = new QPushButton(tr("user&add"), this);
		useraddButton->setPaletteBackgroundColor(QColor(155, 155, 255));
		userdelButton = new QPushButton(tr("user&del"), this);
		userdelButton->setPaletteBackgroundColor(QColor(255, 155, 155));
		readfromfileButton = new QPushButton(tr("read /etc/passwd"), this);
		readfromfileButton->setPaletteBackgroundColor(QColor(255, 255, 0));
		closeButton = new QPushButton(tr("&Close"), this);
		useraddButton->setDefault(true);
		readfromfileButton->setDefault(true);

		connect(useraddButton, SIGNAL(clicked()), this, SLOT(useradd_clicked()));
		connect(userdelButton, SIGNAL(clicked()), this, SLOT(userdel_clicked()));
		connect(readfromfileButton, SIGNAL(clicked()), this, SLOT(readfromfile_clicked()));
		connect(closeButton, SIGNAL(clicked()), this, SLOT(close()));

		firstLayout = new Q3VBoxLayout;
		leftLayout = new Q3HBoxLayout;
		leftLayout->addWidget(usernameLabel);
		leftLayout->addWidget(usernameEditLineEdit);
		leftLayout->addWidget(passwordLabel);
		leftLayout->addWidget(passwordEditLineEdit);
		leftLayout->addWidget(password2Label);
		leftLayout->addWidget(password2EditLineEdit);

		rightLayout = new Q3VBoxLayout;
		rightLayout->addWidget(useraddButton);
		rightLayout->addStretch(1);
		rightLayout->addWidget(userdelButton);
		rightLayout->addStretch(2);
		rightLayout->addWidget(readfromfileButton);
		rightLayout->addWidget(closeButton);

		firstLayout->addLayout(leftLayout);
		firstLayout->addWidget(textEdit1);

		mainLayout = new Q3HBoxLayout(this);
		mainLayout->setMargin(11);
		mainLayout->setSpacing(6);
		mainLayout->addLayout(firstLayout);
		mainLayout->addLayout(rightLayout);

		readFromOutputFile();
		resize(800,600);

}
void Useradd::readfromfile_clicked()
{
	readFromOutputFile();
}
void Useradd::useradd_clicked()
{
		username_str = usernameEditLineEdit->text();
		passwordEditLineEdit_str = passwordEditLineEdit->text();
		password2EditLineEdit_str = password2EditLineEdit->text();

		if(username_str == ""){
			QMessageBox::information( this, tr("segatex alert"),
			    tr("No username given.\n"
			    "Try again !" ));
		}
		else if((passwordEditLineEdit_str == "")||(password2EditLineEdit_str =="")){
			QMessageBox::information( this, tr("segatex alert"),
			    tr("Ooops! Password is empty.\n"
			    "Try again !" ));
		}	
		else if((username_str != "")&&(passwordEditLineEdit_str == password2EditLineEdit_str)){
			useradd_base_process(username_str, passwordEditLineEdit_str);
		}else{
			QMessageBox::information( this, tr("segatex alert"),
			    tr("Password does not match.\n"
			    "Try again !" ));
		}
}
void Useradd::userdel_clicked()
{
		username_str = usernameEditLineEdit->text();

		if(username_str == ""){
			QMessageBox::information( this, tr("segatex alert"),
			    tr("No username given.\n"
			    "Try again !" ));
		}
		if(username_str == "root"){
			QMessageBox::information( this, tr("segatex alert"),
			    tr("You can't delete user root.\n"
			    "Try again !" ));
		}
		else if(username_str != ""){
			userdel_base_process(username_str);
		}
}
////////////////////////////////////////////
void Useradd::readFromStdout()
{
        QByteArray data = process->readStdout();
        QString text = textEdit1->text() + QString(data);
        textEdit1->setText(text);
}
void Useradd::processExited()
{
	if(process->normalExit()){
	} else {
		textEdit1->append(tr("useradd process had an error !"));
		textEdit1->append(tr("\n"));
	}
	delete process;
	process = 0;
	this->setEnabled(true);
}
void Useradd::useradd_base_process(QString username_str, QString passwordEditLineEdit_str)
{
	this->setEnabled(false);
	process = new Q3Process(this);
	process->addArgument("useradd");
	process->addArgument(username_str);
	process->addArgument("-p");
	process->addArgument(passwordEditLineEdit_str);

	outputfile_str = "useradd";
	path = "/usr/share/segatex";
	forward_slash = "/";
	outputfile_str = path + forward_slash + outputfile_str;
	connect(process, SIGNAL(readyReadStdout()),this,SLOT(readFromStdout()));
	connect(process, SIGNAL(processExited()),this,SLOT(processExited()));
	process->start();

	sleep(5);
	readfromfile_clicked();
}
void Useradd::userdel_base_process(QString username_str)
{
	this->setEnabled(false);
	process = new Q3Process(this);
	process->addArgument("userdel");
	process->addArgument("-r");
	process->addArgument(username_str);

	outputfile_str = "userdel";
	path = "/usr/share/segatex";
	forward_slash = "/";
	outputfile_str = path + forward_slash + outputfile_str;
	connect(process, SIGNAL(readyReadStdout()),this,SLOT(readFromStdout()));
	connect(process, SIGNAL(processExited()),this,SLOT(processExited()));
	process->start();

	sleep(10);
	readfromfile_clicked();
}

//this slot should be called from above slot
void Useradd::readFromOutputFile()
{
	/////////////////////////////////////////////////////////////
	path = "/etc";
	/////////////////////////////////////////////////////////////
	forward_slash = "/";
	dir.setPath(path);
	dir_name = dir.absPath();
	/////////////////////////////////////////////////////////////
	dir.setFilter( QDir::Files );
        dir.setSorting( QDir::Name );
	files = dir.entryList("passwd");
	/////////////////////////////////////////////////////////////
	it_d = files.begin();
	textEdit1->clear();
		while(it_d != files.end()){
			name = *it_d;
			file_interface_name = dir_name + forward_slash + name;
			QFile file( file_interface_name );
			if ( file.open( QIODevice::ReadOnly ) ) {
				Q3TextStream stream( &file );
				////////////////////////////////////////////
				while ( !stream.atEnd() ) {
					line_analized = stream.readLine(); // line of text excluding '\n'
					textEdit1->append(line_analized);
				}
				file.close();
				++it_d;
			}else{
				//do nothing
			}
		}
		textEdit1->setCursorPosition(0,0);
}
