/*
 * segatex SELinux tool.
 *
 * Copyright (C) 2007-2013 Shintaro Fujiwara 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * */

#ifndef SQLREFPOLICY_H
#define SQLREFPOLICY_H

#include <QDialog>
#include <QSqlTableModel>
#include <QTableView> 
#include "segatex_core2_process.h" 

class QPushButton;
class QRadioButton;
class QHBoxLayout;
class QVBoxLayout;
class QLabel;

class SegatexCore2Process;

class Sqlrefpolicy: public QDialog
{
	Q_OBJECT
public:
	Sqlrefpolicy(QWidget *parent = 0, const char *name = 0);
	int i_pub;
	QLineEdit *permissionsEditLineEdit;
	QString permissions_pre_main_str;
	QList<QString> av;
signals:
protected:

public slots:
	void segatex_core2_process_sql(const QList<QString> &, const QList<QString> &, const QList<QString> &, const QList<QString> &);
	void segatex_core2_next_denied_message_button_clicked();
	void segatex_core2_prev_denied_message_button_clicked();
	void targetdomain_clicked();
private slots:
private:
	QLineEdit *targetdomainEditLineEdit;
	QLabel *targetdomainLabel;
	QLineEdit *objectclassEditLineEdit;
	QLabel *objectclassLabel;
	//QLineEdit *permissionsEditLineEdit;
	QLabel *permissionsLabel;
	QPushButton *targetdomainobjectclassButton;
	QHBoxLayout *topLayout;
	QHBoxLayout *topleftLayout;
	QHBoxLayout *toprightLayout;
	QVBoxLayout *mainLayout;
	QSqlTableModel *model;
	QTableView *view;
	QString targetdomain_pre_first_str;
	QString targetdomain_pre_main_str;
	QString targetdomain_pre_last_str;
	QString targetdomain_objectclass_str;
	QString objectclass_pre_first_str;
	QString objectclass_pre_main_str;
	QString objectclass_pre_last_str;
	QString permissions_pre_first_str;
	QString permissions_pre_last_str;
	QString access_vector_for_sql;
	SegatexCore2Process *segatex_core2_process_o;
};

#endif
