/*
 * segatex SELinux tool.
 *
 * Copyright (C) 2007-2013 Shintaro Fujiwara 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * */

#include <qlayout.h>
#include <qpushbutton.h>
#include <qlineedit.h>
#include <QLabel>

#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "sesearch.h"
#include "sesearch_process.h"

#include <iostream>
using namespace std;

Sesearch::Sesearch(QWidget *parent, const char *name): QDialog(parent, name)
{
        sesearchLabel = new QLabel(tr("Search about"),this);
        expressionLabel = new QLabel(tr("[=NAME|=P]"),this);
        optionLabel = new QLabel(tr("[regex expression]"),this);

        expressionEditLineEdit = new QLineEdit( this );
        expressionEditLineEdit->setText("");
        expressionEditLineEdit->setPaletteBackgroundColor(QColor(200,200,140));

        optionEditLineEdit = new QLineEdit( this );
        optionEditLineEdit->setText("");
        optionEditLineEdit->setPaletteBackgroundColor(QColor(200,200,140));

	sesearchButton = new QPushButton(tr("sesearch"), this);
	sesearchButton->setPaletteBackgroundColor(QColor(200,80,50));
	connect(sesearchButton, SIGNAL(clicked()), this, SLOT(sesearch_button_clicked()));

	closeButton = new QPushButton(tr("close"), this);
	//closing process button
	connect(closeButton, SIGNAL(clicked()), this, SLOT(close()));
	closeButton->setDefault(true);

	mainLayout = new QHBoxLayout;
	leftLayout = new QVBoxLayout;
	leftupLayout = new QVBoxLayout;
	leftdownLayout = new QVBoxLayout;
	rightLayout = new QVBoxLayout;

	leftupLayout->addWidget(sesearchLabel);
	leftupLayout->addWidget(createFirstExclusiveGroup());
	leftdownLayout->addWidget(createFirstExclusiveGroup2());
	leftdownLayout->addWidget(expressionLabel);
	leftdownLayout->addWidget(expressionEditLineEdit);
	rightLayout->addWidget(createFirstExclusiveGroup3());
	rightLayout->addWidget(optionLabel);
	rightLayout->addWidget(optionEditLineEdit);
	rightLayout->addStretch(5);
	rightLayout->addWidget(sesearchButton);
	rightLayout->addStretch(1);
	rightLayout->addWidget(closeButton);

	mainLayout->addLayout(leftupLayout);
	mainLayout->addLayout(leftdownLayout);
	mainLayout->addLayout(rightLayout);

	setLayout(mainLayout);
	setWindowTitle(tr("Sesearch"));

	sesearch_process = 0;
}

QGroupBox *Sesearch::createFirstExclusiveGroup()
{
        optionButtonGroupBox = new QGroupBox(tr("RULE_TYPES"));
	//second,declear many buttons  
        allRadioButton = new QRadioButton(tr("all(print all below)"));
        allowRadioButton = new QRadioButton(tr("allow"));
        neverallowRadioButton = new QRadioButton(tr("neverallow"));
        auditallowRadioButton = new QRadioButton(tr("auditallow"));
        dontauditRadioButton = new QRadioButton(tr("dontaudit"));
        typeRadioButton = new QRadioButton(tr("type"));
        role_allowRadioButton = new QRadioButton(tr("role_allow"));
        role_transRadioButton = new QRadioButton(tr("role_trans"));
        range_transRadioButton = new QRadioButton(tr("range_trans"));

        allRadioButton->setChecked(true);

	//third,add widget to vboxlayout
	vbox = new QVBoxLayout;
        vbox->addWidget(allRadioButton);
        vbox->addWidget(allowRadioButton);
        vbox->addWidget(neverallowRadioButton);
        vbox->addWidget(auditallowRadioButton);
        vbox->addWidget(dontauditRadioButton);
        vbox->addWidget(typeRadioButton);
        vbox->addWidget(role_allowRadioButton);
        vbox->addWidget(role_transRadioButton);
        vbox->addWidget(range_transRadioButton);
	optionButtonGroupBox->setLayout(vbox);
	
	return optionButtonGroupBox;
}

QGroupBox *Sesearch::createFirstExclusiveGroup2()
{
        optionButtonGroupBox2 = new QGroupBox(tr("EXPRESSIONS"));
	//second,declear many buttons  
        noneRadioButton = new QRadioButton(tr("none"));
        sourceRadioButton = new QRadioButton(tr("source[=NAME]"));
        targetRadioButton = new QRadioButton(tr("target[=NAME]"));
        role_sourceRadioButton = new QRadioButton(tr("role_source[=NAME]"));
        role_targetRadioButton = new QRadioButton(tr("role_target[=NAME]"));
        classRadioButton = new QRadioButton(tr("class[=NAME]"));
        permRadioButton = new QRadioButton(tr("perm[=P1[,P2...]"));
        boolRadioButton = new QRadioButton(tr("bool[=NAME]"));

        noneRadioButton->setChecked(true);

	//third,add widget to vboxlayout
	vbox2 = new QVBoxLayout;
        vbox2->addWidget(noneRadioButton);
        vbox2->addWidget(sourceRadioButton);
        vbox2->addWidget(targetRadioButton);
        vbox2->addWidget(role_sourceRadioButton);
        vbox2->addWidget(role_targetRadioButton);
        vbox2->addWidget(classRadioButton);
        vbox2->addWidget(permRadioButton);
        vbox2->addWidget(boolRadioButton);
	optionButtonGroupBox2->setLayout(vbox2);
	
	return optionButtonGroupBox2;
}

QGroupBox *Sesearch::createFirstExclusiveGroup3()
{
        optionButtonGroupBox3 = new QGroupBox(tr("OPTIONS"));
        noneRadioButton2 = new QRadioButton(tr("none"));
        directRadioButton = new QRadioButton(tr("direct"));
        regexRadioButton = new QRadioButton(tr("regex"));
        linenumRadioButton = new QRadioButton(tr("linenum"));
        semanticRadioButton = new QRadioButton(tr("semantic"));
        show_condRadioButton = new QRadioButton(tr("show_cond"));
        helpRadioButton = new QRadioButton(tr("help"));
        versionRadioButton = new QRadioButton(tr("version(show version)"));

        directRadioButton->setChecked(true);

	vbox3 = new QVBoxLayout;
        vbox3->addWidget(noneRadioButton2);
        vbox3->addWidget(directRadioButton);
        vbox3->addWidget(regexRadioButton);
        vbox3->addWidget(linenumRadioButton);
        vbox3->addWidget(semanticRadioButton);
        vbox3->addWidget(show_condRadioButton);
        vbox3->addWidget(helpRadioButton);
        vbox3->addWidget(versionRadioButton);
	optionButtonGroupBox3->setLayout(vbox3);

	return optionButtonGroupBox3;
}
/*signal and slot should have same argument pattern so I had to pass to another slot*/
void Sesearch::sesearch_button_clicked()
{
///////////////////////for group3////////////////////
	sesearch_str_pp3 = "";
	if(noneRadioButton2->isChecked())
		sesearch_str_pp3 = "sesearch ";
	if(directRadioButton->isChecked())
		sesearch_str_pp3 = "sesearch --direct";
	if(regexRadioButton->isChecked())
		sesearch_str_pp3 = "sesearch --regex";
	if(linenumRadioButton->isChecked())
		sesearch_str_pp3 = "sesearch --linenum";
	if(semanticRadioButton->isChecked())
		sesearch_str_pp3 = "sesearch --semantic";
	if(show_condRadioButton->isChecked())
		sesearch_str_pp3 = "sesearch --show_cond";
	if(helpRadioButton->isChecked())
		sesearch_str_pp3 = "sesearch --help";
	if(versionRadioButton->isChecked())
		sesearch_str_pp3 = "sesearch --version";

	//set option name or etc.
	optionEditLineEdit_str = optionEditLineEdit->text();
	if((optionEditLineEdit_str != "")&&(regexRadioButton->isChecked())){
		sesearch_str_pp3 = sesearch_str_pp3 + " " + optionEditLineEdit_str;
	}
///////////////////////for group1////////////////////
	if(allRadioButton->isChecked())
		sesearch_str_pp = sesearch_str_pp3 + " --all";
	if(allowRadioButton->isChecked())
		sesearch_str_pp = sesearch_str_pp3 + " --allow";
	if(neverallowRadioButton->isChecked())
		sesearch_str_pp = sesearch_str_pp3 + " --neverallow";
	if(auditallowRadioButton->isChecked())
		sesearch_str_pp = sesearch_str_pp3 + " --auditallow";
	if(dontauditRadioButton->isChecked())
		sesearch_str_pp = sesearch_str_pp3 + " --dontaudit";
	if(typeRadioButton->isChecked())
		sesearch_str_pp = sesearch_str_pp3 + " --type";
	if(role_allowRadioButton->isChecked())
		sesearch_str_pp = sesearch_str_pp3 + " --role_allow";
	if(role_transRadioButton->isChecked())
		sesearch_str_pp = sesearch_str_pp3 + " --role_trans";
	if(range_transRadioButton->isChecked())
		sesearch_str_pp = sesearch_str_pp3 + " --range_trans";
///////////////////////for group2////////////////////
	sesearch_str_pp2 = "";
	if(noneRadioButton->isChecked())
		sesearch_str_pp2 = sesearch_str_pp;
	if(sourceRadioButton->isChecked())
		sesearch_str_pp2 = sesearch_str_pp + " --source";
	if(targetRadioButton->isChecked())
		sesearch_str_pp2 = sesearch_str_pp + " --target";
	if(role_sourceRadioButton->isChecked())
		sesearch_str_pp2 = sesearch_str_pp + " --role_source";
	if(role_targetRadioButton->isChecked())
		sesearch_str_pp2 = sesearch_str_pp + " --role_target";
	if(classRadioButton->isChecked())
		sesearch_str_pp2 = sesearch_str_pp + " --class";
	if(permRadioButton->isChecked())
		sesearch_str_pp2 = sesearch_str_pp + " --perm";
	if(boolRadioButton->isChecked())
		sesearch_str_pp2 = sesearch_str_pp + " --bool";

	//set expression name or etc.
	expressionEditLineEdit_str = expressionEditLineEdit->text();
	if((expressionEditLineEdit_str != "")&&(!noneRadioButton->isChecked())){
		sesearch_str_pp2 = sesearch_str_pp2 + expressionEditLineEdit_str;
	}

	if(sesearch_str_pp3 =="")
		sesearch_str_pp_str = sesearch_str_pp;
	else
		sesearch_str_pp_str = sesearch_str_pp2;

	sesearch_process = new SesearchProcess(this);
	connect(closeButton, SIGNAL(clicked()), sesearch_process, SLOT(close()));
	sesearch_process->setCaption(tr(sesearch_str_pp_str));
	sesearch_process->show();
	sesearch_process->raise();
	sesearch_process->setActiveWindow();

	sesearch_process->sesearch_base_process(sesearch_str_pp_str);
}
