/*
 * segatex SELinux tool.
 *
 * Copyright (C) 2007-2013 Shintaro Fujiwara 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * */

#include <qlayout.h>
#include <qpushbutton.h>
#include <q3process.h>
//Added by qt3to4:
#include <Q3HBoxLayout>
#include <Q3VBoxLayout>

#include "semodule_dontaudit_process.h"

//#include <iostream>
//using namespace std;

//default constructor
SemoduleDontauditProcess::SemoduleDontauditProcess(QWidget *parent, const char *name , int semodule_dontaudit_common_int): QDialog(parent, name)
{
	setCaption(tr("Semodule Dontaudit Process"));
	textEdit1 = new Q3TextEdit(this);
	textEdit1->setPaletteBackgroundColor(QColor(174,255,185));
	closeButton = new QPushButton(tr("close"), this);
	closeButton->setDefault(true);
	//closing yum_process button
	connect(closeButton, SIGNAL(clicked()), this, SLOT(close()));
	connect(closeButton, SIGNAL(clicked()), this, SLOT(close_button_clicked()));

	Q3VBoxLayout *headLayout = new Q3VBoxLayout;
	headLayout->addWidget(textEdit1);

	Q3HBoxLayout *footLayout = new Q3HBoxLayout;
	footLayout->addStretch(1);
	footLayout->addWidget(closeButton);

	Q3VBoxLayout *mainLayout = new Q3VBoxLayout(this);
	mainLayout->setMargin(11);
	mainLayout->setSpacing(6);
	mainLayout->addLayout(headLayout);
	mainLayout->addLayout(footLayout);
	resize(300,200);

	semodule_dontaudit_process_base_process(semodule_dontaudit_common_int);
}
void SemoduleDontauditProcess::close_button_clicked()
{
	emit semodule_dontaudit_process_close_button_clicked();
}
void SemoduleDontauditProcess::readFromStdout()
{
	QByteArray data = process->readStdout();
	QString text = textEdit1->text() + QString(data);
	textEdit1->setText(text);
}
void SemoduleDontauditProcess::updateOutputTextEdit()
{
	QByteArray data = process->readStderr();
	QString text = textEdit1->text() + QString(data);
	textEdit1->setText(text);
}
void SemoduleDontauditProcess::processExited()
{
	if(process->normalExit()){
		textEdit1->append(tr("semodule dontaudit process ended !"));
		textEdit1->append(tr("\n"));
	} else {
		textEdit1->append(tr("semodule dontaudit process had an error !"));
		textEdit1->append(tr("\n"));
	}
	delete process;
	process = 0;
	this->setEnabled(true);
	process2 = new Q3Process(this);
	process2->addArgument("/usr/share/segatex/DONTAUDIT_STATE");
	process2->start();

}
void SemoduleDontauditProcess::semodule_dontaudit_process_base_process(int semodule_dontaudit_common_int)
{
	this->setEnabled(false);
	process = new Q3Process(this);
	process->addArgument("semodule");
	if(semodule_dontaudit_common_int == 0){
		//std::cout << "now the command is semodule -DB" << endl;
		process->addArgument("-DB");
	}
	if(semodule_dontaudit_common_int == 1){
		process->addArgument("-B");
		//std::cout << "now the command is semodule -B" << endl;
	}
	connect(process, SIGNAL(readyReadStdout()),this,SLOT(readFromStdout()));
	connect(process, SIGNAL(readyReadStderr()),this,SLOT(updateOutputTextEdit()));
	connect(process, SIGNAL(processExited()),this,SLOT(processExited()));
	process->start();
}
