/*
 * segatex SELinux tool.
 *
 * Copyright (C) 2007-2013 Shintaro Fujiwara 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * */

#include <qlayout.h>
#include <qpushbutton.h>
#include <q3process.h>
#include <qradiobutton.h>
#include <q3buttongroup.h>
#include <qlineedit.h>
#include <q3textedit.h>
//Added by qt3to4:
#include <Q3TextStream>
#include <Q3HBoxLayout>
#include <QLabel>
#include <Q3VBoxLayout>

#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <fstream>

#include "semanage_core_login_process.h"

#include <iostream>
using namespace std;

//default constructor
SemanageCoreLoginProcess::SemanageCoreLoginProcess(QWidget *parent, const char *name): QDialog(parent, name)
{
	setCaption(tr("Semanage Login Process"));
	textEdit1 = new Q3TextEdit(this);
	textEdit1->setPaletteBackgroundColor(QColor(250,180,200));

	semanageEditLabel = new QLabel(tr("Add Unix user:"), this );
	semanageEditLabel2 = new QLabel(tr("as a SELinux user:"), this );
	semanageEditLabel6 = new QLabel(tr("range:"), this );
	semanageEditLineEdit = new QLineEdit( this );
	semanageEditLineEdit2 = new QLineEdit( this );
	semanageEditLineEdit6 = new QLineEdit( this );
	semanageEditLineEdit->setText("");
	semanageEditLineEdit->setPaletteBackgroundColor(QColor(255,100,200));
	semanageEditLineEdit2->setText("");
	semanageEditLineEdit2->setPaletteBackgroundColor(QColor(255,100,200));
	semanageEditLineEdit6->setText("s0");
	semanageEditLineEdit6->setPaletteBackgroundColor(QColor(255,100,200));
	addButton = new QPushButton(tr("Add this user"), this);
	addButton->setPaletteBackgroundColor(QColor(200,157,100));
	connect(addButton, SIGNAL(clicked()), this, SLOT(add_button_clicked()));

	semanageEditLabel3 = new QLabel(tr("Delete Unix user's mapping to SELinux user(Unix user's name):"), this );
	semanageEditLineEdit3 = new QLineEdit( this );
	semanageEditLineEdit3->setText("");
	semanageEditLineEdit3->setPaletteBackgroundColor(QColor(255,100,200));
	deleteButton = new QPushButton(tr("Delete this user"), this);
	deleteButton->setPaletteBackgroundColor(QColor(200,157,100));
	connect(deleteButton, SIGNAL(clicked()), this, SLOT(delete_button_clicked()));

	semanageEditLabel4 = new QLabel(tr("Modify Unix user:"), this );
	semanageEditLabel5 = new QLabel(tr("as a SELinux user:"), this );
	semanageEditLabel7 = new QLabel(tr("range:"), this );
	semanageEditLineEdit4 = new QLineEdit( this );
	semanageEditLineEdit5 = new QLineEdit( this );
	semanageEditLineEdit7 = new QLineEdit( this );
	semanageEditLineEdit4->setText("");
	semanageEditLineEdit4->setPaletteBackgroundColor(QColor(255,100,200));
	semanageEditLineEdit5->setText("");
	semanageEditLineEdit5->setPaletteBackgroundColor(QColor(255,100,200));
	semanageEditLineEdit7->setText("s0");
	semanageEditLineEdit7->setPaletteBackgroundColor(QColor(255,100,200));
	modifyButton = new QPushButton(tr("Modify this user"), this);
	modifyButton->setPaletteBackgroundColor(QColor(200,157,100));
	connect(modifyButton, SIGNAL(clicked()), this, SLOT(modify_button_clicked()));

	closeButton = new QPushButton(tr("close"), this);
	//closing process button
	connect(closeButton, SIGNAL(clicked()), this, SLOT(close()));
	closeButton->setDefault(true);

	//set textEdit smanage such and such -l
	semanage_core_base_login_process();

	mainLayout = new Q3VBoxLayout(this);
	mainLayout->setMargin(11);

	upperLayout = new Q3VBoxLayout;
	upperLayout->addWidget(textEdit1);

	middleLayout = new Q3VBoxLayout;
	leftLayout = new Q3HBoxLayout;
	rightLayout = new Q3HBoxLayout;
	thirdLayout = new Q3HBoxLayout;
	
	leftLayout->addWidget(semanageEditLabel);
	leftLayout->addWidget(semanageEditLineEdit);
	leftLayout->addWidget(semanageEditLabel2);
	leftLayout->addWidget(semanageEditLineEdit2);
	leftLayout->addWidget(semanageEditLabel6);
	leftLayout->addWidget(semanageEditLineEdit6);
	leftLayout->addWidget(addButton);
	rightLayout->addWidget(semanageEditLabel3);
	rightLayout->addWidget(semanageEditLineEdit3);
	rightLayout->addWidget(deleteButton);
	thirdLayout->addWidget(semanageEditLabel4);
	thirdLayout->addWidget(semanageEditLineEdit4);
	thirdLayout->addWidget(semanageEditLabel5);
	thirdLayout->addWidget(semanageEditLineEdit5);
	thirdLayout->addWidget(semanageEditLabel7);
	thirdLayout->addWidget(semanageEditLineEdit7);
	thirdLayout->addWidget(modifyButton);

	middleLayout->addLayout(leftLayout);
	middleLayout->addLayout(rightLayout);
	middleLayout->addLayout(thirdLayout);

	footLayout = new Q3HBoxLayout;
	footLayout->addStretch();
	footLayout->addWidget(closeButton);

	mainLayout->addLayout(upperLayout);
	mainLayout->addLayout(middleLayout);
	mainLayout->addLayout(footLayout);
	resize(900,600);
}

/*signal and slot should have same argument pattern so I had to pass to another slot*/
void SemanageCoreLoginProcess::add_button_clicked()
{
	semanageEditLineEdit_str = semanageEditLineEdit->text();
	semanageEditLineEdit2_str = semanageEditLineEdit2->text();
	semanageEditLineEdit6_str = semanageEditLineEdit6->text();
	add_button_clicked_process(semanageEditLineEdit_str,semanageEditLineEdit2_str,semanageEditLineEdit6_str);
}
/*signal and slot should have same argument pattern so I had to pass to another slot*/
void SemanageCoreLoginProcess::delete_button_clicked()
{
	semanageEditLineEdit3_str = semanageEditLineEdit3->text();
	delete_button_clicked_process(semanageEditLineEdit3_str);
}
/*signal and slot should have same argument pattern so I had to pass to another slot*/
void SemanageCoreLoginProcess::modify_button_clicked()
{
	semanageEditLineEdit4_str = semanageEditLineEdit4->text();
	semanageEditLineEdit5_str = semanageEditLineEdit5->text();
	semanageEditLineEdit7_str = semanageEditLineEdit7->text();
	modify_button_clicked_process(semanageEditLineEdit4_str,semanageEditLineEdit5_str,semanageEditLineEdit7_str);
}

void SemanageCoreLoginProcess::add_button_clicked_process(QString semanageEditLineEdit_str, QString semanageEditLineEdit2_str, QString semanageEditLineEdit6_str)
{
	semanageEditLineEdit_str_pp = "semanage login -a -s " + semanageEditLineEdit2_str + " -r " + semanageEditLineEdit6_str + " " + semanageEditLineEdit_str;
        #define PWD_BUF 8600
        const char* make_module_file="/usr/share/segatex/semanage/add_loggedin";
        ofstream os_add;
        os_add.open(make_module_file);
        if(os_add){
                FILE *read_fp;
                #define SIZE_TMP 8600
                char buffer[SIZE_TMP];
                int chars_read;
                memset(buffer, '\0', sizeof(buffer));
                read_fp = popen(semanageEditLineEdit_str_pp, "r");
                if(read_fp != NULL){
                        chars_read = fread(buffer, sizeof(char), SIZE_TMP, read_fp);
                        while(chars_read>0){
                                buffer[chars_read -1] = '\0';
                                //os << "Reading:-" << endl;
                                os_add << buffer << endl;
                                chars_read= fread(buffer, sizeof(char), SIZE_TMP, read_fp);
                        }
                        pclose(read_fp);
                }
        }
	os_add.close();
	//set textEdit semanage -l
	semanage_core_base_login_process();
	//outputfile_str_common2 = make_module_file;
}

void SemanageCoreLoginProcess::delete_button_clicked_process(QString semanageEditLineEdit3_str)
{
	semanageEditLineEdit_str_pp = "semanage login -d " + semanageEditLineEdit3_str;
        #define PWD_BUF 8600
        const char* make_module_file="/usr/share/segatex/semanage/delete_loggedin";
        ofstream os_delete;
        os_delete.open(make_module_file);
        if(os_delete){
                FILE *read_fp;
                #define SIZE_TMP 8600
                char buffer[SIZE_TMP];
                int chars_read;
                memset(buffer, '\0', sizeof(buffer));
                read_fp = popen(semanageEditLineEdit_str_pp, "r");
                if(read_fp != NULL){
                        chars_read = fread(buffer, sizeof(char), SIZE_TMP, read_fp);
                        while(chars_read>0){
                                buffer[chars_read -1] = '\0';
                                //os << "Reading:-" << endl;
                                os_delete << buffer << endl;
                                chars_read= fread(buffer, sizeof(char), SIZE_TMP, read_fp);
                        }
                        pclose(read_fp);
                }
        }
	os_delete.close();
	//set textEdit semanage -l
	semanage_core_base_login_process();
}

void SemanageCoreLoginProcess::modify_button_clicked_process(QString semanageEditLineEdit4_str, QString semanageEditLineEdit5_str, QString semanageEditLineEdit7_str)
{
	semanageEditLineEdit_str_pp = "semanage login -m -s " + semanageEditLineEdit5_str + " -r " + semanageEditLineEdit7_str + " " + semanageEditLineEdit4_str;
        #define PWD_BUF 8600
        const char* make_module_file="/usr/share/segatex/semanage/modify_loggedin";
        ofstream os_modify;
        os_modify.open(make_module_file);
        if(os_modify){
                FILE *read_fp;
                #define SIZE_TMP 8600
                char buffer[SIZE_TMP];
                int chars_read;
                memset(buffer, '\0', sizeof(buffer));
                read_fp = popen(semanageEditLineEdit_str_pp, "r");
                if(read_fp != NULL){
                        chars_read = fread(buffer, sizeof(char), SIZE_TMP, read_fp);
                        while(chars_read>0){
                                buffer[chars_read -1] = '\0';
                                //os << "Reading:-" << endl;
                                os_modify << buffer << endl;
                                chars_read= fread(buffer, sizeof(char), SIZE_TMP, read_fp);
                        }
                        pclose(read_fp);
                }
        }
	os_modify.close();
	//set textEdit semanage -l
	semanage_core_base_login_process();
}

// {boolean|login|user|port|interface|fcontext|translation}

void SemanageCoreLoginProcess::semanage_core_base_login_process()
{
        #define PWD_BUF 8600
        const char* semanage_login_list_file="/usr/share/segatex/semanage/1_login";
        ofstream os;
        os.open(semanage_login_list_file);
        if(os){
                FILE *read_fp;
                #define SIZE_TMP 8600
                char buffer[SIZE_TMP];
                int chars_read;
                memset(buffer, '\0', sizeof(buffer));

                read_fp = popen("/usr/sbin/semanage login -l", "r");
                if(read_fp != NULL){
                        chars_read = fread(buffer, sizeof(char), SIZE_TMP, read_fp);
                        while(chars_read>0){
                                buffer[chars_read -1] = '\0';
                                //os << "Reading:-" << endl;
                                os << buffer;
                                chars_read= fread(buffer, sizeof(char), SIZE_TMP, read_fp);
			}
			pclose(read_fp);
                }
        }
	os.close();
	//outputfile_str_common = "login_list";

        const char* semanage_user_list_file="/usr/share/segatex/semanage/2_login";
        ofstream os2;
        os2.open(semanage_user_list_file);
        if(os2){
                FILE *read_fp;
                #define SIZE_TMP 8600
                char buffer[SIZE_TMP];
                int chars_read;
                memset(buffer, '\0', sizeof(buffer));
                read_fp = popen("export LANG=C;/usr/sbin/semanage user -l", "r");
                if(read_fp != NULL){
                        chars_read = fread(buffer, sizeof(char), SIZE_TMP, read_fp);
                        while(chars_read>0){
                                buffer[chars_read -1] = '\0';
                                //os << "Reading:-" << endl;
                                os2 << buffer;
                                chars_read= fread(buffer, sizeof(char), SIZE_TMP, read_fp);
                        }
                        pclose(read_fp);
                }
        }
	os2.close();

        const char* semanage_etc_passwd_list_file="/usr/share/segatex/semanage/3_login";
        ofstream os3;
        os3.open(semanage_etc_passwd_list_file);
        if(os3){
                FILE *read_fp;
                #define SIZE_TMP 8600
                char buffer[SIZE_TMP];
                int chars_read;
                memset(buffer, '\0', sizeof(buffer));
                read_fp = popen("cat /etc/passwd", "r");
                if(read_fp != NULL){
                        chars_read = fread(buffer, sizeof(char), SIZE_TMP, read_fp);
                        while(chars_read>0){
                                buffer[chars_read -1] = '\0';
                                //os << "Reading:-" << endl;
                                os3 << buffer;
                                chars_read= fread(buffer, sizeof(char), SIZE_TMP, read_fp);
                        }
                        pclose(read_fp);
                }
        }
	os3.close();

	readFromOutputFile();

}

//this slot should be called from above slot
void SemanageCoreLoginProcess::readFromOutputFile()
{
	/////////////////////////////////////////////////////////////
	path = "/usr/share/segatex/semanage";
	/////////////////////////////////////////////////////////////
	forward_slash = "/";
	dir.setPath(path);
	dir_name = dir.absPath();
	/////////////////////////////////////////////////////////////
	dir.setFilter( QDir::Files );
        dir.setSorting( QDir::Name );
	files = dir.entryList("*login");
	/////////////////////////////////////////////////////////////
	it_d = files.begin();
	int order_x;
	order_x = 1;
	//first clear it all, unless double the file.
	textEdit1->clear();
		while(it_d != files.end()){
			name = *it_d;
			file_interface_name = dir_name + forward_slash + name;
			QFile file( file_interface_name );
			QRegExp rx_nologin("nologin");
			QRegExp rx_shutdown("shutdown");
			QRegExp rx_halt("halt");
			QRegExp rx_news("news");
			QRegExp rx_false("false");
			QRegExp rx_sync("sync");
			if ( file.open( QIODevice::ReadOnly ) ) {
				Q3TextStream stream( &file );
				////////////////////////////////////////////
				int i,j,k,l,m,n;	
				if(order_x == 1)
					textEdit1->append("#########login list#########");
					textEdit1->append("");
				if(order_x == 2)
					textEdit1->append("#########user list#########");
					textEdit1->append("");
				if(order_x == 3)
					textEdit1->append("#########etc passwd list#########");
					textEdit1->append("");
				while ( !stream.atEnd() ) {
					line_analized = stream.readLine(); // line of text excluding '\n'
					//buttons.push_back(line_analized);
					i = line_analized.find( rx_nologin, 0);
					j = line_analized.find( rx_shutdown, 0);
					k = line_analized.find( rx_halt, 0);
					l = line_analized.find( rx_news, 0);
					m = line_analized.find( rx_false, 0);
					n = line_analized.find( rx_sync, 0);
                                        if((i != -1)||(j != -1)||(k != -1)||(l != -1)||(m != -1)||(n != -1)){
						//do nothing
					}else{
						textEdit1->append(line_analized);
					}
				}
				textEdit1->setCursorPosition(0,0);
				file.close();
				order_x++;
				++it_d;
			}else{
				//do nothing
			}
		}
}
