/*
 * segatex SELinux tool.
 *
 * Copyright (C) 2007-2013 Shintaro Fujiwara 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * */

#include <qmessagebox.h>

#include "segatex_getseuserbyname.h"
#include "segatex_getseuserbyname_process.h"


SegatexGetseuserbynameProcess::SegatexGetseuserbynameProcess(QWidget *parent, const char *name): QDialog(parent, name)
{
	// do nothing
}
/* returns selinux user and level from linuxuser*/
int SegatexGetseuserbynameProcess::segatex_getseuserbyname_base_process(QString linuxuser_string)
{
	if(linuxuser_string==""){
		QMessageBox::information(this,tr("segatex alert"),tr("Fill in Linux user !"));
		return 0;
	}
	const char *linuxuser;
	linuxuser = linuxuser_string;
	linuxuser_str = linuxuser;
	seuser_str = "";
	level_str = "";
	char *seuser;
	char *level;
	seuser = NULL;
	level = NULL;
	int i;
	i = getseuserbyname(linuxuser,&seuser,&level);
	if(i < 0){
		QMessageBox::information(this,tr("segatex alert"),tr("getseuserbyname got an error !"));
		return 0;
	}
	
	seuser_str = *&seuser;
	level_str = *&level;

	QMessageBox::information(this,tr(""),tr("Linux user " + linuxuser_str + "\nis mapped to SELinux user\n "
					 + seuser_str + "\nand level is\n " + level_str + " !"));

	free(seuser);
	free(level);

        return 0;
}
