/*
 * segatex SELinux tool.
 *
 * Copyright (C) 2007-2013 Shintaro Fujiwara 
 * shintaro.fujiwara@gmail.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * */
#include <qmessagebox.h>

#include "downloader.h"

#include <iostream>
using namespace std;


Downloader::Downloader(const QUrl &url, QString version)
{

    if (url.scheme() != "ftp") {
        QMessageBox::warning(0, tr("Downloader"),
                             tr("Protocol must be 'ftp'."));
        emit finished();
        return;
    }

    int port = 21;
    if (url.port() != -1)
        port = url.port();

    connect(&ftp, SIGNAL(listInfo(const QUrlInfo &)),
            this, SLOT(listInfo(const QUrlInfo &)));

	ftp.connectToHost(url.host(), port);
	ftp.login();
	if(url.host() == "ftp.riken.jp"){
		cout << "test" << endl;
		if(version == "new4")
			ftp.cd("Linux/fedora/releases/16/Fedora/i386/iso");
		if(version == "new3")
			ftp.cd("Linux/fedora/releases/17/Fedora/i386/iso");
		if(version == "new2")
			ftp.cd("Linux/fedora/releases/18/Fedora/i386/iso");
		if(version == "new")
			ftp.cd("Linux/fedora/releases/19/Fedora/i386/iso");
	}
	if(url.host() == "mirrors.kernel.org"){
		if(version == "new4")
			ftp.cd("fedora/releases/16/Fedora/i386/iso");
		if(version == "new3")
			ftp.cd("fedora/releases/17/Fedora/i386/iso/");
		if(version == "new2")
			ftp.cd("fedora/releases/18/Fedora/i386/iso/");
		if(version == "new")
			ftp.cd("fedora/releases/19/Fedora/i386/iso/");
	}
	if(url.host() == "ftp.uni-kl.de"){
		if(version == "new4")
			ftp.cd("pub/linux/fedora/linux/releases/16/Fedora/i386/iso");
		if(version == "new3")
			ftp.cd("pub/linux/fedora/linux/releases/17/Fedora/i386/iso");
		if(version == "new2")
			ftp.cd("pub/linux/fedora/linux/releases/18/Fedora/i386/iso");
		if(version == "new")
			ftp.cd("pub/linux/fedora/linux/releases/19/Fedora/i386/iso");
	}
	if(url.host() == "ftp.lip6.fr"){
		if(version == "new4")
			ftp.cd("pub/linux/distributions/fedora/releases/16/Fedora/i386/iso");
		if(version == "new3")
			ftp.cd("pub/linux/distributions/fedora/releases/17/Fedora/i386/iso");
		if(version == "new2")
			ftp.cd("pub/linux/distributions/fedora/releases/18/Fedora/i386/iso");
		if(version == "new")
			ftp.cd("pub/linux/distributions/fedora/releases/19/Fedora/i386/iso");
	}
	if(url.host() == "mirror.aarnet.edu.au"){
		if(version == "new4")
			ftp.cd("pub/fedora/linux/releases/16/Fedora/i386/iso");
		if(version == "new3")
			ftp.cd("pub/fedora/linux/releases/17/Fedora/i386/iso");
		if(version == "new2")
			ftp.cd("pub/fedora/linux/releases/18/Fedora/i386/iso");
		if(version == "new")
			ftp.cd("pub/fedora/linux/releases/19/Fedora/i386/iso");
	}
	ftp.list();
}

void Downloader::listInfo(const QUrlInfo &urlInfo)
{
    if (urlInfo.isFile() && urlInfo.isReadable()) {
        QFile *file = new QFile(urlInfo.name());
        if (!file->open(QIODevice::WriteOnly)) {
            QMessageBox::warning(0, tr("Downloader"),
                                 tr("Error: Cannot open file "
                                    "%1:\n%2.")
                                 .arg(file->fileName())
                                 .arg(file->errorString()));
            emit finished();
            return;
        }

        ftp.get(urlInfo.name(), file);
        openedFiles.push_back(file);
   }
}

void Downloader::ftpDone(bool error)
{
    if (error)
        QMessageBox::warning(0, tr("Downloader"),
                             tr("Error: %1.")
                             .arg(ftp.errorString()));

    for (int i = 0; i < (int)openedFiles.size(); ++i)
        delete openedFiles[i];
    emit finished();
}
