#
# segatex SELinux tool.
#
# Copyright (C) 2007-2013 Shintaro Fujiwara 
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#

#!/bin/sh 

ERROR=0
LINE=
LINE2=
SOURCEFILE=
BLANK=""
TAB="	"

FILELISTPREPARE="./sqlrefpolicy_prepare_filelist_prepare.txt"
FILELIST="./sqlrefpolicy_prepare_filelist.txt"
INTERFACENAME_FILE="../if_file_name.txt"
NUM_FILE_CORE="./num.txt"
NUM_FILE="../num.txt"


SQLREFPOLICY_PREPARE(){
	touch "$NUM_FILE_CORE"
	echo '0' > "$NUM_FILE_CORE"

	find . \( -type f -name "*.if" \) -print | sort > $FILELISTPREPARE && awk -F/ '{print $2}' $FILELISTPREPARE > $FILELIST
	IFS=
	while read LINE
	do
		SOURCEFILE="$LINE"
		if [ ! -r "$SOURCEFILE" ]; then
			echo "Cannot find file $SOURCEFILE" 1>&2
			ERROR=1
		else
			INTERFACE_NAME=`echo $LINE | awk -F. '{print $1}'`
		fi
		NUM2=`expr $NUM2 + 1`
		echo $NUM2","$CHECKDIC","$INTERFACE_NAME
		echo $NUM2","$CHECKDIC","$INTERFACE_NAME >> $INTERFACENAME_FILE
	done < "$FILELIST"
}

cd /usr/share/segatex/raw_if_files
if [ -r "/usr/share/segatex/raw_if_files/if_file_name.txt" ]; then
	unlink /usr/share/segatex/raw_if_files/if_file_name.txt
fi
### Get directory name under current directory and put into var.
DICNAME=`find ./ -type d -name "*" | awk -F/ '{ print $2 }' | sort`
### Do something in every directory.

NUM2=0

for CHECKDIC in $DICNAME
do
	(\
	cd $CHECKDIC; \
	echo ""
	echo Make a list of .if files in $CHECKDIC directory !; \
	echo ""
	if [ -r "$FILELISTPREPARE" ]; then
		unlink $FILELISTPREPARE
	fi
	if [ -r "$FILELIST" ]; then
		unlink $FILELIST
	fi
	if [ -r "$NUM_FILE_CORE" ]; then
		unlink $NUM_FILE_CORE
	fi
	SQLREFPOLICY_PREPARE; \
	unlink $FILELISTPREPARE
	unlink $FILELIST
	unlink $NUM_FILE_CORE
	)
done

echo "Making a list of .if files Successfully finished."
echo "/usr/share/segatex/raw_if_files/if_file_name.txt was made!"

exit $ERROR
