/*
 * segatex SELinux tool.
 *
 * Copyright (C) 2007-2013 Shintaro Fujiwara 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * */

#ifndef EDITOR_H
#define EDITOR_H

#include <q3textedit.h>
//Added by qt3to4:
#include <QCloseEvent>

class Editor : public Q3TextEdit
{
	Q_OBJECT
public:
	Editor(QWidget *parent = 0, const char *name = 0);

	void newFile();
	bool open();
	bool openFile(const QString &fileName);
	bool save();
	bool remove();
	bool saveAs();
	QSize sizeHint() const;

signals:
	void message(const QString &fileName, int delay);

protected:
	void closeEvent(QCloseEvent *event);

private:
	bool maybeSave();
	void saveFile(const QString &fileName);
	void setCurrentFile(const QString &fileName);
	QString strippedName(const QString &fullFileName);
	bool readFile(const QString &fileName);
	bool writeFile(const QString &fileName);
	bool removeFile(const QString &fileName);

	QString curFile;
	bool isUntitled;
	QString fileFilters;
};

#endif
