/*
 * segatex SELinux tool.
 *
 * Copyright (C) 2007-2013 Shintaro Fujiwara 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * */

#include <qlayout.h>
#include <qpushbutton.h>
#include <qlineedit.h>
#include <q3textedit.h>
#include <qmessagebox.h>
#include <qworkspace.h>
//Added by qt3to4:
#include <Q3HBoxLayout>
#include <Q3VBoxLayout>

#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <fstream>

#include "downloader.h"

#include <iostream>
using namespace std;


//default constructor
Downloader::Downloader(QWidget *parent, const char *name): QDialog(parent, name)
{
	setCaption(tr("Download fedora"));

        optionButtonGroup = new Q3ButtonGroup(this);
        optionButtonGroup->resize( 400, 50 );
        usRadioButton = new QRadioButton(tr("us ftp site (mirrors.kernel.org)"), optionButtonGroup);
        usRadioButton->setGeometry( 10, 10, 320, 20 );
        jpRadioButton = new QRadioButton(tr("jp ftp site (ftp.riken.jp)"), optionButtonGroup);
        jpRadioButton->setGeometry( 10, 30, 320, 20 );
        deRadioButton = new QRadioButton(tr("german ftp site (ftp.uni-kl.de)"), optionButtonGroup);
        deRadioButton->setGeometry( 10, 50, 320, 20 );
        frRadioButton = new QRadioButton(tr("french ftp site (ftp.lip6.fr)"), optionButtonGroup);
        frRadioButton->setGeometry( 10, 70, 320, 20 );
        auRadioButton = new QRadioButton(tr("Australian ftp site (mirror.aarnet.edu.au)"), optionButtonGroup);
        auRadioButton->setGeometry( 10, 90, 320, 20 );
	usRadioButton->setChecked(true);

        fedoraVersionButtonGroup = new Q3ButtonGroup(this);
        fedoraVersionButtonGroup->resize( 150, 70 );
        new4RadioButton = new QRadioButton(tr("version 15"), fedoraVersionButtonGroup);
        new4RadioButton->setGeometry( 10, 10, 300, 20 );
        new3RadioButton = new QRadioButton(tr("version 16"), fedoraVersionButtonGroup);
        new3RadioButton->setGeometry( 10, 30, 300, 20 );
        new2RadioButton = new QRadioButton(tr("version 17"), fedoraVersionButtonGroup);
        new2RadioButton->setGeometry( 10, 50, 300, 20 );
        newRadioButton = new QRadioButton(tr("version 18"), fedoraVersionButtonGroup);
        newRadioButton->setGeometry( 10, 70, 300, 20 );

	newRadioButton->setChecked(true);

	downloadButton = new QPushButton(tr("Download Fedora"), this);
	downloadButton->setPaletteBackgroundColor(QColor(100,200,200));

	connect(downloadButton, SIGNAL(clicked()), this, SLOT(download_button_clicked()));

	closeButton = new QPushButton(tr("close"), this);
	//closing process button
	connect(closeButton, SIGNAL(clicked()), this, SLOT(close()));
	closeButton->setDefault(true);

	mainLayout = new Q3VBoxLayout(this);
	mainLayout->setMargin(11);

	middleLayout = new Q3VBoxLayout;

	firstLayout = new Q3HBoxLayout;
	secondLayout = new Q3VBoxLayout;
	thirdLayout = new Q3VBoxLayout;

	rightLayout = new Q3HBoxLayout;
	
	secondLayout->addWidget(optionButtonGroup);
	thirdLayout->addWidget(fedoraVersionButtonGroup);
	firstLayout->addLayout(secondLayout);
	firstLayout->addLayout(thirdLayout);

	rightLayout->addWidget(downloadButton);
	rightLayout->addStretch();

	middleLayout->addLayout(firstLayout);
	middleLayout->addLayout(rightLayout);


	footLayout = new Q3HBoxLayout;
	footLayout->addStretch();
	footLayout->addWidget(closeButton);

	mainLayout->addLayout(middleLayout);
	mainLayout->addLayout(footLayout);
	resize(660,250);
}

void Downloader::download_button_clicked()
{
	Q3Url url_for_fedora("ftp://mirrors.kernel.org");
	if(usRadioButton->isChecked()){
		Q3Url url_for_fedora("ftp://mirrors.kernel.org");
		url_for_fedora.setPort(21);
		mirror = 1;
		if(new4RadioButton->isChecked()){
			version = "new4";
		}
		if(new3RadioButton->isChecked()){
			version = "new3";
		}
		if(new2RadioButton->isChecked()){
			version = "new2";
		}
		if(newRadioButton->isChecked()){
			version = "new";
		}
	}
	if(jpRadioButton->isChecked()){
		Q3Url url_for_fedora("ftp://ftp.riken.jp");
		url_for_fedora.setPort(21);
		mirror = 2;
		if(new4RadioButton->isChecked()){
			version = "new4";
		}
		if(new3RadioButton->isChecked()){
			version = "new3";
		}
		if(new2RadioButton->isChecked()){
			version = "new2";
		}
		if(newRadioButton->isChecked()){
			version = "new";
		}
	}
	if(deRadioButton->isChecked()){
		Q3Url url_for_fedora("ftp://ftp.uni-kl.de");
		url_for_fedora.setPort(21);
		mirror = 2;
		if(new4RadioButton->isChecked()){
			version = "new4";
		}
		if(new3RadioButton->isChecked()){
			version = "new3";
		}
		if(new2RadioButton->isChecked()){
			version = "new2";
		}
		if(newRadioButton->isChecked()){
			version = "new";
		}
	}
	if(frRadioButton->isChecked()){
		Q3Url url_for_fedora("ftp://ftp.lip6.fr");
		url_for_fedora.setPort(21);
		mirror = 2;
		if(new4RadioButton->isChecked()){
			version = "new4";
		}
		if(new3RadioButton->isChecked()){
			version = "new3";
		}
		if(new2RadioButton->isChecked()){
			version = "new2";
		}
		if(newRadioButton->isChecked()){
			version = "new";
		}
	}
	if(auRadioButton->isChecked()){
		Q3Url url_for_fedora("ftp://mirror.aarnet.edu.au");
		url_for_fedora.setPort(21);
		mirror = 2;
		if(new4RadioButton->isChecked()){
			version = "new4";
		}
		if(new3RadioButton->isChecked()){
			version = "new3";
		}
		if(new2RadioButton->isChecked()){
			version = "new2";
		}
		if(newRadioButton->isChecked()){
			version = "new";
		}
	}
	downloader_process(url_for_fedora,version);
}
void Downloader::downloader_process(const Q3Url &url_for_fedora, QString version)
{
	this->setEnabled(false);
	process = new Q3Process(this);
	process->addArgument("/usr/share/segatex/downloader_program");
	process->addArgument(url_for_fedora);
	process->addArgument(version);

	connect(process, SIGNAL(readyReadStdout()),this,SLOT(readFromStdout()));
	connect(process, SIGNAL(readyReadStderr()),this,SLOT(updateOutputTextEdit()));
	connect(process, SIGNAL(processExited()),this,SLOT(processExited()));
	process->start();
	QMessageBox::warning(0, tr("Downloader Fedora"),
				tr("Downloading Fedora in your home directory."));
}
void Downloader::updateOutputTextEdit()
{
	QByteArray data = process->readStderr();
}
void Downloader::readFromStdout()
{
	QByteArray data = process->readStdout();
}
void Downloader::processExited()
{
	if(process->normalExit()){
		QMessageBox::warning(0, tr("Downloader Fedora"),
				     tr("Downloaded files in your home directory."));
		return;
	} else {
		QMessageBox::warning(0, tr("Downloader Fedora"),
				     tr("Downloader Fedora process had an error"));
		return;
	}
	delete process;
	process = 0;
	this->setEnabled(true);
}

