#
# segatex SELinux tool.
#
# Copyright (C) 2007-2013 Shintaro Fujiwara 
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#

#!/bin/sh 

ERROR=0
LINE=
SOURCEFILE=
STARTFILE="../start_file"
INCLUDEIFFILE="../allif_exclude_myself.txt"
M4_ED_FILE="../all_exclude_myself.if"
INCLUDESPTFILE="../allspt.txt"
INCLUDEFILE="include_if"
INCLUDEFILE2="include_if2"
INCLUDEFILE3="include_if3"
BROKENUPPREPAREFILE="broken_up_prepare"
BROKENUPPREPAREFILE2="broken_up_prepare2"
BROKENUPPREPAREFILE3="broken_up_prepare3"
BROKENUPPREPAREFILE4="broken_up_prepare4"
BROKENUPPREPAREFILE5="broken_up_prepare5"
BROKENUPFILE="broken_up"
BROKENUPFILE2="broken_up2"
NEWFILE="prepare"
CSPLITFILE="xx00"
CSPLITFILE2="xx01"
BLANK=""
TAB="	"

FILELISTPREPARE="filelist_prepare.txt"
FILELIST="filelist.txt"
FILELIST_EXCLUDE_MYSELF="filelist_exclude_myself.txt"
ALL_EXCLUDE_MYSELF_CURRENT_DEFINE="all_exclude_myself_current.if_"
ALL_EXCLUDE_MYSELF_CURRENT="all_exclude_myself_current.if_prepare"

NUM=0

BREAK_IF(){
	find . \( -type f -name "*.if" \) -print | sort > $FILELISTPREPARE && awk -F/ '{print $2}' $FILELISTPREPARE > $FILELIST
	IFS=
	while read LINE
	do
		echo "NUM:"$NUM
		###for debug
		#if [ $NUM -gt 0 ]; then
		#	exit 0	
		#fi

			SOURCEFILE="$LINE"
		if [ ! -r "$SOURCEFILE" ]; then
			echo "Cannot find file $SOURCEFILE" 1>&2
			ERROR=1
		else
			#echo ""
			#echo ""
			echo "SOURCEFILE:"$SOURCEFILE

			while read LINE_EXCLUDE
			do 
				if [ "$LINE_EXCLUDE" = "$SOURCEFILE" ]; then
					continue
				fi
					cat "$LINE_EXCLUDE" >> $ALL_EXCLUDE_MYSELF_CURRENT
			done < "$FILELIST"
			################check if this works or not!!###################
			################it should be $5 in /usr/share/segatex/raw_if_files/layer###################
			#NOW_DIR=`pwd | awk -F/ '{print $7}'`
			NOW_DIR=`pwd | awk -F/ '{print $5}'`
			if [ "$NOW_DIR" = "admin" ]; then
				echo "$NOW_DIR"
				cat ../apps/*.if >> $ALL_EXCLUDE_MYSELF_CURRENT
				cat ../contrib/*.if >> $ALL_EXCLUDE_MYSELF_CURRENT
				cat ../kernel/*.if >> $ALL_EXCLUDE_MYSELF_CURRENT
				cat ../roles/*.if >> $ALL_EXCLUDE_MYSELF_CURRENT
				cat ../services/*.if >> $ALL_EXCLUDE_MYSELF_CURRENT
				cat ../system/*.if >> $ALL_EXCLUDE_MYSELF_CURRENT
			fi
			if [ "$NOW_DIR" = "apps" ]; then
				echo "$NOW_DIR"
				cat ../admin/*.if >> $ALL_EXCLUDE_MYSELF_CURRENT
				cat ../contrib/*.if >> $ALL_EXCLUDE_MYSELF_CURRENT
				cat ../kernel/*.if >> $ALL_EXCLUDE_MYSELF_CURRENT
				cat ../roles/*.if >> $ALL_EXCLUDE_MYSELF_CURRENT
				cat ../services/*.if >> $ALL_EXCLUDE_MYSELF_CURRENT
				cat ../system/*.if >> $ALL_EXCLUDE_MYSELF_CURRENT
			fi
			if [ "$NOW_DIR" = "contrib" ]; then
				echo "$NOW_DIR"
				cat ../admin/*.if >> $ALL_EXCLUDE_MYSELF_CURRENT
				cat ../apps/*.if >> $ALL_EXCLUDE_MYSELF_CURRENT
				cat ../kernel/*.if >> $ALL_EXCLUDE_MYSELF_CURRENT
				cat ../roles/*.if >> $ALL_EXCLUDE_MYSELF_CURRENT
				cat ../services/*.if >> $ALL_EXCLUDE_MYSELF_CURRENT
				cat ../system/*.if >> $ALL_EXCLUDE_MYSELF_CURRENT
			fi
			if [ "$NOW_DIR" = "kernel" ]; then
				echo "$NOW_DIR"
				cat ../admin/*.if >> $ALL_EXCLUDE_MYSELF_CURRENT
				cat ../apps/*.if >> $ALL_EXCLUDE_MYSELF_CURRENT
				cat ../contrib/*.if >> $ALL_EXCLUDE_MYSELF_CURRENT
				cat ../roles/*.if >> $ALL_EXCLUDE_MYSELF_CURRENT
				cat ../services/*.if >> $ALL_EXCLUDE_MYSELF_CURRENT
				cat ../system/*.if >> $ALL_EXCLUDE_MYSELF_CURRENT
			fi
			if [ "$NOW_DIR" = "roles" ]; then
				echo "$NOW_DIR"
				cat ../admin/*.if >> $ALL_EXCLUDE_MYSELF_CURRENT
				cat ../apps/*.if >> $ALL_EXCLUDE_MYSELF_CURRENT
				cat ../contrib/*.if >> $ALL_EXCLUDE_MYSELF_CURRENT
				cat ../kernel/*.if >> $ALL_EXCLUDE_MYSELF_CURRENT
				cat ../services/*.if >> $ALL_EXCLUDE_MYSELF_CURRENT
				cat ../system/*.if >> $ALL_EXCLUDE_MYSELF_CURRENT
			fi
			if [ "$NOW_DIR" = "services" ]; then
				echo "$NOW_DIR"
				cat ../admin/*.if >> $ALL_EXCLUDE_MYSELF_CURRENT
				cat ../apps/*.if >> $ALL_EXCLUDE_MYSELF_CURRENT
				cat ../contrib/*.if >> $ALL_EXCLUDE_MYSELF_CURRENT
				cat ../kernel/*.if >> $ALL_EXCLUDE_MYSELF_CURRENT
				cat ../roles/*.if >> $ALL_EXCLUDE_MYSELF_CURRENT
				cat ../system/*.if >> $ALL_EXCLUDE_MYSELF_CURRENT
			fi
			if [ "$NOW_DIR" = "system" ]; then
				echo "$NOW_DIR"
				cat ../admin/*.if >> $ALL_EXCLUDE_MYSELF_CURRENT
				cat ../apps/*.if >> $ALL_EXCLUDE_MYSELF_CURRENT
				cat ../contrib/*.if >> $ALL_EXCLUDE_MYSELF_CURRENT
				cat ../kernel/*.if >> $ALL_EXCLUDE_MYSELF_CURRENT
				cat ../roles/*.if >> $ALL_EXCLUDE_MYSELF_CURRENT
				cat ../services/*.if >> $ALL_EXCLUDE_MYSELF_CURRENT
			fi

			####interface to define
			sed 's/interface/define/g' $ALL_EXCLUDE_MYSELF_CURRENT > $ALL_EXCLUDE_MYSELF_CURRENT_DEFINE
	########### write include(`all.if') first line of the source file#######################################
			sed 's/interface(`//g' $SOURCEFILE > $SOURCEFILE"2"
			sed 's/,`//g' $SOURCEFILE"2" > $SOURCEFILE"3"
			cat ../start_file $SOURCEFILE"3" > $SOURCEFILE"4"
			cat $INCLUDEIFFILE $SOURCEFILE"4" > $INCLUDEFILE
			####template to define
			m4 $INCLUDEFILE > $BROKENUPPREPAREFILE2
	########### write include(`all.spt') first line of the brokenupprepare file number#######################################
			cat $INCLUDESPTFILE $BROKENUPPREPAREFILE2 > $BROKENUPPREPAREFILE3
			sed 's/gen_require/temporary_req/g' $BROKENUPPREPAREFILE3 > $BROKENUPPREPAREFILE4
			m4 $BROKENUPPREPAREFILE4 > $BROKENUPFILE
			####this is done
			#echo "Success making "$BROKENUPFILE
			#echo "NOW MAKING RAWFILE PLEASE WAIT!"
	########### make broken .te_raw#######################################
			COMP_STR="## START"
			csplit $BROKENUPFILE /^$COMP_STR/ {*}
			sed 's/## START//g' xx01 > $NEWFILE
	########### eliminate blank lines#######################################
			SOURCEFILE_NEW=$SOURCEFILE"_raw"
			SOURCEFILE_NEW_PRE=$SOURCEFILE_NEW"_pre"
			grep [a-zA-Z#{}\)] $NEWFILE > $SOURCEFILE_NEW_PRE
			sed 's/temporary_req/gen_require/g' $SOURCEFILE_NEW_PRE > $SOURCEFILE_NEW
			echo "Made "$SOURCEFILE_NEW
		fi

		unlink $SOURCEFILE"2"
		unlink $SOURCEFILE"3"
		unlink $SOURCEFILE"4"
		unlink $INCLUDEFILE
		unlink $BROKENUPPREPAREFILE2
		unlink $BROKENUPPREPAREFILE3
		unlink $BROKENUPPREPAREFILE4
		unlink $BROKENUPFILE
		unlink $NEWFILE
		unlink $SOURCEFILE_NEW_PRE
		unlink $CSPLITFILE
		unlink $CSPLITFILE2
		#if [ $NUM = 0 ]; then
			unlink $ALL_EXCLUDE_MYSELF_CURRENT
			unlink $ALL_EXCLUDE_MYSELF_CURRENT_DEFINE
		#fi

		NUM=`expr $NUM + 1`

	done < "$FILELIST"

	unlink $FILELISTPREPARE
	unlink $FILELIST
}

cd /usr/share/segatex/raw_if_files

### Get directory name under current directory and put into var.
DICNAME=`find ./ -type d -name "*" | awk -F/ '{ print $2 }' | sort`
### Do something in every directory.

for CHECKDIC in $DICNAME
do
	(\
	cd $CHECKDIC; \
	echo ""
	echo Breaking .if files in $CHECKDIC directory !; \
	echo ""
	BREAK_IF; \
	)
done

echo "Breaking .if scripts Successfully finished."
echo ""
echo "You can see raw .if files in /usr/share/segatex/raw_if_files/"layers" as if_raw files."
echo "You can understand fully the meaning of interfaces of SELinx."


exit $ERROR
