/*
 * segatex SELinux tool.
 *
 * Copyright (C) 2007-2009 Shintaro Fujiwara 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * */

#include <qlayout.h>
#include <qpushbutton.h>
#include <qlineedit.h>
#include <q3textedit.h>
//Added by qt3to4:
#include <Q3HBoxLayout>
#include <QLabel>
#include <Q3VBoxLayout>

#include "segatex_getorderedcontextlist.h"
#include "segatex_getorderedcontextlist_process.h"


//default constructor
SegatexGetorderedcontextlist::SegatexGetorderedcontextlist(QWidget *parent, const char *name): QDialog(parent, name)
{
	setCaption(tr("Getorderedcontextlist"));

	getorderedcontextlistLabel = new QLabel(tr("segatex can have context of... \n" 
	"Try cp /usr/share/segatex/utils/getorderedcontextlist /root\n"
	" cd /root;./getorderedcontextlist if you want to know root can do.\n"
	"seuser such as system_u,unconfined_u or you name it"), this );
	getorderedcontextlistLabel2 = new QLabel(tr("Fill in seuser."), this );

	getorderedcontextlistLineEdit = new QLineEdit( this );
	getorderedcontextlistLineEdit->setText("");
	getorderedcontextlistLineEdit->setPaletteBackgroundColor(QColor(255,100,200));
	getButton = new QPushButton(tr("getorderedcontextlist of this seuser"), this);
	getButton->setPaletteBackgroundColor(QColor(200,157,100));
	connect(getButton, SIGNAL(clicked()), this, SLOT(get_button_clicked()));
	closeButton = new QPushButton(tr("close"), this);
	connect(closeButton, SIGNAL(clicked()), this, SLOT(close()));
	closeButton->setDefault(true);

	mainLayout = new Q3VBoxLayout(this);
	leftLayout = new Q3HBoxLayout(this);
	rightLayout = new Q3HBoxLayout(this);

	mainLayout->setMargin(1);

	mainLayout->addWidget(getorderedcontextlistLabel);
	//leftLayout->addStretch(1);
	leftLayout->addWidget(getorderedcontextlistLabel2);
	leftLayout->addWidget(getorderedcontextlistLineEdit);
	rightLayout->addStretch(1);
	rightLayout->addWidget(getButton);
	rightLayout->addWidget(closeButton);
	mainLayout->addLayout(leftLayout);
	mainLayout->addLayout(rightLayout);
	//resize(300,300);
	segatex_getorderedcontextlist_process = 0;
}

/*signal and slot should have same argument pattern so I had to pass to another slot*/
void SegatexGetorderedcontextlist::get_button_clicked()
{
	pre_str = "Getorderedcontextlist of ";
	getorderedcontextlistLineEdit_str = getorderedcontextlistLineEdit->text();
	//const char *_seuser;
	//_seuser = getorderedcontextlistLineEdit_str;
	//getorderedcontextlist_caption = pre_str + getorderedcontextlistLineEdit_str;
	getorderedcontextlist_caption = getorderedcontextlistLineEdit_str;

	//segatex_getorderedcontextlist_process = new SegatexGetorderedcontextlistProcess(this,_seuser);
	segatex_getorderedcontextlist_process = new SegatexGetorderedcontextlistProcess(this);
	segatex_getorderedcontextlist_process->setCaption(tr(getorderedcontextlist_caption));
	segatex_getorderedcontextlist_process->show();
	segatex_getorderedcontextlist_process->raise();
	segatex_getorderedcontextlist_process->setActiveWindow();
	segatex_getorderedcontextlist_process->segatex_getorderedcontextlist_base_process(getorderedcontextlistLineEdit_str);
}
