/*
 * segatex SELinux tool.
 *
 * Copyright (C) 2007-2009 Shintaro Fujiwara 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * */

#include <qlayout.h>
#include <qradiobutton.h>
#include <qmessagebox.h>
#include <qpushbutton.h>
#include <q3buttongroup.h>
#include <q3textedit.h>
//Added by qt3to4:
#include <Q3VBoxLayout>
#include <Q3HBoxLayout>

#include "segatex_apply.h"
#include "mainwindow.h"

//#include <iostream>
//using namespace std;

//default constructor
SegatexApply::SegatexApply(QWidget *parent, const char *name): QDialog(parent, name)
{
	setCaption(tr("Apply"));
	agroup = new Q3ButtonGroup( this );
	agroup->resize( 200, 230);
	enforcingRadioButton = new QRadioButton(tr("enforcing"), agroup);
	permissiveRadioButton = new QRadioButton(tr("permissive"),agroup);
	//disabledRadioButton = new QRadioButton(tr("disabled"),agroup);
	applyButton = new QPushButton(tr("&Apply"), this);
	closeButton = new QPushButton(tr("&Close"), this);
	enforcingRadioButton->setChecked(true);
	applyButton->setDefault(true);
	//applyButton->setEnabled(false);

	connect(applyButton, SIGNAL(clicked()), this, SLOT(apply_clicked()));
	connect(closeButton, SIGNAL(clicked()), this, SLOT(close()));

	Q3VBoxLayout *leftLayout = new Q3VBoxLayout;
	leftLayout->addWidget(enforcingRadioButton);
	leftLayout->addWidget(permissiveRadioButton);
	//leftLayout->addWidget(disabledRadioButton);

	Q3VBoxLayout *rightLayout = new Q3VBoxLayout;
	rightLayout->addWidget(applyButton);
	rightLayout->addWidget(closeButton);
	rightLayout->addStretch(1);

	Q3HBoxLayout *mainLayout = new Q3HBoxLayout(this);
	mainLayout->setMargin(11);
	mainLayout->setSpacing(6);
	mainLayout->addLayout(leftLayout);
	mainLayout->addLayout(rightLayout);
}

/*emits signals when apply button is clicked*/
void SegatexApply::apply_clicked()
{
	if(enforcingRadioButton->isOn())
		emit enforcingOn();
	else if(permissiveRadioButton->isOn())
		emit permissiveOn();
	else
		emit disabledOn();
}

int SegatexApply::setenforce_enforcing()
{
	//cout << this << endl;
	return_value = security_setenforce(1);
	if(return_value == 0){
		emit sestateChanged();
		mainWindow = new MainWindow();
		mainWindow->updateSegatexStateIndicator();
		QMessageBox::information(this,tr("Success!"),tr("SELinux is now enforced!"));
		mainWindow->updateSegatexStateIndicator();
	}else
		QMessageBox::warning(this,tr("Failed!"),tr("Could not set SELinux enforcing! Maybe you are not logged in as root?"));

	return return_value;
}

int SegatexApply::setenforce_permissive()
{
	return_value = security_setenforce(0);
	if(return_value == 0){
		emit sestateChanged();
		mainWindow = new MainWindow();
		mainWindow->updateSegatexStateIndicator();
		QMessageBox::information(this,tr("Success!"),tr("SELinux is now permissive!"));
		mainWindow->updateSegatexStateIndicator();
	}else
		QMessageBox::warning(this,tr("Failed!"),tr("Could not set SELinux permissive! Maybe you are not logged in as root?"));

	return return_value;
}

/*
int SegatexApply::setenforce_disabled()
{
	return_value = security_setenforce(-1);
	if(return_value == 0){
		emit sestateChanged();
		mainWindow = new MainWindow();
		mainWindow->updateSegatexStateIndicator();
		QMessageBox::information(this,tr("Success!"),tr("SELinux is now disabled!"));
	}else
		QMessageBox::warning(this,tr("Failed!"),tr("Could not set SELinux disabled! Maybe you are not logged in as root?"));

	return return_value;
}
*/
