/*
 * segatex SELinux tool.
 *
 * Copyright (C) 2007 Shintaro Fujiwara 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * */

#include <qlayout.h>
#include <qcheckbox.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qradiobutton.h>
#include <q3textedit.h>
//Added by qt3to4:
#include <Q3TextStream>
#include <Q3HBoxLayout>
#include <Q3VBoxLayout>

#include "segatex_core2_process.h"

//#include <iostream>
//using namespace std;

//default constructor
SegatexCore2Process::SegatexCore2Process(QWidget *parent, const char *name): QDialog(parent, name)
{
	setCaption(tr("mypolicybysegatex"));
	textEdit1 = new Q3TextEdit(this);
	textEdit1->setPaletteBackgroundColor(QColor(100,255,100));
	closeButton = new QPushButton(tr("close"), this);
	closeButton->setDefault(true);
	//closing process button
	connect(closeButton, SIGNAL(clicked()), this, SLOT(close()));
	connect(closeButton, SIGNAL(clicked()), this, SLOT(close_button_clicked()));

	Q3VBoxLayout *headLayout = new Q3VBoxLayout;
	headLayout->addWidget(textEdit1);

	Q3HBoxLayout *footLayout = new Q3HBoxLayout;
	footLayout->addStretch(1);
	footLayout->addWidget(closeButton);

	Q3VBoxLayout *mainLayout = new Q3VBoxLayout(this);
	mainLayout->setMargin(11);
	mainLayout->setSpacing(6);
	mainLayout->addLayout(headLayout);
	mainLayout->addLayout(footLayout);
	resize(700,500);

	segatex_core2_pre();

}
void SegatexCore2Process::close_button_clicked()
{
	emit segatex_core2_prosess_close_button_clicked();

}
void SegatexCore2Process::segatex_core2_pre()
{

	//change path as you wish.
	/////////////////////////////////////////////////////////////
	path = "/var/log/audit";
	//path_to_be_written = "./mypolicybysegatex_pre.txt";
	path_to_be_written = "/root/segatex/mypolicybysegatex_pre.txt";
	/////////////////////////////////////////////////////////////
	forward_slash = "/";
	dir.setPath(path);
	dir_name = dir.absPath();

	file_w.setName(path_to_be_written);
	/////////////////////////////////////////////////////////////
	dir.setFilter( QDir::Files );
        dir.setSorting( QDir::Name );
	files = dir.entryList("audit.log");
	colon = ":";
	/////////////////////////////////////////////////////////////
	it_d = files.begin();
	if (file_w.exists()) {
		file_w.remove();
	}
	
	if ( file_w.open( QIODevice::WriteOnly | QIODevice::Append ) ) {
		while(it_d != files.end()){
			name = *it_d;
			file_interface_name = dir_name + forward_slash + name;
			QFile file( file_interface_name );
			if ( file.open( QIODevice::ReadOnly ) ) {
				Q3TextStream stream( &file );
				//QTextStream stream_echo( &file );
				////////////////////////////////////////////
				QRegExp rx_denied("denied");
				////////////////////////////////////////////
				QRegExp rx_bracket_last("\\)"); 	
				QRegExp rx_scontext("scontext");
				QRegExp rx_tcontext("tcontext");
				QRegExp rx_tclass("tclass");
				QRegExp rx_firstbrace("\\{");
				QRegExp rx_gen_require_close("^[ \t\n\r\f]+\\'\\)");//close before many blanks
				//rx_summary_title.setWildcard( TRUE ); 

				while ( !stream.atEnd() ) {
					line_analized = stream.readLine(); // line of text excluding '\n'
					if(line_analized.find( rx_denied, 0) != -1){
						for (int i=0;i<30;i++){
							log_str = line_analized.section( ' ', i, i );
							if(log_str.find( rx_scontext, 0) != -1){
								log_str_scontext_pre = log_str.section( ':', 2, 2 );
								log_str_scontext = log_str_scontext_pre;
							}
							if(log_str.find( rx_tcontext, 0) != -1){
								log_str_tcontext_pre = log_str.section( ':', 2, 2 );
								log_str_tcontext = log_str_tcontext_pre;
							}
							if(log_str.find( rx_firstbrace, 0) != -1){
								log_str_access_vector = line_analized.section( ' ', i+1, i+1 );
							}
							if(log_str.find( rx_tclass, 0) != -1){
								log_str_tclass_pre = log_str.section( '=', 1, 1 );
								log_str_tclass = log_str_tclass_pre;
								lines += log_str_scontext + " " + log_str_tcontext + " " + log_str_tclass + " " + log_str_access_vector;
							}
						}
				        }
				}
				lines.sort();
				Q3TextStream stream_w( &file_w );
				for ( it = lines.begin(); it != lines.end(); ++it ){
					if (it_comp != *it)
						stream_w << *it << "\n";
					it_comp = *it;
				}
				file.close();
				lines.clear();
				++it_d;
			}else{
				//do nothing
			}
		}
	}
	//echo
	file_w.close();
	if ( file_w.open( QIODevice::ReadOnly ) ) {
		Q3TextStream stream( &file_w );
		textEdit1->setText( stream.read() );
	}
	segatex_core2_action();
}//end-segatex_core2_pre()

void SegatexCore2Process::segatex_core2_action()
{

	//change path as you wish.
	/////////////////////////////////////////////////////////////
	//path = "./";
	//path_to_be_written = "./mypolicybysegatex.txt";
	//path_selpaw_interface = "./selpaw_interface.csv";
	path = "/root/segatex";
	path_to_be_written = "/root/segatex/mypolicybysegatex.txt";
	path_selpaw_interface = "/root/segatex/selpaw_interface.csv";
	/////////////////////////////////////////////////////////////
	forward_slash = "/";
	dir.setPath(path);
	dir_name = dir.absPath();

	file_w_action.setName(path_to_be_written);
	file2.setName(path_selpaw_interface);
	/////////////////////////////////////////////////////////////
	dir.setFilter( QDir::Files );
        dir.setSorting( QDir::Name );
	files = dir.entryList("mypolicybysegatex_pre.txt");
	/////////////////////////////////////////////////////////////
	it_d = files.begin();
	if (file_w_action.exists()) {
		file_w_action.remove();
	}
	//opens a file to be written	
	if ( file_w_action.open( QIODevice::WriteOnly | QIODevice::Append ) ) {
		//reads every file of the directory having name which had been set.
		while(it_d != files.end()){
			//Set the very name of the file.
			name = *it_d;
			//Set the very path.
			file_interface_name = dir_name + forward_slash + name;
			//Declares the file to be read.
			QFile file( file_interface_name );
			if ( file.open( QIODevice::ReadOnly ) ) {
				Q3TextStream stream( &file );
				//Read every line.
				////int ii;
				////ii=0;
				while ( !stream.atEnd() ) {
					////QString num;
					////num.setNum(ii);
					line_analized = stream.readLine(); // line of text excluding '\n'
					domain = line_analized.section( ' ',0 ,0 );
					//cout << num << ":domain:" << domain << ":";
					target_type = line_analized.section( ' ',1 ,1 );
					//cout << "target_type:" << target_type << ":";
					object_class = line_analized.section( ' ',2 ,2 );
					//cout << "object_class:" << object_class << ":";
					access_vector = line_analized.section( ' ',3 ,3 );
					//cout << "access_vector:" << access_vector << endl;
					QRegExp rx_target_type(target_type);
					QRegExp rx_object_class(object_class);
					QRegExp rx_access_vector(access_vector);
					//Read from selpaw_interface.csv.
					//stream_number = "stream_number" + num;
					if ( file2.open( QIODevice::ReadOnly ) ) {
						Q3TextStream stream_number( &file2 );
						while ( !stream_number.atEnd() ) {
							line_analized2 = stream_number.readLine(); // line of text excluding '\n'
							if((line_analized2.find( rx_target_type, 0) != -1)&&
								(line_analized2.find( rx_object_class, 0) != -1)&&
								(line_analized2.find( rx_access_vector, 0) != -1))
							{
								interface_name = line_analized2.section( ',',2 ,2 );
								//policy = num + ":" + interface_name + "(" + domain + ")";
								policy = interface_name + "(" + domain + ")";
								if(interface_name != "")
									lines += policy; 
							}
						}
					}
					file2.close();
					////ii++;
				}
				//lines.sort();
				Q3TextStream stream_w( &file_w_action );
				for ( it = lines.begin(); it != lines.end(); ++it ){
					if (it_comp != *it)
						stream_w << *it << "\n";
					it_comp = *it;
				}
				file.close();
				lines.clear();
				//Move to next file.
				++it_d;
			}else{
				//do nothing
			}
		}
	}
	//echo
	file_w_action.close();
	if ( file_w_action.open( QIODevice::ReadOnly ) ) {
		Q3TextStream stream( &file_w_action );
		textEdit1->setText( stream.read() );
	}
}//end-segatex_core2_pre()
