/*
 * segatex SELinux tool.
 *
 * Copyright (C) 2007-2008 Shintaro Fujiwara 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * */

#include <qlayout.h>
#include <qpushbutton.h>
#include <qradiobutton.h>
#include <qbuttongroup.h>
#include <qlineedit.h>
#include <qtextedit.h>

#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <fstream>

#include "semanage_core_boolean_process.h"

#include <iostream>
using namespace std;

//default constructor
SemanageCoreBooleanProcess::SemanageCoreBooleanProcess(QWidget *parent, const char *name): QDialog(parent, name)
{
	setCaption(tr("Setsebool Process"));
	textEdit1 = new QTextEdit(this);
	textEdit1->setPaletteBackgroundColor(QColor(0,254,100));

	semanageEditLabel = new QLabel(tr("Boolean:"), this );
	semanageEditLineEdit = new QLineEdit( this );
	semanageEditLineEdit->setText("");
	semanageEditLineEdit->setPaletteBackgroundColor(QColor(255,100,200));
	
	timeButtonGroup = new QButtonGroup(this);
	timeButtonGroup->resize( 200, 200 );
	temporaryRadioButton = new QRadioButton(tr("temporary"), timeButtonGroup);
	permanentRadioButton = new QRadioButton(tr("permanent"), timeButtonGroup);
	temporaryRadioButton->setGeometry( 10, 10, 100, 20 );
	permanentRadioButton->setGeometry( 10, 30, 100, 20 );
	permanentRadioButton->setChecked(true);

	semanageEditLabel2 = new QLabel(tr("value{on|off}:"), this );
	semanageEditLineEdit2 = new QLineEdit( this );
	semanageEditLineEdit2->setText("");
	semanageEditLineEdit2->setPaletteBackgroundColor(QColor(255,100,200));
	addButton = new QPushButton(tr("Set this boolean"), this);
	addButton->setPaletteBackgroundColor(QColor(20,157,100));
	connect(addButton, SIGNAL(clicked()), this, SLOT(add_button_clicked()));

	closeButton = new QPushButton(tr("close"), this);
	//closing process button
	connect(closeButton, SIGNAL(clicked()), this, SLOT(close()));
	closeButton->setDefault(true);

	//set textEdit smanage such and such -l
	semanage_core_base_boolean_process();

	mainLayout = new QVBoxLayout(this);
	mainLayout->setMargin(11);

	upperLayout = new QVBoxLayout;
	upperLayout->addWidget(textEdit1);

	middleLayout = new QVBoxLayout;
	leftLayout = new QHBoxLayout;
	rightLayout = new QHBoxLayout;
	thirdLayout = new QHBoxLayout;
	
	leftLayout->addWidget(semanageEditLabel);
	leftLayout->addWidget(semanageEditLineEdit);
	//rightLayout->addWidget(temporaryRadioButton);
	//rightLayout->addWidget(permanentRadioButton);
	rightLayout->addWidget(timeButtonGroup);
	leftLayout->addWidget(semanageEditLabel2);
	leftLayout->addWidget(semanageEditLineEdit2);
	leftLayout->addWidget(addButton);

	middleLayout->addLayout(leftLayout);
	middleLayout->addLayout(rightLayout);
	middleLayout->addLayout(thirdLayout);

	footLayout = new QHBoxLayout;
	footLayout->addStretch();
	footLayout->addWidget(closeButton);

	mainLayout->addLayout(upperLayout);
	mainLayout->addLayout(middleLayout);
	mainLayout->addLayout(footLayout);
	resize(1100,600);
}

/*signal and slot should have same argument pattern so I had to pass to another slot*/
void SemanageCoreBooleanProcess::add_button_clicked()
{
	semanageEditLineEdit_str = semanageEditLineEdit->text();
	semanageEditLineEdit2_str = semanageEditLineEdit2->text();
	add_button_clicked_process(semanageEditLineEdit_str,semanageEditLineEdit2_str);
}
/* this slot does just make .pp file */
void SemanageCoreBooleanProcess::add_button_clicked_process(QString semanageEditLineEdit_str, QString semanageEditLineEdit2_str)
{
	if(temporaryRadioButton->isChecked())
		semanageEditLineEdit_str_pp = "setsebool " + semanageEditLineEdit_str + " " + semanageEditLineEdit2_str;
	if(permanentRadioButton->isChecked())
		semanageEditLineEdit_str_pp = "setsebool -P " + semanageEditLineEdit_str + " " + semanageEditLineEdit2_str;
        #define PWD_BUF 8600
        const char* make_module_file="/root/segatex/semanage/add_booleaned";
        ofstream os_add;
        os_add.open(make_module_file);
        if(os_add){
                FILE *read_fp;
                #define SIZE_TMP 8600
                char buffer[SIZE_TMP];
                int chars_read;
                memset(buffer, '\0', sizeof(buffer));
                read_fp = popen(semanageEditLineEdit_str_pp, "r");
                if(read_fp != NULL){
                        chars_read = fread(buffer, sizeof(char), SIZE_TMP, read_fp);
                        while(chars_read>0){
                                buffer[chars_read -1] = '\0';
                                //os << "Reading:-" << endl;
                                os_add << buffer << endl;
                                chars_read= fread(buffer, sizeof(char), SIZE_TMP, read_fp);
                        }
                        pclose(read_fp);
                }
        }
	os_add.close();
	//set textEdit semanage -l
	semanage_core_base_boolean_process();
	//outputfile_str_common2 = make_module_file;
}
// {boolean|login|user|port|interface|fcontext|translation}
void SemanageCoreBooleanProcess::semanage_core_base_boolean_process()
{
        #define PWD_BUF 8600
        const char* semanage_boolean_list_file="/root/segatex/semanage/1_boolean";
        ofstream os_test;
        os_test.open(semanage_boolean_list_file);
        if(os_test){
                FILE *read_fp;
                #define SIZE_TMP 8600
                char buffer[SIZE_TMP];
                int chars_read;
                memset(buffer, '\0', sizeof(buffer));

                read_fp = popen("semanage boolean -l", "r");
                if(read_fp != NULL){
                        chars_read = fread(buffer, sizeof(char), SIZE_TMP, read_fp);
                        while(chars_read>0){
                                buffer[chars_read -1] = '\0';
                                //os << "Reading:-" << endl;
                                os_test << buffer;
                                chars_read= fread(buffer, sizeof(char), SIZE_TMP, read_fp);
			}
			pclose(read_fp);
                }
        }
	os_test.close();
	//outputfile_str_common = "boolean_list";
	readFromOutputFile();
}

//this slot should be called from above slot
void SemanageCoreBooleanProcess::readFromOutputFile()
{
	/////////////////////////////////////////////////////////////
	//path = "./";
	path = "/root/segatex/semanage";
	/////////////////////////////////////////////////////////////
	forward_slash = "/";
	dir.setPath(path);
	dir_name = dir.absPath();
	/////////////////////////////////////////////////////////////
	dir.setFilter( QDir::Files );
        dir.setSorting( QDir::Name );
	//files = dir.entryList(outputfile_str_common);
	files = dir.entryList("*boolean");
	/////////////////////////////////////////////////////////////
	it_d = files.begin();
	int order_x;
	order_x = 1;
	//first clear it all, unless double the file.
	textEdit1->clear();
		while(it_d != files.end()){
			name = *it_d;
			file_interface_name = dir_name + forward_slash + name;
			QFile file( file_interface_name );
			/*
			QRegExp rx_nologin("nologin");
			QRegExp rx_shutdown("shutdown");
			QRegExp rx_halt("halt");
			QRegExp rx_news("news");
			QRegExp rx_false("false");
			QRegExp rx_sync("sync");
			*/
			if ( file.open( IO_ReadOnly ) ) {
				QTextStream stream( &file );
				////////////////////////////////////////////
				//int i,j,k,l,m,n;	
				if(order_x == 1)
					textEdit1->append("#########boolean list#########");
					textEdit1->append("");
				/*
				if(order_x == 2)
					textEdit1->append("#########user list#########");
					textEdit1->append("");
				if(order_x == 3)
					textEdit1->append("#########etc passwd list#########");
					textEdit1->append("");
				*/
				while ( !stream.atEnd() ) {
					line_analized = stream.readLine(); // line of text excluding '\n'
					//buttons.push_back(line_analized);
					/*
					i = line_analized.find( rx_nologin, 0);
					j = line_analized.find( rx_shutdown, 0);
					k = line_analized.find( rx_halt, 0);
					l = line_analized.find( rx_news, 0);
					m = line_analized.find( rx_false, 0);
					n = line_analized.find( rx_sync, 0);
					*/
                                        //if((i != -1)||(j != -1)||(k != -1)||(l != -1)||(m != -1)||(n != -1)){
						//do nothing
					//}else{
						textEdit1->append(line_analized);
					//}
				}
				//file.close();
				order_x++;
				++it_d;
			}else{
				//do nothing
			}
			file.close();
		}
}
