/*
 * segatex SELinux tool.
 *
 * Copyright (C) 2007 Shintaro Fujiwara 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * */

#include "selpaw.h"

//for debug
//#include <iostream>
//using namespace std;

//default constructor
Selpaw::Selpaw(){}
//constructor for Layout
Selpaw::Selpaw(QSplitter*&){}

void Selpaw::make_refine_selpaw()
{

	//change path as you wish.
	/////////////////////////////////////////////////////////////
	path = "./";
	path_to_be_written = "selpaw_interface_raw.csv";
	/////////////////////////////////////////////////////////////
	forward_slash = "/";
	dir.setPath(path);
	dir_name = dir.absPath();

	file_w.setName(path_to_be_written);
	/////////////////////////////////////////////////////////////
	dir.setFilter( QDir::Files );
        dir.setSorting( QDir::Name );
	files = dir.entryList("selpaw_admin.txt; selpaw_apps.txt; selpaw_kernel.txt; selpaw_services.txt; selpaw_system.txt");
	/////////////////////////////////////////////////////////////
	it_d = files.begin();
	if (file_w.exists()) {
		file_w.remove();
	}
	cumma =",";
	if ( file_w.open( IO_WriteOnly | IO_Append ) ) {
		while(it_d != files.end()){
			name = *it_d;
			file_interface_name = dir_name + forward_slash + name;
			QFile file( file_interface_name );
			if ( file.open( IO_ReadOnly ) ) {
				QTextStream stream( &file );
				//////////files_pattern/////////////////////////////////////////////
				QRegExp rx_getattr_dirs_pattern("rx_getattr_dirs_pattern");
				QRegExp rx_setattr_dirs_pattern("setattr_dirs_pattern");
				QRegExp rx_search_dirs_pattern("search_dirs_pattern");
				QRegExp rx_list_dirs_pattern("list_dirs_pattern");
				QRegExp rx_add_entry_dirs_pattern("add_entry_dirs_pattern");
				QRegExp rx_del_entry_dirs_pattern("del_entry_dirs_pattern");
				QRegExp rx_create_dirs_pattern("create_dirs_pattern");
				QRegExp rx_delete_dirs_pattern("delete_dirs_pattern");
				QRegExp rx_rename_dirs_pattern("rename_dirs_pattern");
				QRegExp rx_manage_dirs_pattern("manage_dirs_pattern");
				QRegExp rx_relabelfrom_dirs_pattern("relabelfrom_dirs_pattern");
				QRegExp rx_relabelto_dirs_pattern("relabelto_dirs_pattern");
				QRegExp rx_relabel_dirs_pattern("relabel_dirs_pattern");
				QRegExp rx_rw_dirs_pattern("rw_dirs_pattern");
				QRegExp rx_getattr_files_pattern("getattr_files_pattern");
				QRegExp rx_setattr_files_pattern("setattr_files_pattern");
				QRegExp rx_read_files_pattern("read_files_pattern");
				QRegExp rx_mmap_files_pattern("mmap_files_pattern");
				QRegExp rx_exec_files_pattern("exec_files_pattern");
				QRegExp rx_append_files_pattern("append_files_pattern");
				QRegExp rx_write_files_pattern("write_files_pattern");
				QRegExp rx_rw_files_pattern("rw_files_pattern");
				QRegExp rx_create_files_pattern("create_files_pattern");
				QRegExp rx_delete_files_pattern("delete_files_pattern");
				QRegExp rx_rename_files_pattern("rename_files_pattern");
				QRegExp rx_manage_files_pattern("manage_files_pattern");
				QRegExp rx_relabelfrom_files_pattern("relabelfrom_files_pattern");
				QRegExp rx_relabelto_files_pattern("relabelto_files_pattern");
				QRegExp rx_relabel_files_pattern("relabel_files_pattern");
				QRegExp rx_getattr_lnk_files_pattern("getattr_lnk_files_pattern");
				QRegExp rx_setattr_lnk_files_pattern("setattr_lnk_files_pattern");
				QRegExp rx_read_lnk_files_pattern("read_lnk_files_pattern");
				QRegExp rx_append_lnk_files_pattern("append_lnk_files_pattern");
				QRegExp rx_write_lnk_files_pattern("write_lnk_files_pattern");
				QRegExp rx_rw_lnk_files_pattern("rw_lnk_files_pattern");
				QRegExp rx_create_lnk_files_pattern("create_lnk_files_pattern");
				QRegExp rx_delete_lnk_files_pattern("delete_lnk_files_pattern");
				QRegExp rx_rename_lnk_files_pattern("rename_lnk_files_pattern");
				QRegExp rx_manage_lnk_files_pattern("manage_lnk_files_pattern");
				QRegExp rx_relabelfrom_lnk_files_pattern("relabelfrom_lnk_files_pattern");
				QRegExp rx_relabelto_lnk_files_pattern("relabelto_lnk_files_pattern");
				QRegExp rx_relabel_lnk_files_pattern("relabel_lnk_files_pattern");
				QRegExp rx_getattr_fifo_files_pattern("getattr_fifo_files_pattern");	
				QRegExp rx_setattr_fifo_files_pattern("setattr_fifo_files_pattern");
				QRegExp rx_read_fifo_files_pattern("read_fifo_files_pattern");
				QRegExp rx_append_fifo_files_pattern("append_fifo_files_pattern");
				QRegExp rx_write_fifo_files_pattern("write_fifo_files_pattern");
				QRegExp rx_rw_fifo_files_pattern("rw_fifo_files_pattern");
				QRegExp rx_create_fifo_files_pattern("create_fifo_files_pattern");
				QRegExp rx_delete_fifo_files_pattern("delete_fifo_files_pattern");
				QRegExp rx_rename_fifo_files_pattern("rename_fifo_files_pattern");
				QRegExp rx_manage_fifo_files_pattern("manage_fifo_files_pattern");
				QRegExp rx_relabelfrom_fifo_files_pattern("relabelfrom_fifo_files_pattern");
				QRegExp rx_relabelto_fifo_files_pattern("relabelto_fifo_files_pattern");
				QRegExp rx_relabel_fifo_files_pattern("relabel_fifo_files_pattern");
				QRegExp rx_getattr_sock_files_pattern("getattr_sock_files_pattern");
				QRegExp rx_setattr_sock_files_pattern("setattr_sock_files_pattern");
				QRegExp rx_read_sock_files_pattern("read_sock_files_pattern");	
				QRegExp rx_write_sock_files_pattern("write_sock_files_pattern");
				QRegExp rx_rw_sock_files_pattern("rw_sock_files_pattern");
				QRegExp rx_create_sock_files_pattern("create_sock_files_pattern");
				QRegExp rx_delete_sock_files_pattern("delete_sock_files_pattern");
				QRegExp rx_rename_sock_files_pattern("rename_sock_files_pattern");
				QRegExp rx_manage_sock_files_pattern("manage_sock_files_pattern");
				QRegExp rx_relabelfrom_sock_files_pattern("relabelfrom_sock_files_pattern");
				QRegExp rx_relabelto_sock_files_pattern("relabelto_sock_files_pattern");
				QRegExp rx_relabel_sock_files_pattern("relabel_sock_files_pattern");
				QRegExp rx_getattr_blk_files_pattern("getattr_blk_files_pattern");
				QRegExp rx_setattr_blk_files_pattern("setattr_blk_files_pattern");
				QRegExp rx_read_blk_files_pattern("read_blk_files_pattern");
				QRegExp rx_append_blk_files_pattern("append_blk_files_pattern");	
				QRegExp rx_write_blk_files_pattern("write_blk_files_pattern");
				QRegExp rx_rw_blk_files_pattern("rw_blk_files_pattern");
				QRegExp rx_create_blk_files_pattern("create_blk_files_pattern");
				QRegExp rx_delete_blk_files_pattern("delete_blk_files_pattern");
				QRegExp rx_rename_blk_files_pattern("rename_blk_files_pattern");
				QRegExp rx_manage_blk_files_pattern("manage_blk_files_pattern");
				QRegExp rx_relabelfrom_blk_files_pattern("relabelfrom_blk_files_pattern");
				QRegExp rx_relabelto_blk_files_pattern("relabelto_blk_files_pattern");
				QRegExp rx_relabel_blk_files_pattern("relabel_blk_files_pattern");
				QRegExp rx_getattr_chr_files_pattern("getattr_chr_files_pattern");
				QRegExp rx_setattr_chr_files_pattern("setattr_chr_files_pattern");
				QRegExp rx_read_chr_files_pattern("read_chr_files_pattern");
				QRegExp rx_append_chr_files_pattern("append_chr_files_pattern");
				QRegExp rx_write_chr_files_pattern("write_chr_files_pattern");
				QRegExp rx_rw_chr_files_pattern("rw_chr_files_pattern");
				QRegExp rx_create_chr_files_pattern("create_chr_files_pattern");
				QRegExp rx_delete_chr_files_pattern("delete_chr_files_pattern");
				QRegExp rx_rename_chr_files_pattern("rename_chr_files_pattern");
				QRegExp rx_manage_chr_files_pattern("manage_chr_files_pattern");
				QRegExp rx_relabelfrom_chr_files_pattern("relabelfrom_chr_files_pattern");
				QRegExp rx_relabelto_chr_files_pattern("relabelto_chr_files_pattern");
				QRegExp rx_relabel_chr_files_pattern("relabel_chr_files_pattern");
				QRegExp rx_filetrans_add_pattern("filetrans_add_pattern");
				QRegExp rx_filetrans_pattern("filetrans_pattern");
				QRegExp rx_dontaudit("^dontaudit");
				
				
				QRegExp rx_interface4("\\$1"); 		
				
				////////////////////////////////////////////
				//QRegExp rx_can_exec("can_exec");
				while ( !stream.atEnd() ) {
					line_analized = stream.readLine(); // line of text excluding '\n'
					QString layer_name = line_analized.section( ',',0, 0 );   // s == "surname"
					QString interface_file_name_this = line_analized.section( ',',1, 1 );   // s == "surname"
					QString interface_name_this = line_analized.section( ',',2, 2 );   // s == "surname"
					//back to original state
					line_analized = line_analized.section( ',',3);
					//////////////////////////files pattern//////////////////////////////////////
					//getattr_dirs_pattern
					if(line_analized.find( rx_getattr_dirs_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );	
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines += tab + "allow " + first_var + " " + third_var + ":dir getattr_dir_perms;";
				        }					
					//setattr_dirs_pattern
					if(line_analized.find( rx_setattr_dirs_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines += tab + "allow " + first_var + " " + third_var + ":dir setattr_dir_perms;";
				        }					
					//search_dirs_pattern
					if(line_analized.find( rx_search_dirs_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines += tab + "allow " + first_var + " " + third_var + ":dir search_dir_perms;";
				        }					
					//list_dirs_pattern
					if(line_analized.find( rx_list_dirs_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines += tab + "allow " + first_var + " " + third_var + ":dir list_dir_perms;";
				        }						
					//add_entry_dirs_pattern
					if(line_analized.find( rx_add_entry_dirs_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );	
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines += tab + "allow " + first_var + " " + third_var + ":dir add_entry_dir_perms;";
				        }					
					//del_entry_dirs_pattern
					if(line_analized.find( rx_del_entry_dirs_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines += tab + "allow " + first_var + " " + third_var + ":dir del_entry_dir_perms;";
				        }					
					//create_dirs_pattern
					if(line_analized.find( rx_create_dirs_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines += tab + "allow " + first_var + " " + second_var + ":dir add_entry_dir_perms;";
						lines += tab + "allow " + first_var + " " + third_var + ":dir create_dir_perms;";
				        }					
					//delete_dirs_pattern
					if(line_analized.find( rx_delete_dirs_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines += tab + "allow " + first_var + " " + second_var + ":dir del_entry_dir_perms;";
						lines += tab + "allow " + first_var + " " + third_var + ":dir delete_dir_perms;";
				        }					
					//rename_dirs_pattern
					if(line_analized.find( rx_rename_dirs_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines += tab + "allow " + first_var + " " + second_var + ":dir rw_dir_perms;";
						lines += tab + "allow " + first_var + " " + third_var + ":dir rename_dir_perms;";
				        }					
					//manage_dirs_pattern
					if(line_analized.find( rx_manage_dirs_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines += tab + "allow " + first_var + " " + second_var + ":dir rw_dir_perms;";
						lines += tab + "allow " + first_var + " " + third_var + ":dir manage_dir_perms;";
				        }					
					//relabelfrom_dirs_pattern
					if(line_analized.find( rx_relabelfrom_dirs_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );		
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines += tab + "allow " + first_var + " " + third_var + ":dir relabelfrom_dir_perms;";
				        }					
					//relabelto_dirs_pattern
					if(line_analized.find( rx_relabelto_dirs_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines += tab + "allow " + first_var + " " + third_var + ":dir relabelto_dir_perms;";
				        }					
					//relabel_dirs_pattern
					if(line_analized.find( rx_relabel_dirs_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );	
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines += tab + "allow " + first_var + " " + third_var + ":dir relabel_dir_perms;";
				        }					
					//rw_dirs_pattern
					if(line_analized.find( rx_rw_dirs_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );	
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines += tab + "allow " + first_var + " " + third_var + ":dir add_entry_dir_perms;";
						lines += tab + "allow " + first_var + " " + third_var + ":dir del_entry_dir_perms;";
				        }					
					//r_files_pattern
					if(line_analized.find( rx_getattr_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );	
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines += tab + "allow " + first_var + " " + third_var + ":file getattr_file_perms;";
				        }					
					//setattr_files_pattern
					if(line_analized.find( rx_setattr_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines += tab + "allow " + first_var + " " + third_var + ":file setattr_file_perms;";
				        }					
					//read_files_pattern
					if(line_analized.find( rx_read_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines += tab + "allow " + first_var + " " + third_var + ":file read_file_perms;";
				        }					
					//mmap_files_pattern
					if(line_analized.find( rx_mmap_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines += tab + "allow " + first_var + " " + third_var + ":file mmap_file_perms;";
				        }					
					//exec_files_pattern
					if(line_analized.find( rx_exec_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines += tab + "allow " + first_var + " " + third_var + ":file exec_file_perms;";
				        }					
					//append_files_pattern
					if(line_analized.find( rx_append_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );		
 						third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines += tab + "allow " + first_var + " " + third_var + ":file append_file_perms;";
				        }					
					//write_files_pattern
					if(line_analized.find( rx_write_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );		
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines += tab + "allow " + first_var + " " + third_var + ":file write_file_perms;";
				        }					
					//rw_files_pattern
					if(line_analized.find( rx_rw_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );	
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines += tab + "allow " + first_var + " " + third_var + ":file rw_file_perms;";
				        }					
					//create_files_pattern
					if(line_analized.find( rx_create_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );	
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines += tab + "allow " + first_var + " " + second_var + ":dir add_entry_dir_perms;";
						lines += tab + "allow " + first_var + " " + third_var + ":file create_file_perms;";
				        }					
					//delete_files_pattern
					if(line_analized.find( rx_delete_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );	
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines += tab + "allow " + first_var + " " + second_var + ":dir del_entry_dir_perms;";
						lines += tab + "allow " + first_var + " " + third_var + ":file delete_file_perms;";
				        }										
					//rename_files_pattern
					if(line_analized.find( rx_rename_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines += tab + "allow " + first_var + " " + second_var + ":dir rw_dir_perms;";
						lines += tab + "allow " + first_var + " " + third_var + ":file rename_file_perms;";
				        }					
					//manage_files_pattern
					if(line_analized.find( rx_manage_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );	
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines += tab + "allow " + first_var + " " + second_var + ":dir rw_dir_perms;";
						lines += tab + "allow " + first_var + " " + third_var + ":file manage_file_perms;";
				        }					
					//relabelfrom_files_pattern
					if(line_analized.find( rx_relabelfrom_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines += tab + "allow " + first_var + " " + third_var + ":file relabelfrom_file_perms;";
				        }					
					//relabelto_files_pattern
					if(line_analized.find( rx_relabelto_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );	
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines += tab + "allow " + first_var + " " + third_var + ":file relabelto_file_perms;";
				        }					
					//relabel_files_pattern
					if(line_analized.find( rx_relabel_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );		
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines += tab + "allow " + first_var + " " + third_var + ":file relabel_file_perms;";
				        }					
					//getattr_lnk_files_pattern
					if(line_analized.find( rx_getattr_lnk_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines += tab + "allow " + first_var + " " + third_var + ":lnk_file getattr_lnk_file_perms;";
				        }						
					//setattr_lnk_files_pattern
					if(line_analized.find( rx_setattr_lnk_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );	
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines += tab + "allow " + first_var + " " + third_var + ":lnk_file setattr_lnk_file_perms;";
				        }					
					//read_lnk_files_pattern
					if(line_analized.find( rx_read_lnk_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );			
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines += tab + "allow " + first_var + " " + third_var + ":lnk_file read_lnk_file_perms;";
				        }					
					//append_lnk_files_pattern
					if(line_analized.find( rx_append_lnk_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines += tab + "allow " + first_var + " " + third_var + ":lnk_file append_lnk_file_perms;";
				        }					
					//write_lnk_files_pattern
					if(line_analized.find( rx_write_lnk_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines += tab + "allow " + first_var + " " + third_var + ":lnk_file write_lnk_file_perms;";
				        }						
					//rw_lnk_files_pattern
					if(line_analized.find( rx_rw_lnk_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines += tab + "allow " + first_var + " " + third_var + ":lnk_file rw_lnk_file_perms;";
				        }							
					//create_lnk_files_pattern
					if(line_analized.find( rx_create_lnk_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );	
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines += tab + "allow " + first_var + " " + second_var + ":dir add_entry_dir_perms;";
						lines += tab + "allow " + first_var + " " + third_var + ":lnk_file create_lnk_file_perms;";
				        }					
					//delete_lnk_files_pattern
					if(line_analized.find( rx_delete_lnk_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );	
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines += tab + "allow " + first_var + " " + second_var + ":dir del_entry_dir_perms;";
						lines += tab + "allow " + first_var + " " + third_var + ":lnk_file delete_lnk_file_perms;";
				        }					
					//rename_lnk_files_pattern
					if(line_analized.find( rx_rename_lnk_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines += tab + "allow " + first_var + " " + second_var + ":dir rw_dir_perms;";
						lines += tab + "allow " + first_var + " " + third_var + ":lnk_file rename_lnk_file_perms;";
				        }						
					//manage_lnk_files_pattern
					if(line_analized.find( rx_manage_lnk_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );	
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines += tab + "allow " + first_var + " " + second_var + ":dir rw_dir_perms;";
						lines += tab + "allow " + first_var + " " + third_var + ":lnk_file manage_lnk_file_perms;";
				        }					
					//relabelfrom_lnk_files_pattern
					if(line_analized.find( rx_relabelfrom_lnk_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines += tab + "allow " + first_var + " " + third_var + ":lnk_file relabelfrom_lnk_file_perms;";
				        }					
					//relabelto_lnk_files_pattern
					if(line_analized.find( rx_relabelto_lnk_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );		
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines += tab + "allow " + first_var + " " + third_var + ":lnk_file relabelto_lnk_file_perms;";
				        }					
					//relabel_lnk_files_pattern
					if(line_analized.find( rx_relabel_lnk_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines += tab + "allow " + first_var + " " + third_var + ":lnk_file relabel_lnk_file_perms;";
				        }					
					//getattr_fifo_files_pattern
					if(line_analized.find( rx_getattr_fifo_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines += tab + "allow " + first_var + " " + third_var + ":fifo_file getattr_fifo_file_perms;";
				        }					
					//setattr_fifo_files_pattern
					if(line_analized.find( rx_setattr_fifo_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines += tab + "allow " + first_var + " " + third_var + ":fifo_file setattr_fifo_file_perms;";
				        }					
					//read_fifo_files_pattern
					if(line_analized.find( rx_read_fifo_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );	
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines += tab + "allow " + first_var + " " + third_var + ":fifo_file read_fifo_file_perms;";
				        }					
					//append_fifo_files_pattern
					if(line_analized.find( rx_append_fifo_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines += tab + "allow " + first_var + " " + third_var + ":fifo_file append_fifo_file_perms;";
				        }					
					//write_fifo_files_pattern
					if(line_analized.find( rx_write_fifo_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );	
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines += tab + "allow " + first_var + " " + third_var + ":fifo_file write_fifo_file_perms;";
				        }					
					//rw_fifo_files_pattern
					if(line_analized.find( rx_rw_fifo_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );	
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines += tab + "allow " + first_var + " " + third_var + ":fifo_file rw_fifo_file_perms;";
				        }					
					//create_fifo_files_pattern
					if(line_analized.find( rx_create_fifo_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines += tab + "allow " + first_var + " " + second_var + ":dir add_entry_dir_perms;";
						lines += tab + "allow " + first_var + " " + third_var + ":fifo_file create_fifo_file_perms;";
				        }					
					//delete_fifo_files_pattern
					if(line_analized.find( rx_delete_fifo_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines += tab + "allow " + first_var + " " + second_var + ":dir del_entry_dir_perms;";
						lines += tab + "allow " + first_var + " " + third_var + ":fifo_file delete_fifo_file_perms;";
				        }					
					//rename_fifo_files_pattern
					if(line_analized.find( rx_rename_fifo_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );	
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines += tab + "allow " + first_var + " " + second_var + ":dir rw_dir_perms;";
						lines += tab + "allow " + first_var + " " + third_var + ":fifo_file rename_fifo_file_perms;";
				        }					
					//manage_fifo_files_pattern
					if(line_analized.find( rx_manage_fifo_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines += tab + "allow " + first_var + " " + second_var + ":dir rw_dir_perms;";
						lines += tab + "allow " + first_var + " " + third_var + ":fifo_file manage_fifo_file_perms;";
				        }					
					//relabelfrom_fifo_files_pattern
					if(line_analized.find( rx_relabelfrom_fifo_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );		
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines += tab + "allow " + first_var + " " + third_var + ":fifo_file relabelfrom_fifo_file_perms;";
				        }					
					//relabelto_fifo_files_pattern
					if(line_analized.find( rx_relabelto_fifo_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines += tab + "allow " + first_var + " " + third_var + ":fifo_file relabelto_fifo_file_perms;";
				        }					
					//relabel_fifo_files_pattern
					if(line_analized.find( rx_relabel_fifo_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );	
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines += tab + "allow " + first_var + " " + third_var + ":fifo_file relabel_fifo_file_perms;";
				        }					
					//getattr_sock_files_pattern
					if(line_analized.find( rx_getattr_sock_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );	
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines += tab + "allow " + first_var + " " + third_var + ":sock_file getattr_sock_file_perms;";
				        }					
					//setattr_sock_files_pattern
					if(line_analized.find( rx_setattr_sock_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines += tab + "allow " + first_var + " " + third_var + ":sock_file setattr_sock_file_perms;";
				        }					
					//read_sock_files_pattern
					if(line_analized.find( rx_read_sock_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );		
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines += tab + "allow " + first_var + " " + third_var + ":sock_file read_sock_file_perms;";
				        }					
					//write_sock_files_pattern
					if(line_analized.find( rx_write_sock_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines += tab + "allow " + first_var + " " + third_var + ":sock_file write_sock_file_perms;";
				        }
					//rw_sock_files_pattern
					if(line_analized.find( rx_rw_sock_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines += tab + "allow " + first_var + " " + third_var + ":sock_file rw_sock_file_perms;";
				        }
					//create_sock_files_pattern
					if(line_analized.find( rx_create_sock_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines += tab + "allow " + first_var + " " + second_var + ":dir add_entry_dir_perms;";
						lines += tab + "allow " + first_var + " " + third_var + ":sock_file create_sock_file_perms;";
				        }					
					//delete_sock_files_pattern
					if(line_analized.find( rx_delete_sock_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines += tab + "allow " + first_var + " " + second_var + ":dir del_entry_dir_perms;";
						lines += tab + "allow " + first_var + " " + third_var + ":sock_file delete_sock_file_perms;";
				        }					
					//rename_sock_files_pattern
					if(line_analized.find( rx_rename_sock_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );		
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines += tab + "allow " + first_var + " " + second_var + ":dir rw_dir_perms;";
						lines += tab + "allow " + first_var + " " + third_var + ":sock_file rename_sock_file_perms;";
				        }					
					//manage_sock_files_pattern
					if(line_analized.find( rx_manage_sock_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );	
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines += tab + "allow " + first_var + " " + second_var + ":dir rw_dir_perms;";
						lines += tab + "allow " + first_var + " " + third_var + ":sock_file manage_sock_file_perms;";
				        }					
					//relabelfrom_sock_files_pattern
					if(line_analized.find( rx_relabelfrom_sock_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );	
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines += tab + "allow " + first_var + " " + third_var + ":sock_file relabelfrom_sock_file_perms;";
				        }					
					//relabelto_sock_files_pattern
					if(line_analized.find( rx_relabelto_sock_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );	
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines += tab + "allow " + first_var + " " + third_var + ":sock_file relabelto_sock_file_perms;";
				        }					
					//relabel_sock_files_pattern
					if(line_analized.find( rx_relabel_sock_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );			
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines += tab + "allow " + first_var + " " + third_var + ":sock_file relabel_sock_file_perms;";
				        }					
					//getattr_blk_files_pattern
					if(line_analized.find( rx_getattr_blk_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );	
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines += tab + "allow " + first_var + " " + third_var + ":blk_file getattr_blk_file_perms;";
				        }						
					//setattr_blk_files_pattern
					if(line_analized.find( rx_setattr_blk_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );	
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines += tab + "allow " + first_var + " " + third_var + ":blk_file setattr_blk_file_perms;";
				        }					
					//read_blk_files_pattern
					if(line_analized.find( rx_read_blk_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );		
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines += tab + "allow " + first_var + " " + third_var + ":blk_file read_blk_file_perms;";
				        }						
					//append_blk_files_pattern
					if(line_analized.find( rx_append_blk_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines += tab + "allow " + first_var + " " + third_var + ":blk_file append_blk_file_perms;";
				        }					
					//write_blk_files_pattern
					if(line_analized.find( rx_write_blk_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );		
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines += tab + "allow " + first_var + " " + third_var + ":blk_file write_blk_file_perms;";
				        }						
					//rw_blk_files_pattern
					if(line_analized.find( rx_rw_blk_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );		
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines += tab + "allow " + first_var + " " + third_var + ":blk_file rw_blk_file_perms;";
				        }						
					//create_blk_files_pattern
					if(line_analized.find( rx_create_blk_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );	
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines += tab + "allow " + first_var + " " + "self:capability mknod;";
						lines += tab + "allow " + first_var + " " + second_var + ":dir add_entry_dir_perms;";
						lines += tab + "allow " + first_var + " " + third_var + ":blk_file create_blk_file_perms;";
				        }					
					//delete_blk_files_pattern
					if(line_analized.find( rx_delete_blk_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );	
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines += tab + "allow " + first_var + " " + second_var + ":dir del_entry_dir_perms;";
						lines += tab + "allow " + first_var + " " + third_var + ":blk_file delete_blk_file_perms;";
				        }					
					//rename_blk_files_pattern
					if(line_analized.find( rx_rename_blk_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines += tab + "allow " + first_var + " " + second_var + ":dir rw_dir_perms;";
						lines += tab + "allow " + first_var + " " + third_var + ":blk_file rename_blk_file_perms;";
				        }					
					//manage_blk_files_pattern
					if(line_analized.find( rx_manage_blk_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );		
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines += tab + "allow " + first_var + " " + "self:capability mknod;";
						lines += tab + "allow " + first_var + " " + second_var + ":dir rw_dir_perms;";
						lines += tab + "allow " + first_var + " " + third_var + ":blk_file manage_blk_file_perms;";
				        }					
					//relabelfrom_blk_files_pattern
					if(line_analized.find( rx_relabelfrom_blk_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );		
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines += tab + "allow " + first_var + " " + third_var + ":blk_file relabelfrom_blk_file_perms;";
				        }							
					//relabelto_blk_files_pattern
					if(line_analized.find( rx_relabelto_blk_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );		
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines += tab + "allow " + first_var + " " + third_var + ":blk_file relabelto_blk_file_perms;";
				        }							
					//relabel_blk_files_pattern
					if(line_analized.find( rx_relabel_blk_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines += tab + "allow " + first_var + " " + third_var + ":blk_file relabel_blk_file_perms;";
				        }						
					//getattr_chr_files_pattern
					if(line_analized.find( rx_getattr_chr_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines += tab + "allow " + first_var + " " + third_var + ":chr_file getattr_chr_file_perms;";
				        }					
					//setattr_chr_files_pattern
					if(line_analized.find( rx_read_chr_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines += tab + "allow " + first_var + " " + third_var + ":chr_file setattr_chr_file_perms;";
				        }					
					//read_chr_files_pattern
					if(line_analized.find( rx_read_chr_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );	
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines += tab + "allow " + first_var + " " + third_var + ":chr_file read_chr_file_perms;";
				        }
					//append_chr_files_pattern
					if(line_analized.find( rx_append_chr_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );		
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines += tab + "allow " + first_var + " " + third_var + ":chr_file append_chr_file_perms;";
				        }						
					//write_chr_files_pattern
					if(line_analized.find( rx_write_chr_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );			
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines += tab + "allow " + first_var + " " + third_var + ":chr_file write_chr_file_perms;";
				        }					
					//rw_chr_files_pattern
					if(line_analized.find( rx_rw_chr_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines += tab + "allow " + first_var + " " + third_var + ":chr_file rw_chr_file_perms;";
				        }					
					//create_chr_files_pattern
					if(line_analized.find( rx_create_chr_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );	
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines += tab + "allow " + first_var + " " + "self:capability mknod;";
						lines += tab + "allow " + first_var + " " + second_var + ":dir add_entry_dir_perms;";
						lines += tab + "allow " + first_var + " " + third_var + ":chr_file create_chr_file_perms;";
				        }					
					//delete_chr_files_pattern
					if(line_analized.find( rx_delete_chr_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );			
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
				
						line_analized="";
						lines += tab + "allow " + first_var + " " + second_var + ":dir del_entry_dir_perms;";
						lines += tab + "allow " + first_var + " " + third_var + ":chr_file delete_chr_file_perms;";
				        }					
					//rename_chr_files_pattern
					if(line_analized.find( rx_rename_chr_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );	
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
				
						line_analized="";
						lines += tab + "allow " + first_var + " " + second_var + ":dir rw_dir_perms;";
						lines += tab + "allow " + first_var + " " + third_var + ":chr_file rename_chr_file_perms;";
				        }					
					//manage_chr_files_pattern
					if(line_analized.find( rx_manage_chr_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						line_analized="";
						lines += tab + "allow " + first_var + " " + "self:capability mknod;";						
						lines += tab + "allow " + first_var + " " + second_var + ":dir rw_dir_perms;";
						lines += tab + "allow " + first_var + " " + third_var + ":chr_file manage_chr_file_perms;";
				        }
					//relabelfrom_chr_files_pattern
					if(line_analized.find( rx_relabelfrom_chr_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );		
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						
						line_analized="";
						lines += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines += tab + "allow " + first_var + " " + third_var + ":chr_file relabelfrom_chr_file_perms;";
				        }
					//relabelto_chr_files_pattern
					if(line_analized.find( rx_relabelto_chr_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						
						line_analized="";
						lines += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines += tab + "allow " + first_var + " " + third_var + ":chr_file relabelto_chr_file_perms;";
				        }
					//relabel_chr_files_pattern
					if(line_analized.find( rx_relabel_chr_files_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );
	    					third_var = line_analized.section( ',', 2, 2 );
						third_var = third_var.replace( QChar(')'), "" );
						
						line_analized="";
						lines += tab + "allow " + first_var + " " + second_var + ":dir search_dir_perms;";
						lines += tab + "allow " + first_var + " " + third_var + ":chr_file relabel_chr_file_perms;";
				        }
					//filetrans_add_pattern
					if(line_analized.find( rx_filetrans_add_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );	
	    					third_var = line_analized.section( ',', 2, 2 );
						fourth_var = line_analized.section( ',', 3, 3 );
						fourth_var = fourth_var.replace( QChar(')'), "" );
						line_analized="";
						lines += tab + "allow " + first_var + " " + second_var + ":dir ra_dir_perms;";
						lines += tab + "type_transition " + first_var + " " + second_var + ":" + fourth_var + " " + third_var + ";";
				        }					
					//filetrans_pattern
					if(line_analized.find( rx_filetrans_pattern, 0) != -1){
					        first_var = line_analized.section( ',', 0, 0 );
						first_var = first_var.replace( QRegExp("[a-zA-Z0-9_]*\\("), "" );
						first_var = first_var.stripWhiteSpace();  
					        second_var = line_analized.section( ',', 1, 1 );	
	    					third_var = line_analized.section( ',', 2, 2 );
						fourth_var = line_analized.section( ',', 3, 3 );
						fourth_var = fourth_var.replace( QChar(')'), "" );
						line_analized="";
						lines += tab + "allow " + first_var + " " + second_var + ":dir rw_dir_perms;";
						lines += tab + "type_transition " + first_var + " " + second_var + ":" + fourth_var + " " + third_var + ";";
				        }										
					/////////////////end-files pattern//////////////////////								////////////////dontaudit//////////////////////////////
					else if(line_analized.find( rx_dontaudit, 0) != -1){
						lines += layer_name + cumma + interface_file_name_this + cumma + interface_name_this + cumma + line_analized;							line_analized = "";
					}else{
					////////////////end-dontaudit//////////////////////////////
					    lines += layer_name + cumma + interface_file_name_this + cumma + interface_name_this + cumma + line_analized;//this adds to lines. also append can be used
				        }
				}
				// it should have space otherwise getattr_dir_perms and r_dir_perms would collide
lines.gres(" dir_file_class_set","{ dir file lnk_file sock_file fifo_file chr_file blk_file }");
lines.gres(" file_class_set","{ file lnk_file sock_file fifo_file chr_file blk_file }");
lines.gres(" notdevfile_class_set","{ file lnk_file sock_file fifo_file }");
lines.gres(" devfile_class_set","{ chr_file blk_file }");
lines.gres(" socket_class_set","{ tcp_socket udp_socket rawip_socket netlink_socket packet_socket unix_stream_socket unix_dgram_socket appletalk_socket netlink_route_socket netlink_firewall_socket netlink_tcpdiag_socket netlink_nflog_socket netlink_xfrm_socket netlink_selinux_socket netlink_audit_socket netlink_ip6fw_socket netlink_dnrt_socket netlink_kobject_uevent_socket }");
lines.gres(" dgram_socket_class_set","{ udp_socket unix_dgram_socket }");
lines.gres(" stream_socket_class_set","{ tcp_socket unix_stream_socket }");
lines.gres(" unpriv_socket_class_set","{ tcp_socket udp_socket unix_stream_socket unix_dgram_socket }");
lines.gres(" stat_file_perms","{ getattr }");
lines.gres(" x_file_perms","{ getattr execute }");
lines.gres(" r_file_perms","{ read getattr lock ioctl }");
lines.gres(" rx_file_perms","{ read getattr lock execute ioctl }");
lines.gres(" ra_file_perms","{ ioctl read getattr lock append }");
lines.gres(" link_file_perms","{ getattr link unlink rename }");
lines.gres(" create_lnk_perms","{ create read getattr setattr link unlink rename }");
lines.gres(" create_file_perms","{ create ioctl read getattr lock write setattr append link unlink rename }");
lines.gres(" r_dir_perms","{ read getattr lock search ioctl }");
lines.gres(" rw_dir_perms","{ read getattr lock search ioctl add_name remove_name write }");
lines.gres(" ra_dir_perms","{ read getattr lock search ioctl add_name write }");
lines.gres(" create_dir_perms","{ create read getattr lock setattr ioctl link unlink rename search add_name remove_name reparent write rmdir }");
lines.gres(" mount_fs_perms","{ mount remount unmount getattr }");
lines.gres(" rw_socket_perms","{ ioctl read getattr write setattr append bind connect getopt setopt shutdown }");
lines.gres(" create_socket_perms","{ create rw_socket_perms }");
lines.gres(" rw_stream_socket_perms","{ rw_socket_perms listen accept }");
lines.gres(" create_stream_socket_perms","{ create_socket_perms listen accept }");
lines.gres(" connected_socket_perms","{ create ioctl read getattr write setattr append bind getopt setopt shutdown }");
lines.gres(" connected_stream_socket_perms","{ connected_socket_perms listen accept }");
lines.gres(" create_netlink_socket_perms","{ create_socket_perms nlmsg_read nlmsg_write }");
lines.gres(" rw_netlink_socket_perms","{ create_socket_perms nlmsg_read nlmsg_write }");
lines.gres(" r_netlink_socket_perms","{ create_socket_perms nlmsg_read }");
lines.gres(" signal_perms","{ sigchld sigkill sigstop signull signal }");
lines.gres(" packet_perms","{ tcp_recv tcp_send udp_recv udp_send rawip_recv rawip_send }");
lines.gres(" r_sem_perms","{ associate getattr read unix_read }");
lines.gres(" rw_sem_perms","{ associate getattr read write unix_read unix_write }");
lines.gres(" create_sem_perms","{ associate getattr setattr create destroy read write unix_read unix_write }");
lines.gres(" r_msgq_perms","{ associate getattr read unix_read }");
lines.gres(" rw_msgq_perms","{ associate getattr read write enqueue unix_read unix_write }");
lines.gres(" create_msgq_perms","{ associate getattr setattr create destroy read write enqueue unix_read unix_write }");
lines.gres(" r_shm_perms","{ associate getattr read unix_read }");
lines.gres(" rw_shm_perms","{ associate getattr read write lock unix_read unix_write }");
lines.gres(" create_shm_perms","{ associate getattr setattr create destroy read write lock unix_read unix_write }");
lines.gres(" getattr_dir_perms","{ getattr }");
lines.gres(" setattr_dir_perms","{ setattr }");
lines.gres(" search_dir_perms","{ getattr search }");
lines.gres(" list_dir_perms","{ getattr search read lock ioctl }");
lines.gres(" add_entry_dir_perms","{ getattr search lock ioctl write add_name }");
lines.gres(" del_entry_dir_perms","{ getattr search lock ioctl write remove_name }");
lines.gres(" create_dir_perms","{ getattr create }");
lines.gres(" rename_dir_perms","{ getattr rename }");
lines.gres(" delete_dir_perms","{ getattr rmdir }");
lines.gres(" manage_dir_perms","{ create getattr setattr read write link unlink rename search add_name remove_name reparent rmdir lock ioctl }");
lines.gres(" relabelfrom_dir_perms","{ getattr relabelfrom }");
lines.gres(" relabelto_dir_perms","{ getattr relabelto }");
lines.gres(" relabel_dir_perms","{ getattr relabelfrom relabelto }");
lines.gres(" getattr_file_perms","{ getattr }");
lines.gres(" setattr_file_perms","{ setattr }");
lines.gres(" read_file_perms","{ getattr read lock ioctl }");
lines.gres(" mmap_file_perms","{ getattr read execute }");
lines.gres(" exec_file_perms","{ getattr read execute execute_no_trans }");
lines.gres(" append_file_perms","{ getattr append lock ioctl }");
lines.gres(" write_file_perms","{ getattr write append lock ioctl }");
lines.gres(" rw_file_perms","{ getattr read write append ioctl lock }");
lines.gres(" create_file_perms","{ getattr create }");
lines.gres(" rename_file_perms","{ getattr rename }");
lines.gres(" delete_file_perms","{ getattr unlink }");
lines.gres(" manage_file_perms","{ create getattr setattr read write append rename link unlink ioctl lock }");
lines.gres(" relabelfrom_file_perms","{ getattr relabelfrom }");
lines.gres(" relabelto_file_perms","{ getattr relabelto }");
lines.gres(" relabel_file_perms","{ getattr relabelfrom relabelto }");
lines.gres(" getattr_lnk_file_perms","{ getattr }");
lines.gres(" setattr_lnk_file_perms","{ setattr }");
lines.gres(" read_lnk_file_perms","{ getattr read }");
lines.gres(" write_lnk_file_perms","{ getattr write lock ioctl }");
lines.gres(" rw_lnk_file_perms","{ getattr read write lock ioctl }");
lines.gres(" create_lnk_file_perms","{ create getattr }");
lines.gres(" rename_lnk_file_perms","{ getattr rename }");
lines.gres(" delete_lnk_file_perms","{ getattr unlink }");
lines.gres(" manage_lnk_file_perms","{ create read getattr setattr unlink rename }");
lines.gres(" relabelfrom_lnk_file_perms","{ getattr relabelfrom }");
lines.gres(" relabelto_lnk_file_perms","{ getattr relabelto }");
lines.gres(" relabel_lnk_file_perms","{ getattr relabelfrom relabelto }");
lines.gres(" getattr_fifo_file_perms","{ getattr }");
lines.gres(" setattr_fifo_file_perms","{ setattr }");
lines.gres(" read_fifo_file_perms","{ getattr read lock ioctl }");
lines.gres(" append_fifo_file_perms","{ getattr append lock ioctl }");
lines.gres(" write_fifo_file_perms","{ getattr write append lock ioctl }");
lines.gres(" rw_fifo_file_perms","{ getattr read write append ioctl lock }");
lines.gres(" create_fifo_file_perms","{ getattr create }");
lines.gres(" rename_fifo_file_perms","{ getattr rename }");
lines.gres(" delete_fifo_file_perms","{ getattr unlink }");
lines.gres(" manage_fifo_file_perms","{ create getattr setattr read write append rename link unlink ioctl lock }");
lines.gres(" relabelfrom_fifo_file_perms","{ getattr relabelfrom }");
lines.gres(" relabelto_fifo_file_perms","{ getattr relabelto }");
lines.gres(" relabel_fifo_file_perms","{ getattr relabelfrom relabelto }");
lines.gres(" getattr_sock_file_perms","{ getattr }");
lines.gres(" setattr_sock_file_perms","{ setattr }");
lines.gres(" read_sock_file_perms","{ getattr read }");
lines.gres(" write_sock_file_perms","{ getattr write append }");
lines.gres(" rw_sock_file_perms","{ getattr read write append }");
lines.gres(" create_sock_file_perms","{ getattr create }");
lines.gres(" rename_sock_file_perms","{ getattr rename }");
lines.gres(" delete_sock_file_perms","{ getattr unlink }");
lines.gres(" manage_sock_file_perms","{ create getattr setattr read write rename link unlink ioctl lock append }");
lines.gres(" relabelfrom_sock_file_perms","{ getattr relabelfrom }");
lines.gres(" relabelto_sock_file_perms","{ getattr relabelto }");
lines.gres(" relabel_sock_file_perms","{ getattr relabelfrom relabelto }");
lines.gres(" getattr_blk_file_perms","{ getattr }");
lines.gres(" setattr_blk_file_perms","{ setattr }");
lines.gres(" read_blk_file_perms","{ getattr read lock ioctl }");
lines.gres(" append_blk_file_perms","{ getattr append lock ioctl }");
lines.gres(" write_blk_file_perms","{ getattr write append lock ioctl }");
lines.gres(" rw_blk_file_perms","{ getattr read write append ioctl lock }");
lines.gres(" create_blk_file_perms","{ getattr create }");
lines.gres(" rename_blk_file_perms","{ getattr rename }");
lines.gres(" delete_blk_file_perms","{ getattr unlink }");
lines.gres(" manage_blk_file_perms","{ create getattr setattr read write append rename link unlink ioctl lock }");
lines.gres(" relabelfrom_blk_file_perms","{ getattr relabelfrom }");
lines.gres(" relabelto_blk_file_perms","{ getattr relabelto }");
lines.gres(" relabel_blk_file_perms","{ getattr relabelfrom relabelto }");
lines.gres(" getattr_chr_file_perms","{ getattr }");
lines.gres(" setattr_chr_file_perms","{ setattr }");
lines.gres(" read_chr_file_perms","{ getattr read lock ioctl }");
lines.gres(" append_chr_file_perms","{ getattr append lock ioctl }");
lines.gres(" write_chr_file_perms","{ getattr write append lock ioctl }");
lines.gres(" rw_chr_file_perms","{ getattr read write append ioctl lock }");
lines.gres(" create_chr_file_perms","{ getattr create }");
lines.gres(" rename_chr_file_perms","{ getattr rename }");
lines.gres(" delete_chr_file_perms","{ getattr unlink }");
lines.gres(" manage_chr_file_perms","{ create getattr setattr read write append rename link unlink ioctl lock }");
lines.gres(" relabelfrom_chr_file_perms","{ getattr relabelfrom }");
lines.gres(" relabelto_chr_file_perms","{ getattr relabelto }");
lines.gres(" relabel_chr_file_perms","{ getattr relabelfrom relabelto }");
lines.gres(" rw_term_perms","{ getattr read write ioctl }");
lines.gres(" client_stream_socket_perms","{ create ioctl read getattr write setattr append bind getopt setopt shutdown }");
lines.gres(" server_stream_socket_perms","{ client_stream_socket_perms listen accept }");
				
				lines.sort();
				//meke it unique there is no unique function, so...
				QTextStream stream_w( &file_w );
				for ( it = lines.begin(); it != lines.end(); ++it ){
				    it_str = *it;
				    if(it_comp_str != it_str){
					stream_w << *it << "\n";
				    }
				    it_comp_str = *it;
				}
				file.close();
				lines.clear();
				++it_d;
			}else{
				//do nothing
			}
		}
	}
	file_w.close();
	make_selpaw_types_all();
}

//should be called from make_refine_selpaw
void Selpaw::make_selpaw_types_all()
{

	//change path as you wish.
	/////////////////////////////////////////////////////////////
	path = "./";
	path_to_be_written = "selpaw_types_all.txt";
	/////////////////////////////////////////////////////////////
	forward_slash = "/";
	dir.setPath(path);
	dir_name = dir.absPath();

	file_w.setName(path_to_be_written);
	/////////////////////////////////////////////////////////////
	dir.setFilter( QDir::Files );
        dir.setSorting( QDir::Name );
	files = dir.entryList("selpaw*types.txt");
	/////////////////////////////////////////////////////////////
	it_d = files.begin();
	if (file_w.exists()) {
		file_w.remove();
	}
	cumma =",";
	if ( file_w.open( IO_WriteOnly | IO_Append ) ) {
		while(it_d != files.end()){
			name = *it_d;
			file_interface_name = dir_name + forward_slash + name;
			QFile file( file_interface_name );
			if ( file.open( IO_ReadOnly ) ) {
				QTextStream stream( &file );
				//////////files_pattern/////////////////////////////////////////////
				
				
				QRegExp rx_interface4("\\$1"); 		
				
				////////////////////////////////////////////
				//QRegExp rx_can_exec("can_exec");
				while ( !stream.atEnd() ) {
					line_analized = stream.readLine(); // line of text excluding '\n'
					lines += line_analized;
				}
				// it should have space otherwise getattr_dir_perms and r_dir_perms would collide
				lines.sort();
				//meke it unique there is no unique function, so...
				QTextStream stream_w( &file_w );
				for ( it = lines.begin(); it != lines.end(); ++it ){
				    it_str = *it;
				    if(it_comp_str != it_str){
					stream_w << *it << "\n";
				    }
				    it_comp_str = *it;
				}
				file.close();
				lines.clear();
				++it_d;
			}else{
				//do nothing
			}
		}
	}
	file_w.close();
	make_selpaw_types_all_interfaces();
}//end-make_selpaw_types_all

//should be called from make_selpaw_types_all
void Selpaw::make_selpaw_types_all_interfaces()
{

	//change path as you wish.
	/////////////////////////////////////////////////////////////
	path = "./";
	path_to_be_written = "selpaw_types_all_interfaces.txt";
	/////////////////////////////////////////////////////////////
	forward_slash = "/";
	dir.setPath(path);
	dir_name = dir.absPath();

	file_w.setName(path_to_be_written);
	/////////////////////////////////////////////////////////////
	dir.setFilter( QDir::Files );
        dir.setSorting( QDir::Name );
	files = dir.entryList("interfaces*.txt");
	/////////////////////////////////////////////////////////////
	it_d = files.begin();
	if (file_w.exists()) {
		file_w.remove();
	}
	cumma =",";
	if ( file_w.open( IO_WriteOnly | IO_Append ) ) {
		while(it_d != files.end()){
			name = *it_d;
			layer_name = name;
			layer_name = layer_name.replace("interfaces_","");
			layer_name = layer_name.replace(".txt","");
			layer_name = layer_name.replace("_broken_up","");
			file_interface_name = dir_name + forward_slash + name;
			QFile file( file_interface_name );
			if ( file.open( IO_ReadOnly ) ) {
				QTextStream stream( &file );
				//////////files_pattern/////////////////////////////////////////////
				
				QRegExp rx_interface4("\\(\\$1\\)"); 	
				QRegExp rx_colon(":");
				QRegExp rx_if_file_name("^:");
				QRegExp rx_if(".if");
				QRegExp rx_gen_require("^\\[gen_require\\]");
				QRegExp rx_interface("^[a-zA-Z]");
				
				if(layer_name != "kernel_prepare"){
					while ( !stream.atEnd() ) {

						line_analized = stream.readLine(); // line of text excluding '\n'

						if(line_analized.find( rx_interface, 0) != -1){
							interface_name_this = line_analized;	
						}
						if(line_analized.find( rx_if_file_name, 0) != -1){
							line_analized = line_analized.replace(":","");
							interface_file_name_this = line_analized.replace(".if","");
						}
						if(line_analized.find( rx_interface4, 0) != -1){
							line_analized = line_analized.stripWhiteSpace();
							lines += layer_name + cumma + interface_file_name_this + cumma + interface_name_this + cumma + line_analized.replace("($1)","");
							//lines += line_analized;
						}
					}
				}
				// it should have space otherwise getattr_dir_perms and r_dir_perms would collide
				lines.sort();
				//meke it unique there is no unique function, so...
				QTextStream stream_w( &file_w );
				for ( it = lines.begin(); it != lines.end(); ++it ){
				    it_str = *it;
				    if(it_comp_str != it_str){
					stream_w << *it << "\n";
				    }
				    it_comp_str = *it;
				}
				file.close();
				lines.clear();
				++it_d;
			}else{
				//do nothing
			}
		}
	}
	file_w.close();
}//end-make_selpaw_types_all_interfaces
