/*
 * segatex SELinux tool.
 *
 * Copyright (C) 2007 Shintaro Fujiwara 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * */

#include <qlayout.h>
#include <qpushbutton.h>
#include <qprocess.h>

#include "segatex_audit2allow_process.h"

//#include <iostream>
//using namespace std;

//default constructor
SegatexAudit2allowProcess::SegatexAudit2allowProcess(QWidget *parent, const char *name): QDialog(parent, name)
{
	setCaption(tr("Audit2allow Process"));
	textEdit1 = new QTextEdit(this);
	textEdit1->setPaletteBackgroundColor(QColor(174,187,255));
	closeButton = new QPushButton(tr("close"), this);
	closeButton->setDefault(true);
	//closing yum_process button
	connect(closeButton, SIGNAL(clicked()), this, SLOT(close()));
	connect(closeButton, SIGNAL(clicked()), this, SLOT(close_button_clicked()));

	QVBoxLayout *headLayout = new QVBoxLayout;
	headLayout->addWidget(textEdit1);

	QHBoxLayout *footLayout = new QHBoxLayout;
	footLayout->addStretch(1);
	footLayout->addWidget(closeButton);

	QVBoxLayout *mainLayout = new QVBoxLayout(this);
	mainLayout->setMargin(11);
	mainLayout->setSpacing(6);
	mainLayout->addLayout(headLayout);
	mainLayout->addLayout(footLayout);
	resize(600,500);

	audit2allow_base_process();

}
void SegatexAudit2allowProcess::close_button_clicked()
{
	emit audit2allow_prosess_close_button_clicked();

}
void SegatexAudit2allowProcess::readFromStdout()
{
	QByteArray data = process->readStdout();
	QString text = textEdit1->text() + QString(data);
	textEdit1->setText(text);
}
void SegatexAudit2allowProcess::processExited()
{
	if(process->normalExit()){
		textEdit1->append(tr("audit2allow process ended !"));
		textEdit1->append(tr("\n"));
	} else {
		textEdit1->append(tr("audit2allow process had an error !"));
		textEdit1->append(tr("\n"));
	}
	delete process;
	process = 0;
	this->setEnabled(true);
}
void SegatexAudit2allowProcess::audit2allow_base_process()
{
	this->setEnabled(false);
	process = new QProcess(this);
	process->addArgument("audit2allow");
	process->addArgument("-m");
	process->addArgument("local");
	process->addArgument("-a");
	connect(process, SIGNAL(readyReadStdout()),this,SLOT(readFromStdout()));
	//connect(process, SIGNAL(readyReadStderr()),this,SLOT(updateOutputTextEdit()));
	connect(process, SIGNAL(processExited()),this,SLOT(processExited()));
	process->start();
}
