/*
 * segatex_editor SELinux tool.
 *
 * Copyright (C) 2007 Shintaro Fujiwara 
 * shintaro.fujiwara@gmai.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * */

#include "selpaw_adjust.h"

//for debug
//#include <iostream>
//using namespace std;

//default constructor
SelpawAdjust::SelpawAdjust(){}
//constructor for Layout
SelpawAdjust::SelpawAdjust(QSplitter*&){}

void SelpawAdjust::adjust_selpaw_ready()
{

	//change path as you wish.
	/////////////////////////////////////////////////////////////
	path = "./";
	path_to_be_written = "selpaw_eliminated_interfaces.csv";
	/////////////////////////////////////////////////////////////
	forward_slash = "/";
	dir.setPath(path);
	dir_name = dir.absPath();

	file_w.setName(path_to_be_written);
	/////////////////////////////////////////////////////////////
	dir.setFilter( QDir::Files );
        dir.setSorting( QDir::Name );
	files = dir.entryList("selpaw_interface_raw.csv");
	/////////////////////////////////////////////////////////////
	it_d = files.begin();
	if (file_w.exists()) {
		file_w.remove();
	}
	cumma =",";
	if ( file_w.open( IO_WriteOnly | IO_Append ) ) {
		while(it_d != files.end()){
			name = *it_d;
			file_interface_name = dir_name + forward_slash + name;
			QFile file( file_interface_name );
			if ( file.open( IO_ReadOnly ) ) {
				QTextStream stream( &file );
				////////////////////////////////////////////
				
				QRegExp rx_interface4("\\$1"); 		
				QRegExp rx_interface5("\\$2"); 		
				QRegExp rx_interface6("\\$3"); 		
				QRegExp rx_interface7("\\$4"); 		
				
				////////////////////////////////////////////
				while ( !stream.atEnd() ) {
					line_analized = stream.readLine(); // line of text excluding '\n'
					layer_name = line_analized.section( ',',0, 0 );   // s == "surname"
					interface_name_this = line_analized.section( ',',2, 2 );   // s == "surname"

					if(
						(line_analized.find( rx_interface5, 0) != -1)||
						(line_analized.find( rx_interface6, 0) != -1)|| 
						(line_analized.find( rx_interface7, 0) != -1) 
					){
						lines_interface_name += interface_name_this;
					}
				}

				lines_interface_name.sort();
				//meke it unique there is no unique function, so...
				QTextStream stream_w( &file_w );
				for ( it = lines_interface_name.begin(); it != lines_interface_name.end(); ++it ){
				    it_str = *it;
				    if(it_comp_str != it_str){
					stream_w << *it << "\n";
				    }
				    it_comp_str = *it;
				}
				file.close();
				lines_interface_name.clear();
				++it_d;
			}else{
				//do nothing
			}
		}
	}
	file_w.close();
}

void SelpawAdjust::adjust_selpaw()
{
	//change path as you wish.
	/////////////////////////////////////////////////////////////
	path = "./";
	path_to_be_written = "selpaw_interface_ready.csv";
	/////////////////////////////////////////////////////////////
	forward_slash = "/";
	dir.setPath(path);
	dir_name = dir.absPath();

	file_w.setName(path_to_be_written);
	/////////////////////////////////////////////////////////////
	dir.setFilter( QDir::Files );
        dir.setSorting( QDir::Name );
	files = dir.entryList("selpaw_interface_raw.csv");
	/////////////////////////////////////////////////////////////
	it_d = files.begin();
	if (file_w.exists()) {
		file_w.remove();
	}
	cumma =",";
	if ( file_w.open( IO_WriteOnly | IO_Append ) ) {
		while(it_d != files.end()){
			name = *it_d;
			file_interface_name = dir_name + forward_slash + name;
			QFile file( file_interface_name );
			if ( file.open( IO_ReadOnly ) ) {
				QTextStream stream( &file );
				////////////////////////////////////////////
				
				QRegExp rx_interface4("\\$1"); 		
				QRegExp rx_interface5("\\$2"); 		
				QRegExp rx_interface6("\\$3"); 		
				QRegExp rx_interface7("\\$4"); 		
				QRegExp rx_aide_run("aide_run");
				QRegExp rx_amanda_run_recover("amanda_run_recover");
				QRegExp rx_amavis_spool_filetrans("amavis_spool_filetrans");
				QRegExp rx_amtu_run("amtu_run");
				QRegExp rx_apache_run_helper("apache_run_helper");
				QRegExp rx_apt_run("apt_run");
				QRegExp rx_auth_domtrans_login_program("auth_domtrans_login_program");
				QRegExp rx_auth_run_pam("auth_run_pam");
				QRegExp rx_auth_run_utempter("auth_run_utempter");
				QRegExp rx_backup_run("backup_run");
				QRegExp rx_bind_run_ndc("bind_run_ndc");
				QRegExp rx_bluetooth_run_helper("bluetooth_run_helper");
				QRegExp rx_bootloader_run("bootloader_run");
				QRegExp rx_certwatach_run("certwatach_run");
				QRegExp rx_clock_run("clock_run");
				QRegExp rx_clockspeed_run_cli("clockspeed_run_cli");
				QRegExp rx_consoletype_run("consoletype_run");
				QRegExp rx_dcc_run_cdcc("dcc_run_cdcc");
				QRegExp rx_dcc_run_client("dcc_run_client");
				QRegExp rx_dcc_run_dbclean("dcc_run_dbclean");
				QRegExp rx_ddcprobe_run("ddcprobe_run");
				QRegExp rx_dev_filetrans("dev_filetrans");
				QRegExp rx_dmidecode_run("dmidecode_run");
				QRegExp rx_domain_entry_file("domain_entry_file");
				QRegExp rx_dpkg_run("dpkg_run");
				QRegExp rx_ethereal_run_tethereal("ethereal_run_tethereal");
				QRegExp rx_evolution_alarm_dbus_chat("evolution_alarm_dbus_chat");
				QRegExp rx_evolution_dbus_chat("evolution_dbus_chat");
				QRegExp rx_files_boot_filetrans("files_boot_filetrans");
				QRegExp rx_files_etc_filetrans("files_etc_filetrans");
				QRegExp rx_files_etc_filetrans_etc_runtime("files_etc_filetrans_etc_runtime");
				QRegExp rx_files_home_filetrans("files_home_filetrans");
				QRegExp rx_files_kernel_modules_filetrans("files_kernel_modules_filetrans");
				QRegExp rx_files_lock_filetrans("files_lock_filetrans");
				QRegExp rx_files_manage_all_files("files_manage_all_files");
				QRegExp rx_files_pid_filetrans("files_pid_filetrans");
				QRegExp rx_files_read_all_dirs_except("files_read_all_dirs_except");
				QRegExp rx_files_read_all_files_except("files_read_all_files_except");
				QRegExp rx_files_read_all_symlinks_except("files_read_all_symlinks_except");
				QRegExp rx_files_relabel_all_files("files_relabel_all_files");
				QRegExp rx_files_root_filetrans("files_root_filetrans");
				QRegExp rx_files_spool_filetrans("files_spool_filetrans");
				QRegExp rx_files_tmp_filetrans("files_tmp_filetrans");
				QRegExp rx_files_usr_filetrans("files_usr_filetrans");
				QRegExp rx_files_var_filetrans("files_var_filestrans");
				QRegExp rx_files_var_lib_filetrans("files_var_lib_filetrans");
				QRegExp rx_firstboot_run("firstboot_run");
				QRegExp rx_fs_tmpfs_filetrans("fs_tmpfs_filetrans");
				QRegExp rx_fstools_run("fstools_run");
				QRegExp rx_hostname_run("hostname_run");
				QRegExp rx_inetd_core_service_domain("inetd_core_services_domain");
				QRegExp rx_init_daemon_domain("init_daemon_domain");
				QRegExp rx_init_domain("init_domain");
				QRegExp rx_init_run_daemon("init_run_daemon");
				QRegExp rx_init_script_tmp_filetrans("init_script_tmp_filetrans");
				QRegExp rx_init_system_domain("init_system_domain");
				QRegExp rx_ipsec_run_setkey("ipsec_run_setkey");
				QRegExp rx_iptables_run("iptables_run");
				QRegExp rx_kernel_domtrans_to("kernel_domtrans_to");
				QRegExp rx_kudzu_run("kudzu_run");
				QRegExp rx_lib_filetrans_shared_lib("lib_filetrans_shared_lib");
				QRegExp rx_libs_run_ldconfig("libs_run_ldconfig");
				QRegExp rx_loadkeys_run("loadkeys_run");
				QRegExp rx_logging_log_filetrans("logging_log_filetrans");
				QRegExp rx_logging_run_auditctl("logging_run_auditctl");
				QRegExp rx_logging_run_auditd("logging_run_auditd");
				QRegExp rx_logrotate_run("logrotate_run");
				QRegExp rx_lpd_run_checkpc("lpd_run_checkpc");
				QRegExp rx_lvm_run("lvm_run");
				QRegExp rx_modutils_run_depmod("modutils_run_depmod");
				QRegExp rx_modutils_run_insmod("modutils_run_insmod");
				QRegExp rx_modutils_run_update_mods("modutils_run_update_mods");
				QRegExp rx_mount_run("mount_run");
				QRegExp rx_mta_spool_filetrans("mta_spool_filetrans");
				QRegExp rx_netlabel_run_mgmt("netlabel_run_mgmt");
				QRegExp rx_netutils_run("netutils_run");
				QRegExp rx_netutils_run_ping("netutils_run_ping");
				QRegExp rx_netutils_run_ping_cond("netutils_run_ping_cond");
				QRegExp rx_netutils_run_traceroute("netutils_run_traceroute");
				QRegExp rx_netutils_run_traceroute_cond("netutils_run_traceroute_cond");
				QRegExp rx_nscd_run("nscd_run");
				QRegExp rx_oav_run_update("oav_run_update");
				QRegExp rx_oddjob_system_entry("oddjob_system_entry");
				QRegExp rx_pcmcia_run_cardctl("pcmcia_run_cardctl");
				QRegExp rx_portage_main_domain("portage_main_domain");
				QRegExp rx_portage_run("portage_run");
				QRegExp rx_portage_run_gcc_config("portage_run_gcc_config");
				QRegExp rx_portmap_run_helper("portmap_run_helper");
				QRegExp rx_postfix_config_filetrans("postfix_config_filetrans");
				QRegExp rx_postfix_run_map("postfix_run_map");
				QRegExp rx_ppp_run("ppp_run");
				QRegExp rx_ppp_run_cond("ppp_run_cond");
				QRegExp rx_qmail_smtpd_service_domain("qmail_smtpd_service_domain");
				QRegExp rx_quota_run("quota_run");
				QRegExp rx_rpm_run("rpm_run");
				QRegExp rx_samba_run_net("samba_run_net");
				QRegExp rx_samba_run_winbind_helper("samba_run_winbind_helper");
				QRegExp rx_seutil_init_script_run_runinit("seutil_init_script_run_runinit");
				QRegExp rx_seutil_run_checkpolicy("seutil_run_checkpolicy");
				QRegExp rx_seutil_run_loadpolicy("seutil_run_loadpolicy");
				QRegExp rx_seutil_run_newrole("seutil_run_newrole");
				QRegExp rx_seutil_run_runinit("seutil_run_runinit");
				QRegExp rx_seutil_run_semanage("seutil_run_semanage");
				QRegExp rx_seutil_run_setfiles("seutil_run_setfiles");
				QRegExp rx_sysnet_dhcp_state_filetrans("sysnet_dhcp_state_filetrans");
				QRegExp rx_sysnet_run_dhcpc("sysnet_run_dhcpc");
				QRegExp rx_sysnet_run_ifconfig("sysnet_run_ifconfig");
				QRegExp rx_tripwire_run_siggen("tripwire_run_siggen");
				QRegExp rx_tripwire_run_tripwire("tripwire_run_tripwire");
				QRegExp rx_tripwire_run_twadmin("tirpwire_run_twadmin");
				QRegExp rx_tripwire_run_twprint("tripwire_run_twprint");
				QRegExp rx_unconfined_domtrans_to("unconfined_domtrans_to");
				QRegExp rx_unconfined_run("unconfined_run");
				QRegExp rx_usbmodules_run("usbmodules_run");
				QRegExp rx_userdom_generic_user_home_dir_filetrans_generic_user_home_content("userdom_generic_user_home_dir_filetrans_generic_user_home_content");
				QRegExp rx_userdom_sysadm_home_dir_filetrans("userdom_sysadm_home_dir_filetrans");
				QRegExp rx_usermanage_run_admin_passwd("usermanage_run_admin_passwd");
				QRegExp rx_usermanage_run_chfn("usermanage_run_chfn");
				QRegExp rx_usermanage_run_groupadd("usermanage_run_groupadd");
				QRegExp rx_usermanage_run_passwd("usermanage_run_passwd");
				QRegExp rx_usermanage_run_useradd("usermanage_run_useradd");
				QRegExp rx_usernetctl_run("usernetctl_run");
				QRegExp rx_vpn_run("vpn_run");
				QRegExp rx_webalizer_run("webalizer_run");
				QRegExp rx_yam_run("yam_run");

				cumma = ",";
				
				////////////////////////////////////////////
				while ( !stream.atEnd() ) {
					line_analized = stream.readLine(); // line of text excluding '\n'
					layer_name = line_analized.section( ',',0, 0 );   // s == "surname"
					interface_name_this = line_analized.section( ',',2, 2 );   // s == "surname"

					if(
						(line_analized.find( rx_interface5, 0) != -1)||
						(line_analized.find( rx_aide_run, 0) != -1)||
						(line_analized.find( rx_amanda_run_recover, 0) != -1)||
						(line_analized.find( rx_amavis_spool_filetrans, 0) != -1)||
						(line_analized.find( rx_amtu_run, 0) != -1)||
						(line_analized.find( rx_apache_run_helper, 0) != -1)||
						(line_analized.find( rx_apt_run, 0) != -1)||
						(line_analized.find( rx_auth_domtrans_login_program, 0) != -1)||
						(line_analized.find( rx_auth_run_pam, 0) != -1)||
						(line_analized.find( rx_auth_run_utempter, 0) != -1)||
						(line_analized.find( rx_backup_run, 0) != -1)||
						(line_analized.find( rx_bind_run_ndc, 0) != -1)||
						(line_analized.find( rx_bluetooth_run_helper, 0) != -1)||
						(line_analized.find( rx_bootloader_run, 0) != -1)||
						(line_analized.find( rx_certwatach_run, 0) != -1)||
						(line_analized.find( rx_clock_run, 0) != -1)||
						(line_analized.find( rx_clockspeed_run_cli, 0) != -1)||
						(line_analized.find( rx_consoletype_run, 0) != -1)||
						(line_analized.find( rx_dcc_run_cdcc, 0) != -1)||
						(line_analized.find( rx_dcc_run_client, 0) != -1)||
						(line_analized.find( rx_dcc_run_dbclean, 0) != -1)||
						(line_analized.find( rx_ddcprobe_run, 0) != -1)||
						(line_analized.find( rx_dev_filetrans, 0) != -1)||
						(line_analized.find( rx_dmidecode_run, 0) != -1)||
						(line_analized.find( rx_domain_entry_file, 0) != -1)||
						(line_analized.find( rx_dpkg_run, 0) != -1)||
						(line_analized.find( rx_ethereal_run_tethereal, 0) != -1)||
						(line_analized.find( rx_evolution_alarm_dbus_chat, 0) != -1)||
						(line_analized.find( rx_evolution_dbus_chat, 0) != -1)||
						(line_analized.find( rx_files_boot_filetrans, 0) != -1)||
						(line_analized.find( rx_files_etc_filetrans, 0) != -1)||
						(line_analized.find( rx_files_etc_filetrans_etc_runtime, 0) != -1)||
						(line_analized.find( rx_files_home_filetrans, 0) != -1)||
						(line_analized.find( rx_files_kernel_modules_filetrans, 0) != -1)||
						(line_analized.find( rx_files_lock_filetrans, 0) != -1)||
						(line_analized.find( rx_files_manage_all_files, 0) != -1)||
						(line_analized.find( rx_files_pid_filetrans, 0) != -1)||
						(line_analized.find( rx_files_read_all_dirs_except, 0) != -1)||
						(line_analized.find( rx_files_read_all_files_except, 0) != -1)||
						(line_analized.find( rx_files_read_all_symlinks_except, 0) != -1)||
						(line_analized.find( rx_files_relabel_all_files, 0) != -1)||
						(line_analized.find( rx_files_root_filetrans, 0) != -1)||
						(line_analized.find( rx_files_spool_filetrans, 0) != -1)||
						(line_analized.find( rx_files_tmp_filetrans, 0) != -1)||
						(line_analized.find( rx_files_usr_filetrans, 0) != -1)||
						(line_analized.find( rx_files_var_filetrans, 0) != -1)||
						(line_analized.find( rx_files_var_lib_filetrans, 0) != -1)||
						(line_analized.find( rx_firstboot_run, 0) != -1)||
						(line_analized.find( rx_fs_tmpfs_filetrans, 0) != -1)||
						(line_analized.find( rx_fstools_run, 0) != -1)||
						(line_analized.find( rx_hostname_run, 0) != -1)||
						(line_analized.find( rx_inetd_core_service_domain, 0) != -1)||
						(line_analized.find( rx_init_daemon_domain, 0) != -1)||
						(line_analized.find( rx_init_domain, 0) != -1)||
						(line_analized.find( rx_init_run_daemon, 0) != -1)||
						(line_analized.find( rx_init_script_tmp_filetrans, 0) != -1)||
						(line_analized.find( rx_init_system_domain, 0) != -1)||
						(line_analized.find( rx_ipsec_run_setkey, 0) != -1)||
						(line_analized.find( rx_iptables_run, 0) != -1)||
						(line_analized.find( rx_kernel_domtrans_to, 0) != -1)||
						(line_analized.find( rx_kudzu_run, 0) != -1)||
						(line_analized.find( rx_lib_filetrans_shared_lib, 0) != -1)||
						(line_analized.find( rx_libs_run_ldconfig, 0) != -1)||
						(line_analized.find( rx_loadkeys_run, 0) != -1)||
						(line_analized.find( rx_logging_log_filetrans, 0) != -1)||
						(line_analized.find( rx_logging_run_auditctl, 0) != -1)||
						(line_analized.find( rx_logging_run_auditd, 0) != -1)||
						(line_analized.find( rx_logrotate_run, 0) != -1)||
						(line_analized.find( rx_lpd_run_checkpc, 0) != -1)||
						(line_analized.find( rx_lvm_run, 0) != -1)||
						(line_analized.find( rx_modutils_run_depmod, 0) != -1)||
						(line_analized.find( rx_modutils_run_insmod, 0) != -1)||
						(line_analized.find( rx_modutils_run_update_mods, 0) != -1)||
						(line_analized.find( rx_mount_run, 0) != -1)||
						(line_analized.find( rx_mta_spool_filetrans, 0) != -1)||
						(line_analized.find( rx_netlabel_run_mgmt, 0) != -1)||
						(line_analized.find( rx_netutils_run, 0) != -1)||
						(line_analized.find( rx_netutils_run_ping, 0) != -1)||
						(line_analized.find( rx_netutils_run_ping_cond, 0) != -1)||
						(line_analized.find( rx_netutils_run_traceroute, 0) != -1)||
						(line_analized.find( rx_netutils_run_traceroute_cond, 0) != -1)||
						(line_analized.find( rx_nscd_run, 0) != -1)||
						(line_analized.find( rx_oav_run_update, 0) != -1)||
						(line_analized.find( rx_oddjob_system_entry, 0) != -1)||
						(line_analized.find( rx_pcmcia_run_cardctl, 0) != -1)||
						(line_analized.find( rx_portage_main_domain, 0) != -1)||
						(line_analized.find( rx_portage_run, 0) != -1)||
						(line_analized.find( rx_portage_run_gcc_config, 0) != -1)||
						(line_analized.find( rx_portmap_run_helper, 0) != -1)||
						(line_analized.find( rx_postfix_config_filetrans, 0) != -1)||
						(line_analized.find( rx_postfix_run_map, 0) != -1)||
						(line_analized.find( rx_ppp_run, 0) != -1)||
						(line_analized.find( rx_ppp_run_cond, 0) != -1)||
						(line_analized.find( rx_qmail_smtpd_service_domain, 0) != -1)||
						(line_analized.find( rx_quota_run, 0) != -1)||
						(line_analized.find( rx_rpm_run, 0) != -1)||
						(line_analized.find( rx_samba_run_net, 0) != -1)||
						(line_analized.find( rx_samba_run_winbind_helper, 0) != -1)||
						(line_analized.find( rx_seutil_init_script_run_runinit, 0) != -1)||
						(line_analized.find( rx_seutil_run_checkpolicy, 0) != -1)||
						(line_analized.find( rx_seutil_run_loadpolicy, 0) != -1)||
						(line_analized.find( rx_seutil_run_newrole, 0) != -1)||
						(line_analized.find( rx_seutil_run_runinit, 0) != -1)||
						(line_analized.find( rx_seutil_run_semanage, 0) != -1)||
						(line_analized.find( rx_seutil_run_setfiles, 0) != -1)||
						(line_analized.find( rx_sysnet_dhcp_state_filetrans, 0) != -1)||
						(line_analized.find( rx_sysnet_run_dhcpc, 0) != -1)||
						(line_analized.find( rx_sysnet_run_ifconfig, 0) != -1)||
						(line_analized.find( rx_tripwire_run_siggen, 0) != -1)||
						(line_analized.find( rx_tripwire_run_tripwire, 0) != -1)||
						(line_analized.find( rx_tripwire_run_twadmin, 0) != -1)||
						(line_analized.find( rx_tripwire_run_twprint, 0) != -1)||
						(line_analized.find( rx_unconfined_domtrans_to, 0) != -1)||
						(line_analized.find( rx_unconfined_run, 0) != -1)||
						(line_analized.find( rx_usbmodules_run, 0) != -1)||
						(line_analized.find( rx_userdom_generic_user_home_dir_filetrans_generic_user_home_content, 0) != -1)||
						(line_analized.find( rx_userdom_sysadm_home_dir_filetrans, 0) != -1)||
						(line_analized.find( rx_usermanage_run_admin_passwd, 0) != -1)||
						(line_analized.find( rx_usermanage_run_chfn, 0) != -1)||
						(line_analized.find( rx_usermanage_run_groupadd, 0) != -1)||
						(line_analized.find( rx_usermanage_run_passwd, 0) != -1)||
						(line_analized.find( rx_usermanage_run_useradd, 0) != -1)||
						(line_analized.find( rx_usernetctl_run, 0) != -1)||
						(line_analized.find( rx_vpn_run, 0) != -1)||
						(line_analized.find( rx_webalizer_run, 0) != -1)||
						(line_analized.find( rx_yam_run, 0) != -1)



					){
						//do nothing
					}else{
						line_analized = line_analized.replace( QRegExp("   "), " " );
						line_analized = line_analized.replace( QRegExp("  "), " " );
						lines += line_analized + cumma;
					}
				}

				lines_interface_name.sort();
				//meke it unique there is no unique function, so...
				QTextStream stream_w( &file_w );
				for ( it = lines.begin(); it != lines.end(); ++it ){
				    it_str = *it;
				    if(it_comp_str != it_str){
					stream_w << *it << "\n";
				    }
				    it_comp_str = *it;
				}
				file.close();
				lines.clear();
				++it_d;
			}else{
				//do nothing
			}
		}
	}
	file_w.close();
}

void SelpawAdjust::refine_selpaw()
{

	//change path as you wish.
	/////////////////////////////////////////////////////////////
	path = "./";
	path_to_be_written = "selpaw_interface.csv";
	/////////////////////////////////////////////////////////////
	forward_slash = "/";
	dir.setPath(path);
	dir_name = dir.absPath();

	file_w.setName(path_to_be_written);
	/////////////////////////////////////////////////////////////
	dir.setFilter( QDir::Files );
        dir.setSorting( QDir::Name );
	files = dir.entryList("selpaw_interface_ready.csv");
	/////////////////////////////////////////////////////////////
	it_d = files.begin();
	if (file_w.exists()) {
		file_w.remove();
	}
	if ( file_w.open( IO_WriteOnly | IO_Append ) ) {
		while(it_d != files.end()){
			name = *it_d;
			file_interface_name = dir_name + forward_slash + name;
			QFile file( file_interface_name );
			if ( file.open( IO_ReadOnly ) ) {
				QTextStream stream( &file );
				////////////////////////////////////////////
				
				QRegExp rx_brace("\\("); 		
				QRegExp rx_type("type"); 		
				QRegExp rx_type2(";:"); 		
				QRegExp rx_type3(";\\$"); 		
				
				////////////////////////////////////////////
				while ( !stream.atEnd() ) {
					line_analized = stream.readLine(); // line of text excluding '\n'

					if(
						( line_analized.find( rx_brace, 0) != -1)||
						( line_analized.find( rx_type, 0) != -1)||
						( line_analized.find( rx_type2, 0) != -1)||
						( line_analized.find( rx_type3, 0) != -1)
					)
					{
						// do nothing	
					}else{
						lines += line_analized;
					}
					
				}

				lines.sort();
				//meke it unique there is no unique function, so...
				
				lines.gres(" ;",";");

				QTextStream stream_w( &file_w );
				for ( it = lines.begin(); it != lines.end(); ++it ){
				    it_str = *it;
				    if(it_comp_str != it_str){
					stream_w << *it << "\n";
				    }
				    it_comp_str = *it;
				}
				file.close();
				lines.clear();
				++it_d;
			}else{
				//do nothing
			}
		}
	}
	file_w.close();
	refine_selpaw_types();
}//end-refine_selpaw

//read selpaw_types_all_interfaces.txt and get section 3,3
//which is a interface which needed in the very interface.
//reg from selpaw_types_all.txt
//remain layer_name,interface_file_name_this and replace after [gen_require]
//after that combine the file with selpaw_types_all.txt
//called from refine_selpaw
void SelpawAdjust::refine_selpaw_types()
{

	//change path as you wish.
	/////////////////////////////////////////////////////////////
	path = "./";
	path_to_be_written = "selpaw_types_all_second.txt";
	/////////////////////////////////////////////////////////////
	forward_slash = "/";
	dir.setPath(path);
	dir_name = dir.absPath();

	file_w.setName(path_to_be_written);
	/////////////////////////////////////////////////////////////
	dir.setFilter( QDir::Files );
        dir.setSorting( QDir::Name );
	files = dir.entryList("selpaw_types_all_interfaces.txt");
	/////////////////////////////////////////////////////////////
	it_d = files.begin();
	if (file_w.exists()) {
		file_w.remove();
	}
	cumma = ",";
	if ( file_w.open( IO_WriteOnly | IO_Append ) ) {
		while(it_d != files.end()){
			name = *it_d;
			file_interface_name = dir_name + forward_slash + name;
			file_interface_gen_require = dir_name + forward_slash + "selpaw_types_all.txt";
			QFile file( file_interface_name );
			QFile file2( file_interface_gen_require);
			if ( file.open( IO_ReadOnly ) ) {
				QTextStream stream( &file );
				////////////////////////////////////////////
			/*	
				QRegExp rx_brace("\\("); 		
				QRegExp rx_type("type"); 		
				QRegExp rx_type2(";:"); 		
				QRegExp rx_type3(";\\$"); 		
			*/
				
				////////////////////////////////////////////
				while ( !stream.atEnd() ) {
					line_analized = stream.readLine(); // line of text excluding '\n'
					layer_name = line_analized.section( ',', 0, 0 ); 
					interface_file_name_this = line_analized.section( ',', 1, 1 ); 
					interface_name_this = line_analized.section( ',', 2, 2 ); 
					interface_name_this_to_be_replaced = line_analized.section( ',', 3, 3 ); 
					QRegExp rx_interface_name_this_to_be_replaced( interface_name_this_to_be_replaced ); 		
					//cout << interface_name_this_to_be_replaced << endl;
					if ( file2.open ( IO_ReadOnly)) {
						QTextStream stream2( &file2 );
						while ( !stream2.atEnd() ) {
							line_analized2 = stream2.readLine(); // line of text excluding '\n'
							//cout << "	" << line_analized2 << endl;
							if( line_analized2.find( rx_interface_name_this_to_be_replaced, 0) != -1){
								//cout << "	" << layer_name + cumma + interface_file_name_this + cumma + interface_name_this + cumma + line_analized2.section( ',', 3 ) << endl;
								lines += layer_name + cumma + interface_file_name_this + cumma + interface_name_this + cumma + line_analized2.section( ',', 3 );
							}
						}
						file2.close();
					}
				
				}

				//lines.sort();
				//make it unique there is no unique function, so...
				//lines.gres(" ;",";");

				QTextStream stream_w( &file_w );
				for ( it = lines.begin(); it != lines.end(); ++it ){
				    it_str = *it;
				    if(it_comp_str != it_str){
					stream_w << *it << "\n";
				    }
				    it_comp_str = *it;
				}
				file.close();
				lines.clear();
				++it_d;
			}else{
				//do nothing
			}
		}
	}
	file_w.close();
	refine_selpaw_types_final();
}//end-refine_selpaw_types

//combine type files and make only one type file
//called from refine_selpaw_types
void SelpawAdjust::refine_selpaw_types_final()
{

	//change path as you wish.
	/////////////////////////////////////////////////////////////
	path = "./";
	path_to_be_written = "selpaw_types_all.txt";
	/////////////////////////////////////////////////////////////
	forward_slash = "/";
	dir.setPath(path);
	dir_name = dir.absPath();

	file_w.setName(path_to_be_written);
	/////////////////////////////////////////////////////////////
	dir.setFilter( QDir::Files );
        dir.setSorting( QDir::Name );
	files = dir.entryList("selpaw_types_all_second.txt");
	/////////////////////////////////////////////////////////////
	it_d = files.begin();
	/*
	if (file_w.exists()) {
		file_w.remove();
	}
	*/
	cumma = ",";
	if ( file_w.open( IO_WriteOnly | IO_Append ) ) {
		while(it_d != files.end()){
			name = *it_d;
			file_interface_name = dir_name + forward_slash + name;
			QFile file( file_interface_name );
			if ( file.open( IO_ReadOnly ) ) {
				QTextStream stream( &file );
				////////////////////////////////////////////
				while ( !stream.atEnd() ) {
					line_analized = stream.readLine(); // line of text excluding '\n'
					lines += line_analized;
				}
				QTextStream stream_w( &file_w );
				for ( it = lines.begin(); it != lines.end(); ++it ){
				    it_str = *it;
				    if(it_comp_str != it_str){
					stream_w << *it << "\n";
				    }
				    it_comp_str = *it;
				}
				file.close();
				lines.clear();
				++it_d;
			}else{
				//do nothing
			}
		}
	}
	file_w.close();
	sort_selpaw_types();
}//end-refine_selpaw_types_final

//sort type file and make it selpaw_type file
//should be called from refine_selpaw_types_final
void SelpawAdjust::sort_selpaw_types()
{

	/////////////////////////////////////////////////////////////
	path = "./";
	path_to_be_written = "selpaw_interface_types.csv";
	/////////////////////////////////////////////////////////////
	forward_slash = "/";
	dir.setPath(path);
	dir_name = dir.absPath();
	file_w.setName(path_to_be_written);
	/////////////////////////////////////////////////////////////
	dir.setFilter( QDir::Files );
        dir.setSorting( QDir::Name );
	files = dir.entryList("selpaw_types_all.txt");
	/////////////////////////////////////////////////////////////
	it_d = files.begin();
	if (file_w.exists()) {
		file_w.remove();
	}
	cumma = ",";
	if ( file_w.open( IO_WriteOnly | IO_Append ) ) {
		while(it_d != files.end()){
			name = *it_d;
			file_interface_name = dir_name + forward_slash + name;
			QFile file( file_interface_name );
			if ( file.open( IO_ReadOnly ) ) {
				QTextStream stream( &file );
				////////////////////////////////////////////
				while ( !stream.atEnd() ) {
					line_analized = stream.readLine(); // line of text excluding '\n'
					lines += line_analized;
				}
				lines.sort();
				QTextStream stream_w( &file_w );
				for ( it = lines.begin(); it != lines.end(); ++it ){
				    it_str = *it;
				    if(it_comp_str != it_str){
					stream_w << *it << "\n";
				    }
				    it_comp_str = *it;
				}
				file.close();
				lines.clear();
				++it_d;
			}else{
				//do nothing
			}
		}
	}
	file_w.close();
	sort_selpaw_summary();
}//end-sort_selpaw_types

//sort summary file and make it selpaw_summary file
//should be called from sort_selpaw_types
void SelpawAdjust::sort_selpaw_summary()
{

	/////////////////////////////////////////////////////////////
	path = "./";
	path_to_be_written = "selpaw_interface_summary.csv";
	/////////////////////////////////////////////////////////////
	forward_slash = "/";
	dir.setPath(path);
	dir_name = dir.absPath();
	file_w.setName(path_to_be_written);
	/////////////////////////////////////////////////////////////
	dir.setFilter( QDir::Files );
        dir.setSorting( QDir::Name );
	files = dir.entryList("selpaw*summary.txt");
	/////////////////////////////////////////////////////////////
	it_d = files.begin();
	if (file_w.exists()) {
		file_w.remove();
	}
	cumma = ",";
	if ( file_w.open( IO_WriteOnly | IO_Append ) ) {
		while(it_d != files.end()){
			name = *it_d;
			file_interface_name = dir_name + forward_slash + name;
			QFile file( file_interface_name );
			if ( file.open( IO_ReadOnly ) ) {
				QTextStream stream( &file );
				////////////////////////////////////////////
				while ( !stream.atEnd() ) {
					line_analized = stream.readLine(); // line of text excluding '\n'
					lines += line_analized;
				}
				lines.sort();
				QTextStream stream_w( &file_w );
				for ( it = lines.begin(); it != lines.end(); ++it ){
				    it_str = *it;
				    if(it_comp_str != it_str){
					stream_w << *it << "\n";
				    }
				    it_comp_str = *it;
				}
				file.close();
				lines.clear();
				++it_d;
			}else{
				//do nothing
			}
		}
	}
	file_w.close();
}//end-sort_selpaw_summary

SelpawAdjust::~SelpawAdjust(){}
