/*
 * segatex_editor SELinux tool.
 *
 * Copyright (C) 2007 Shintaro Fujiwara 
 * shintaro.fujiwara@gmai.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * */

#include "segatex_state.h"

//#include <iostream>
//using namespace std;

//default constructor
SegatexState::SegatexState(){}

/* returns selinux loaded policy as QString*/
QString SegatexState::which_policy()
{

	QRegExp rx_policy_targeted("targeted");
	QRegExp rx_policy_strict("strict");
	QRegExp rx_policy_mls("mls");

	pol_root = selinux_default_type_path();
		
	if( pol_root.find( rx_policy_targeted, 0) != -1){
                installed_policy="targeted";
        }
	if( pol_root.find( rx_policy_strict, 0) != -1){
                installed_policy="strict";
        }
	if( pol_root.find( rx_policy_mls, 0) != -1){
                installed_policy="mls";
        }
        return installed_policy;
}

/* returns selinux is enabled or not as QString*/
QString SegatexState::is_selinux_enabled_segatex()
{
	enabled_or_not = is_selinux_enabled();
	if(enabled_or_not == 1)
		enabled_or_not_str = "enabled";
	else
		enabled_or_not_str = "disabled";

	return enabled_or_not_str;
}

/* returns getenforce as QString*/
QString SegatexState::getenforce_segatex()
{
	getenforce = security_getenforce();
	if(getenforce == 1)
		getenforce_str = "enforcing";
	else
		getenforce_str = "permissive";

	return getenforce_str;
}
