/*
 * segatex_editor SELinux tool.
 *
 * Copyright (C) 2007 Shintaro Fujiwara 
 * shintaro.fujiwara@gmai.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * */

#include <qlayout.h>
#include <qcheckbox.h>
#include <qpushbutton.h>
#include <qtextedit.h>

#include "segatex_apply.h"
#include "mainwindow.h"

#include <iostream>
using namespace std;

//default constructor
SegatexApply::SegatexApply(QWidget *parent, const char *name): QDialog(parent, name)
{
	setCaption(tr("Apply"));
	enforcingCheckBox = new QCheckBox(tr("enforcing"), this);
	permissiveCheckBox = new QCheckBox(tr("permissive"), this);
	applyButton = new QPushButton(tr("&Apply"), this);
	closeButton = new QPushButton(tr("&Close"), this);
	applyButton->setDefault(true);
	//applyButton->setEnabled(false);

	connect(applyButton, SIGNAL(clicked()), this, SLOT(apply_clicked()));
	connect(closeButton, SIGNAL(clicked()), this, SLOT(close()));

	QVBoxLayout *leftLayout = new QVBoxLayout;
	leftLayout->addWidget(enforcingCheckBox);
	leftLayout->addWidget(permissiveCheckBox);

	QVBoxLayout *rightLayout = new QVBoxLayout;
	rightLayout->addWidget(applyButton);
	rightLayout->addWidget(closeButton);
	rightLayout->addStretch(1);

	QHBoxLayout *mainLayout = new QHBoxLayout(this);
	mainLayout->setMargin(11);
	mainLayout->setSpacing(6);
	mainLayout->addLayout(leftLayout);
	mainLayout->addLayout(rightLayout);
}

/*emits signals when apply button is clicked*/
void SegatexApply::apply_clicked()
{
	if(enforcingCheckBox->isOn())
		emit enforcingOn();
	else
		emit permissiveOn();
}

int SegatexApply::setenforce_enforce()
{
	return_value = security_setenforce(1);
	if(return_value == 0){
		emit sestateChanged();
		mainWindow = new MainWindow();
		mainWindow->updateSegatexStateIndicator();
	}
	return return_value;
}
int SegatexApply::setenforce_permissive()
{
	return_value = security_setenforce(0);
	if(return_value == 0){
		emit sestateChanged();
		mainWindow = new MainWindow();
		mainWindow->updateSegatexStateIndicator();
	}
	return return_value;
}
