#include "parselines_misc.h"

//for debug
//#include <iostream>
//using namespace std;

//default constructor
ParseLinesMisc::ParseLinesMisc(){}
//constructor for Layout
ParseLinesMisc::ParseLinesMisc(QSplitter*&){}

void ParseLinesMisc::obj_perm_sets()
{
	/////////////////////////////////////////////////////////////
	path = "refpolicy/policy/support";
	path_to_be_written = "./obj_perm_sets_prepare.txt";

	forward_slash = "/";
	dir.setPath(path);
	dir_name = dir.absPath();

	file_w.setName(path_to_be_written);
	/////////////////////////////////////////////////////////////
	files = dir.entryList("obj_perm_sets.spt");
	/////////////////////////////////////////////////////////////

	it_d = files.begin();
	if (file_w.exists()) {
		file_w.remove();
	}
	if ( file_w.open( IO_WriteOnly | IO_Append ) ) {
		while(it_d != files.end()){
			name = *it_d;
			file_interface_name = dir_name + forward_slash + name;
			QFile file( file_interface_name );


			if ( file.open( IO_ReadOnly ) ) {
				QTextStream stream( &file );
				QTextStream stream_echo( &file );
				////////////////////////////////////////////
				QRegExp rx_a1("define\\(\\`"); 	
				////////////////////////////////////////////'
				QRegExp rx_a2("\\'\\, \\`"); 
				QRegExp rx_a3("\\'\\,\\`");
				QRegExp rx_a4("\\'\\)");
				QRegExp rx_bracket_last("\\)"); 	
				int i = -1;
				
				while ( !stream.atEnd() ) {
					line = stream.readLine(); // line of text excluding '\n'
					i = line.find( rx_a1, 0);
					if(i != -1){
						line.replace(rx_a1,"");
					        line.replace(rx_a2,"");
						line.replace(rx_a3,"");
						line.replace(rx_a4,"");
						lines_obj_perm_sets += line;//this adds to lines. also append can be used
					}
					
				}
				QTextStream stream_w( &file_w );
				for ( it = lines_obj_perm_sets.begin(); it != lines_obj_perm_sets.end(); ++it ){
					stream_w << *it << "\n";
				}
				file.close();
				lines_obj_perm_sets.clear();
			}else{
				//do nothing
			}
			++it_d;
		}
	}
	file_w.close();    
}//end-obj_perm_sets

//this function should only be called from other functions.
void ParseLinesMisc::file_patterns()
{
	/////////////////////////////////////////////////////////////
	path = "refpolicy/policy/support";
	path_to_be_written = "./file_patterns_prepare.txt";

	forward_slash = "/";
	dir.setPath(path);
	dir_name = dir.absPath();

	file_w.setName(path_to_be_written);
	/////////////////////////////////////////////////////////////
	files = dir.entryList("file_patterns.spt");
	/////////////////////////////////////////////////////////////

	it_d = files.begin();
	if (file_w.exists()) {
		file_w.remove();
	}
	if ( file_w.open( IO_WriteOnly | IO_Append ) ) {
		while(it_d != files.end()){
			name = *it_d;
			file_interface_name = dir_name + forward_slash + name;
			QFile file( file_interface_name );


			if ( file.open( IO_ReadOnly ) ) {
				QTextStream stream( &file );
				QTextStream stream_echo( &file );
				////////////////////////////////////////////
				QRegExp rx_a1("define\\(\\`"); 	
				////////////////////////////////////////////'
				QRegExp rx_a2("\\'\\, \\`"); 
				QRegExp rx_a3("\\'\\,\\`");
				QRegExp rx_a4("\\'\\)");
				QRegExp rx_a5("^\\s[allow]");
				QRegExp rx_a6("^\\s[type]");
				QRegExp rx_bracket_last("\\)"); 	
				int i,j,k = -1;
				while ( !stream.atEnd() ) {
					line = stream.readLine(); // line of text excluding '\n'
					i = line.find( rx_a1, 0);
					if(i != -1){
						line.replace(rx_a1,"");
					        line.replace(rx_a2,"");
						line.replace(rx_a3,"");
						line.replace(rx_a4,"");
						lines_file_patterns += line;//this adds to lines. also append can be used
					}
					j = line.find( rx_a5, 0);
					if(j != -1){
						lines_file_patterns += line;//this adds to lines. also append can be used
					}
					k = line.find( rx_a6, 0);
					if(k != -1){
						lines_file_patterns += line;//this adds to lines. also append can be used
					}

				}
				QTextStream stream_w( &file_w );
				for ( it = lines_file_patterns.begin(); it != lines_file_patterns.end(); ++it ){
					stream_w << *it << "\n";
				}
				file.close();
				lines_file_patterns.clear();
			}else{
				//do nothing
			}
			++it_d;
		}
	}
	file_w.close();    
}//end-file_patterns

//this function should only be called from other functions.
void ParseLinesMisc::analize_file_patterns()
{
        /////////////////////////////////////////////////////////////
	path = "refpolicy/policy/support";
	path_to_be_written_ready = "./obj_perm_sets_analized_ready.txt";
	path_to_be_written = "./file_patterns_analized.txt";
	
	forward_slash = "/";
	dir.setPath(path);
	dir_name = dir.absPath();
	
	dir_name_curr = dir_curr.currentDirPath();
	
	file_w_ready.setName(path_to_be_written_ready);
	file_w.setName(path_to_be_written);
	/////////////////////////////////////////////////////////////
	files = dir.entryList("obj_perm_sets.spt");
	/////////////////////////////////////////////////////////////
	files_to_be_analized = dir.entryList("file_patterns.spt");
	files_to_be_read = dir_curr.entryList("file_patterns_prepare.txt");
	/////////////////////////////////////////////////////////////

	it_d = files.begin();
	/////////////////////////////////////////////////////////////
	it_d_analized = files_to_be_analized.begin();
	it_d_read = files_to_be_read.begin();
	/////////////////////////////////////////////////////////////

	if (file_w_ready.exists()) {
		file_w_ready.remove();
	}
	if (file_w.exists()) {
		file_w.remove();
	}
	if (file_w_ready.open(IO_WriteOnly | IO_Append)){
	    
	    while(it_d != files.end()){
		name = *it_d;
		file_interface_name = dir_name + forward_slash + name;
		QFile file( file_interface_name );

			if ( file.open( IO_ReadOnly ) ) {
				QTextStream stream( &file );
				QTextStream stream_echo( &file );
				////////////////////////////////////////////
				QRegExp rx_a1("define\\(\\`"); 	
				////////////////////////////////////////////'
				QRegExp rx_a2("\\'\\, \\`"); 
				QRegExp rx_a3("\\'\\,\\`");
				QRegExp rx_a4("\\'\\)");
				QRegExp rx_a7("\\#");
				QRegExp rx_bracket_last("\\)"); 	
				int i = -1;
				//line_added = "line_analized.replace";
				line_added = "lines_break.gres";
				double_quote = "\"";
				brace_first = "(";
				brace_end = ")";
				cumma = ",";
				semicolon = ";";
				space = " ";
				line_first = line_added + brace_first + double_quote + space;
				line_middle = double_quote + cumma + double_quote;
				line_end = double_quote + brace_end + semicolon;
				while ( !stream.atEnd() ) {
					line = stream.readLine(); // line of text excluding '\n'
					i = line.find( rx_a1, 0);
					if(i != -1){
						line.replace(rx_a7, "");
					        line.replace(rx_a1,line_first);
					        line.replace(rx_a2,line_middle);
						line.replace(rx_a3,line_middle);
						line.replace(rx_a4,line_end);
											
						lines_analize_file_patterns += line;//this adds to lines. also append can be used
					}
					
				}
				QTextStream stream_w_ready( &file_w_ready );
				for ( it = lines_analize_file_patterns.begin(); it != lines_analize_file_patterns.end(); ++it ){
					stream_w_ready << *it << "\n";
				}
				file.close();
				lines_analize_file_patterns.clear();
			}else{
				//do nothing
			}
			++it_d;
		}
	        file_w_ready.close();   
	}
	//write to analized file.
	if (file_w.open(IO_WriteOnly | IO_Append)){
	    while(it_d_read != files_to_be_read.end()){
		name = *it_d_read;
		file_interface_name_analized = dir_name_curr + forward_slash + name;
		
		//open file to be analized
		QFile file_analized( file_interface_name_analized );

			if ( file_analized.open( IO_ReadOnly ) ) {
				QTextStream stream_analized( &file_analized );
				//QTextStream stream_echo( &file );
				////////////////////////////////////////////
				while ( !stream_analized.atEnd() ) {
					line_analized = stream_analized.readLine(); // line of text excluding '\n'
					lines_break += line_analized;//this adds to lines. also append can be used
				}
// it should have space otherwise getattr_dir_perms and r_dir_perms would collide
lines_break.gres(" dir_file_class_set","{ dir file lnk_file sock_file fifo_file chr_file blk_file }");
lines_break.gres(" file_class_set","{ file lnk_file sock_file fifo_file chr_file blk_file }");
lines_break.gres(" notdevfile_class_set","{ file lnk_file sock_file fifo_file }");
lines_break.gres(" devfile_class_set","{ chr_file blk_file }");
lines_break.gres(" socket_class_set","{ tcp_socket udp_socket rawip_socket netlink_socket packet_socket unix_stream_socket unix_dgram_socket appletalk_socket netlink_route_socket netlink_firewall_socket netlink_tcpdiag_socket netlink_nflog_socket netlink_xfrm_socket netlink_selinux_socket netlink_audit_socket netlink_ip6fw_socket netlink_dnrt_socket netlink_kobject_uevent_socket }");
lines_break.gres(" dgram_socket_class_set","{ udp_socket unix_dgram_socket }");
lines_break.gres(" stream_socket_class_set","{ tcp_socket unix_stream_socket }");
lines_break.gres(" unpriv_socket_class_set","{ tcp_socket udp_socket unix_stream_socket unix_dgram_socket }");
lines_break.gres(" stat_file_perms","{ getattr }");
lines_break.gres(" x_file_perms","{ getattr execute }");
lines_break.gres(" r_file_perms","{ read getattr lock ioctl }");
lines_break.gres(" rx_file_perms","{ read getattr lock execute ioctl }");
lines_break.gres(" ra_file_perms","{ ioctl read getattr lock append }");
lines_break.gres(" link_file_perms","{ getattr link unlink rename }");
lines_break.gres(" create_lnk_perms","{ create read getattr setattr link unlink rename }");
lines_break.gres(" create_file_perms","{ create ioctl read getattr lock write setattr append link unlink rename }");
lines_break.gres(" r_dir_perms","{ read getattr lock search ioctl }");
lines_break.gres(" rw_dir_perms","{ read getattr lock search ioctl add_name remove_name write }");
lines_break.gres(" ra_dir_perms","{ read getattr lock search ioctl add_name write }");
lines_break.gres(" create_dir_perms","{ create read getattr lock setattr ioctl link unlink rename search add_name remove_name reparent write rmdir }");
lines_break.gres(" mount_fs_perms","{ mount remount unmount getattr }");
lines_break.gres(" rw_socket_perms","{ ioctl read getattr write setattr append bind connect getopt setopt shutdown }");
lines_break.gres(" create_socket_perms","{ create rw_socket_perms }");
lines_break.gres(" rw_stream_socket_perms","{ rw_socket_perms listen accept }");
lines_break.gres(" create_stream_socket_perms","{ create_socket_perms listen accept }");
lines_break.gres(" connected_socket_perms","{ create ioctl read getattr write setattr append bind getopt setopt shutdown }");
lines_break.gres(" connected_stream_socket_perms","{ connected_socket_perms listen accept }");
lines_break.gres(" create_netlink_socket_perms","{ create_socket_perms nlmsg_read nlmsg_write }");
lines_break.gres(" rw_netlink_socket_perms","{ create_socket_perms nlmsg_read nlmsg_write }");
lines_break.gres(" r_netlink_socket_perms","{ create_socket_perms nlmsg_read }");
lines_break.gres(" signal_perms","{ sigchld sigkill sigstop signull signal }");
lines_break.gres(" packet_perms","{ tcp_recv tcp_send udp_recv udp_send rawip_recv rawip_send }");
lines_break.gres(" r_sem_perms","{ associate getattr read unix_read }");
lines_break.gres(" rw_sem_perms","{ associate getattr read write unix_read unix_write }");
lines_break.gres(" create_sem_perms","{ associate getattr setattr create destroy read write unix_read unix_write }");
lines_break.gres(" r_msgq_perms","{ associate getattr read unix_read }");
lines_break.gres(" rw_msgq_perms","{ associate getattr read write enqueue unix_read unix_write }");
lines_break.gres(" create_msgq_perms","{ associate getattr setattr create destroy read write enqueue unix_read unix_write }");
lines_break.gres(" r_shm_perms","{ associate getattr read unix_read }");
lines_break.gres(" rw_shm_perms","{ associate getattr read write lock unix_read unix_write }");
lines_break.gres(" create_shm_perms","{ associate getattr setattr create destroy read write lock unix_read unix_write }");
lines_break.gres(" getattr_dir_perms","{ getattr }");
lines_break.gres(" setattr_dir_perms","{ setattr }");
lines_break.gres(" search_dir_perms","{ getattr search }");
lines_break.gres(" list_dir_perms","{ getattr search read lock ioctl }");
lines_break.gres(" add_entry_dir_perms","{ getattr search lock ioctl write add_name }");
lines_break.gres(" del_entry_dir_perms","{ getattr search lock ioctl write remove_name }");
lines_break.gres(" create_dir_perms","{ getattr create }");
lines_break.gres(" rename_dir_perms","{ getattr rename }");
lines_break.gres(" delete_dir_perms","{ getattr rmdir }");
lines_break.gres(" manage_dir_perms","{ create getattr setattr read write link unlink rename search add_name remove_name reparent rmdir lock ioctl }");
lines_break.gres(" relabelfrom_dir_perms","{ getattr relabelfrom }");
lines_break.gres(" relabelto_dir_perms","{ getattr relabelto }");
lines_break.gres(" relabel_dir_perms","{ getattr relabelfrom relabelto }");
lines_break.gres(" getattr_file_perms","{ getattr }");
lines_break.gres(" setattr_file_perms","{ setattr }");
lines_break.gres(" read_file_perms","{ getattr read lock ioctl }");
lines_break.gres(" mmap_file_perms","{ getattr read execute }");
lines_break.gres(" exec_file_perms","{ getattr read execute execute_no_trans }");
lines_break.gres(" append_file_perms","{ getattr append lock ioctl }");
lines_break.gres(" write_file_perms","{ getattr write append lock ioctl }");
lines_break.gres(" rw_file_perms","{ getattr read write append ioctl lock }");
lines_break.gres(" create_file_perms","{ getattr create }");
lines_break.gres(" rename_file_perms","{ getattr rename }");
lines_break.gres(" delete_file_perms","{ getattr unlink }");
lines_break.gres(" manage_file_perms","{ create getattr setattr read write append rename link unlink ioctl lock }");
lines_break.gres(" relabelfrom_file_perms","{ getattr relabelfrom }");
lines_break.gres(" relabelto_file_perms","{ getattr relabelto }");
lines_break.gres(" relabel_file_perms","{ getattr relabelfrom relabelto }");
lines_break.gres(" getattr_lnk_file_perms","{ getattr }");
lines_break.gres(" setattr_lnk_file_perms","{ setattr }");
lines_break.gres(" read_lnk_file_perms","{ getattr read }");
lines_break.gres(" write_lnk_file_perms","{ getattr write lock ioctl }");
lines_break.gres(" rw_lnk_file_perms","{ getattr read write lock ioctl }");
lines_break.gres(" create_lnk_file_perms","{ create getattr }");
lines_break.gres(" rename_lnk_file_perms","{ getattr rename }");
lines_break.gres(" delete_lnk_file_perms","{ getattr unlink }");
lines_break.gres(" manage_lnk_file_perms","{ create read getattr setattr unlink rename }");
lines_break.gres(" relabelfrom_lnk_file_perms","{ getattr relabelfrom }");
lines_break.gres(" relabelto_lnk_file_perms","{ getattr relabelto }");
lines_break.gres(" relabel_lnk_file_perms","{ getattr relabelfrom relabelto }");
lines_break.gres(" getattr_fifo_file_perms","{ getattr }");
lines_break.gres(" setattr_fifo_file_perms","{ setattr }");
lines_break.gres(" read_fifo_file_perms","{ getattr read lock ioctl }");
lines_break.gres(" append_fifo_file_perms","{ getattr append lock ioctl }");
lines_break.gres(" write_fifo_file_perms","{ getattr write append lock ioctl }");
lines_break.gres(" rw_fifo_file_perms","{ getattr read write append ioctl lock }");
lines_break.gres(" create_fifo_file_perms","{ getattr create }");
lines_break.gres(" delete_fifo_file_perms","{ getattr unlink }");
lines_break.gres(" manage_fifo_file_perms","{ create getattr setattr read write append rename link unlink ioctl lock }");
lines_break.gres(" relabelfrom_fifo_file_perms","{ getattr relabelfrom }");
lines_break.gres(" relabelto_fifo_file_perms","{ getattr relabelto }");
lines_break.gres(" relabel_fifo_file_perms","{ getattr relabelfrom relabelto }");
lines_break.gres(" getattr_sock_file_perms","{ getattr }");
lines_break.gres(" setattr_sock_file_perms","{ setattr }");
lines_break.gres(" read_sock_file_perms","{ getattr read }");
lines_break.gres(" write_sock_file_perms","{ getattr write append }");
lines_break.gres(" rw_sock_file_perms","{ getattr read write append }");
lines_break.gres(" create_sock_file_perms","{ getattr create }");
lines_break.gres(" delete_sock_file_perms","{ getattr unlink }");
lines_break.gres(" manage_sock_file_perms","{ create getattr setattr read write rename link unlink ioctl lock }");
lines_break.gres(" relabelfrom_sock_file_perms","{ getattr relabelfrom }");
lines_break.gres(" relabelto_sock_file_perms","{ getattr relabelto }");
lines_break.gres(" relabel_sock_file_perms","{ getattr relabelfrom relabelto }");
lines_break.gres(" getattr_blk_file_perms","{ getattr }");
lines_break.gres(" setattr_blk_file_perms","{ setattr }");
lines_break.gres(" read_blk_file_perms","{ getattr read lock ioctl }");
lines_break.gres(" append_blk_file_perms","{ getattr append lock ioctl }");
lines_break.gres(" write_blk_file_perms","{ getattr write append lock ioctl }");
lines_break.gres(" rw_blk_file_perms","{ getattr read write append ioctl lock }");
lines_break.gres(" create_blk_file_perms","{ getattr create }");
lines_break.gres(" rename_blk_file_perms","{ getattr rename }");
lines_break.gres(" delete_blk_file_perms","{ getattr unlink }");
lines_break.gres(" manage_blk_file_perms","{ create getattr setattr read write append rename link unlink ioctl lock }");
lines_break.gres(" relabelfrom_blk_file_perms","{ getattr relabelfrom }");
lines_break.gres(" relabelto_blk_file_perms","{ getattr relabelto }");
lines_break.gres(" relabel_blk_file_perms","{ getattr relabelfrom relabelto }");
lines_break.gres(" getattr_chr_file_perms","{ getattr }");
lines_break.gres(" setattr_chr_file_perms","{ setattr }");
lines_break.gres(" read_chr_file_perms","{ getattr read lock ioctl }");
lines_break.gres(" append_chr_file_perms","{ getattr append lock ioctl }");
lines_break.gres(" write_chr_file_perms","{ getattr write append lock ioctl }");
lines_break.gres(" rw_chr_file_perms","{ getattr read write append ioctl lock }");
lines_break.gres(" create_chr_file_perms","{ getattr create }");
lines_break.gres(" rename_chr_file_perms","{ getattr rename }");
lines_break.gres(" delete_chr_file_perms","{ getattr unlink }");
lines_break.gres(" manage_chr_file_perms","{ create getattr setattr read write append rename link unlink ioctl lock }");
lines_break.gres(" relabelfrom_chr_file_perms","{ getattr relabelfrom }");
lines_break.gres(" relabelto_chr_file_perms","{ getattr relabelto }");
lines_break.gres(" relabel_chr_file_perms","{ getattr relabelfrom relabelto }");
lines_break.gres(" rw_term_perms","{ getattr read write ioctl }");
lines_break.gres(" client_stream_socket_perms","{ create ioctl read getattr write setattr append bind getopt setopt shutdown }");
lines_break.gres(" server_stream_socket_perms","{ client_stream_socket_perms listen accept }");
//only here and not in other module related functions
lines_break.gres(" can_exec","allow $1 $2:file { rx_file_perms execute_no_trans };");				
				QTextStream stream_w( &file_w );
				for ( it = lines_break.begin(); it != lines_break.end(); ++it ){
					stream_w << *it << "\n";
				}
				file_analized.close();
				lines_break.clear();
			}else{
			    //do nothing
			}
			++it_d_read;
		}	    
	        file_w.close();   
	}
}//end-analize_file_patterns

//this function should only be called from other functions.
void ParseLinesMisc::ipc_patterns_prepare()
{
	/////////////////////////////////////////////////////////////
	path = "refpolicy/policy/support";
	path_to_be_written = "./ipc_patterns_prepare.txt";

	forward_slash = "/";
	dir.setPath(path);
	dir_name = dir.absPath();

	file_w.setName(path_to_be_written);
	/////////////////////////////////////////////////////////////
	files = dir.entryList("ipc_patterns.spt");
	/////////////////////////////////////////////////////////////

	it_d = files.begin();
	if (file_w.exists()) {
		file_w.remove();
	}
	if ( file_w.open( IO_WriteOnly | IO_Append ) ) {
		while(it_d != files.end()){
			name = *it_d;
			file_interface_name = dir_name + forward_slash + name;
			QFile file( file_interface_name );


			if ( file.open( IO_ReadOnly ) ) {
				QTextStream stream( &file );
				QTextStream stream_echo( &file );
				////////////////////////////////////////////
				QRegExp rx_a1("define\\(\\`"); 	
				////////////////////////////////////////////'
				QRegExp rx_a2("\\'\\, \\`"); 
				QRegExp rx_a3("\\'\\,\\`");
				QRegExp rx_a4("\\'\\)");
				QRegExp rx_a5("^\\s[allow]");
				QRegExp rx_a6("^\\s[type]");
				QRegExp rx_bracket_last("\\)"); 	
				int i,j,k = -1;
				while ( !stream.atEnd() ) {
					line = stream.readLine(); // line of text excluding '\n'
					i = line.find( rx_a1, 0);
					if(i != -1){
						line.replace(rx_a1,"");
					        line.replace(rx_a2,"");
						line.replace(rx_a3,"");
						line.replace(rx_a4,"");
						lines_ipc_patterns += line;//this adds to lines. also append can be used
					}
					j = line.find( rx_a5, 0);
					if(j != -1){
						lines_ipc_patterns += line;//this adds to lines. also append can be used
					}
					k = line.find( rx_a6, 0);
					if(k != -1){
						lines_ipc_patterns += line;//this adds to lines. also append can be used
					}

				}
				QTextStream stream_w( &file_w );
				for ( it = lines_ipc_patterns.begin(); it != lines_ipc_patterns.end(); ++it ){
					stream_w << *it << "\n";
				}
				file.close();
				lines_ipc_patterns.clear();
			}else{
				//do nothing
			}
			++it_d;
		}
	}
	file_w.close();    
}//end-ipc_patterns_prepare

void ParseLinesMisc::ipc_patterns()
{
        //first exec these functions for breaking up macros.
        file_patterns();
        analize_file_patterns();
        ipc_patterns_prepare();
	/////////////////////////////////////////////////////////////
	path_to_be_written = "./ipc_patterns_analized.txt";
	forward_slash = "/";
	dir_name_curr = dir_curr.currentDirPath();
	file_w.setName(path_to_be_written);
	files_to_be_read = dir_curr.entryList("ipc_patterns_prepare.txt");
	it_d_read = files_to_be_read.begin();
	/////////////////////////////////////////////////////////////

	if (file_w.exists()) {
		file_w.remove();
	}
	    //write to analized file.	
	if (file_w.open(IO_WriteOnly | IO_Append)){
	    while(it_d_read != files_to_be_read.end()){
		name = *it_d_read;
		file_interface_name_analized = dir_name_curr + forward_slash + name;
		
		//open file to be analized
		QFile file_analized( file_interface_name_analized );

			if ( file_analized.open( IO_ReadOnly ) ) {
				QTextStream stream_analized( &file_analized );
				//QTextStream stream_echo( &file );
				////////////////////////////////////////////
				while ( !stream_analized.atEnd() ) {
					line_analized = stream_analized.readLine(); // line of text excluding '\n'
//                                        #include "obj_perm_sets_analized_ready.txt"	
					lines_break += line_analized;//this adds to lines. also append can be used
				}
// it should have space otherwise getattr_dir_perms and r_dir_perms would collide
lines_break.gres(" dir_file_class_set","{ dir file lnk_file sock_file fifo_file chr_file blk_file }");
lines_break.gres(" file_class_set","{ file lnk_file sock_file fifo_file chr_file blk_file }");
lines_break.gres(" notdevfile_class_set","{ file lnk_file sock_file fifo_file }");
lines_break.gres(" devfile_class_set","{ chr_file blk_file }");
lines_break.gres(" socket_class_set","{ tcp_socket udp_socket rawip_socket netlink_socket packet_socket unix_stream_socket unix_dgram_socket appletalk_socket netlink_route_socket netlink_firewall_socket netlink_tcpdiag_socket netlink_nflog_socket netlink_xfrm_socket netlink_selinux_socket netlink_audit_socket netlink_ip6fw_socket netlink_dnrt_socket netlink_kobject_uevent_socket }");
lines_break.gres(" dgram_socket_class_set","{ udp_socket unix_dgram_socket }");
lines_break.gres(" stream_socket_class_set","{ tcp_socket unix_stream_socket }");
lines_break.gres(" unpriv_socket_class_set","{ tcp_socket udp_socket unix_stream_socket unix_dgram_socket }");
lines_break.gres(" stat_file_perms","{ getattr }");
lines_break.gres(" x_file_perms","{ getattr execute }");
lines_break.gres(" r_file_perms","{ read getattr lock ioctl }");
lines_break.gres(" rx_file_perms","{ read getattr lock execute ioctl }");
lines_break.gres(" ra_file_perms","{ ioctl read getattr lock append }");
lines_break.gres(" link_file_perms","{ getattr link unlink rename }");
lines_break.gres(" create_lnk_perms","{ create read getattr setattr link unlink rename }");
lines_break.gres(" create_file_perms","{ create ioctl read getattr lock write setattr append link unlink rename }");
lines_break.gres(" r_dir_perms","{ read getattr lock search ioctl }");
lines_break.gres(" rw_dir_perms","{ read getattr lock search ioctl add_name remove_name write }");
lines_break.gres(" ra_dir_perms","{ read getattr lock search ioctl add_name write }");
lines_break.gres(" create_dir_perms","{ create read getattr lock setattr ioctl link unlink rename search add_name remove_name reparent write rmdir }");
lines_break.gres(" mount_fs_perms","{ mount remount unmount getattr }");
lines_break.gres(" rw_socket_perms","{ ioctl read getattr write setattr append bind connect getopt setopt shutdown }");
lines_break.gres(" create_socket_perms","{ create rw_socket_perms }");
lines_break.gres(" rw_stream_socket_perms","{ rw_socket_perms listen accept }");
lines_break.gres(" create_stream_socket_perms","{ create_socket_perms listen accept }");
lines_break.gres(" connected_socket_perms","{ create ioctl read getattr write setattr append bind getopt setopt shutdown }");
lines_break.gres(" connected_stream_socket_perms","{ connected_socket_perms listen accept }");
lines_break.gres(" create_netlink_socket_perms","{ create_socket_perms nlmsg_read nlmsg_write }");
lines_break.gres(" rw_netlink_socket_perms","{ create_socket_perms nlmsg_read nlmsg_write }");
lines_break.gres(" r_netlink_socket_perms","{ create_socket_perms nlmsg_read }");
lines_break.gres(" signal_perms","{ sigchld sigkill sigstop signull signal }");
lines_break.gres(" packet_perms","{ tcp_recv tcp_send udp_recv udp_send rawip_recv rawip_send }");
lines_break.gres(" r_sem_perms","{ associate getattr read unix_read }");
lines_break.gres(" rw_sem_perms","{ associate getattr read write unix_read unix_write }");
lines_break.gres(" create_sem_perms","{ associate getattr setattr create destroy read write unix_read unix_write }");
lines_break.gres(" r_msgq_perms","{ associate getattr read unix_read }");
lines_break.gres(" rw_msgq_perms","{ associate getattr read write enqueue unix_read unix_write }");
lines_break.gres(" create_msgq_perms","{ associate getattr setattr create destroy read write enqueue unix_read unix_write }");
lines_break.gres(" r_shm_perms","{ associate getattr read unix_read }");
lines_break.gres(" rw_shm_perms","{ associate getattr read write lock unix_read unix_write }");
lines_break.gres(" create_shm_perms","{ associate getattr setattr create destroy read write lock unix_read unix_write }");
lines_break.gres(" getattr_dir_perms","{ getattr }");
lines_break.gres(" setattr_dir_perms","{ setattr }");
lines_break.gres(" search_dir_perms","{ getattr search }");
lines_break.gres(" list_dir_perms","{ getattr search read lock ioctl }");
lines_break.gres(" add_entry_dir_perms","{ getattr search lock ioctl write add_name }");
lines_break.gres(" del_entry_dir_perms","{ getattr search lock ioctl write remove_name }");
lines_break.gres(" create_dir_perms","{ getattr create }");
lines_break.gres(" rename_dir_perms","{ getattr rename }");
lines_break.gres(" delete_dir_perms","{ getattr rmdir }");
lines_break.gres(" manage_dir_perms","{ create getattr setattr read write link unlink rename search add_name remove_name reparent rmdir lock ioctl }");
lines_break.gres(" relabelfrom_dir_perms","{ getattr relabelfrom }");
lines_break.gres(" relabelto_dir_perms","{ getattr relabelto }");
lines_break.gres(" relabel_dir_perms","{ getattr relabelfrom relabelto }");
lines_break.gres(" getattr_file_perms","{ getattr }");
lines_break.gres(" setattr_file_perms","{ setattr }");
lines_break.gres(" read_file_perms","{ getattr read lock ioctl }");
lines_break.gres(" mmap_file_perms","{ getattr read execute }");
lines_break.gres(" exec_file_perms","{ getattr read execute execute_no_trans }");
lines_break.gres(" append_file_perms","{ getattr append lock ioctl }");
lines_break.gres(" write_file_perms","{ getattr write append lock ioctl }");
lines_break.gres(" rw_file_perms","{ getattr read write append ioctl lock }");
lines_break.gres(" create_file_perms","{ getattr create }");
lines_break.gres(" rename_file_perms","{ getattr rename }");
lines_break.gres(" delete_file_perms","{ getattr unlink }");
lines_break.gres(" manage_file_perms","{ create getattr setattr read write append rename link unlink ioctl lock }");
lines_break.gres(" relabelfrom_file_perms","{ getattr relabelfrom }");
lines_break.gres(" relabelto_file_perms","{ getattr relabelto }");
lines_break.gres(" relabel_file_perms","{ getattr relabelfrom relabelto }");
lines_break.gres(" getattr_lnk_file_perms","{ getattr }");
lines_break.gres(" setattr_lnk_file_perms","{ setattr }");
lines_break.gres(" read_lnk_file_perms","{ getattr read }");
lines_break.gres(" write_lnk_file_perms","{ getattr write lock ioctl }");
lines_break.gres(" rw_lnk_file_perms","{ getattr read write lock ioctl }");
lines_break.gres(" create_lnk_file_perms","{ create getattr }");
lines_break.gres(" rename_lnk_file_perms","{ getattr rename }");
lines_break.gres(" delete_lnk_file_perms","{ getattr unlink }");
lines_break.gres(" manage_lnk_file_perms","{ create read getattr setattr unlink rename }");
lines_break.gres(" relabelfrom_lnk_file_perms","{ getattr relabelfrom }");
lines_break.gres(" relabelto_lnk_file_perms","{ getattr relabelto }");
lines_break.gres(" relabel_lnk_file_perms","{ getattr relabelfrom relabelto }");
lines_break.gres(" getattr_fifo_file_perms","{ getattr }");
lines_break.gres(" setattr_fifo_file_perms","{ setattr }");
lines_break.gres(" read_fifo_file_perms","{ getattr read lock ioctl }");
lines_break.gres(" append_fifo_file_perms","{ getattr append lock ioctl }");
lines_break.gres(" write_fifo_file_perms","{ getattr write append lock ioctl }");
lines_break.gres(" rw_fifo_file_perms","{ getattr read write append ioctl lock }");
lines_break.gres(" create_fifo_file_perms","{ getattr create }");
lines_break.gres(" delete_fifo_file_perms","{ getattr unlink }");
lines_break.gres(" manage_fifo_file_perms","{ create getattr setattr read write append rename link unlink ioctl lock }");
lines_break.gres(" relabelfrom_fifo_file_perms","{ getattr relabelfrom }");
lines_break.gres(" relabelto_fifo_file_perms","{ getattr relabelto }");
lines_break.gres(" relabel_fifo_file_perms","{ getattr relabelfrom relabelto }");
lines_break.gres(" getattr_sock_file_perms","{ getattr }");
lines_break.gres(" setattr_sock_file_perms","{ setattr }");
lines_break.gres(" read_sock_file_perms","{ getattr read }");
lines_break.gres(" write_sock_file_perms","{ getattr write append }");
lines_break.gres(" rw_sock_file_perms","{ getattr read write append }");
lines_break.gres(" create_sock_file_perms","{ getattr create }");
lines_break.gres(" delete_sock_file_perms","{ getattr unlink }");
lines_break.gres(" manage_sock_file_perms","{ create getattr setattr read write rename link unlink ioctl lock }");
lines_break.gres(" relabelfrom_sock_file_perms","{ getattr relabelfrom }");
lines_break.gres(" relabelto_sock_file_perms","{ getattr relabelto }");
lines_break.gres(" relabel_sock_file_perms","{ getattr relabelfrom relabelto }");
lines_break.gres(" getattr_blk_file_perms","{ getattr }");
lines_break.gres(" setattr_blk_file_perms","{ setattr }");
lines_break.gres(" read_blk_file_perms","{ getattr read lock ioctl }");
lines_break.gres(" append_blk_file_perms","{ getattr append lock ioctl }");
lines_break.gres(" write_blk_file_perms","{ getattr write append lock ioctl }");
lines_break.gres(" rw_blk_file_perms","{ getattr read write append ioctl lock }");
lines_break.gres(" create_blk_file_perms","{ getattr create }");
lines_break.gres(" rename_blk_file_perms","{ getattr rename }");
lines_break.gres(" delete_blk_file_perms","{ getattr unlink }");
lines_break.gres(" manage_blk_file_perms","{ create getattr setattr read write append rename link unlink ioctl lock }");
lines_break.gres(" relabelfrom_blk_file_perms","{ getattr relabelfrom }");
lines_break.gres(" relabelto_blk_file_perms","{ getattr relabelto }");
lines_break.gres(" relabel_blk_file_perms","{ getattr relabelfrom relabelto }");
lines_break.gres(" getattr_chr_file_perms","{ getattr }");
lines_break.gres(" setattr_chr_file_perms","{ setattr }");
lines_break.gres(" read_chr_file_perms","{ getattr read lock ioctl }");
lines_break.gres(" append_chr_file_perms","{ getattr append lock ioctl }");
lines_break.gres(" write_chr_file_perms","{ getattr write append lock ioctl }");
lines_break.gres(" rw_chr_file_perms","{ getattr read write append ioctl lock }");
lines_break.gres(" create_chr_file_perms","{ getattr create }");
lines_break.gres(" rename_chr_file_perms","{ getattr rename }");
lines_break.gres(" delete_chr_file_perms","{ getattr unlink }");
lines_break.gres(" manage_chr_file_perms","{ create getattr setattr read write append rename link unlink ioctl lock }");
lines_break.gres(" relabelfrom_chr_file_perms","{ getattr relabelfrom }");
lines_break.gres(" relabelto_chr_file_perms","{ getattr relabelto }");
lines_break.gres(" relabel_chr_file_perms","{ getattr relabelfrom relabelto }");
lines_break.gres(" rw_term_perms","{ getattr read write ioctl }");
lines_break.gres(" client_stream_socket_perms","{ create ioctl read getattr write setattr append bind getopt setopt shutdown }");
lines_break.gres(" server_stream_socket_perms","{ client_stream_socket_perms listen accept }");
//only here and not in other module related functions
lines_break.gres(" can_exec","allow $1 $2:file { rx_file_perms execute_no_trans };");				
				
				
				QTextStream stream_w( &file_w );
				for ( it = lines_break.begin(); it != lines_break.end(); ++it ){
					stream_w << *it << "\n";
				}
				file_analized.close();
				lines_break.clear();
			}else{
			    //do nothing
			}
			++it_d_read;
		}	    
	        file_w.close();   
	    }
	  
}//end-ipc_patterns

void ParseLinesMisc::misc_patterns()
{
        //first exec these functions for breaking up macros.
        file_patterns();
        analize_file_patterns();
	/////////////////////////////////////////////////////////////
	path = "refpolicy/policy/support";
	path_to_be_written = "./misc_patterns_prepare.txt";

	forward_slash = "/";
	dir.setPath(path);
	dir_name = dir.absPath();

	file_w.setName(path_to_be_written);
	/////////////////////////////////////////////////////////////
	files = dir.entryList("misc_patterns.spt");
	/////////////////////////////////////////////////////////////

	it_d = files.begin();
	if (file_w.exists()) {
		file_w.remove();
	}
	if ( file_w.open( IO_WriteOnly | IO_Append ) ) {
		while(it_d != files.end()){
			name = *it_d;
			file_interface_name = dir_name + forward_slash + name;
			QFile file( file_interface_name );


			if ( file.open( IO_ReadOnly ) ) {
				QTextStream stream( &file );
				QTextStream stream_echo( &file );
				QRegExp rx_a1("define\\(\\`"); 	
				////////////////////////////////////////////'
				QRegExp rx_a2("\\'\\, \\`"); 
				QRegExp rx_a3("\\'\\,\\`");
				QRegExp rx_a4("\\'\\)");
				
				QRegExp rx_start("\\'\\,\\`");
				QRegExp rx_end("\\'\\)");	
				
				QRegExp rx_bracket_last("\\)"); 	
				int j,k = -1;
				int started = -1;
				line_started = "#start";
				line_ended = "#end";
				while ( !stream.atEnd() ) {
					line_analized = stream.readLine(); // line of text excluding '\n'
					j = line_analized.find( rx_start, 0);
					if(j != -1){
					    started=101;
					    line_analized.replace(rx_a1,"");
					    line_analized.replace(rx_a2,"");
					    line_analized.replace(rx_a3,"");									}
					k = line_analized.find( rx_end, 0);
					if(k != -1){
					    started = -1;
					}
					if(started >= 101){
					    lines_break += line_analized;
					}   
					if(started == 0){
					    lines_break += line_started;
					}
					if(started == -1){
					    lines_break += line_ended;
					}
					started++;
                                }
// it should have space otherwise getattr_dir_perms and r_dir_perms would collide
lines_break.gres(" dir_file_class_set","{ dir file lnk_file sock_file fifo_file chr_file blk_file }");
lines_break.gres(" file_class_set","{ file lnk_file sock_file fifo_file chr_file blk_file }");
lines_break.gres(" notdevfile_class_set","{ file lnk_file sock_file fifo_file }");
lines_break.gres(" devfile_class_set","{ chr_file blk_file }");
lines_break.gres(" socket_class_set","{ tcp_socket udp_socket rawip_socket netlink_socket packet_socket unix_stream_socket unix_dgram_socket appletalk_socket netlink_route_socket netlink_firewall_socket netlink_tcpdiag_socket netlink_nflog_socket netlink_xfrm_socket netlink_selinux_socket netlink_audit_socket netlink_ip6fw_socket netlink_dnrt_socket netlink_kobject_uevent_socket }");
lines_break.gres(" dgram_socket_class_set","{ udp_socket unix_dgram_socket }");
lines_break.gres(" stream_socket_class_set","{ tcp_socket unix_stream_socket }");
lines_break.gres(" unpriv_socket_class_set","{ tcp_socket udp_socket unix_stream_socket unix_dgram_socket }");
lines_break.gres(" stat_file_perms","{ getattr }");
lines_break.gres(" x_file_perms","{ getattr execute }");
lines_break.gres(" r_file_perms","{ read getattr lock ioctl }");
lines_break.gres(" rx_file_perms","{ read getattr lock execute ioctl }");
lines_break.gres(" ra_file_perms","{ ioctl read getattr lock append }");
lines_break.gres(" link_file_perms","{ getattr link unlink rename }");
lines_break.gres(" create_lnk_perms","{ create read getattr setattr link unlink rename }");
lines_break.gres(" create_file_perms","{ create ioctl read getattr lock write setattr append link unlink rename }");
lines_break.gres(" r_dir_perms","{ read getattr lock search ioctl }");
lines_break.gres(" rw_dir_perms","{ read getattr lock search ioctl add_name remove_name write }");
lines_break.gres(" ra_dir_perms","{ read getattr lock search ioctl add_name write }");
lines_break.gres(" create_dir_perms","{ create read getattr lock setattr ioctl link unlink rename search add_name remove_name reparent write rmdir }");
lines_break.gres(" mount_fs_perms","{ mount remount unmount getattr }");
lines_break.gres(" rw_socket_perms","{ ioctl read getattr write setattr append bind connect getopt setopt shutdown }");
lines_break.gres(" create_socket_perms","{ create rw_socket_perms }");
lines_break.gres(" rw_stream_socket_perms","{ rw_socket_perms listen accept }");
lines_break.gres(" create_stream_socket_perms","{ create_socket_perms listen accept }");
lines_break.gres(" connected_socket_perms","{ create ioctl read getattr write setattr append bind getopt setopt shutdown }");
lines_break.gres(" connected_stream_socket_perms","{ connected_socket_perms listen accept }");
lines_break.gres(" create_netlink_socket_perms","{ create_socket_perms nlmsg_read nlmsg_write }");
lines_break.gres(" rw_netlink_socket_perms","{ create_socket_perms nlmsg_read nlmsg_write }");
lines_break.gres(" r_netlink_socket_perms","{ create_socket_perms nlmsg_read }");
lines_break.gres(" signal_perms","{ sigchld sigkill sigstop signull signal }");
lines_break.gres(" packet_perms","{ tcp_recv tcp_send udp_recv udp_send rawip_recv rawip_send }");
lines_break.gres(" r_sem_perms","{ associate getattr read unix_read }");
lines_break.gres(" rw_sem_perms","{ associate getattr read write unix_read unix_write }");
lines_break.gres(" create_sem_perms","{ associate getattr setattr create destroy read write unix_read unix_write }");
lines_break.gres(" r_msgq_perms","{ associate getattr read unix_read }");
lines_break.gres(" rw_msgq_perms","{ associate getattr read write enqueue unix_read unix_write }");
lines_break.gres(" create_msgq_perms","{ associate getattr setattr create destroy read write enqueue unix_read unix_write }");
lines_break.gres(" r_shm_perms","{ associate getattr read unix_read }");
lines_break.gres(" rw_shm_perms","{ associate getattr read write lock unix_read unix_write }");
lines_break.gres(" create_shm_perms","{ associate getattr setattr create destroy read write lock unix_read unix_write }");
lines_break.gres(" getattr_dir_perms","{ getattr }");
lines_break.gres(" setattr_dir_perms","{ setattr }");
lines_break.gres(" search_dir_perms","{ getattr search }");
lines_break.gres(" list_dir_perms","{ getattr search read lock ioctl }");
lines_break.gres(" add_entry_dir_perms","{ getattr search lock ioctl write add_name }");
lines_break.gres(" del_entry_dir_perms","{ getattr search lock ioctl write remove_name }");
lines_break.gres(" create_dir_perms","{ getattr create }");
lines_break.gres(" rename_dir_perms","{ getattr rename }");
lines_break.gres(" delete_dir_perms","{ getattr rmdir }");
lines_break.gres(" manage_dir_perms","{ create getattr setattr read write link unlink rename search add_name remove_name reparent rmdir lock ioctl }");
lines_break.gres(" relabelfrom_dir_perms","{ getattr relabelfrom }");
lines_break.gres(" relabelto_dir_perms","{ getattr relabelto }");
lines_break.gres(" relabel_dir_perms","{ getattr relabelfrom relabelto }");
lines_break.gres(" getattr_file_perms","{ getattr }");
lines_break.gres(" setattr_file_perms","{ setattr }");
lines_break.gres(" read_file_perms","{ getattr read lock ioctl }");
lines_break.gres(" mmap_file_perms","{ getattr read execute }");
lines_break.gres(" exec_file_perms","{ getattr read execute execute_no_trans }");
lines_break.gres(" append_file_perms","{ getattr append lock ioctl }");
lines_break.gres(" write_file_perms","{ getattr write append lock ioctl }");
lines_break.gres(" rw_file_perms","{ getattr read write append ioctl lock }");
lines_break.gres(" create_file_perms","{ getattr create }");
lines_break.gres(" rename_file_perms","{ getattr rename }");
lines_break.gres(" delete_file_perms","{ getattr unlink }");
lines_break.gres(" manage_file_perms","{ create getattr setattr read write append rename link unlink ioctl lock }");
lines_break.gres(" relabelfrom_file_perms","{ getattr relabelfrom }");
lines_break.gres(" relabelto_file_perms","{ getattr relabelto }");
lines_break.gres(" relabel_file_perms","{ getattr relabelfrom relabelto }");
lines_break.gres(" getattr_lnk_file_perms","{ getattr }");
lines_break.gres(" setattr_lnk_file_perms","{ setattr }");
lines_break.gres(" read_lnk_file_perms","{ getattr read }");
lines_break.gres(" write_lnk_file_perms","{ getattr write lock ioctl }");
lines_break.gres(" rw_lnk_file_perms","{ getattr read write lock ioctl }");
lines_break.gres(" create_lnk_file_perms","{ create getattr }");
lines_break.gres(" rename_lnk_file_perms","{ getattr rename }");
lines_break.gres(" delete_lnk_file_perms","{ getattr unlink }");
lines_break.gres(" manage_lnk_file_perms","{ create read getattr setattr unlink rename }");
lines_break.gres(" relabelfrom_lnk_file_perms","{ getattr relabelfrom }");
lines_break.gres(" relabelto_lnk_file_perms","{ getattr relabelto }");
lines_break.gres(" relabel_lnk_file_perms","{ getattr relabelfrom relabelto }");
lines_break.gres(" getattr_fifo_file_perms","{ getattr }");
lines_break.gres(" setattr_fifo_file_perms","{ setattr }");
lines_break.gres(" read_fifo_file_perms","{ getattr read lock ioctl }");
lines_break.gres(" append_fifo_file_perms","{ getattr append lock ioctl }");
lines_break.gres(" write_fifo_file_perms","{ getattr write append lock ioctl }");
lines_break.gres(" rw_fifo_file_perms","{ getattr read write append ioctl lock }");
lines_break.gres(" create_fifo_file_perms","{ getattr create }");
lines_break.gres(" delete_fifo_file_perms","{ getattr unlink }");
lines_break.gres(" manage_fifo_file_perms","{ create getattr setattr read write append rename link unlink ioctl lock }");
lines_break.gres(" relabelfrom_fifo_file_perms","{ getattr relabelfrom }");
lines_break.gres(" relabelto_fifo_file_perms","{ getattr relabelto }");
lines_break.gres(" relabel_fifo_file_perms","{ getattr relabelfrom relabelto }");
lines_break.gres(" getattr_sock_file_perms","{ getattr }");
lines_break.gres(" setattr_sock_file_perms","{ setattr }");
lines_break.gres(" read_sock_file_perms","{ getattr read }");
lines_break.gres(" write_sock_file_perms","{ getattr write append }");
lines_break.gres(" rw_sock_file_perms","{ getattr read write append }");
lines_break.gres(" create_sock_file_perms","{ getattr create }");
lines_break.gres(" delete_sock_file_perms","{ getattr unlink }");
lines_break.gres(" manage_sock_file_perms","{ create getattr setattr read write rename link unlink ioctl lock }");
lines_break.gres(" relabelfrom_sock_file_perms","{ getattr relabelfrom }");
lines_break.gres(" relabelto_sock_file_perms","{ getattr relabelto }");
lines_break.gres(" relabel_sock_file_perms","{ getattr relabelfrom relabelto }");
lines_break.gres(" getattr_blk_file_perms","{ getattr }");
lines_break.gres(" setattr_blk_file_perms","{ setattr }");
lines_break.gres(" read_blk_file_perms","{ getattr read lock ioctl }");
lines_break.gres(" append_blk_file_perms","{ getattr append lock ioctl }");
lines_break.gres(" write_blk_file_perms","{ getattr write append lock ioctl }");
lines_break.gres(" rw_blk_file_perms","{ getattr read write append ioctl lock }");
lines_break.gres(" create_blk_file_perms","{ getattr create }");
lines_break.gres(" rename_blk_file_perms","{ getattr rename }");
lines_break.gres(" delete_blk_file_perms","{ getattr unlink }");
lines_break.gres(" manage_blk_file_perms","{ create getattr setattr read write append rename link unlink ioctl lock }");
lines_break.gres(" relabelfrom_blk_file_perms","{ getattr relabelfrom }");
lines_break.gres(" relabelto_blk_file_perms","{ getattr relabelto }");
lines_break.gres(" relabel_blk_file_perms","{ getattr relabelfrom relabelto }");
lines_break.gres(" getattr_chr_file_perms","{ getattr }");
lines_break.gres(" setattr_chr_file_perms","{ setattr }");
lines_break.gres(" read_chr_file_perms","{ getattr read lock ioctl }");
lines_break.gres(" append_chr_file_perms","{ getattr append lock ioctl }");
lines_break.gres(" write_chr_file_perms","{ getattr write append lock ioctl }");
lines_break.gres(" rw_chr_file_perms","{ getattr read write append ioctl lock }");
lines_break.gres(" create_chr_file_perms","{ getattr create }");
lines_break.gres(" rename_chr_file_perms","{ getattr rename }");
lines_break.gres(" delete_chr_file_perms","{ getattr unlink }");
lines_break.gres(" manage_chr_file_perms","{ create getattr setattr read write append rename link unlink ioctl lock }");
lines_break.gres(" relabelfrom_chr_file_perms","{ getattr relabelfrom }");
lines_break.gres(" relabelto_chr_file_perms","{ getattr relabelto }");
lines_break.gres(" relabel_chr_file_perms","{ getattr relabelfrom relabelto }");
lines_break.gres(" rw_term_perms","{ getattr read write ioctl }");
lines_break.gres(" client_stream_socket_perms","{ create ioctl read getattr write setattr append bind getopt setopt shutdown }");
lines_break.gres(" server_stream_socket_perms","{ client_stream_socket_perms listen accept }");
//only here and not in other module related functions
lines_break.gres(" can_exec","allow $1 $2:file { rx_file_perms execute_no_trans };");	
				QTextStream stream_w( &file_w );
				for ( it = lines_break.begin(); it != lines_break.end(); ++it ){
					stream_w << *it << "\n";
				}
				file.close();
				lines_break.clear();
			}else{
				//do nothing
			}
			++it_d;
		}
	}
	file_w.close();    
}//end-misc_patterns
ParseLinesMisc::~ParseLinesMisc(){}
