#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <qmainwindow.h>
#include <qwidgetlist.h>

class QAction;
class QLabel;
class QWorkspace;
class QSplitter;
class QTextEdit;
class QPushButton;
class Editor;
class ParseLines;
class ParseLinesAdmin;
class ParseLinesApps;
class ParseLinesKernel;
class ParseLinesServices;
class ParseLinesSystem;
class ParseLinesMisc;
class ParseLinesSelpaw;
class Selpaw;
class SelpawAdjust;

class MainWindow : public QMainWindow
{
    Q_OBJECT
public:
    MainWindow(QWidget *parent = 0, const char *name = 0);

public slots:
    void newFile();
    void openFile(const QString &fileName);

protected:
    void closeEvent(QCloseEvent *event);

private slots:
    void open();
    void save();
    void saveAs();
    void cut();
    void copy();
    void paste();
    void del();
    void about();
    void updateMenus();
    void activateWindow(int param);
    void copyAvailable(bool available);
    void updateModIndicator();

private:
    void createActions();
    void createMenus();
    void createWindowsMenu();
    void createToolBars();
    void createStatusBar();
    Editor *createEditor();
    Editor *activeEditor();

    QWorkspace *workspace;
    QLabel *readyLabel;
    QLabel *modLabel;
    QWidgetList windows;

    //newly added
    QSplitter *horizontalSplitter;
    QSplitter *verticalSplitter;
    QSplitter *verticalSplitter2;
    QSplitter *rightSplitter;
    QSplitter *rightVerticalSplitter;
    QTextEdit *textEcho;
    QPushButton *pushButton1;
    QPushButton *pushButton2;
    QPushButton *pushButton3;
    QPushButton *pushButton4;
    QPushButton *pushButton5;
    QPushButton *pushButton6;
    QPushButton *pushButton7;
    QPushButton *pushButton8;
    QPushButton *pushButton9;
    QPushButton *pushButton10;
    QPushButton *pushButton11;
    QPushButton *pushButton12;
    QPushButton *pushButton13;        
    QPushButton *pushButton14;        
    QPushButton *pushButton15;        
    QPushButton *pushButton16;        
    QPushButton *pushButton17;        
    QPushButton *pushButton18;        
    QPushButton *pushButton19;        
    QPushButton *pushButton20;        
    QPushButton *pushButton21;        
    QPushButton *pushButton22;        
    
    ParseLines *parse1;
    ParseLines *parse2;
    ParseLines *parse3;
    ParseLines *parse4;
    ParseLines *parse5;
    ParseLines *parse6;
    ParseLines *parse7;
    ParseLines *parse8;
    ParseLines *parse9;
    ParseLines *parse10;
    ParseLines *parse11;
    ParseLines *parse12;    
    ParseLines *parse13;        
    ParseLines *parse14;
    ParseLines *parse15;
    ParseLines *parse16;
    ParseLines *parse17;
    ParseLines *parse18;
    Selpaw *selpaw1;
    SelpawAdjust *selpawadjust1;
    SelpawAdjust *selpawadjust2;
    SelpawAdjust *selpawadjust3;
    
    QPopupMenu *fileMenu;
    QPopupMenu *editMenu;
    QPopupMenu *windowsMenu;
    QPopupMenu *helpMenu;
    QToolBar *fileToolBar;
    QToolBar *editToolBar;
    QAction *newAct;
    QAction *openAct;
    QAction *saveAct;
    QAction *saveAsAct;
    QAction *exitAct;
    QAction *cutAct;
    QAction *copyAct;
    QAction *pasteAct;
    QAction *deleteAct;
    QAction *closeAct;
    QAction *closeAllAct;
    QAction *tileAct;
    QAction *cascadeAct;
    QAction *nextAct;
    QAction *previousAct;
    QAction *aboutAct;
    QAction *aboutQtAct;
};

#endif
